/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import tvbrowser.core.Settings;
import util.i18n.Localizer;
import util.ui.CaretPositionCorrector;

public class TimePeriodChooser
extends JPanel {
    public static final Localizer LOCALIZER = Localizer.getLocalizerFor(TimePeriodChooser.class);
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALGIN_CENTER = 2;
    private JSpinner mTimeFromSp;
    private JSpinner mTimeToSp;
    private JLabel mLabel1;
    private JLabel mLabel2;

    public TimePeriodChooser(int alignment) {
        this(-1, -1, alignment);
    }

    public TimePeriodChooser(int from, int to, int alignment) {
        FlowLayout layout = new FlowLayout(0, 0, 0);
        JPanel content = new JPanel((LayoutManager)new FormLayout("pref, 3dlu, pref, 3dlu, pref, 3dlu, pref", "pref"));
        this.mTimeFromSp = new JSpinner(new SpinnerDateModel());
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.mTimeFromSp, Settings.getTimePattern());
        this.mTimeFromSp.setEditor(dateEditor);
        CaretPositionCorrector.createCorrector(dateEditor.getTextField(), new char[]{':'}, -1);
        this.mTimeToSp = new JSpinner(new SpinnerDateModel());
        dateEditor = new JSpinner.DateEditor(this.mTimeToSp, Settings.getTimePattern());
        this.mTimeToSp.setEditor(dateEditor);
        CaretPositionCorrector.createCorrector(dateEditor.getTextField(), new char[]{':'}, -1);
        CellConstraints cc = new CellConstraints();
        this.mLabel1 = new JLabel(LOCALIZER.msg("between", "between"));
        content.add((Component)this.mLabel1, cc.xy(1, 1));
        content.add((Component)this.mTimeFromSp, cc.xy(3, 1));
        this.mLabel2 = new JLabel(LOCALIZER.msg("and", "and"));
        content.add((Component)this.mLabel2, cc.xy(5, 1));
        content.add((Component)this.mTimeToSp, cc.xy(7, 1));
        if (from >= 0) {
            this.setFromTime(from);
        }
        if (to >= 0) {
            this.setToTime(to);
        }
        if (alignment == 0) {
            layout.setAlignment(0);
        } else if (alignment == 1) {
            layout.setAlignment(2);
        } else {
            layout.setAlignment(1);
        }
        this.setLayout(layout);
        this.add(content);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mTimeFromSp.setEnabled(enabled);
        this.mTimeToSp.setEnabled(enabled);
        this.mLabel1.setEnabled(enabled);
        this.mLabel2.setEnabled(enabled);
    }

    private int getTime(JSpinner spinner) {
        Date fromTime = (Date)spinner.getValue();
        Calendar cal = Calendar.getInstance();
        cal.setTime(fromTime);
        return cal.get(11) * 60 + cal.get(12);
    }

    private void setTime(JSpinner spinner, int time) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, time / 60);
        cal.set(12, time % 60);
        spinner.setValue(cal.getTime());
    }

    public void setFromTime(int minutes) {
        this.setTime(this.mTimeFromSp, minutes);
    }

    public void setToTime(int minutes) {
        this.setTime(this.mTimeToSp, minutes);
    }

    public int getFromTime() {
        return this.getTime(this.mTimeFromSp);
    }

    public int getToTime() {
        return this.getTime(this.mTimeToSp);
    }
}

