/*
 * Decompiled with CFR 0.152.
 */
package util.ui.customizableitems;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ListUI;
import util.i18n.Localizer;
import util.ui.customizableitems.ItemFilter;
import util.ui.customizableitems.SelectableItem;
import util.ui.customizableitems.SelectableItemRenderer;
import util.ui.customizableitems.SelectableItemRendererCenterComponentIf;

public class SelectableItemList<E>
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(SelectableItemList.class);
    private SelectableItemListModel mListModel;
    private SelectableItemRenderer<E> mItemRenderer;
    private JButton mSelectAllBt;
    private JButton mDeSelectAllBt;
    private JList<SelectableItem<E>> mList;
    private Component[] mComponents;
    private boolean mIsEnabled = true;
    private JScrollPane mScrollPane;
    private JPanel mEditorComp = null;
    private int mEditingIndex = -1;

    public SelectableItemList(E[] currSelection, E[] allItems) {
        this(currSelection, allItems, null);
    }

    public SelectableItemList(E[] currSelection, E[] allItems, E[] notSelectableItems) {
        this(currSelection, allItems, false, notSelectableItems);
    }

    public SelectableItemList(E[] currSelection, E[] allItems, boolean showSelectionButtons) {
        this(currSelection, allItems, showSelectionButtons, null);
    }

    public SelectableItemList(E[] currSelection, E[] allItems, boolean showSelectionButtons, E[] notSelectableItems) {
        this.setLayout(new BorderLayout(0, 3));
        this.mListModel = new SelectableItemListModel();
        this.setEntries(currSelection, allItems, notSelectableItems);
        this.mList = new JList(this.mListModel);
        this.mItemRenderer = new SelectableItemRenderer();
        this.mList.setCellRenderer(this.mItemRenderer);
        this.mScrollPane = new JScrollPane(this.mList);
        this.mScrollPane.getVerticalScrollBar().setBlockIncrement(50);
        this.mScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.mItemRenderer.setScrollPane(this.mScrollPane);
        this.add((Component)this.mScrollPane, "Center");
        this.mList.addListSelectionListener(this);
        this.mList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                int index;
                if (SwingUtilities.isLeftMouseButton(evt) && (index = SelectableItemList.this.mList.locationToIndex(evt.getPoint())) != -1) {
                    Object item;
                    Rectangle oldCellBounds = SelectableItemList.this.mList.getCellBounds(index, index);
                    SelectableItemList.this.calculateSize();
                    SelectableItemList.this.addEditor(index);
                    if (evt.getX() <= SelectableItemList.this.mItemRenderer.getSelectionWidth() && SelectableItemList.this.mIsEnabled && oldCellBounds.contains(evt.getPoint()) && ((SelectableItem)(item = SelectableItemList.this.mListModel.getElementAt(index))).isSelectable()) {
                        ((SelectableItem)item).setSelected(!((SelectableItem)item).isSelected());
                        SelectableItemList.this.handleItemSelectionChanged();
                        SelectableItemList.this.mList.repaint();
                    }
                }
            }
        });
        this.mList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    SelectableItemList.this.addEditor(SelectableItemList.this.mList.getSelectedIndex());
                    List objs = SelectableItemList.this.mList.getSelectedValuesList();
                    for (SelectableItem item : objs) {
                        item.setSelected(!item.isSelected());
                    }
                    SelectableItemList.this.handleItemSelectionChanged();
                    SelectableItemList.this.mList.repaint();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                SelectableItemList.this.calculateSize();
                SelectableItemList.this.addEditor(SelectableItemList.this.mList.getSelectedIndex());
            }
        });
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("pref,3dlu:grow,pref", "pref");
        layout.setColumnGroups((int[][])new int[][]{{1, 3}});
        JPanel p3 = new JPanel((LayoutManager)layout);
        this.mSelectAllBt = new JButton(LOCALIZER.msg("addAll", "Select all items"));
        this.mSelectAllBt.setToolTipText(LOCALIZER.msg("tooltip.all", "Select all items in the list."));
        this.mSelectAllBt.addActionListener(e -> this.selectAll());
        p3.add((Component)this.mSelectAllBt, cc.xy(1, 1));
        this.mDeSelectAllBt = new JButton(LOCALIZER.msg("delAll", "Deselect all items"));
        this.mDeSelectAllBt.setToolTipText(LOCALIZER.msg("tooltip.none", "Deselect all items in the list."));
        this.mDeSelectAllBt.addActionListener(e -> this.clearSelection());
        p3.add((Component)this.mDeSelectAllBt, cc.xy(3, 1));
        if (showSelectionButtons) {
            this.add((Component)p3, "South");
        }
    }

    private void handleItemSelectionChanged() {
        if (this.mEditorComp != null) {
            JCheckBox cb = (JCheckBox)this.mEditorComp.getComponent(0);
            cb.setSelected(((SelectableItem)this.mListModel.getElementAt(this.mEditingIndex)).isSelected());
            this.mEditorComp.repaint();
            ListSelectionListener[] listeners = this.mList.getListSelectionListeners();
            if (listeners != null) {
                for (ListSelectionListener listener : listeners) {
                    if (this.mList.getSelectedValue() == null) continue;
                    int[] indices = this.mList.getSelectedIndices();
                    listener.valueChanged(new ListSelectionEvent(this.mList.getSelectedValue(), indices[0], indices[indices.length - 1], false));
                }
            }
        }
    }

    public void updateCurrentSelection() {
        this.removeEditor();
        this.mList.repaint();
        this.addEditor(this.mList.getSelectedIndex());
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.mList.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.mList.removeListSelectionListener(listener);
    }

    public void setSelectionMode(int selectionMode) {
        this.mList.setSelectionMode(selectionMode);
    }

    @Deprecated(since="3.4.5")
    public Object[] getListSelection() {
        List<SelectableItem<E>> list = this.mList.getSelectedValuesList();
        Object[] items = new Object[list.size()];
        int max = list.size();
        for (int i = 0; i < max; ++i) {
            items[i] = list.get(i).getItem();
        }
        return items;
    }

    public List<E> getListSelectionList() {
        List<SelectableItem<E>> list = this.mList.getSelectedValuesList();
        ArrayList<E> items = new ArrayList<E>(list.size());
        for (SelectableItem<E> item : list) {
            items.add(item.getItem());
        }
        return items;
    }

    private void setEntries(E[] currSelection, E[] allItems, E[] disabledItems) {
        this.mListModel.removeAllElements();
        this.mComponents = new Component[allItems.length];
        ArrayList<E> selectionList = new ArrayList<E>();
        for (E element : currSelection) {
            selectionList.add(element);
        }
        for (int i = 0; i < allItems.length; ++i) {
            SelectableItem<E> item = new SelectableItem<E>(allItems[i], selectionList.remove(allItems[i]), !this.arrayContainsItem(disabledItems, allItems[i]));
            this.mListModel.addElement(item);
        }
    }

    private boolean arrayContainsItem(Object[] itemArr, Object item) {
        if (item != null && itemArr != null) {
            for (Object arrayItem : itemArr) {
                if (arrayItem == null || !arrayItem.equals(item)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated(since="3.4.5")
    public Object[] getSelection() {
        List selection = this.mListModel.getSelectionList();
        return selection.toArray();
    }

    public List<E> getSelectionList() {
        return this.mListModel.getSelectionList();
    }

    public SelectableItem<E> getSelectedValue() {
        return this.mList.getSelectedValue();
    }

    public void setSelectedIndex(int index) {
        this.mList.setSelectedIndex(index);
    }

    public void invertSelection() {
        this.removeEditor();
        if (this.mIsEnabled) {
            this.mListModel.invertSelection();
            this.mList.repaint();
        }
    }

    public void selectFiltered() {
        for (int i = 0; i < this.mListModel.getSize(); ++i) {
            ((SelectableItem)this.mListModel.getElementAt(i)).setSelected(true);
        }
    }

    public void selectAll() {
        this.removeEditor();
        if (this.mIsEnabled) {
            this.mListModel.selectAll();
            this.mList.repaint();
        }
    }

    public void clearSelection() {
        this.removeEditor();
        if (this.mIsEnabled) {
            this.mListModel.clearSelection();
            this.mList.repaint();
        }
    }

    @Override
    public void setEnabled(boolean value) {
        this.mIsEnabled = value;
        this.mItemRenderer.setEnabled(value);
        this.mList.setEnabled(value);
        this.mSelectAllBt.setEnabled(value);
        this.mDeSelectAllBt.setEnabled(value);
        this.mScrollPane.getVerticalScrollBar().setEnabled(value);
        this.mScrollPane.setWheelScrollingEnabled(value);
    }

    public void calculateSize() {
        if (this.mList != null) {
            this.mList.setSize(this.mList.getPreferredSize());
            this.mList.ensureIndexIsVisible(this.mList.getSelectedIndex());
            this.mList.repaint();
        }
    }

    public void addCenterRendererComponent(Class<?> clazz, SelectableItemRendererCenterComponentIf<E> component) {
        this.mItemRenderer.setCenterRendererComponent(clazz, component);
    }

    public void setListUI(ListUI ui) {
        this.mList.setUI(ui);
    }

    public void setHorizontalScrollBarPolicy(int value) {
        this.mScrollPane.setHorizontalScrollBarPolicy(value);
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this.mList.addMouseListener(listener);
    }

    public void setFilterComboBox(JComboBox<? extends ItemFilter> filterBox) {
        this.mListModel.setComboBox(filterBox);
    }

    public void setNameFilter(ItemFilter nameFilter) {
        this.mListModel.setNameFilter(nameFilter);
    }

    private void removeEditor() {
        this.mList.invalidate();
        if (this.mEditorComp != null) {
            this.mEditorComp.setVisible(false);
            this.mEditorComp.setEnabled(false);
            this.mList.remove(this.mEditorComp);
        }
        this.mEditingIndex = -1;
        this.mEditorComp = null;
        this.mList.validate();
        this.mList.repaint();
    }

    private boolean addEditor(int index) {
        int blockcorrection = 0;
        if (this.mEditorComp != null) {
            if (this.mEditingIndex < index) {
                blockcorrection = this.mList.getCellBounds((int)this.mEditingIndex, (int)this.mEditingIndex).height - this.mList.getCellBounds((int)index, (int)index).height;
            }
            this.removeEditor();
        }
        this.mList.repaint();
        if (index < 0 || index >= this.mListModel.getSize()) {
            return false;
        }
        this.mList.validate();
        this.mEditorComp = this.mItemRenderer.getListCellComponent(this.mList, (SelectableItem<E>)this.mListModel.getElementAt(index), index, true, true);
        this.mEditorComp.validate();
        Rectangle cb = this.mList.getCellBounds(index, index);
        if (blockcorrection > 0) {
            cb.y -= blockcorrection;
        }
        this.mEditorComp.setBounds(cb);
        this.mEditingIndex = index;
        this.mList.add(this.mEditorComp);
        this.mList.validate();
        ((JCheckBox)this.mEditorComp.getComponent(0)).addItemListener(e -> {
            JCheckBox cb1 = (JCheckBox)this.mEditorComp.getComponent(0);
            ((SelectableItem)this.mListModel.getElementAt(this.mEditingIndex)).setSelected(cb1.isSelected());
            this.handleItemSelectionChanged();
        });
        this.mEditorComp.repaint();
        return true;
    }

    public int getItemCount() {
        return this.mListModel.getSize();
    }

    public void setVerticalScrollBarBlockIncrement(int value) {
        this.mScrollPane.getVerticalScrollBar().setBlockIncrement(value);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
            this.mComponents[i] = this.mItemRenderer.getListCellRendererComponent(this.mList, (SelectableItem<E>)this.mListModel.getElementAt(i), i, this.mList.isSelectedIndex(i), true);
        }
    }

    public boolean isEmpty() {
        return this.mListModel.getSize() == 0;
    }

    private class SelectableItemListModel
    extends AbstractListModel<SelectableItem<E>> {
        private JComboBox<? extends ItemFilter> mFilterBox;
        private ItemFilter mNameFilter;
        private ArrayList<SelectableItem<E>> mFullList = new ArrayList();
        private ArrayList<SelectableItem<E>> mFilteredList = new ArrayList();

        private SelectableItemListModel() {
        }

        protected void setNameFilter(ItemFilter filter) {
            this.mNameFilter = filter;
            this.mNameFilter.setChangeListener(e -> this.filter());
        }

        protected void setComboBox(JComboBox<? extends ItemFilter> filterBox) {
            this.mFilterBox = filterBox;
            this.mFilterBox.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.filter();
                }
            });
        }

        private void filter() {
            this.mFilteredList.clear();
            SelectableItemList.this.removeEditor();
            Object filter = this.mFilterBox != null ? this.mFilterBox.getSelectedItem() : this.mNameFilter;
            for (SelectableItem o : this.mFullList) {
                if (filter instanceof ItemFilter) {
                    if (!((ItemFilter)filter).accept(o.getItem()) || this.mNameFilter != null && !this.mNameFilter.accept(o.getItem())) continue;
                    this.mFilteredList.add(o);
                    continue;
                }
                this.mFilteredList.add(o);
            }
            this.fireIntervalRemoved(this, 0, this.mFullList.size());
            this.fireIntervalAdded(this, 0, this.mFilteredList.size());
        }

        protected void addElement(SelectableItem<E> o) {
            this.mFullList.add(o);
            if (this.mFilterBox != null) {
                Object filter = this.mFilterBox.getSelectedItem();
                if (filter instanceof ItemFilter) {
                    if (((ItemFilter)filter).accept(o.getItem())) {
                        this.mFilteredList.add(o);
                    }
                } else {
                    this.mFilteredList.add(o);
                }
            } else {
                this.mFilteredList.add(o);
            }
        }

        @Override
        public SelectableItem<E> getElementAt(int index) {
            return this.mFilteredList.get(index);
        }

        @Override
        public int getSize() {
            return this.mFilteredList.size();
        }

        protected int size() {
            return this.getSize();
        }

        protected void removeAllElements() {
            this.mFullList.clear();
            this.mFilteredList.clear();
        }

        protected List<E> getSelectionList() {
            ArrayList objList = new ArrayList();
            for (int i = 0; i < this.mFullList.size(); ++i) {
                SelectableItem item = this.mFullList.get(i);
                if (!item.isSelected()) continue;
                objList.add(item.getItem());
            }
            return objList;
        }

        protected void selectAll() {
            for (int i = 0; i < this.mFullList.size(); ++i) {
                SelectableItem item = this.mFullList.get(i);
                item.setSelected(true);
            }
        }

        protected void clearSelection() {
            for (int i = 0; i < this.mFullList.size(); ++i) {
                SelectableItem item = this.mFullList.get(i);
                item.setSelected(false);
            }
        }

        protected void invertSelection() {
            for (int i = 0; i < this.mFullList.size(); ++i) {
                SelectableItem item;
                item.setSelected(!(item = this.mFullList.get(i)).isSelected());
            }
        }
    }
}

