/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Germany
extends DelegateCalendar {
    private static final Germany SETTLEMENT_CALENDAR = new Germany(Market.SETTLEMENT);
    private static final Germany FWB_CALENDAR = new Germany(Market.FWB);
    private static final Germany XETRA_CALENDAR = new Germany(Market.XETRA);
    private static final Germany EUREX_CALENDAR = new Germany(Market.EUREX);

    private Germany(Market market) {
        WesternCalendar delegate;
        switch (market) {
            case SETTLEMENT: {
                delegate = new GermanySettlementCalendar();
                break;
            }
            case FWB: {
                delegate = new FWBCalendar();
                break;
            }
            case XETRA: {
                delegate = new XetraCalendar();
                break;
            }
            case EUREX: {
                delegate = new EurexCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Germany getCalendar(Market market) {
        switch (market) {
            case SETTLEMENT: {
                return SETTLEMENT_CALENDAR;
            }
            case FWB: {
                return FWB_CALENDAR;
            }
            case XETRA: {
                return XETRA_CALENDAR;
            }
            case EUREX: {
                return EUREX_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class EurexCalendar
    extends WesternCalendar {
        private EurexCalendar() {
        }

        @Override
        public String getName() {
            return "Eurex";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || dd == em - 3 || dd == em || d == 1 && m == Month.MAY || d == 24 && m == Month.DECEMBER || d == 25 && m == Month.DECEMBER || d == 26 && m == Month.DECEMBER) && (d != 31 || m != Month.DECEMBER);
        }
    }

    private static final class XetraCalendar
    extends WesternCalendar {
        private XetraCalendar() {
        }

        @Override
        public String getName() {
            return "Xetra";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || dd == em - 3 || dd == em || d == 1 && m == Month.MAY || d == 24 && m == Month.DECEMBER || d == 25 && m == Month.DECEMBER || d == 26 && m == Month.DECEMBER) && (d != 31 || m != Month.DECEMBER);
        }
    }

    private static final class FWBCalendar
    extends WesternCalendar {
        private FWBCalendar() {
        }

        @Override
        public String getName() {
            return "Frankfurt stock exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || dd == em - 3 || dd == em || d == 1 && m == Month.MAY || d == 24 && m == Month.DECEMBER || d == 25 && m == Month.DECEMBER || d == 26 && m == Month.DECEMBER) && (d != 31 || m != Month.DECEMBER);
        }
    }

    private static final class GermanySettlementCalendar
    extends WesternCalendar {
        private GermanySettlementCalendar() {
        }

        @Override
        public String getName() {
            return "German settlement";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || dd == em - 3 || dd == em || dd == em + 38 || dd == em + 49 || dd == em + 59 || d == 1 && m == Month.MAY || d == 3 && m == Month.OCTOBER || d == 24 && m == Month.DECEMBER || d == 25 && m == Month.DECEMBER || d == 26 && m == Month.DECEMBER) && (d != 31 || m != Month.DECEMBER);
        }
    }

    public static enum Market {
        SETTLEMENT,
        FWB,
        XETRA,
        EUREX;

    }
}

