/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Slovakia
extends DelegateCalendar {
    private static final Slovakia BSSE_CALENDAR = new Slovakia(Market.BSSE);

    private Slovakia(Market market) {
        SlovakiaBSSECalendar delegate;
        switch (market) {
            case BSSE: {
                delegate = new SlovakiaBSSECalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Slovakia getCalendar(Market market) {
        switch (market) {
            case BSSE: {
                return BSSE_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class SlovakiaBSSECalendar
    extends WesternCalendar {
        private SlovakiaBSSECalendar() {
        }

        @Override
        public String getName() {
            return "Bratislava stock exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || d == 6 && m == Month.JANUARY || dd == em - 3 || dd == em || d == 1 && m == Month.MAY || d == 8 && m == Month.MAY || d == 5 && m == Month.JULY || d == 29 && m == Month.AUGUST || d == 1 && m == Month.SEPTEMBER || d == 15 && m == Month.SEPTEMBER || d == 1 && m == Month.NOVEMBER || d == 17 && m == Month.NOVEMBER || d == 24 && m == Month.DECEMBER || d == 25 && m == Month.DECEMBER || d == 26 && m == Month.DECEMBER) && (y < 2004 || (d < 24 || d > 31 || m != Month.DECEMBER) && (d < 1 || d > 6 || m != Month.JANUARY));
        }
    }

    public static enum Market {
        BSSE;

    }
}

