/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.matrixutilities;

import org.jquantlib.math.Matrix;

public class CholeskyDecomposition {
    private boolean error = false;
    private String errorMessage = null;

    Matrix CholeskyDecomposition(Matrix S, boolean flexible) {
        int size = S.rows();
        this.validateMatrix(S);
        Matrix result = new Matrix(size, size, 0.0);
        block0: for (int i = 0; i < size; ++i) {
            for (int j = i; j < size; ++j) {
                double sum = S.get(i, j);
                for (int k = 0; k <= i - 1; ++k) {
                    sum -= result.get(i, k) * result.get(j, k);
                }
                if (i == j) {
                    if (sum <= 0.0) {
                        this.error = true;
                        StringBuffer sb = new StringBuffer("Validate Positive Definate Failed with :").append(sum).append(" <= 0.0 for ").append(i).append(",").append(j);
                        this.errorMessage = sb.toString();
                        continue block0;
                    }
                    result.set(i, i, Math.sqrt(Math.max(sum, 0.0)));
                    continue;
                }
                result.set(j, i, sum == 0.0 ? 0.0 : sum / result.get(i, i));
            }
        }
        return result;
    }

    private boolean validateMatrix(Matrix S) {
        if (S.columns() != S.rows()) {
            throw new RuntimeException("input matrix is not square.");
        }
        return true;
    }
}

