/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.arguments;

import org.jquantlib.instruments.BarrierType;
import org.jquantlib.pricingengines.arguments.OneAssetStrikedOptionArguments;

public class BarrierOptionArguments
extends OneAssetStrikedOptionArguments {
    public BarrierType barrierType;
    public double barrier;
    public double rebate;

    @Override
    public void validate() {
        super.validate();
        double underlying = this.stochasticProcess.initialValues()[0];
        switch (this.barrierType) {
            case DownIn: {
                if (underlying >= this.barrier) break;
                throw new ArithmeticException("underlying (" + underlying + ") < barrier (" + this.barrier + "): down-and-in barrier undefined");
            }
            case UpIn: {
                if (underlying <= this.barrier) break;
                throw new ArithmeticException("underlying (" + underlying + ") > barrier (" + this.barrier + "): up-and-in barrier undefined");
            }
            case DownOut: {
                if (underlying >= this.barrier) break;
                throw new ArithmeticException("underlying (" + underlying + ") < barrier (" + this.barrier + "): down-and-out barrier undefined");
            }
            case UpOut: {
                if (underlying <= this.barrier) break;
                throw new ArithmeticException("underlying (" + underlying + ") > barrier (" + this.barrier + "): up-and-out barrier undefined");
            }
            default: {
                throw new ArithmeticException("unknown type");
            }
        }
    }
}

