/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util.manifestparser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.apache.felix.framework.util.manifestparser.R4Attribute;
import org.apache.felix.framework.util.manifestparser.R4Directive;
import org.apache.felix.moduleloader.ICapability;
import org.osgi.framework.Version;

public class Capability
implements ICapability {
    private String m_namespace = null;
    private R4Directive[] m_directives = null;
    private R4Attribute[] m_attributes = null;
    private Map m_attrMap = null;
    private String[] m_uses = new String[0];
    private String[][] m_includeFilter = null;
    private String[][] m_excludeFilter = null;
    private String m_pkgName = null;
    private Version m_pkgVersion = Version.emptyVersion;

    public Capability(String namespace, R4Directive[] dirs, R4Attribute[] attrs) {
        this.m_namespace = namespace;
        this.m_directives = dirs;
        this.m_attributes = attrs;
        String mandatory = "";
        for (int dirIdx = 0; this.m_directives != null && dirIdx < this.m_directives.length; ++dirIdx) {
            int filterIdx;
            String[] ss;
            if (this.m_directives[dirIdx].getName().equals("uses")) {
                StringTokenizer tok = new StringTokenizer(this.m_directives[dirIdx].getValue(), ",");
                this.m_uses = new String[tok.countTokens()];
                for (int i = 0; i < this.m_uses.length; ++i) {
                    this.m_uses[i] = tok.nextToken().trim();
                }
                continue;
            }
            if (this.m_directives[dirIdx].getName().equals("mandatory")) {
                mandatory = this.m_directives[dirIdx].getValue();
                continue;
            }
            if (this.m_directives[dirIdx].getName().equals("include")) {
                ss = ManifestParser.parseDelimitedString(this.m_directives[dirIdx].getValue(), ",");
                this.m_includeFilter = new String[ss.length][];
                for (filterIdx = 0; filterIdx < ss.length; ++filterIdx) {
                    this.m_includeFilter[filterIdx] = Capability.parseSubstring(ss[filterIdx]);
                }
                continue;
            }
            if (!this.m_directives[dirIdx].getName().equals("exclude")) continue;
            ss = ManifestParser.parseDelimitedString(this.m_directives[dirIdx].getValue(), ",");
            this.m_excludeFilter = new String[ss.length][];
            for (filterIdx = 0; filterIdx < ss.length; ++filterIdx) {
                this.m_excludeFilter[filterIdx] = Capability.parseSubstring(ss[filterIdx]);
            }
        }
        StringTokenizer tok = new StringTokenizer(mandatory, ", ");
        while (tok.hasMoreTokens()) {
            String attrName = tok.nextToken().trim();
            boolean found = false;
            for (int i = 0; !found && i < this.m_attributes.length; ++i) {
                if (!this.m_attributes[i].getName().equals(attrName)) continue;
                this.m_attributes[i] = new R4Attribute(this.m_attributes[i].getName(), this.m_attributes[i].getValue(), true);
                found = true;
            }
            if (found) continue;
            throw new IllegalArgumentException("Mandatory attribute '" + attrName + "' does not exist.");
        }
        for (int i = 0; i < this.m_attributes.length; ++i) {
            if (this.m_attributes[i].getName().equals("package")) {
                this.m_pkgName = (String)this.m_attributes[i].getValue();
                continue;
            }
            if (!this.m_attributes[i].getName().equals("version")) continue;
            this.m_pkgVersion = (Version)this.m_attributes[i].getValue();
        }
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getPackageName() {
        return this.m_pkgName;
    }

    public Version getPackageVersion() {
        return this.m_pkgVersion;
    }

    public R4Directive[] getDirectives() {
        return this.m_directives;
    }

    public R4Attribute[] getAttributes() {
        return this.m_attributes;
    }

    public String[] getUses() {
        return this.m_uses;
    }

    public boolean isIncluded(String name) {
        if (this.m_includeFilter == null && this.m_excludeFilter == null) {
            return true;
        }
        String className = Util.getClassName(name);
        boolean included = this.m_includeFilter == null;
        for (int i = 0; !included && this.m_includeFilter != null && i < this.m_includeFilter.length; ++i) {
            included = Capability.checkSubstring(this.m_includeFilter[i], className);
        }
        boolean excluded = false;
        for (int i = 0; !excluded && this.m_excludeFilter != null && i < this.m_excludeFilter.length; ++i) {
            excluded = Capability.checkSubstring(this.m_excludeFilter[i], className);
        }
        return included && !excluded;
    }

    public Map getProperties() {
        if (this.m_attrMap == null) {
            this.m_attrMap = new Map(){

                public int size() {
                    return Capability.this.m_attributes.length + 2;
                }

                public boolean isEmpty() {
                    return false;
                }

                public boolean containsKey(Object key) {
                    return this.get(key) != null;
                }

                public boolean containsValue(Object value) {
                    if (Capability.this.m_pkgName.equals(value)) {
                        return true;
                    }
                    if (Capability.this.m_pkgVersion.equals(value)) {
                        return true;
                    }
                    for (int i = 0; i < Capability.this.m_attributes.length; ++i) {
                        if (!Capability.this.m_attributes[i].getValue().equals(value)) continue;
                        return true;
                    }
                    return false;
                }

                public Object get(Object key) {
                    if ("package".equals(key)) {
                        return Capability.this.m_pkgName;
                    }
                    if ("version".equals(key)) {
                        return Capability.this.m_pkgVersion;
                    }
                    for (int i = 0; i < Capability.this.m_attributes.length; ++i) {
                        if (!Capability.this.m_attributes[i].getName().equals(key)) continue;
                        return Capability.this.m_attributes[i].getValue();
                    }
                    return null;
                }

                public Object put(Object key, Object value) {
                    throw new UnsupportedOperationException("Map.put() not implemented.");
                }

                public Object remove(Object key) {
                    throw new UnsupportedOperationException("Map.remove() not implemented.");
                }

                public void putAll(Map t) {
                    throw new UnsupportedOperationException("Map.putAll() not implemented.");
                }

                public void clear() {
                    throw new UnsupportedOperationException("Map.clear() not implemented.");
                }

                public Set keySet() {
                    HashSet<String> set = new HashSet<String>();
                    set.add("package");
                    set.add("version");
                    for (int i = 0; i < Capability.this.m_attributes.length; ++i) {
                        set.add(Capability.this.m_attributes[i].getName());
                    }
                    return set;
                }

                public Collection values() {
                    throw new UnsupportedOperationException("Map.values() not implemented.");
                }

                public Set entrySet() {
                    throw new UnsupportedOperationException("Map.entrySet() not implemented.");
                }
            };
        }
        return this.m_attrMap;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(this.getNamespace());
        for (i = 0; this.m_directives != null && i < this.m_directives.length; ++i) {
            sb.append(";");
            sb.append(this.m_directives[i].getName());
            sb.append(":=\"");
            sb.append(this.m_directives[i].getValue());
            sb.append("\"");
        }
        for (i = 0; this.m_attributes != null && i < this.m_attributes.length; ++i) {
            sb.append(";");
            sb.append(this.m_attributes[i].getName());
            sb.append("=\"");
            sb.append(this.m_attributes[i].getValue());
            sb.append("\"");
        }
        return sb.toString();
    }

    private static String[] parseSubstring(String target) {
        ArrayList<String> pieces = new ArrayList<String>();
        StringBuffer ss = new StringBuffer();
        boolean wasStar = false;
        boolean leftstar = false;
        boolean rightstar = false;
        int idx = 0;
        while (true) {
            char c;
            if (idx >= target.length()) {
                if (wasStar) {
                    rightstar = true;
                    break;
                }
                pieces.add(ss.toString());
                break;
            }
            if ((c = target.charAt(idx++)) == '*') {
                if (wasStar) {
                    throw new IllegalArgumentException("Invalid filter string: " + target);
                }
                if (ss.length() > 0) {
                    pieces.add(ss.toString());
                }
                ss.setLength(0);
                if (pieces.size() == 0) {
                    leftstar = true;
                }
                ss.setLength(0);
                wasStar = true;
                continue;
            }
            wasStar = false;
            ss.append(c);
        }
        ss.setLength(0);
        if (leftstar || rightstar || pieces.size() > 1) {
            if (rightstar) {
                pieces.add("");
            }
            if (leftstar) {
                pieces.add(0, "");
            }
        }
        return pieces.toArray(new String[pieces.size()]);
    }

    private static boolean checkSubstring(String[] pieces, String s) {
        boolean result = false;
        int len = pieces.length;
        for (int i = 0; i < len; ++i) {
            String piece = pieces[i];
            int index = 0;
            if (i == len - 1) {
                if (s.endsWith(piece)) {
                    result = true;
                    break;
                }
                result = false;
                break;
            }
            if (i == 0) {
                if (!s.startsWith(piece)) {
                    result = false;
                    break;
                }
            } else if ((index = s.indexOf(piece, index)) < 0) {
                result = false;
                break;
            }
            index += piece.length();
        }
        return result;
    }
}

