/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;

public class EventManager {
    static final boolean DEBUG = false;
    private EventThread thread = null;
    private boolean closed = false;
    protected final String threadName;
    protected final ThreadGroup threadGroup;

    public EventManager() {
        this(null, null);
    }

    public EventManager(String threadName) {
        this(threadName, null);
    }

    public EventManager(String threadName, ThreadGroup threadGroup) {
        this.threadName = threadName;
        this.threadGroup = threadGroup;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (this.thread != null) {
            this.thread.close();
            this.thread = null;
        }
        this.closed = true;
    }

    synchronized EventThread getEventThread() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.thread == null) {
            this.thread = new EventThread(this.threadGroup, this.threadName);
            this.thread.start();
        }
        return this.thread;
    }

    static void dispatchEvent(EventListeners.ListElement[] listeners, EventDispatcher dispatcher, int eventAction, Object eventObject) {
        int size = listeners.length;
        int i = 0;
        while (i < size) {
            EventListeners.ListElement listener = listeners[i];
            if (listener == null) break;
            try {
                dispatcher.dispatchEvent(listener.primary, listener.companion, eventAction, eventObject);
            }
            catch (Throwable throwable) {}
            ++i;
        }
    }

    static class EventThread
    extends Thread {
        private static int nextThreadNumber;
        private Queued head = null;
        private Queued tail = null;
        private volatile boolean running = true;

        EventThread(ThreadGroup threadGroup, String threadName) {
            super(threadGroup, threadName == null ? EventThread.getNextName() : threadName);
            this.setDaemon(true);
        }

        private static synchronized String getNextName() {
            return "EventManagerThread-" + nextThreadNumber++;
        }

        EventThread(String threadName) {
            this((ThreadGroup)null, threadName);
        }

        EventThread() {
            this((ThreadGroup)null, (String)null);
        }

        void close() {
            this.running = false;
            this.interrupt();
        }

        public void run() {
            try {
                while (true) {
                    Queued item;
                    if ((item = this.getNextEvent()) == null) {
                        return;
                    }
                    EventManager.dispatchEvent(item.listeners, item.dispatcher, item.action, item.object);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
        }

        synchronized void postEvent(EventListeners.ListElement[] l, EventDispatcher d, int a, Object o) {
            if (!this.isAlive()) {
                throw new IllegalStateException();
            }
            Queued item = new Queued(l, d, a, o);
            if (this.head == null) {
                this.head = item;
                this.tail = item;
            } else {
                this.tail.next = item;
                this.tail = item;
            }
            this.notify();
        }

        private synchronized Queued getNextEvent() {
            while (this.running && this.head == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.running) {
                return null;
            }
            Queued item = this.head;
            this.head = item.next;
            if (this.head == null) {
                this.tail = null;
            }
            return item;
        }

        private static class Queued {
            final EventListeners.ListElement[] listeners;
            final EventDispatcher dispatcher;
            final int action;
            final Object object;
            Queued next;

            Queued(EventListeners.ListElement[] l, EventDispatcher d, int a, Object o) {
                this.listeners = l;
                this.dispatcher = d;
                this.action = a;
                this.object = o;
                this.next = null;
            }
        }
    }
}

