/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.matcher;

import org.apache.commons.text.matcher.StringMatcher;
import org.apache.commons.text.matcher.StringMatcherFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringMatcherFactoryTest {
    @Test
    public void test_andMatcher() {
        Assertions.assertNotNull((Object)StringMatcherFactory.INSTANCE.andMatcher(new StringMatcher[]{StringMatcherFactory.INSTANCE.charMatcher('1'), StringMatcherFactory.INSTANCE.stringMatcher("2")}));
        Assertions.assertNotNull((Object)StringMatcherFactory.INSTANCE.andMatcher(new StringMatcher[]{null, StringMatcherFactory.INSTANCE.stringMatcher("2")}));
        Assertions.assertNotNull((Object)StringMatcherFactory.INSTANCE.andMatcher(new StringMatcher[]{null, null}));
        StringMatcher andMatcher = StringMatcherFactory.INSTANCE.andMatcher(new StringMatcher[0]);
        Assertions.assertNotNull((Object)andMatcher);
        Assertions.assertEquals((int)0, (int)andMatcher.size());
        andMatcher = StringMatcherFactory.INSTANCE.andMatcher(new StringMatcher[]{StringMatcherFactory.INSTANCE.charMatcher('1')});
        Assertions.assertNotNull((Object)andMatcher);
        Assertions.assertEquals((int)1, (int)andMatcher.size());
    }

    @Test
    public void test_charMatcher() {
        StringMatcher charMatcher = StringMatcherFactory.INSTANCE.charMatcher('1');
        Assertions.assertNotNull((Object)charMatcher);
        Assertions.assertNotNull((Object)charMatcher.toString());
        Assertions.assertEquals((int)1, (int)charMatcher.size());
    }

    @Test
    public void test_charSetMatcher_char() {
        StringMatcher charSetMatcher = StringMatcherFactory.INSTANCE.charSetMatcher(new char[]{'1'});
        Assertions.assertNotNull((Object)charSetMatcher);
        Assertions.assertNotNull((Object)charSetMatcher.toString());
        Assertions.assertEquals((int)1, (int)charSetMatcher.size());
    }

    @Test
    public void test_charSetMatcher_String() {
        StringMatcher charSetMatcher = StringMatcherFactory.INSTANCE.charSetMatcher("1");
        Assertions.assertNotNull((Object)charSetMatcher);
        Assertions.assertNotNull((Object)charSetMatcher.toString());
        Assertions.assertEquals((int)1, (int)charSetMatcher.size());
    }

    @Test
    public void test_commaMatcher() {
        StringMatcher commaMatcher = StringMatcherFactory.INSTANCE.commaMatcher();
        Assertions.assertNotNull((Object)commaMatcher);
        Assertions.assertNotNull((Object)commaMatcher.toString());
        Assertions.assertEquals((int)1, (int)commaMatcher.size());
    }

    @Test
    public void test_doubleQuoteMatcher() {
        StringMatcher doubleQuoteMatcher = StringMatcherFactory.INSTANCE.doubleQuoteMatcher();
        Assertions.assertNotNull((Object)doubleQuoteMatcher);
        Assertions.assertNotNull((Object)doubleQuoteMatcher.toString());
        Assertions.assertEquals((int)1, (int)doubleQuoteMatcher.size());
    }

    @Test
    public void test_noneMatcher() {
        StringMatcher noneMatcher = StringMatcherFactory.INSTANCE.noneMatcher();
        Assertions.assertNotNull((Object)noneMatcher);
        Assertions.assertNotNull((Object)noneMatcher.toString());
        Assertions.assertEquals((int)0, (int)noneMatcher.size());
    }

    @Test
    public void test_quoteMatcher() {
        StringMatcher quoteMatcher = StringMatcherFactory.INSTANCE.quoteMatcher();
        Assertions.assertNotNull((Object)quoteMatcher);
        Assertions.assertNotNull((Object)quoteMatcher.toString());
        Assertions.assertEquals((int)1, (int)quoteMatcher.size());
    }

    @Test
    public void test_singleQuoteMatcher() {
        StringMatcher singleQuoteMatcher = StringMatcherFactory.INSTANCE.singleQuoteMatcher();
        Assertions.assertNotNull((Object)singleQuoteMatcher);
        Assertions.assertNotNull((Object)singleQuoteMatcher.toString());
        Assertions.assertEquals((int)1, (int)singleQuoteMatcher.size());
    }

    @Test
    public void test_spaceMatcher() {
        StringMatcher spaceMatcher = StringMatcherFactory.INSTANCE.spaceMatcher();
        Assertions.assertNotNull((Object)spaceMatcher);
        Assertions.assertNotNull((Object)spaceMatcher.toString());
        Assertions.assertEquals((int)1, (int)spaceMatcher.size());
    }

    @Test
    public void test_splitMatcher() {
        StringMatcher splitMatcher = StringMatcherFactory.INSTANCE.splitMatcher();
        Assertions.assertNotNull((Object)splitMatcher);
        Assertions.assertNotNull((Object)splitMatcher.toString());
        Assertions.assertEquals((int)1, (int)splitMatcher.size());
    }

    @Test
    public void test_stringMatcher() {
        StringMatcher stringMatcher = StringMatcherFactory.INSTANCE.stringMatcher("1");
        Assertions.assertNotNull((Object)stringMatcher);
        Assertions.assertNotNull((Object)stringMatcher.toString());
        Assertions.assertEquals((int)1, (int)stringMatcher.size());
        stringMatcher = StringMatcherFactory.INSTANCE.stringMatcher(new char[0]);
        Assertions.assertNotNull((Object)stringMatcher);
        Assertions.assertNotNull((Object)stringMatcher.toString());
        Assertions.assertEquals((int)0, (int)stringMatcher.size());
    }

    @Test
    public void test_stringMatcherChars() {
        StringMatcher stringMatcher = StringMatcherFactory.INSTANCE.stringMatcher(new char[]{'1', '2'});
        Assertions.assertNotNull((Object)stringMatcher);
        Assertions.assertNotNull((Object)stringMatcher.toString());
        Assertions.assertEquals((int)2, (int)stringMatcher.size());
        stringMatcher = StringMatcherFactory.INSTANCE.stringMatcher(new char[]{'1'});
        Assertions.assertNotNull((Object)stringMatcher);
        Assertions.assertNotNull((Object)stringMatcher.toString());
        Assertions.assertEquals((int)1, (int)stringMatcher.size());
        stringMatcher = StringMatcherFactory.INSTANCE.stringMatcher(new char[0]);
        Assertions.assertNotNull((Object)stringMatcher);
        Assertions.assertNotNull((Object)stringMatcher.toString());
        Assertions.assertEquals((int)0, (int)stringMatcher.size());
    }

    @Test
    public void test_tabMatcher() {
        StringMatcher charMatcher = StringMatcherFactory.INSTANCE.charMatcher('1');
        Assertions.assertNotNull((Object)charMatcher);
        Assertions.assertNotNull((Object)charMatcher.toString());
        Assertions.assertEquals((int)1, (int)charMatcher.size());
    }

    @Test
    public void test_trimMatcher() {
        StringMatcher charMatcher = StringMatcherFactory.INSTANCE.charMatcher('1');
        Assertions.assertNotNull((Object)charMatcher);
        Assertions.assertNotNull((Object)charMatcher.toString());
        Assertions.assertEquals((int)1, (int)charMatcher.size());
    }

    @Test
    public void testDefaultMethods() {
        StringMatcherDefaults stringMatcher = new StringMatcherDefaults();
        Assertions.assertEquals((int)0, (int)stringMatcher.size());
        Assertions.assertEquals((int)2, (int)stringMatcher.isMatch("1", 0));
    }

    private static final class StringMatcherDefaults
    implements StringMatcher {
        private StringMatcherDefaults() {
        }

        public int isMatch(char[] buffer, int start, int bufferStart, int bufferEnd) {
            return 2;
        }
    }
}

