#!/bin/sh
set -e
GV=$1
[ -z "$GV" ] && echo "GV not set" && exit 1
PV=`grep -h '^".*:v' pub/*/*.c | awk '{print $2}' | awk -F/ '{printf "%04i%02i%02i\n", $3, $1, $2}' | sort -u | tail -n1`
P="ethercard-diag-$PV.${GV}g"
rm -rf $P
git-archive --prefix=$P/ master | tar xf -
git-format-patch -o $P/patches/ master..Gentoo
tar cf - $P | lzma > $P.tar.lzma
rm -rf $P
lzcat $P.tar.lzma | tar xf -
cd $P
make -j4 -s
cd ..
rm -rf $P
du -b $P.tar.lzma
