/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import org.aspectj.testing.Tester;

public class Util {
    public static final String DEFAULT_COMMAND = "-read";
    public static final String DEFAULT_NAME = "test.ser";

    public static void fail(String name) throws Exception {
        try {
            Util.read(name);
            Tester.checkFailed((String)"java.io.InvalidClassException");
        }
        catch (InvalidClassException ex) {
            System.out.println("? Util.fail() ex=" + ex);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object read(String name) throws Exception {
        Object obj;
        File file = new File(name);
        file.deleteOnExit();
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(file));
            obj = in.readObject();
            System.out.println("? Util.read() obj=" + obj);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            in.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        in.close();
        return obj;
    }

    public static void write(String name, Object obj) throws IOException {
        File file = new File(name);
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
        out.writeObject(obj);
        out.close();
        System.out.println("? Util.write() suid=" + ObjectStreamClass.lookup(obj.getClass()));
    }

    public static void main(String[] args) throws Exception {
        String name;
        String command = args.length > 0 ? args[0] : DEFAULT_COMMAND;
        String string = name = args.length > 1 ? args[1] : DEFAULT_NAME;
        if (command.equals(DEFAULT_COMMAND)) {
            Util.read(name);
        } else if (command.equals("-fail")) {
            Util.fail(name);
        }
    }
}

