/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajbrowser;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.BuildListener;
import org.aspectj.ajde.ui.FileStructureView;
import org.aspectj.ajde.ui.InvalidResourceException;
import org.aspectj.ajde.ui.internal.UserPreferencesStore;
import org.aspectj.ajde.ui.swing.AjdeUIManager;
import org.aspectj.ajde.ui.swing.IconRegistry;
import org.aspectj.ajde.ui.swing.MultiStructureViewPanel;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IHierarchyListener;
import org.aspectj.tools.ajbrowser.BasicEditor;
import org.aspectj.tools.ajbrowser.BrowserOptionsPanel;
import org.aspectj.tools.ajbrowser.BrowserProperties;
import org.aspectj.tools.ajbrowser.BrowserUIAdapter;
import org.aspectj.tools.ajbrowser.CompilerMessagesPanel;
import org.aspectj.tools.ajbrowser.EditorManager;
import org.aspectj.tools.ajbrowser.TopFrame;
import org.aspectj.util.FileUtil;

public class BrowserManager {
    private static final BrowserManager INSTANCE = new BrowserManager();
    private BrowserProperties browserProjectProperties;
    private EditorManager editorManager;
    private List configFiles = new ArrayList();
    public static final String TITLE = "AspectJ Browser";
    private static TopFrame topFrame = null;
    public final IHierarchyListener VIEW_LISTENER = new IHierarchyListener(){

        public void elementsUpdated(IHierarchy model) {
            FileStructureView fsv = Ajde.getDefault().getStructureViewManager().getDefaultFileView();
            if (fsv != null) {
                fsv.setSourceFile(BrowserManager.getDefault().getEditorManager().getCurrFile());
            }
        }
    };
    private final BuildListener BUILD_MESSAGES_LISTENER = new BuildListener(){

        public void compileStarted(String buildConfigFile) {
        }

        public void compileFinished(String buildConfigFile, int buildTime, boolean succeeded, boolean warnings) {
            if (succeeded && !warnings) {
                BrowserManager.this.hideMessages();
            } else {
                BrowserManager.this.showMessages();
            }
        }

        public void compileAborted(String buildConfigFile, String message) {
        }
    };

    public static BrowserManager getDefault() {
        return INSTANCE;
    }

    public void init(String[] configFilesArgs, boolean visible) {
        try {
            UserPreferencesStore preferencesAdapter = new UserPreferencesStore(true);
            this.browserProjectProperties = new BrowserProperties(preferencesAdapter);
            CompilerMessagesPanel taskListManager = new CompilerMessagesPanel();
            BasicEditor ajdeEditor = new BasicEditor();
            BrowserUIAdapter browserUIAdapter = new BrowserUIAdapter();
            topFrame = new TopFrame();
            this.configFiles = this.getConfigFilesList(configFilesArgs);
            AjdeUIManager.getDefault().init(ajdeEditor, taskListManager, this.browserProjectProperties, preferencesAdapter, browserUIAdapter, new IconRegistry(), topFrame, true);
            this.editorManager = new EditorManager(ajdeEditor);
            Ajde.getDefault().getBuildManager().addListener(this.BUILD_MESSAGES_LISTENER);
            MultiStructureViewPanel multiViewPanel = new MultiStructureViewPanel(AjdeUIManager.getDefault().getViewManager().getBrowserPanel(), AjdeUIManager.getDefault().getFileStructurePanel());
            topFrame.init(multiViewPanel, taskListManager, this.editorManager.getEditorPanel());
            if (visible) {
                ((Component)topFrame).setVisible(true);
            }
            if (this.configFiles.size() == 0) {
                Ajde.getDefault().getErrorHandler().handleWarning("No build configuration selected. Select a \".lst\" build configuration file in order to compile and navigate structure.");
            }
            AjdeUIManager.getDefault().getOptionsFrame().addOptionsPanel(new BrowserOptionsPanel());
            AsmManager.getDefault().addListener(this.VIEW_LISTENER);
            if (configFilesArgs.length > 0 && configFilesArgs[0] != null) {
                Ajde.getDefault().getConfigurationManager().setActiveConfigFile(configFilesArgs[0]);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Ajde.getDefault().getErrorHandler().handleError("AJDE failed to initialize.", t);
        }
    }

    public void resetEditorFrame() {
        topFrame.resetSourceEditorPanel();
    }

    public void resetEditor() {
        ((Component)BrowserManager.getDefault().getRootFrame()).setSize(BrowserManager.getDefault().getRootFrame().getWidth() + 1, BrowserManager.getDefault().getRootFrame().getHeight() + 1);
        BrowserManager.getDefault().getRootFrame().doLayout();
        BrowserManager.getDefault().getRootFrame().repaint();
    }

    public void setStatusInformation(String text) {
        BrowserManager.topFrame.statusText_label.setText(text);
    }

    public void setEditorStatusText(String text) {
        topFrame.setTitle("AspectJ Browser - " + text);
    }

    public void saveAll() {
        this.editorManager.saveContents();
    }

    public void showMessages() {
        topFrame.showMessagesPanel();
    }

    public void hideMessages() {
        topFrame.hideMessagesPanel();
    }

    public JFrame getRootFrame() {
        return topFrame;
    }

    public void openFile(String filePath) {
        try {
            if (filePath.endsWith(".lst")) {
                AjdeUIManager.getDefault().getBuildConfigEditor().openFile(filePath);
                topFrame.setEditorPanel(AjdeUIManager.getDefault().getBuildConfigEditor());
            } else if (FileUtil.hasSourceSuffix(filePath)) {
                this.editorManager.showSourceLine(filePath, 0, false);
            } else {
                Ajde.getDefault().getErrorHandler().handleError("File: " + filePath + " could not be opened because the extension was not recoginzed.");
            }
        }
        catch (IOException ioe) {
            Ajde.getDefault().getErrorHandler().handleError("Could not open file: " + filePath, ioe);
        }
        catch (InvalidResourceException ire) {
            Ajde.getDefault().getErrorHandler().handleError("Invalid file: " + filePath, ire);
        }
        this.browserProjectProperties.setLastOpenSourceFilePath(filePath);
    }

    private List getConfigFilesList(String[] configFiles) {
        ArrayList<String> configs = new ArrayList<String>();
        for (int i = 0; i < configFiles.length; ++i) {
            if (!configFiles[i].endsWith(".lst")) continue;
            configs.add(configFiles[i]);
        }
        return configs;
    }

    public List getConfigFiles() {
        return this.configFiles;
    }

    public BrowserProperties getBrowserProjectProperties() {
        return this.browserProjectProperties;
    }

    public EditorManager getEditorManager() {
        return this.editorManager;
    }
}

