/*
* This code is released under the GNU General Public License.  See COPYING for 
* details.  Copyright 2003 John Spray: spray_john@users.sourceforge.net
*/


#include <math.h>
#include <SDL_opengl.h>
#include <SDL.h>
#include <SDL_ttf.h>
#include <string.h>

#include "MenuItem.h"

GLuint SDL_GL_LoadTexture(SDL_Surface *surface, GLfloat *texcoord);

MenuItem::MenuItem()
{
	selected=0;
	target=NULL;
}

void MenuItem::SetPos(int newx,int newwidth,int newy,int newheight)
{
	x=newx;
	width=newwidth;
	y=newy;
	height=newheight;
}

int MenuItem::CheckClick(int clickx,int clicky)
{
	if(clickx>x && clickx<x+width &&
	clicky>y && clicky<y+height){
		return 1;
	}
	return 0;
}

void MenuItem::Draw(int viewportx,int viewporty)
{
	static int pulsing=0;
	static int pulsingv=1;
	static float arrowscale=1;
	static float arrowscalev=-0.01;
	float displayval;

	pulsing+=pulsingv;
	if(pulsing>100||pulsing<0)
		pulsingv*=-1;

	arrowscale+=arrowscalev;
	if(arrowscale<0.5||arrowscale>1)
		arrowscalev*=-1;

	glPushMatrix();
	glLoadIdentity();

	SDL_Surface* text;
	SDL_Color color = {255,255,255,0};
	GLfloat texcoords[4];
	int gltex;
	char displaytext[128];
	char displaytextvalue[32];


	strcpy(displaytext,label);

	if(function==MENU_FLOAT){
		sprintf(displaytextvalue,"%.1f",*((float*)target));
		strcat(displaytext,displaytextvalue);
	}
	else if(function==MENU_FLOATONE){
		//Squash the negative bit for display neatness
		displayval=*(float*)target;
		displayval=fabs(displayval);
		sprintf(displaytextvalue,"%.1f",*((float*)target));
		strcat(displaytext,displaytextvalue);
	}
	else if(function==MENU_STRING){
		sprintf(displaytextvalue,"%s",(char*)target);
		strcat(displaytext,displaytextvalue);
	}
	else if(function==MENU_BOOL){
		if(*(int*)target){
			sprintf(displaytextvalue,"Yes");
			strcat(displaytext,displaytextvalue);
		}
		else{
			sprintf(displaytextvalue,"No");
			strcat(displaytext,displaytextvalue);
		}
	}

	text=TTF_RenderText_Blended(parent->font,displaytext,color);

	width=static_cast<int>(text->w*(viewportx/800.0f));  //ie compensate for different window size, with fonts appearing true size
	height=static_cast<int>((int)text->h*(viewporty/600.0f)); //at 800x600
	x=viewportx/2-width/2;

	gltex=parent->visual->SDL_GL_LoadTexture(text,texcoords);

	SDL_FreeSurface(text);

	float shadowoffset=3;
	glColor4f(0.0f,0.0f,0.0f,0.5f);

	glBegin(GL_QUADS);
		glTexCoord2f(texcoords[0],texcoords[1]);
		glVertex3f(x+shadowoffset,viewporty-y-shadowoffset,0);
		glTexCoord2f(texcoords[0],texcoords[3]);
		glVertex3f(x+shadowoffset,viewporty-y-height-shadowoffset,0);
		glTexCoord2f(texcoords[2],texcoords[3]);
		glVertex3f(x+shadowoffset+width,viewporty-y-height-shadowoffset,0);
		glTexCoord2f(texcoords[2],texcoords[1]);
		glVertex3f(x+shadowoffset+width,viewporty-y-shadowoffset,0);
	glEnd();
	


	glColor4f(1.0f,0.0f,0.0f,0.5f+selected*((float)pulsing/100.0f)*0.5f);

	glBegin(GL_QUADS);
		glTexCoord2f(texcoords[0],texcoords[1]);
		glVertex3f(x,viewporty-y,0);
		glTexCoord2f(texcoords[0],texcoords[3]);
		glVertex3f(x,viewporty-y-height,0);
		glTexCoord2f(texcoords[2],texcoords[3]);
		glVertex3f(x+width,viewporty-y-height,0);
		glTexCoord2f(texcoords[2],texcoords[1]);
		glVertex3f(x+width,viewporty-y,0);
	glEnd();

	if(function==MENU_FLOATONE && selected){
		glColor4f(1.0f,0.0f,0.0f,0.2f);
		glDisable(GL_TEXTURE_2D);
		glBegin(GL_QUADS);
			glVertex3f(x,viewporty-y,0);
			glVertex3f(x,viewporty-y-height,0);
			glVertex3f(x+width*(*((float*)target)),viewporty-y-height,0);
			glVertex3f(x+width*(*((float*)target)),viewporty-y,0);
		glEnd();
		glEnable(GL_TEXTURE_2D);
	}

	glDeleteTextures(1,(GLuint*)&gltex);

	glColor4f(1.0f,0.0f,0.0f,0.5f+selected*((float)pulsing/100.0f)*0.5f);

	if(selected){
		glDisable(GL_TEXTURE_2D);
		glTranslatef(x+width,viewporty-y-height/2,0);
		glBegin(GL_TRIANGLES);
			glVertex3f(0,0,0);
			glVertex3f(+(height/2)*arrowscale,-(height/2)*arrowscale,0);
			glVertex3f(+(height/2)*arrowscale,+(height/2)*arrowscale,0);
		glEnd();
		glTranslatef(-width,0,0);
		glBegin(GL_TRIANGLES);
			glVertex3f(0,0,0);
			glVertex3f(-(height/2)*arrowscale,+(height/2)*arrowscale,0);
			glVertex3f(-(height/2)*arrowscale,-(height/2)*arrowscale,0);
		glEnd();
		glEnable(GL_TEXTURE_2D);
	}

	glPopMatrix();

}

void MenuItem::Left()
{
	if(function==MENU_FLOAT)
		*(float*)target-=0.1;
	if(function==MENU_FLOATONE)
	// 0.001 coping with 0.0 apparently not being equal to -0.0
		if(*(float*)target-0.1>=-0.001)	
			*(float*)target-=0.1;	
	if(function==MENU_BOOL)
		*(int*)target=!*(int*)target;
}

void MenuItem::Right()
{
	if(function==MENU_FLOAT)
		*(float*)target+=0.1;
	if(function==MENU_FLOATONE)
	// 0.001 coping with 0.0 apparently not being equal to -0.0
		if(*(float*)target+0.1<=1.001)	
			*(float*)target+=0.1;	
	if(function==MENU_BOOL)
		*(int*)target=!*(int*)target;
}



