#
# Parse the command line...
#
# $Id: args.tcl,v 1.7 2011/02/17 14:58:11 rader Exp $
#

proc ParseArgs { } { 
  global argc argv cl cols rows win_size debug
  global font taskdata task_args default_task_cmd cur_task_cmd
  global color_fg color_bg
  global ignore_exit_status

  set cl ""
  for { set i 0 } { $i < $argc } { incr i } {
    set arg [lindex $argv $i]
    set cl "$cl $arg"
    if { $arg == "--background" || $arg == "-bg" } {
      incr i
      set cl "$cl [lindex $argv $i]"
      if { $i >= $argc } {
        Usage
        exit
      }
      set color_bg [lindex $argv $i]
      continue
    }
    if { $arg == "--commands" || $arg == "-c" } {
      CommandLineHelp
      exit
    }
    if { $arg == "--debug" || $arg == "-d" } {
      puts "Debug=1"
      set debug 1
      continue
    }
    if { $arg == "--help" || $arg == "-h" } {
      Usage
      exit
    }
    if { $arg == "--data" || $arg == "-ds" } {
      incr i
      set cl "$cl [lindex $argv $i]"
      if { $i >= $argc } {
        Usage
        exit
      }
      set taskdata [lindex $argv $i]
      set task_args "rc.data.location:$taskdata $task_args"
      continue
    }
    if { $arg == "--font" || $arg == "-fn" } {
      incr i
      set cl "$cl [lindex $argv $i]"
      if { $i >= $argc } {
        Usage
        exit
      }
      set font [lindex $argv $i]
      continue
    }
    if { $arg == "--foreground" || $arg == "-fg" } {
      incr i
      set cl "$cl [lindex $argv $i]"
      if { $i >= $argc } {
        Usage
        exit
      }
      set color_fg [lindex $argv $i]
      continue
    }
    if { $arg == "--geometry" || $arg == "-geom" } {
      incr i
      set cl "$cl [lindex $argv $i]"
      if { $i >= $argc } {
        Usage
        exit
      }
      set s [lindex $argv $i]
      if { ! [regexp {([0-9]+)x([0-9]+)} $s junk cols rows] } {
        Usage
        exit
      }
      set win_size [expr $rows - 6]
      set defaultwidth [expr $cols - 2]
      regsub { rc.defaultwidth=[0-9]+ } $task_args " rc.defaultwidth=$defaultwidth " task_args
      continue
    }
    if { $arg == "--ignore-exit-status" || $arg == "-i" } {
      set ignore_exit_status 1
      continue
    }
    if { $arg == "--report" || $arg == "-r" } {
      incr i
      if { $i >= $argc } {
        Usage
        exit
      }
      set default_task_cmd [lindex $argv $i]
      set cur_task_cmd $default_task_cmd
      continue
    }
    if { $arg == "--taskrc" || $arg == "-t" } {
      incr i
      set cl "$cl [lindex $argv $i]"
      if { $i >= $argc } {
        Usage
        exit
      }
      set taskrc [lindex $argv $i]
      if { ! [file exists $taskrc] } {
        puts "vittk: $taskrc: No such file"
        exit
      }
      set task_args "rc:$taskrc $task_args"
      continue
    }
    puts "vittk: invalid option: $arg"
    puts "Try `vittk --help' for more information."
    exit
  }
  regsub -all {^ +} $cl "" cl
}

