// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`InvokeModelWithResponseStream`](crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`body(Blob)`](crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamFluentBuilder::body) / [`set_body(Option<Blob>)`](crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamFluentBuilder::set_body):<br>required: **false**<br><p>The prompt and inference parameters in the format specified in the <code>contentType</code> in the header. You must provide the body in JSON format. To see the format and content of the request and response bodies for different models, refer to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/api-methods-run.html">Run inference</a> in the Bedrock User Guide.</p><br>
    ///   - [`content_type(impl Into<String>)`](crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamFluentBuilder::content_type) / [`set_content_type(Option<String>)`](crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamFluentBuilder::set_content_type):<br>required: **false**<br><p>The MIME type of the input data in the request. You must specify <code>application/json</code>.</p><br>
    ///   - [`accept(impl Into<String>)`](crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamFluentBuilder::accept) / [`set_accept(Option<String>)`](crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamFluentBuilder::set_accept):<br>required: **false**<br><p>The desired MIME type of the inference body in the response. The default value is <code>application/json</code>.</p><br>
    ///   - [`model_id(impl Into<String>)`](crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamFluentBuilder::model_id) / [`set_model_id(Option<String>)`](crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamFluentBuilder::set_model_id):<br>required: **true**<br><p>The unique identifier of the model to invoke to run inference.</p> <p>The <code>modelId</code> to provide depends on the type of model or throughput that you use:</p> <ul>  <li>   <p>If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.</p></li>  <li>   <p>If you use an inference profile, specify the inference profile ID or its ARN. For a list of inference profile IDs, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html">Supported Regions and models for cross-region inference</a> in the Amazon Bedrock User Guide.</p></li>  <li>   <p>If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a Provisioned Throughput</a> in the Amazon Bedrock User Guide.</p></li>  <li>   <p>If you use a custom model, first purchase Provisioned Throughput for it. Then specify the ARN of the resulting provisioned model. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p></li>  <li>   <p>If you use an <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">imported model</a>, specify the ARN of the imported model. You can get the model ARN from a successful call to <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html">CreateModelImportJob</a> or from the Imported models page in the Amazon Bedrock console.</p></li> </ul><br>
    ///   - [`trace(Trace)`](crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamFluentBuilder::trace) / [`set_trace(Option<Trace>)`](crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamFluentBuilder::set_trace):<br>required: **false**<br><p>Specifies whether to enable or disable the Bedrock trace. If enabled, you can see the full Bedrock trace.</p><br>
    ///   - [`guardrail_identifier(impl Into<String>)`](crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamFluentBuilder::guardrail_identifier) / [`set_guardrail_identifier(Option<String>)`](crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamFluentBuilder::set_guardrail_identifier):<br>required: **false**<br><p>The unique identifier of the guardrail that you want to use. If you don't provide a value, no guardrail is applied to the invocation.</p> <p>An error is thrown in the following situations.</p> <ul>  <li>   <p>You don't provide a guardrail identifier but you specify the <code>amazon-bedrock-guardrailConfig</code> field in the request body.</p></li>  <li>   <p>You enable the guardrail but the <code>contentType</code> isn't <code>application/json</code>.</p></li>  <li>   <p>You provide a guardrail identifier, but <code>guardrailVersion</code> isn't specified.</p></li> </ul><br>
    ///   - [`guardrail_version(impl Into<String>)`](crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamFluentBuilder::guardrail_version) / [`set_guardrail_version(Option<String>)`](crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamFluentBuilder::set_guardrail_version):<br>required: **false**<br><p>The version number for the guardrail. The value can also be <code>DRAFT</code>.</p><br>
    ///   - [`performance_config_latency(PerformanceConfigLatency)`](crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamFluentBuilder::performance_config_latency) / [`set_performance_config_latency(Option<PerformanceConfigLatency>)`](crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamFluentBuilder::set_performance_config_latency):<br>required: **false**<br><p>Model performance settings for the request.</p><br>
    /// - On success, responds with [`InvokeModelWithResponseStreamOutput`](crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamOutput) with field(s):
    ///   - [`body(EventReceiver<ResponseStream, ResponseStreamError>)`](crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamOutput::body): <p>Inference response from the model in the format specified by the <code>contentType</code> header. To see the format and content of this field for different models, refer to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>.</p>
    ///   - [`content_type(String)`](crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamOutput::content_type): <p>The MIME type of the inference result.</p>
    ///   - [`performance_config_latency(Option<PerformanceConfigLatency>)`](crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamOutput::performance_config_latency): <p>Model performance settings for the request.</p>
    /// - On failure, responds with [`SdkError<InvokeModelWithResponseStreamError>`](crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError)
    pub fn invoke_model_with_response_stream(
        &self,
    ) -> crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamFluentBuilder {
        crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamFluentBuilder::new(self.handle.clone())
    }
}
