# Swiss Map [![Build Status](https://github.com/cockroachdb/swiss/actions/workflows/ci.yaml/badge.svg?branch=main)](https://github.com/cockroachdb/swiss/actions/workflows/ci.yaml) [![GoDoc](https://godoc.org/github.com/cockroachdb/swiss?status.svg)](https://godoc.org/github.com/cockroachdb/swiss)

`swiss.Map` is a Go implementation of [Google's Swiss Tables hash table
design](https://abseil.io/about/design/swisstables). The [Rust version of
Swiss Tables](https://github.com/rust-lang/hashbrown) is now the `HashMap`
implementation in the Rust standard library.

A `swiss.Map[K,V]` maps keys of type `K` to values of type `V`, similar to
Go's builtin `map[K]V` type. The primary advantage of `swiss.Map` over Go's
builtin map is performance. `swiss.Map` has similar or slightly better
performance than Go's builtin map for small map sizes, and significantly
better performance at large map sizes. The benchmarks where `swiss.Map`
performs worse are due to a fast-path optimization in Go's builtin maps for
tiny (6 or fewer element) maps with int32, int64, or string keys, and when
growing a tiny map no initial capacity specified. In the latter case, Go's
builtin map is sometimes able to place the map and first bucket on the stack
avoiding heap allocations entirely.

<details>
<summary>Performance: Go's builtin map (old) vs swiss.Map (new)</summary>

Tested on a GCE `n1-standard-16` instance.

```
goos: linux
goarch: amd64
pkg: github.com/cockroachdb/swiss
cpu: Intel(R) Xeon(R) CPU @ 2.60GHz

name                                 old time/op    new time/op    delta
MapIter/Int/6-16                       72.9ns ± 1%    38.3ns ± 1%      -47.53%  (p=0.000 n=10+10)
MapIter/Int/12-16                       123ns ± 1%      56ns ± 2%      -54.72%  (p=0.000 n=9+10)
MapIter/Int/18-16                       191ns ± 5%      80ns ± 1%      -58.11%  (p=0.000 n=10+9)
MapIter/Int/24-16                       229ns ± 4%      89ns ± 1%      -61.41%  (p=0.000 n=10+10)
MapIter/Int/30-16                       300ns ± 2%     125ns ± 2%      -58.47%  (p=0.000 n=9+10)
MapIter/Int/64-16                       588ns ± 3%     233ns ± 1%      -60.33%  (p=0.000 n=10+10)
MapIter/Int/128-16                     1.14µs ± 4%    0.45µs ± 1%      -60.73%  (p=0.000 n=10+10)
MapIter/Int/256-16                     2.38µs ± 2%    0.86µs ± 0%      -63.89%  (p=0.000 n=10+10)
MapIter/Int/512-16                     5.13µs ± 2%    1.70µs ± 0%      -66.89%  (p=0.000 n=10+10)
MapIter/Int/1024-16                    11.0µs ± 2%     4.0µs ± 3%      -63.31%  (p=0.000 n=10+10)
MapIter/Int/2048-16                    22.6µs ± 2%    10.7µs ± 1%      -52.70%  (p=0.000 n=10+9)
MapIter/Int/4096-16                    45.8µs ± 2%    23.6µs ± 0%      -48.52%  (p=0.000 n=10+10)
MapIter/Int/8192-16                    91.4µs ± 0%    48.7µs ± 0%      -46.67%  (p=0.000 n=8+9)
MapIter/Int/32768-16                    367µs ± 1%     198µs ± 0%      -46.03%  (p=0.000 n=10+10)
MapIter/Int/65536-16                    735µs ± 1%     397µs ± 0%      -46.03%  (p=0.000 n=10+10)
MapIter/Int/131072-16                  1.47ms ± 1%    0.79ms ± 0%      -46.01%  (p=0.000 n=9+10)
MapIter/Int/262144-16                  2.96ms ± 2%    1.60ms ± 0%      -46.04%  (p=0.000 n=10+10)
MapIter/Int/524288-16                  6.07ms ± 2%    3.23ms ± 0%      -46.82%  (p=0.000 n=10+10)
MapIter/Int/1048576-16                 12.3ms ± 2%     6.9ms ± 1%      -44.18%  (p=0.000 n=10+10)
MapIter/Int/2097152-16                 24.9ms ± 1%    14.5ms ± 1%      -41.78%  (p=0.000 n=10+10)
MapIter/Int/4194304-16                 50.5ms ± 1%    29.2ms ± 1%      -42.14%  (p=0.000 n=10+10)
MapGetHit/Int64/6-16                   4.93ns ± 0%    6.62ns ±15%      +34.14%  (p=0.000 n=10+10)
MapGetHit/Int64/12-16                  7.29ns ± 1%    6.35ns ± 0%      -12.89%  (p=0.000 n=8+8)
MapGetHit/Int64/18-16                  7.57ns ±18%    6.56ns ± 9%      -13.30%  (p=0.001 n=10+10)
MapGetHit/Int64/24-16                  7.54ns ± 5%    6.67ns ± 7%      -11.56%  (p=0.000 n=10+9)
MapGetHit/Int64/30-16                  7.01ns ± 2%    6.35ns ± 0%       -9.46%  (p=0.000 n=10+8)
MapGetHit/Int64/64-16                  7.09ns ± 1%    6.72ns ±10%       -5.23%  (p=0.001 n=10+10)
MapGetHit/Int64/128-16                 7.13ns ± 2%    6.73ns ± 3%       -5.62%  (p=0.000 n=10+10)
MapGetHit/Int64/256-16                 7.14ns ± 1%    6.72ns ± 3%       -5.96%  (p=0.000 n=10+10)
MapGetHit/Int64/512-16                 7.20ns ± 1%    6.76ns ± 1%       -6.15%  (p=0.000 n=10+9)
MapGetHit/Int64/1024-16                7.44ns ± 1%    6.81ns ± 1%       -8.41%  (p=0.000 n=10+8)
MapGetHit/Int64/2048-16                10.2ns ± 4%     7.1ns ± 1%      -29.79%  (p=0.000 n=10+10)
MapGetHit/Int64/4096-16                16.4ns ± 2%     8.6ns ± 1%      -47.76%  (p=0.000 n=10+10)
MapGetHit/Int64/8192-16                19.6ns ± 2%     8.9ns ± 1%      -54.48%  (p=0.000 n=10+10)
MapGetHit/Int64/32768-16               23.0ns ± 1%     9.9ns ± 1%      -57.18%  (p=0.000 n=10+10)
MapGetHit/Int64/65536-16               26.0ns ± 1%    14.1ns ± 3%      -45.65%  (p=0.000 n=10+10)
MapGetHit/Int64/131072-16              27.1ns ± 1%    16.1ns ± 4%      -40.67%  (p=0.000 n=10+10)
MapGetHit/Int64/262144-16              29.9ns ± 3%    17.7ns ± 4%      -40.85%  (p=0.000 n=10+10)
MapGetHit/Int64/524288-16              33.5ns ± 5%    20.1ns ± 2%      -39.88%  (p=0.000 n=10+7)
MapGetHit/Int64/1048576-16             45.3ns ±10%    30.8ns ± 9%      -32.00%  (p=0.000 n=10+10)
MapGetHit/Int64/2097152-16             55.4ns ± 2%    47.0ns ± 3%      -15.07%  (p=0.000 n=10+10)
MapGetHit/Int64/4194304-16             58.7ns ± 2%    55.0ns ± 2%       -6.34%  (p=0.000 n=9+10)
MapGetHit/Int32/6-16                   5.04ns ± 0%    6.40ns ± 0%      +27.16%  (p=0.000 n=10+9)
MapGetHit/Int32/12-16                  7.71ns ±11%    6.53ns ± 3%      -15.29%  (p=0.000 n=10+9)
MapGetHit/Int32/18-16                  8.04ns ± 8%    6.41ns ± 0%      -20.29%  (p=0.000 n=8+8)
MapGetHit/Int32/24-16                  7.93ns ±10%    6.61ns ± 6%      -16.71%  (p=0.000 n=10+10)
MapGetHit/Int32/30-16                  7.00ns ± 4%    6.74ns ±13%         ~     (p=0.165 n=10+10)
MapGetHit/Int32/64-16                  7.05ns ± 0%    6.75ns ± 2%       -4.20%  (p=0.000 n=8+8)
MapGetHit/Int32/128-16                 7.08ns ± 1%    6.94ns ± 5%       -2.06%  (p=0.028 n=9+10)
MapGetHit/Int32/256-16                 7.11ns ± 1%    6.76ns ± 4%       -4.90%  (p=0.000 n=10+10)
MapGetHit/Int32/512-16                 7.22ns ± 1%    6.79ns ± 4%       -5.99%  (p=0.000 n=10+10)
MapGetHit/Int32/1024-16                7.31ns ± 0%    6.72ns ± 1%       -8.14%  (p=0.000 n=8+10)
MapGetHit/Int32/2048-16                8.91ns ± 6%    6.76ns ± 1%      -24.15%  (p=0.000 n=10+10)
MapGetHit/Int32/4096-16                16.3ns ± 1%     8.1ns ± 1%      -50.37%  (p=0.000 n=9+10)
MapGetHit/Int32/8192-16                19.1ns ± 1%     8.4ns ± 1%      -55.92%  (p=0.000 n=10+10)
MapGetHit/Int32/32768-16               22.0ns ± 1%     8.9ns ± 0%      -59.57%  (p=0.000 n=10+8)
MapGetHit/Int32/65536-16               24.0ns ± 0%    10.2ns ± 1%      -57.39%  (p=0.000 n=9+8)
MapGetHit/Int32/131072-16              26.2ns ± 1%    13.5ns ± 4%      -48.57%  (p=0.000 n=10+10)
MapGetHit/Int32/262144-16              27.1ns ± 1%    15.2ns ± 3%      -43.76%  (p=0.000 n=10+10)
MapGetHit/Int32/524288-16              30.2ns ± 4%    16.4ns ± 3%      -45.49%  (p=0.000 n=9+10)
MapGetHit/Int32/1048576-16             34.3ns ±10%    19.4ns ± 3%      -43.58%  (p=0.000 n=9+10)
MapGetHit/Int32/2097152-16             44.4ns ±11%    29.5ns ± 5%      -33.50%  (p=0.000 n=10+10)
MapGetHit/Int32/4194304-16             52.8ns ± 3%    42.7ns ± 2%      -19.13%  (p=0.000 n=9+10)
MapGetHit/String/6-16                  12.9ns ± 1%     9.7ns ±23%      -24.32%  (p=0.000 n=10+10)
MapGetHit/String/12-16                 9.52ns ± 7%    9.52ns ± 7%         ~     (p=0.930 n=10+10)
MapGetHit/String/18-16                 10.4ns ± 5%     9.5ns ± 1%       -8.91%  (p=0.000 n=9+9)
MapGetHit/String/24-16                 9.67ns ± 9%   10.95ns ± 5%      +13.17%  (p=0.000 n=10+8)
MapGetHit/String/30-16                 8.74ns ± 3%    9.48ns ± 1%       +8.49%  (p=0.000 n=10+8)
MapGetHit/String/64-16                 8.94ns ± 2%   10.02ns ± 4%      +12.02%  (p=0.000 n=10+10)
MapGetHit/String/128-16                9.47ns ± 2%   10.02ns ± 4%       +5.82%  (p=0.000 n=10+10)
MapGetHit/String/256-16                10.3ns ± 2%    10.0ns ± 4%       -3.33%  (p=0.000 n=10+10)
MapGetHit/String/512-16                10.9ns ± 2%    10.0ns ± 4%       -7.78%  (p=0.000 n=10+10)
MapGetHit/String/1024-16               11.3ns ± 2%    10.5ns ± 5%       -7.45%  (p=0.000 n=9+10)
MapGetHit/String/2048-16               15.7ns ± 6%    10.8ns ± 1%      -31.48%  (p=0.000 n=10+10)
MapGetHit/String/4096-16               27.2ns ± 2%    12.6ns ± 1%      -53.77%  (p=0.000 n=10+10)
MapGetHit/String/8192-16               30.1ns ± 1%    13.1ns ± 1%      -56.64%  (p=0.000 n=10+10)
MapGetHit/String/32768-16              37.3ns ± 1%    19.3ns ± 2%      -48.32%  (p=0.000 n=10+9)
MapGetHit/String/65536-16              39.0ns ± 1%    22.1ns ± 4%      -43.25%  (p=0.000 n=9+10)
MapGetHit/String/131072-16             40.7ns ± 4%    25.0ns ± 3%      -38.72%  (p=0.000 n=10+10)
MapGetHit/String/262144-16             52.7ns ± 7%    28.5ns ± 4%      -45.97%  (p=0.000 n=10+10)
MapGetHit/String/524288-16             68.5ns ±10%    40.4ns ± 3%      -41.06%  (p=0.000 n=10+8)
MapGetHit/String/1048576-16            76.8ns ± 4%    64.1ns ± 7%      -16.46%  (p=0.000 n=10+10)
MapGetHit/String/2097152-16            86.5ns ± 2%    78.7ns ± 1%       -9.00%  (p=0.000 n=10+9)
MapGetHit/String/4194304-16            94.4ns ± 5%    86.7ns ± 1%       -8.23%  (p=0.000 n=10+10)
MapGetMiss/Int64/6-16                  7.16ns ± 0%    7.49ns ± 0%       +4.62%  (p=0.000 n=10+8)
MapGetMiss/Int64/12-16                 11.1ns ±37%     8.9ns ±17%      -19.60%  (p=0.000 n=10+10)
MapGetMiss/Int64/18-16                 10.0ns ± 0%     8.2ns ±18%      -17.55%  (p=0.000 n=8+10)
MapGetMiss/Int64/24-16                 11.5ns ±14%     9.7ns ±16%      -15.75%  (p=0.002 n=10+10)
MapGetMiss/Int64/30-16                 9.94ns ± 0%    7.88ns ± 5%      -20.79%  (p=0.000 n=9+10)
MapGetMiss/Int64/64-16                 11.4ns ±16%     8.2ns ± 4%      -28.39%  (p=0.000 n=10+10)
MapGetMiss/Int64/128-16                10.5ns ± 8%     8.4ns ± 4%      -19.95%  (p=0.000 n=10+10)
MapGetMiss/Int64/256-16                10.5ns ± 5%     8.5ns ± 6%      -18.62%  (p=0.000 n=10+10)
MapGetMiss/Int64/512-16                10.3ns ± 2%     8.6ns ± 5%      -16.34%  (p=0.000 n=8+10)
MapGetMiss/Int64/1024-16               10.5ns ± 3%     8.7ns ± 2%      -17.18%  (p=0.000 n=10+10)
MapGetMiss/Int64/2048-16               10.9ns ± 2%     8.9ns ± 2%      -17.72%  (p=0.000 n=10+10)
MapGetMiss/Int64/4096-16               11.1ns ± 1%    10.5ns ± 2%       -5.45%  (p=0.000 n=8+10)
MapGetMiss/Int64/8192-16               11.7ns ± 2%    10.9ns ± 1%       -6.53%  (p=0.000 n=10+10)
MapGetMiss/Int64/32768-16              14.0ns ± 1%    11.6ns ± 1%      -17.32%  (p=0.000 n=10+10)
MapGetMiss/Int64/65536-16              17.2ns ± 1%    12.6ns ± 1%      -26.46%  (p=0.000 n=9+10)
MapGetMiss/Int64/131072-16             18.4ns ± 3%    14.5ns ± 2%      -21.17%  (p=0.000 n=10+10)
MapGetMiss/Int64/262144-16             20.1ns ± 2%    16.1ns ± 3%      -19.93%  (p=0.000 n=8+10)
MapGetMiss/Int64/524288-16             42.3ns ±28%    18.0ns ± 3%      -57.35%  (p=0.000 n=10+10)
MapGetMiss/Int64/1048576-16            53.3ns ± 7%    21.7ns ± 5%      -59.34%  (p=0.000 n=8+10)
MapGetMiss/Int64/2097152-16            58.5ns ± 4%    32.9ns ± 5%      -43.80%  (p=0.000 n=10+10)
MapGetMiss/Int64/4194304-16            63.2ns ± 7%    43.5ns ± 3%      -31.16%  (p=0.000 n=9+10)
MapGetMiss/Int32/6-16                  8.92ns ± 0%    7.19ns ± 0%      -19.45%  (p=0.000 n=10+8)
MapGetMiss/Int32/12-16                 11.0ns ± 0%     8.7ns ±18%      -20.45%  (p=0.000 n=9+10)
MapGetMiss/Int32/18-16                 11.0ns ± 0%     7.6ns ±10%      -31.26%  (p=0.000 n=9+10)
MapGetMiss/Int32/24-16                 12.5ns ±15%     9.1ns ±22%      -27.69%  (p=0.000 n=10+10)
MapGetMiss/Int32/30-16                 11.0ns ± 0%     7.7ns ± 6%      -30.29%  (p=0.000 n=8+10)
MapGetMiss/Int32/64-16                 11.0ns ± 0%     7.8ns ± 7%      -28.75%  (p=0.000 n=9+9)
MapGetMiss/Int32/128-16                11.7ns ±13%     8.0ns ± 6%      -31.76%  (p=0.000 n=10+10)
MapGetMiss/Int32/256-16                11.5ns ± 4%     8.2ns ± 6%      -28.83%  (p=0.000 n=10+10)
MapGetMiss/Int32/512-16                11.4ns ± 6%     8.3ns ± 1%      -26.91%  (p=0.000 n=10+8)
MapGetMiss/Int32/1024-16               11.5ns ± 3%     8.4ns ± 3%      -26.83%  (p=0.000 n=10+10)
MapGetMiss/Int32/2048-16               11.5ns ± 2%     8.5ns ± 3%      -25.93%  (p=0.000 n=9+10)
MapGetMiss/Int32/4096-16               11.5ns ± 1%    10.1ns ± 2%      -12.27%  (p=0.000 n=10+10)
MapGetMiss/Int32/8192-16               11.6ns ± 2%    10.3ns ± 0%      -11.61%  (p=0.000 n=10+8)
MapGetMiss/Int32/32768-16              12.5ns ± 1%    11.0ns ± 1%      -11.58%  (p=0.000 n=10+10)
MapGetMiss/Int32/65536-16              14.2ns ± 2%    11.8ns ± 1%      -16.82%  (p=0.000 n=9+10)
MapGetMiss/Int32/131072-16             17.1ns ± 2%    14.3ns ± 2%      -16.72%  (p=0.000 n=10+10)
MapGetMiss/Int32/262144-16             18.1ns ± 3%    15.3ns ± 3%      -15.47%  (p=0.000 n=9+10)
MapGetMiss/Int32/524288-16             20.9ns ± 7%    16.8ns ± 2%      -19.84%  (p=0.000 n=10+10)
MapGetMiss/Int32/1048576-16            24.9ns ±16%    20.1ns ± 3%      -19.08%  (p=0.000 n=9+9)
MapGetMiss/Int32/2097152-16            38.6ns ±20%    32.3ns ± 9%      -16.22%  (p=0.003 n=10+10)
MapGetMiss/Int32/4194304-16            51.6ns ± 6%    42.9ns ± 3%      -16.85%  (p=0.000 n=10+10)
MapGetMiss/String/6-16                 7.79ns ± 0%    9.77ns ± 9%      +25.41%  (p=0.000 n=10+10)
MapGetMiss/String/12-16                13.5ns ±16%    11.1ns ±15%      -18.26%  (p=0.000 n=10+10)
MapGetMiss/String/18-16                13.6ns ± 9%    10.4ns ±10%      -23.75%  (p=0.000 n=10+10)
MapGetMiss/String/24-16                13.6ns ± 3%    11.7ns ±15%      -13.89%  (p=0.000 n=9+10)
MapGetMiss/String/30-16                13.3ns ± 6%    10.0ns ± 7%      -24.85%  (p=0.000 n=9+10)
MapGetMiss/String/64-16                13.1ns ± 4%    10.5ns ± 7%      -19.53%  (p=0.000 n=9+10)
MapGetMiss/String/128-16               12.7ns ± 1%    10.6ns ± 2%      -16.28%  (p=0.000 n=10+8)
MapGetMiss/String/256-16               13.1ns ± 4%    10.8ns ± 6%      -17.39%  (p=0.000 n=10+10)
MapGetMiss/String/512-16               13.3ns ± 4%    11.0ns ± 5%      -17.68%  (p=0.000 n=10+10)
MapGetMiss/String/1024-16              15.0ns ± 3%    11.0ns ± 3%      -26.65%  (p=0.000 n=10+9)
MapGetMiss/String/2048-16              18.2ns ± 4%    11.4ns ± 2%      -37.39%  (p=0.000 n=10+9)
MapGetMiss/String/4096-16              17.1ns ± 3%    13.1ns ± 3%      -23.30%  (p=0.000 n=10+10)
MapGetMiss/String/8192-16              17.1ns ± 1%    13.7ns ± 1%      -20.13%  (p=0.000 n=9+9)
MapGetMiss/String/32768-16             28.6ns ± 2%    14.9ns ± 3%      -47.98%  (p=0.000 n=10+10)
MapGetMiss/String/65536-16             25.4ns ± 2%    16.9ns ± 3%      -33.45%  (p=0.000 n=9+10)
MapGetMiss/String/131072-16            38.3ns ± 2%    19.6ns ± 2%      -48.72%  (p=0.000 n=9+10)
MapGetMiss/String/262144-16            40.7ns ± 8%    22.3ns ± 3%      -45.20%  (p=0.000 n=8+10)
MapGetMiss/String/524288-16            52.4ns ±20%    27.8ns ± 3%      -47.02%  (p=0.000 n=10+10)
MapGetMiss/String/1048576-16           65.7ns ± 7%    40.9ns ± 7%      -37.70%  (p=0.000 n=10+10)
MapGetMiss/String/2097152-16           80.8ns ± 3%    52.5ns ± 1%      -35.08%  (p=0.000 n=10+7)
MapGetMiss/String/4194304-16           78.9ns ± 2%    58.4ns ± 2%      -26.05%  (p=0.000 n=10+10)
MapPutGrow/Int64/6-16                  83.2ns ± 0%   154.0ns ± 0%      +85.04%  (p=0.000 n=9+9)
MapPutGrow/Int64/12-16                  408ns ± 0%     392ns ± 0%       -3.76%  (p=0.000 n=9+9)
MapPutGrow/Int64/18-16                  876ns ± 0%     749ns ± 0%      -14.49%  (p=0.000 n=10+9)
MapPutGrow/Int64/24-16                 1.10µs ± 0%    0.84µs ± 1%      -23.60%  (p=0.000 n=9+10)
MapPutGrow/Int64/30-16                 1.93µs ± 0%    1.47µs ± 0%      -24.04%  (p=0.000 n=10+10)
MapPutGrow/Int64/64-16                 4.37µs ± 0%    2.93µs ± 0%      -32.84%  (p=0.000 n=10+8)
MapPutGrow/Int64/128-16                8.82µs ± 0%    5.73µs ± 1%      -35.08%  (p=0.000 n=10+10)
MapPutGrow/Int64/256-16                17.3µs ± 0%    11.1µs ± 0%      -35.76%  (p=0.000 n=10+9)
MapPutGrow/Int64/512-16                34.1µs ± 0%    21.8µs ± 1%      -36.09%  (p=0.000 n=10+10)
MapPutGrow/Int64/1024-16               67.3µs ± 0%    44.0µs ± 1%      -34.71%  (p=0.000 n=10+10)
MapPutGrow/Int64/2048-16                134µs ± 0%      86µs ± 1%      -35.52%  (p=0.000 n=9+9)
MapPutGrow/Int64/4096-16                268µs ± 0%     210µs ± 0%      -21.76%  (p=0.000 n=10+10)
MapPutGrow/Int64/8192-16                540µs ± 0%     470µs ± 0%      -12.95%  (p=0.000 n=10+10)
MapPutGrow/Int64/32768-16              2.36ms ± 0%    2.09ms ± 0%      -11.33%  (p=0.000 n=10+10)
MapPutGrow/Int64/65536-16              4.87ms ± 1%    4.38ms ± 0%      -10.07%  (p=0.000 n=10+9)
MapPutGrow/Int64/131072-16             11.3ms ± 3%     9.4ms ± 1%      -16.77%  (p=0.000 n=10+10)
MapPutGrow/Int64/262144-16             26.4ms ± 2%    19.7ms ± 0%      -25.54%  (p=0.000 n=10+6)
MapPutGrow/Int64/524288-16             62.2ms ± 2%    42.8ms ± 1%      -31.10%  (p=0.000 n=10+10)
MapPutGrow/Int64/1048576-16             147ms ± 3%      92ms ± 1%      -37.53%  (p=0.000 n=9+10)
MapPutGrow/Int64/2097152-16             347ms ± 1%     208ms ± 1%      -40.02%  (p=0.000 n=10+8)
MapPutGrow/Int64/4194304-16             774ms ± 1%     474ms ± 1%      -38.79%  (p=0.000 n=9+10)
MapPutGrow/Int32/6-16                  85.4ns ± 0%   159.5ns ± 1%      +86.80%  (p=0.000 n=10+10)
MapPutGrow/Int32/12-16                  385ns ± 0%     363ns ± 0%       -5.81%  (p=0.000 n=10+10)
MapPutGrow/Int32/18-16                  822ns ± 0%     648ns ± 0%      -21.10%  (p=0.000 n=10+10)
MapPutGrow/Int32/24-16                 1.04µs ± 0%    0.73µs ± 1%      -29.67%  (p=0.000 n=10+10)
MapPutGrow/Int32/30-16                 1.80µs ± 0%    1.22µs ± 0%      -32.15%  (p=0.000 n=10+9)
MapPutGrow/Int32/64-16                 4.00µs ± 0%    2.49µs ± 0%      -37.86%  (p=0.000 n=10+9)
MapPutGrow/Int32/128-16                8.14µs ± 0%    4.88µs ± 1%      -40.00%  (p=0.000 n=10+10)
MapPutGrow/Int32/256-16                16.1µs ± 0%     9.6µs ± 1%      -40.63%  (p=0.000 n=9+10)
MapPutGrow/Int32/512-16                31.6µs ± 0%    18.8µs ± 0%      -40.57%  (p=0.000 n=10+10)
MapPutGrow/Int32/1024-16               62.3µs ± 0%    37.0µs ± 1%      -40.61%  (p=0.000 n=10+10)
MapPutGrow/Int32/2048-16                124µs ± 0%      74µs ± 0%      -40.63%  (p=0.000 n=10+9)
MapPutGrow/Int32/4096-16                245µs ± 0%     190µs ± 0%      -22.31%  (p=0.000 n=10+10)
MapPutGrow/Int32/8192-16                495µs ± 0%     435µs ± 0%      -12.10%  (p=0.000 n=10+10)
MapPutGrow/Int32/32768-16              2.08ms ± 0%    1.93ms ± 0%       -7.08%  (p=0.000 n=10+10)
MapPutGrow/Int32/65536-16              4.37ms ± 1%    4.00ms ± 0%       -8.34%  (p=0.000 n=8+8)
MapPutGrow/Int32/131072-16             10.0ms ± 3%     8.2ms ± 0%      -18.19%  (p=0.000 n=10+10)
MapPutGrow/Int32/262144-16             22.3ms ± 1%    17.5ms ± 1%      -21.44%  (p=0.000 n=10+10)
MapPutGrow/Int32/524288-16             50.5ms ± 1%    37.1ms ± 2%      -26.56%  (p=0.000 n=10+10)
MapPutGrow/Int32/1048576-16             119ms ± 2%      79ms ± 1%      -33.30%  (p=0.000 n=10+10)
MapPutGrow/Int32/2097152-16             285ms ± 1%     174ms ± 1%      -39.14%  (p=0.000 n=10+10)
MapPutGrow/Int32/4194304-16             654ms ± 1%     390ms ± 1%      -40.40%  (p=0.000 n=10+10)
MapPutGrow/String/6-16                 88.6ns ± 0%   209.8ns ± 0%     +136.77%  (p=0.000 n=10+9)
MapPutGrow/String/12-16                 490ns ± 1%     539ns ± 0%       +9.98%  (p=0.000 n=10+10)
MapPutGrow/String/18-16                1.14µs ± 1%    1.10µs ± 0%       -3.14%  (p=0.000 n=10+9)
MapPutGrow/String/24-16                1.36µs ± 1%    1.21µs ± 1%      -11.09%  (p=0.000 n=10+10)
MapPutGrow/String/30-16                2.47µs ± 2%    2.19µs ± 1%      -11.41%  (p=0.000 n=10+10)
MapPutGrow/String/64-16                5.46µs ± 0%    4.41µs ± 1%      -19.23%  (p=0.000 n=9+10)
MapPutGrow/String/128-16               11.1µs ± 1%     8.6µs ± 0%      -22.92%  (p=0.000 n=10+10)
MapPutGrow/String/256-16               22.1µs ± 1%    16.4µs ± 1%      -25.99%  (p=0.000 n=10+10)
MapPutGrow/String/512-16               44.8µs ± 0%    32.7µs ± 1%      -27.06%  (p=0.000 n=9+10)
MapPutGrow/String/1024-16              89.5µs ± 1%    63.9µs ± 1%      -28.60%  (p=0.000 n=10+10)
MapPutGrow/String/2048-16               182µs ± 1%     128µs ± 1%      -29.66%  (p=0.000 n=10+10)
MapPutGrow/String/4096-16               386µs ± 1%     290µs ± 0%      -24.91%  (p=0.000 n=9+8)
MapPutGrow/String/8192-16               853µs ± 1%     663µs ± 1%      -22.23%  (p=0.000 n=10+9)
MapPutGrow/String/32768-16             4.04ms ± 3%    3.18ms ± 1%      -21.36%  (p=0.000 n=10+10)
MapPutGrow/String/65536-16             8.75ms ± 3%    7.13ms ± 3%      -18.57%  (p=0.000 n=10+10)
MapPutGrow/String/131072-16            20.1ms ± 3%    14.8ms ± 2%      -26.71%  (p=0.000 n=10+10)
MapPutGrow/String/262144-16            46.0ms ± 0%    32.4ms ± 3%      -29.53%  (p=0.000 n=8+10)
MapPutGrow/String/524288-16             112ms ± 1%      72ms ± 3%      -35.11%  (p=0.000 n=7+10)
MapPutGrow/String/1048576-16            268ms ± 2%     169ms ± 2%      -36.92%  (p=0.000 n=10+10)
MapPutGrow/String/2097152-16            660ms ± 2%     395ms ± 1%      -40.18%  (p=0.000 n=9+8)
MapPutGrow/String/4194304-16            1.43s ± 1%     0.91s ± 1%      -36.55%  (p=0.000 n=9+10)
MapPutPreAllocate/Int64/6-16           83.7ns ± 0%   142.5ns ± 1%      +70.38%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/12-16           330ns ± 0%     227ns ± 1%      -31.29%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/18-16           534ns ± 1%     329ns ± 1%      -38.34%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/24-16           759ns ± 0%     409ns ± 1%      -46.16%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/30-16           918ns ± 1%     549ns ± 1%      -40.19%  (p=0.000 n=10+9)
MapPutPreAllocate/Int64/64-16          2.11µs ± 1%    1.06µs ± 0%      -49.94%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/128-16         4.11µs ± 0%    2.07µs ± 1%      -49.74%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/256-16         7.89µs ± 0%    3.97µs ± 1%      -49.76%  (p=0.000 n=9+10)
MapPutPreAllocate/Int64/512-16         15.7µs ± 1%     7.8µs ± 1%      -50.22%  (p=0.000 n=10+9)
MapPutPreAllocate/Int64/1024-16        31.3µs ± 0%    16.3µs ± 1%      -47.79%  (p=0.000 n=9+9)
MapPutPreAllocate/Int64/2048-16        64.8µs ± 1%    31.3µs ± 1%      -51.69%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/4096-16         132µs ± 1%      73µs ± 1%      -45.02%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/8192-16         272µs ± 1%     154µs ± 1%      -43.55%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/32768-16       1.24ms ± 1%    0.79ms ± 1%      -36.04%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/65536-16       2.52ms ± 0%    1.77ms ± 2%      -29.86%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/131072-16      5.75ms ± 1%    3.45ms ± 1%      -39.97%  (p=0.000 n=10+9)
MapPutPreAllocate/Int64/262144-16      12.6ms ± 1%     8.0ms ± 3%      -36.98%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/524288-16      30.1ms ± 1%    20.1ms ± 3%      -33.43%  (p=0.000 n=10+9)
MapPutPreAllocate/Int64/1048576-16     72.2ms ± 1%    52.5ms ± 4%      -27.26%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/2097152-16      164ms ± 1%     132ms ± 5%      -19.77%  (p=0.000 n=8+10)
MapPutPreAllocate/Int64/4194304-16      363ms ± 1%     300ms ± 1%      -17.39%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/6-16           84.9ns ± 0%   131.4ns ± 1%      +54.89%  (p=0.000 n=10+8)
MapPutPreAllocate/Int32/12-16           298ns ± 0%     220ns ± 0%      -26.06%  (p=0.000 n=10+8)
MapPutPreAllocate/Int32/18-16           479ns ± 0%     309ns ± 1%      -35.42%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/24-16           692ns ± 0%     399ns ± 1%      -42.29%  (p=0.000 n=10+9)
MapPutPreAllocate/Int32/30-16           820ns ± 0%     478ns ± 1%      -41.71%  (p=0.000 n=10+9)
MapPutPreAllocate/Int32/64-16          1.82µs ± 0%    0.88µs ± 1%      -51.68%  (p=0.000 n=10+9)
MapPutPreAllocate/Int32/128-16         3.62µs ± 0%    1.64µs ± 1%      -54.61%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/256-16         7.21µs ± 0%    3.21µs ± 0%      -55.51%  (p=0.000 n=10+8)
MapPutPreAllocate/Int32/512-16         14.0µs ± 0%     6.3µs ± 1%      -55.40%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/1024-16        27.7µs ± 0%    12.4µs ± 1%      -55.10%  (p=0.000 n=10+9)
MapPutPreAllocate/Int32/2048-16        56.0µs ± 0%    25.1µs ± 1%      -55.19%  (p=0.000 n=8+8)
MapPutPreAllocate/Int32/4096-16         114µs ± 0%      59µs ± 1%      -47.86%  (p=0.000 n=9+9)
MapPutPreAllocate/Int32/8192-16         233µs ± 0%     124µs ± 1%      -46.80%  (p=0.000 n=8+10)
MapPutPreAllocate/Int32/32768-16       1.01ms ± 0%    0.57ms ± 2%      -43.78%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/65536-16       2.25ms ± 0%    1.36ms ±10%      -39.79%  (p=0.000 n=7+10)
MapPutPreAllocate/Int32/131072-16      5.07ms ± 1%    3.24ms ±11%      -35.97%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/262144-16      10.9ms ± 1%     6.1ms ± 1%      -44.05%  (p=0.000 n=10+8)
MapPutPreAllocate/Int32/524288-16      24.2ms ± 1%    14.4ms ± 5%      -40.49%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/1048576-16     59.5ms ± 2%    38.3ms ± 8%      -35.55%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/2097152-16      145ms ± 1%     103ms ± 3%      -29.32%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/4194304-16      319ms ± 1%     251ms ± 3%      -21.13%  (p=0.000 n=10+10)
MapPutPreAllocate/String/6-16          92.1ns ± 0%   225.2ns ± 1%     +144.64%  (p=0.000 n=9+10)
MapPutPreAllocate/String/12-16          395ns ± 1%     401ns ± 1%       +1.57%  (p=0.000 n=10+10)
MapPutPreAllocate/String/18-16          661ns ± 0%     616ns ± 1%       -6.87%  (p=0.000 n=9+10)
MapPutPreAllocate/String/24-16          885ns ± 0%     778ns ± 1%      -12.01%  (p=0.000 n=8+10)
MapPutPreAllocate/String/30-16         1.13µs ± 0%    1.03µs ± 1%       -8.95%  (p=0.000 n=9+9)
MapPutPreAllocate/String/64-16         2.41µs ± 0%    2.09µs ± 1%      -13.16%  (p=0.000 n=10+10)
MapPutPreAllocate/String/128-16        4.67µs ± 0%    4.06µs ± 1%      -13.21%  (p=0.000 n=10+10)
MapPutPreAllocate/String/256-16        9.29µs ± 0%    7.98µs ± 1%      -14.04%  (p=0.000 n=8+10)
MapPutPreAllocate/String/512-16        19.0µs ± 0%    16.4µs ± 1%      -13.60%  (p=0.000 n=10+10)
MapPutPreAllocate/String/1024-16       38.0µs ± 1%    31.4µs ± 1%      -17.41%  (p=0.000 n=10+10)
MapPutPreAllocate/String/2048-16       76.3µs ± 0%    63.8µs ± 1%      -16.33%  (p=0.000 n=10+10)
MapPutPreAllocate/String/4096-16        160µs ± 1%     150µs ± 1%       -6.23%  (p=0.000 n=10+10)
MapPutPreAllocate/String/8192-16        345µs ± 1%     323µs ± 4%       -6.41%  (p=0.000 n=10+9)
MapPutPreAllocate/String/32768-16      1.61ms ± 3%    1.86ms ± 2%      +15.65%  (p=0.000 n=10+10)
MapPutPreAllocate/String/65536-16      3.40ms ± 1%    3.89ms ± 3%      +14.42%  (p=0.000 n=9+10)
MapPutPreAllocate/String/131072-16     7.78ms ± 1%    7.53ms ± 2%       -3.22%  (p=0.000 n=10+10)
MapPutPreAllocate/String/262144-16     19.3ms ± 1%    18.6ms ± 2%       -3.31%  (p=0.000 n=9+10)
MapPutPreAllocate/String/524288-16     45.8ms ± 2%    44.1ms ± 3%       -3.59%  (p=0.000 n=10+10)
MapPutPreAllocate/String/1048576-16     105ms ± 1%     108ms ± 1%       +2.09%  (p=0.000 n=8+9)
MapPutPreAllocate/String/2097152-16     257ms ± 1%     253ms ± 2%       -1.51%  (p=0.010 n=9+10)
MapPutPreAllocate/String/4194304-16     562ms ± 1%     565ms ± 2%         ~     (p=0.436 n=10+10)
MapPutReuse/Int64/6-16                 92.3ns ± 0%    75.5ns ± 0%      -18.25%  (p=0.000 n=10+10)
MapPutReuse/Int64/12-16                 272ns ± 0%     131ns ± 0%      -51.86%  (p=0.000 n=8+9)
MapPutReuse/Int64/18-16                 435ns ± 0%     184ns ± 0%      -57.64%  (p=0.000 n=10+9)
MapPutReuse/Int64/24-16                 653ns ± 0%     263ns ± 0%      -59.77%  (p=0.000 n=10+8)
MapPutReuse/Int64/30-16                 754ns ± 0%     310ns ± 0%      -58.92%  (p=0.000 n=10+8)
MapPutReuse/Int64/64-16                1.66µs ± 0%    0.64µs ± 0%      -61.35%  (p=0.000 n=10+8)
MapPutReuse/Int64/128-16               3.35µs ± 0%    1.27µs ± 1%      -61.95%  (p=0.000 n=10+10)
MapPutReuse/Int64/256-16               6.70µs ± 0%    2.52µs ± 1%      -62.35%  (p=0.000 n=10+9)
MapPutReuse/Int64/512-16               13.3µs ± 0%     5.2µs ± 4%      -61.40%  (p=0.000 n=10+10)
MapPutReuse/Int64/1024-16              26.6µs ± 0%    10.4µs ± 4%      -60.83%  (p=0.000 n=10+10)
MapPutReuse/Int64/2048-16              55.2µs ± 0%    22.3µs ± 1%      -59.54%  (p=0.000 n=10+9)
MapPutReuse/Int64/4096-16               114µs ± 0%      55µs ± 3%      -51.35%  (p=0.000 n=10+10)
MapPutReuse/Int64/8192-16               234µs ± 0%     113µs ± 2%      -51.45%  (p=0.000 n=9+10)
MapPutReuse/Int64/32768-16             1.00ms ± 1%    0.51ms ± 2%      -48.75%  (p=0.000 n=10+10)
MapPutReuse/Int64/65536-16             2.26ms ± 1%    1.22ms ± 2%      -45.91%  (p=0.000 n=9+9)
MapPutReuse/Int64/131072-16            4.75ms ± 2%    2.65ms ± 2%      -44.27%  (p=0.000 n=10+10)
MapPutReuse/Int64/262144-16            10.2ms ± 1%     5.9ms ± 4%      -42.46%  (p=0.000 n=10+10)
MapPutReuse/Int64/524288-16            22.0ms ± 1%    15.3ms ± 7%      -30.66%  (p=0.000 n=9+9)
MapPutReuse/Int64/1048576-16           57.2ms ± 2%    55.5ms ± 6%       -3.09%  (p=0.019 n=10+10)
MapPutReuse/Int64/2097152-16            133ms ± 2%     137ms ± 5%       +3.07%  (p=0.004 n=10+10)
MapPutReuse/Int64/4194304-16            319ms ± 1%     290ms ± 1%       -8.86%  (p=0.000 n=9+10)
MapPutReuse/Int32/6-16                 93.9ns ± 0%    73.6ns ± 2%      -21.59%  (p=0.000 n=10+10)
MapPutReuse/Int32/12-16                 271ns ± 0%     127ns ± 2%      -53.15%  (p=0.000 n=9+10)
MapPutReuse/Int32/18-16                 440ns ± 0%     176ns ± 0%      -59.94%  (p=0.000 n=10+10)
MapPutReuse/Int32/24-16                 655ns ± 0%     252ns ± 0%      -61.56%  (p=0.000 n=8+9)
MapPutReuse/Int32/30-16                 764ns ± 0%     292ns ± 0%      -61.83%  (p=0.000 n=10+9)
MapPutReuse/Int32/64-16                1.67µs ± 0%    0.60µs ± 0%      -64.35%  (p=0.000 n=10+9)
MapPutReuse/Int32/128-16               3.42µs ± 0%    1.20µs ± 0%      -64.79%  (p=0.000 n=10+9)
MapPutReuse/Int32/256-16               6.83µs ± 0%    2.59µs ± 0%      -62.04%  (p=0.000 n=9+9)
MapPutReuse/Int32/512-16               13.6µs ± 0%     5.0µs ± 2%      -63.40%  (p=0.000 n=9+9)
MapPutReuse/Int32/1024-16              27.1µs ± 0%    10.1µs ± 5%      -62.63%  (p=0.000 n=8+10)
MapPutReuse/Int32/2048-16              53.5µs ± 0%    19.4µs ± 2%      -63.71%  (p=0.000 n=10+10)
MapPutReuse/Int32/4096-16               111µs ± 0%      50µs ± 3%      -55.16%  (p=0.000 n=10+10)
MapPutReuse/Int32/8192-16               228µs ± 0%     103µs ± 2%      -54.72%  (p=0.000 n=10+10)
MapPutReuse/Int32/32768-16              955µs ± 0%     443µs ± 3%      -53.64%  (p=0.000 n=9+10)
MapPutReuse/Int32/65536-16             2.03ms ± 1%    0.95ms ± 1%      -53.22%  (p=0.000 n=10+10)
MapPutReuse/Int32/131072-16            4.50ms ± 1%    2.71ms ± 2%      -39.79%  (p=0.000 n=10+8)
MapPutReuse/Int32/262144-16            9.35ms ± 1%    5.05ms ± 2%      -46.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/524288-16            20.4ms ± 0%    11.3ms ± 5%      -44.58%  (p=0.000 n=9+10)
MapPutReuse/Int32/1048576-16           43.4ms ± 1%    37.7ms ±14%      -13.10%  (p=0.000 n=10+10)
MapPutReuse/Int32/2097152-16            107ms ± 1%     122ms ± 6%      +13.64%  (p=0.000 n=10+10)
MapPutReuse/Int32/4194304-16            266ms ± 1%     263ms ± 5%         ~     (p=0.968 n=9+10)
MapPutReuse/String/6-16                 103ns ± 0%      97ns ± 2%       -5.47%  (p=0.000 n=10+10)
MapPutReuse/String/12-16                298ns ± 0%     184ns ± 1%      -38.21%  (p=0.000 n=10+10)
MapPutReuse/String/18-16                494ns ± 0%     273ns ± 0%      -44.79%  (p=0.000 n=9+9)
MapPutReuse/String/24-16                726ns ± 0%     368ns ± 1%      -49.27%  (p=0.000 n=10+10)
MapPutReuse/String/30-16                855ns ± 0%     478ns ± 7%      -44.05%  (p=0.000 n=9+10)
MapPutReuse/String/64-16               1.84µs ± 0%    0.99µs ±11%      -46.31%  (p=0.000 n=9+8)
MapPutReuse/String/128-16              3.71µs ± 0%    1.86µs ± 1%      -49.94%  (p=0.000 n=10+9)
MapPutReuse/String/256-16              7.41µs ± 1%    3.76µs ± 6%      -49.24%  (p=0.000 n=10+10)
MapPutReuse/String/512-16              14.8µs ± 0%     7.8µs ± 5%      -47.39%  (p=0.000 n=10+10)
MapPutReuse/String/1024-16             31.1µs ± 0%    16.5µs ± 2%      -46.91%  (p=0.000 n=9+10)
MapPutReuse/String/2048-16             63.7µs ± 0%    36.1µs ± 1%      -43.26%  (p=0.000 n=9+9)
MapPutReuse/String/4096-16              130µs ± 0%      85µs ± 2%      -34.69%  (p=0.000 n=9+10)
MapPutReuse/String/8192-16              268µs ± 0%     178µs ± 0%      -33.75%  (p=0.000 n=10+9)
MapPutReuse/String/32768-16            1.26ms ± 1%    0.89ms ± 3%      -28.93%  (p=0.000 n=9+10)
MapPutReuse/String/65536-16            2.66ms ± 1%    2.00ms ± 3%      -24.73%  (p=0.000 n=10+10)
MapPutReuse/String/131072-16           5.72ms ± 2%    4.38ms ± 3%      -23.47%  (p=0.000 n=10+10)
MapPutReuse/String/262144-16           12.4ms ± 2%    11.1ms ± 2%      -10.17%  (p=0.000 n=10+10)
MapPutReuse/String/524288-16           36.5ms ± 1%    27.3ms ±17%      -25.33%  (p=0.000 n=10+10)
MapPutReuse/String/1048576-16          83.4ms ± 2%    81.3ms ±10%         ~     (p=0.065 n=9+10)
MapPutReuse/String/2097152-16           197ms ± 1%     208ms ± 4%       +5.68%  (p=0.000 n=9+10)
MapPutReuse/String/4194304-16           433ms ± 1%     456ms ± 1%       +5.28%  (p=0.000 n=9+10)
MapPutDelete/Int64/6-16                27.2ns ± 0%    25.3ns ± 1%       -6.91%  (p=0.000 n=9+10)
MapPutDelete/Int64/12-16               28.5ns ± 3%    23.9ns ± 6%      -16.24%  (p=0.000 n=9+10)
MapPutDelete/Int64/18-16               27.2ns ± 8%    21.9ns ±10%      -19.18%  (p=0.000 n=10+10)
MapPutDelete/Int64/24-16               28.5ns ± 2%    24.9ns ± 9%      -12.50%  (p=0.000 n=8+10)
MapPutDelete/Int64/30-16               26.9ns ± 7%    20.1ns ± 7%      -25.57%  (p=0.000 n=10+10)
MapPutDelete/Int64/64-16               26.9ns ± 4%    20.5ns ± 9%      -23.87%  (p=0.000 n=10+10)
MapPutDelete/Int64/128-16              27.0ns ± 3%    20.9ns ± 7%      -22.50%  (p=0.000 n=10+9)
MapPutDelete/Int64/256-16              27.1ns ± 2%    21.1ns ± 5%      -22.16%  (p=0.000 n=10+10)
MapPutDelete/Int64/512-16              27.2ns ± 2%    22.1ns ± 6%      -18.93%  (p=0.000 n=10+10)
MapPutDelete/Int64/1024-16             32.8ns ± 2%    22.7ns ± 5%      -30.81%  (p=0.000 n=10+10)
MapPutDelete/Int64/2048-16             45.8ns ± 2%    23.2ns ± 6%      -49.37%  (p=0.000 n=10+9)
MapPutDelete/Int64/4096-16             51.7ns ± 1%    28.1ns ± 2%      -45.58%  (p=0.000 n=10+10)
MapPutDelete/Int64/8192-16             54.5ns ± 1%    28.9ns ± 2%      -46.99%  (p=0.000 n=9+10)
MapPutDelete/Int64/32768-16            57.6ns ± 0%    31.1ns ± 1%      -45.98%  (p=0.000 n=10+10)
MapPutDelete/Int64/65536-16            64.5ns ± 1%    36.2ns ± 2%      -43.82%  (p=0.000 n=10+8)
MapPutDelete/Int64/131072-16           69.8ns ± 1%    42.8ns ± 2%      -38.59%  (p=0.000 n=8+10)
MapPutDelete/Int64/262144-16           75.4ns ± 2%    52.9ns ± 9%      -29.79%  (p=0.000 n=9+10)
MapPutDelete/Int64/524288-16           81.4ns ± 1%    70.5ns ±17%      -13.30%  (p=0.000 n=9+10)
MapPutDelete/Int64/1048576-16          87.4ns ± 2%    94.4ns ± 9%       +7.97%  (p=0.007 n=10+10)
MapPutDelete/Int64/2097152-16           111ns ± 2%     101ns ± 3%       -9.45%  (p=0.000 n=10+10)
MapPutDelete/Int64/4194304-16           143ns ± 1%     109ns ± 2%      -23.90%  (p=0.000 n=10+10)
MapPutDelete/Int32/6-16                26.0ns ± 0%    21.3ns ± 0%      -18.10%  (p=0.000 n=9+10)
MapPutDelete/Int32/12-16               27.0ns ± 2%    21.1ns ±14%      -21.80%  (p=0.000 n=9+10)
MapPutDelete/Int32/18-16               26.0ns ± 6%    19.5ns ±10%      -25.08%  (p=0.000 n=9+10)
MapPutDelete/Int32/24-16               28.2ns ± 4%    21.7ns ±13%      -23.04%  (p=0.000 n=10+10)
MapPutDelete/Int32/30-16               25.7ns ± 8%    18.9ns ± 6%      -26.38%  (p=0.000 n=10+10)
MapPutDelete/Int32/64-16               25.7ns ± 5%    19.1ns ± 7%      -25.73%  (p=0.000 n=10+10)
MapPutDelete/Int32/128-16              25.7ns ± 3%    20.2ns ± 9%      -21.24%  (p=0.000 n=10+10)
MapPutDelete/Int32/256-16              25.9ns ± 3%    20.1ns ± 6%      -22.51%  (p=0.000 n=9+10)
MapPutDelete/Int32/512-16              26.8ns ± 7%    20.2ns ± 4%      -24.36%  (p=0.000 n=10+9)
MapPutDelete/Int32/1024-16             31.9ns ± 2%    21.1ns ± 6%      -33.82%  (p=0.000 n=10+10)
MapPutDelete/Int32/2048-16             43.5ns ± 2%    21.1ns ± 5%      -51.51%  (p=0.000 n=10+10)
MapPutDelete/Int32/4096-16             49.9ns ± 1%    26.2ns ± 5%      -47.53%  (p=0.000 n=10+10)
MapPutDelete/Int32/8192-16             52.6ns ± 1%    26.9ns ± 4%      -48.81%  (p=0.000 n=10+9)
MapPutDelete/Int32/32768-16            55.0ns ± 0%    28.1ns ± 1%      -48.91%  (p=0.000 n=9+10)
MapPutDelete/Int32/65536-16            57.4ns ± 1%    29.8ns ± 1%      -48.04%  (p=0.000 n=9+10)
MapPutDelete/Int32/131072-16           65.2ns ± 2%    35.1ns ± 5%      -46.24%  (p=0.000 n=10+10)
MapPutDelete/Int32/262144-16           68.7ns ± 2%    38.0ns ± 2%      -44.68%  (p=0.000 n=10+10)
MapPutDelete/Int32/524288-16           75.2ns ± 2%    43.8ns ±14%      -41.68%  (p=0.000 n=10+10)
MapPutDelete/Int32/1048576-16          80.8ns ± 2%    58.8ns ±13%      -27.17%  (p=0.000 n=10+10)
MapPutDelete/Int32/2097152-16          88.1ns ± 3%    72.9ns ± 6%      -17.31%  (p=0.000 n=10+10)
MapPutDelete/Int32/4194304-16           119ns ± 1%      90ns ± 4%      -23.91%  (p=0.000 n=7+10)
MapPutDelete/String/6-16               31.1ns ± 0%    25.9ns ± 1%      -16.67%  (p=0.000 n=8+9)
MapPutDelete/String/12-16              32.4ns ± 2%    30.6ns ±16%         ~     (p=0.097 n=8+10)
MapPutDelete/String/18-16              31.3ns ± 2%    28.4ns ±12%       -9.23%  (p=0.003 n=9+10)
MapPutDelete/String/24-16              33.1ns ± 4%    33.0ns ± 9%         ~     (p=0.579 n=10+10)
MapPutDelete/String/30-16              30.2ns ± 3%    28.7ns ±12%         ~     (p=0.113 n=9+9)
MapPutDelete/String/64-16              31.2ns ± 2%    29.8ns ±16%         ~     (p=0.326 n=9+10)
MapPutDelete/String/128-16             31.2ns ± 1%    29.9ns ±14%         ~     (p=0.165 n=8+10)
MapPutDelete/String/256-16             31.5ns ± 3%    30.2ns ±12%         ~     (p=0.075 n=10+10)
MapPutDelete/String/512-16             32.1ns ± 2%    30.7ns ± 9%       -4.39%  (p=0.030 n=10+10)
MapPutDelete/String/1024-16            47.8ns ± 4%    31.4ns ± 4%      -34.36%  (p=0.000 n=10+8)
MapPutDelete/String/2048-16            62.1ns ± 1%    33.0ns ± 1%      -46.94%  (p=0.000 n=10+9)
MapPutDelete/String/4096-16            69.3ns ± 1%    41.3ns ± 2%      -40.36%  (p=0.000 n=10+10)
MapPutDelete/String/8192-16            71.0ns ± 1%    42.0ns ± 3%      -40.93%  (p=0.000 n=10+10)
MapPutDelete/String/32768-16           83.2ns ± 1%    48.9ns ± 1%      -41.22%  (p=0.000 n=9+10)
MapPutDelete/String/65536-16           87.7ns ± 1%    55.3ns ± 3%      -37.00%  (p=0.000 n=9+10)
MapPutDelete/String/131072-16          91.5ns ± 2%    69.8ns ± 8%      -23.68%  (p=0.000 n=10+10)
MapPutDelete/String/262144-16           102ns ± 1%      96ns ±20%         ~     (p=0.138 n=10+10)
MapPutDelete/String/524288-16           113ns ± 2%     140ns ±17%      +24.65%  (p=0.000 n=10+10)
MapPutDelete/String/1048576-16          140ns ± 2%     159ns ± 4%      +14.06%  (p=0.000 n=10+10)
MapPutDelete/String/2097152-16          177ns ± 2%     174ns ± 2%         ~     (p=0.063 n=10+10)
MapPutDelete/String/4194304-16          205ns ± 2%     185ns ± 2%       -9.75%  (p=0.000 n=10+10)
```
</details>

<details>
<summary>Memory: Go's builtin map (old) vs swiss.Map (new)</summary>

```
name                                 old alloc/op   new alloc/op   delta
MapIter/Int/6-16                        0.00B          0.00B              ~     (all equal)
MapIter/Int/12-16                       0.00B          0.00B              ~     (all equal)
MapIter/Int/18-16                       0.00B          0.00B              ~     (all equal)
MapIter/Int/24-16                       0.00B          0.00B              ~     (all equal)
MapIter/Int/30-16                       0.00B          0.00B              ~     (all equal)
MapIter/Int/64-16                       0.00B          0.00B              ~     (all equal)
MapIter/Int/128-16                      0.00B          0.00B              ~     (all equal)
MapIter/Int/256-16                      0.00B          0.00B              ~     (all equal)
MapIter/Int/512-16                      0.00B          0.00B              ~     (all equal)
MapIter/Int/1024-16                     0.00B          0.00B              ~     (all equal)
MapIter/Int/2048-16                     0.00B          0.00B              ~     (all equal)
MapIter/Int/4096-16                     0.00B          0.00B              ~     (all equal)
MapIter/Int/8192-16                     0.00B          0.00B              ~     (all equal)
MapIter/Int/32768-16                    0.00B          0.00B              ~     (all equal)
MapIter/Int/65536-16                    0.00B          0.00B              ~     (all equal)
MapIter/Int/131072-16                   0.00B          0.00B              ~     (all equal)
MapIter/Int/262144-16                   0.00B          0.00B              ~     (all equal)
MapIter/Int/524288-16                   0.00B          0.00B              ~     (all equal)
MapIter/Int/1048576-16                  0.00B          0.00B              ~     (all equal)
MapIter/Int/2097152-16                  0.00B          0.00B              ~     (all equal)
MapIter/Int/4194304-16                  0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/6-16                    0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/12-16                   0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/18-16                   0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/24-16                   0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/30-16                   0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/64-16                   0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/128-16                  0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/256-16                  0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/512-16                  0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/1024-16                 0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/2048-16                 0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/4096-16                 0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/8192-16                 0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/32768-16                0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/65536-16                0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/131072-16               0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/262144-16               0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/524288-16               0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/1048576-16              0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/2097152-16              0.00B          0.00B              ~     (all equal)
MapGetHit/Int64/4194304-16              0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/6-16                    0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/12-16                   0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/18-16                   0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/24-16                   0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/30-16                   0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/64-16                   0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/128-16                  0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/256-16                  0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/512-16                  0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/1024-16                 0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/2048-16                 0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/4096-16                 0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/8192-16                 0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/32768-16                0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/65536-16                0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/131072-16               0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/262144-16               0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/524288-16               0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/1048576-16              0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/2097152-16              0.00B          0.00B              ~     (all equal)
MapGetHit/Int32/4194304-16              0.00B          0.00B              ~     (all equal)
MapGetHit/String/6-16                   0.00B          0.00B              ~     (all equal)
MapGetHit/String/12-16                  0.00B          0.00B              ~     (all equal)
MapGetHit/String/18-16                  0.00B          0.00B              ~     (all equal)
MapGetHit/String/24-16                  0.00B          0.00B              ~     (all equal)
MapGetHit/String/30-16                  0.00B          0.00B              ~     (all equal)
MapGetHit/String/64-16                  0.00B          0.00B              ~     (all equal)
MapGetHit/String/128-16                 0.00B          0.00B              ~     (all equal)
MapGetHit/String/256-16                 0.00B          0.00B              ~     (all equal)
MapGetHit/String/512-16                 0.00B          0.00B              ~     (all equal)
MapGetHit/String/1024-16                0.00B          0.00B              ~     (all equal)
MapGetHit/String/2048-16                0.00B          0.00B              ~     (all equal)
MapGetHit/String/4096-16                0.00B          0.00B              ~     (all equal)
MapGetHit/String/8192-16                0.00B          0.00B              ~     (all equal)
MapGetHit/String/32768-16               0.00B          0.00B              ~     (all equal)
MapGetHit/String/65536-16               0.00B          0.00B              ~     (all equal)
MapGetHit/String/131072-16              0.00B          0.00B              ~     (all equal)
MapGetHit/String/262144-16              0.00B          0.00B              ~     (all equal)
MapGetHit/String/524288-16              0.00B          0.00B              ~     (all equal)
MapGetHit/String/1048576-16             0.00B          0.00B              ~     (all equal)
MapGetHit/String/2097152-16             0.00B          0.00B              ~     (all equal)
MapGetHit/String/4194304-16             0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/6-16                   0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/12-16                  0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/18-16                  0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/24-16                  0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/30-16                  0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/64-16                  0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/128-16                 0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/256-16                 0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/512-16                 0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/1024-16                0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/2048-16                0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/4096-16                0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/8192-16                0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/32768-16               0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/65536-16               0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/131072-16              0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/262144-16              0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/524288-16              0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/1048576-16             0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/2097152-16             0.00B          0.00B              ~     (all equal)
MapGetMiss/Int64/4194304-16             0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/6-16                   0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/12-16                  0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/18-16                  0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/24-16                  0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/30-16                  0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/64-16                  0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/128-16                 0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/256-16                 0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/512-16                 0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/1024-16                0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/2048-16                0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/4096-16                0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/8192-16                0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/32768-16               0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/65536-16               0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/131072-16              0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/262144-16              0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/524288-16              0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/1048576-16             0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/2097152-16             0.00B          0.00B              ~     (all equal)
MapGetMiss/Int32/4194304-16             0.00B          0.00B              ~     (all equal)
MapGetMiss/String/6-16                  0.00B          0.00B              ~     (all equal)
MapGetMiss/String/12-16                 0.00B          0.00B              ~     (all equal)
MapGetMiss/String/18-16                 0.00B          0.00B              ~     (all equal)
MapGetMiss/String/24-16                 0.00B          0.00B              ~     (all equal)
MapGetMiss/String/30-16                 0.00B          0.00B              ~     (all equal)
MapGetMiss/String/64-16                 0.00B          0.00B              ~     (all equal)
MapGetMiss/String/128-16                0.00B          0.00B              ~     (all equal)
MapGetMiss/String/256-16                0.00B          0.00B              ~     (all equal)
MapGetMiss/String/512-16                0.00B          0.00B              ~     (all equal)
MapGetMiss/String/1024-16               0.00B          0.00B              ~     (all equal)
MapGetMiss/String/2048-16               0.00B          0.00B              ~     (all equal)
MapGetMiss/String/4096-16               0.00B          0.00B              ~     (all equal)
MapGetMiss/String/8192-16               0.00B          0.00B              ~     (all equal)
MapGetMiss/String/32768-16              0.00B          0.00B              ~     (all equal)
MapGetMiss/String/65536-16              0.00B          0.00B              ~     (all equal)
MapGetMiss/String/131072-16             0.00B          0.00B              ~     (all equal)
MapGetMiss/String/262144-16             0.00B          0.00B              ~     (all equal)
MapGetMiss/String/524288-16             0.00B          0.00B              ~     (all equal)
MapGetMiss/String/1048576-16            0.00B          0.00B              ~     (all equal)
MapGetMiss/String/2097152-16            0.00B          0.00B              ~     (all equal)
MapGetMiss/String/4194304-16            0.00B          0.00B              ~     (all equal)
MapPutGrow/Int64/6-16                   0.00B        144.00B ± 0%        +Inf%  (p=0.000 n=10+10)
MapPutGrow/Int64/12-16                   317B ± 0%      432B ± 0%      +36.28%  (p=0.000 n=10+10)
MapPutGrow/Int64/18-16                   931B ± 0%     1008B ± 0%       +8.27%  (p=0.000 n=10+10)
MapPutGrow/Int64/24-16                 1.01kB ± 0%    1.01kB ± 0%       -0.10%  (p=0.000 n=9+10)
MapPutGrow/Int64/30-16                 2.22kB ± 0%    2.16kB ± 0%       -2.65%  (p=0.000 n=10+10)
MapPutGrow/Int64/64-16                 5.18kB ± 0%    4.46kB ± 0%      -13.77%  (p=0.000 n=7+10)
MapPutGrow/Int64/128-16                10.8kB ± 0%     9.3kB ± 0%      -13.85%  (p=0.000 n=10+10)
MapPutGrow/Int64/256-16                21.5kB ± 0%    18.8kB ± 0%      -12.48%  (p=0.000 n=10+10)
MapPutGrow/Int64/512-16                43.2kB ± 0%    37.2kB ± 0%      -13.78%  (p=0.000 n=10+10)
MapPutGrow/Int64/1024-16               86.6kB ± 0%    78.2kB ± 0%       -9.68%  (p=0.000 n=10+10)
MapPutGrow/Int64/2048-16                173kB ± 0%     152kB ± 0%      -12.34%  (p=0.000 n=9+10)
MapPutGrow/Int64/4096-16                347kB ± 0%     226kB ± 0%      -34.94%  (p=0.000 n=10+10)
MapPutGrow/Int64/8192-16                686kB ± 0%     373kB ± 0%      -45.58%  (p=0.000 n=8+10)
MapPutGrow/Int64/32768-16              2.72MB ± 0%    1.26MB ± 0%      -53.72%  (p=0.000 n=9+10)
MapPutGrow/Int64/65536-16              5.45MB ± 0%    2.44MB ± 0%      -55.26%  (p=0.000 n=10+8)
MapPutGrow/Int64/131072-16             10.9MB ± 0%     4.8MB ± 0%      -56.05%  (p=0.000 n=9+9)
MapPutGrow/Int64/262144-16             21.9MB ± 0%     9.5MB ± 0%      -56.46%  (p=0.000 n=10+10)
MapPutGrow/Int64/524288-16             43.8MB ± 0%    19.0MB ± 0%      -56.67%  (p=0.000 n=10+10)
MapPutGrow/Int64/1048576-16            87.7MB ± 0%    37.9MB ± 0%      -56.84%  (p=0.000 n=10+10)
MapPutGrow/Int64/2097152-16             176MB ± 0%      76MB ± 0%      -56.98%  (p=0.000 n=10+10)
MapPutGrow/Int64/4194304-16             352MB ± 0%     151MB ± 0%      -57.07%  (p=0.000 n=10+8)
MapPutGrow/Int32/6-16                   0.00B         80.00B ± 0%        +Inf%  (p=0.000 n=10+10)
MapPutGrow/Int32/12-16                   179B ± 0%      224B ± 0%      +25.14%  (p=0.000 n=10+10)
MapPutGrow/Int32/18-16                   525B ± 0%      512B ± 0%       -2.48%  (p=0.000 n=10+10)
MapPutGrow/Int32/24-16                   577B ± 0%      512B ± 0%      -11.27%  (p=0.000 n=10+10)
MapPutGrow/Int32/30-16                 1.25kB ± 0%    1.09kB ± 0%      -13.31%  (p=0.000 n=9+10)
MapPutGrow/Int32/64-16                 2.84kB ± 0%    2.24kB ± 0%      -21.10%  (p=0.002 n=8+10)
MapPutGrow/Int32/128-16                6.18kB ± 0%    4.54kB ± 0%      -26.44%  (p=0.000 n=10+10)
MapPutGrow/Int32/256-16                12.6kB ± 0%     9.4kB ± 0%      -25.12%  (p=0.000 n=10+10)
MapPutGrow/Int32/512-16                23.9kB ± 0%    18.9kB ± 0%      -20.99%  (p=0.000 n=9+10)
MapPutGrow/Int32/1024-16               47.7kB ± 0%    37.3kB ± 0%      -21.86%  (p=0.000 n=10+10)
MapPutGrow/Int32/2048-16                101kB ± 0%      78kB ± 0%      -22.55%  (p=0.000 n=9+10)
MapPutGrow/Int32/4096-16                194kB ± 0%     119kB ± 0%      -38.53%  (p=0.000 n=10+10)
MapPutGrow/Int32/8192-16                388kB ± 0%     201kB ± 0%      -48.14%  (p=0.000 n=10+10)
MapPutGrow/Int32/32768-16              1.53MB ± 0%    0.69MB ± 0%      -54.63%  (p=0.000 n=9+7)
MapPutGrow/Int32/65536-16              3.07MB ± 0%    1.35MB ± 0%      -56.03%  (p=0.000 n=10+10)
MapPutGrow/Int32/131072-16             6.16MB ± 0%    2.66MB ± 0%      -56.78%  (p=0.000 n=10+10)
MapPutGrow/Int32/262144-16             12.3MB ± 0%     5.3MB ± 0%      -57.16%  (p=0.000 n=10+10)
MapPutGrow/Int32/524288-16             24.7MB ± 0%    10.5MB ± 0%      -57.36%  (p=0.000 n=10+9)
MapPutGrow/Int32/1048576-16            49.6MB ± 0%    21.0MB ± 0%      -57.59%  (p=0.000 n=9+10)
MapPutGrow/Int32/2097152-16             100MB ± 0%      42MB ± 0%      -57.78%  (p=0.000 n=9+8)
MapPutGrow/Int32/4194304-16             200MB ± 0%      84MB ± 0%      -57.93%  (p=0.000 n=9+10)
MapPutGrow/String/6-16                  0.00B        288.00B ± 0%        +Inf%  (p=0.000 n=10+10)
MapPutGrow/String/12-16                  618B ± 0%      864B ± 0%      +39.81%  (p=0.000 n=8+10)
MapPutGrow/String/18-16                1.83kB ± 0%    2.02kB ± 0%      +10.34%  (p=0.000 n=9+10)
MapPutGrow/String/24-16                1.94kB ± 0%    2.02kB ± 0%       +3.70%  (p=0.000 n=8+10)
MapPutGrow/String/30-16                4.34kB ± 0%    4.32kB ± 0%       -0.39%  (p=0.002 n=8+10)
MapPutGrow/String/64-16                9.66kB ± 0%    9.18kB ± 0%       -4.95%  (p=0.000 n=10+10)
MapPutGrow/String/128-16               19.8kB ± 0%    18.7kB ± 0%       -5.68%  (p=0.000 n=9+10)
MapPutGrow/String/256-16               40.2kB ± 0%    37.1kB ± 0%       -7.67%  (p=0.000 n=10+10)
MapPutGrow/String/512-16               83.2kB ± 0%    78.0kB ± 0%       -6.22%  (p=0.000 n=10+10)
MapPutGrow/String/1024-16               166kB ± 0%     152kB ± 0%       -8.84%  (p=0.000 n=10+10)
MapPutGrow/String/2048-16               325kB ± 0%     291kB ± 0%      -10.33%  (p=0.000 n=9+10)
MapPutGrow/String/4096-16               641kB ± 0%     430kB ± 0%      -32.88%  (p=0.000 n=10+10)
MapPutGrow/String/8192-16              1.27MB ± 0%    0.71MB ± 0%      -44.38%  (p=0.000 n=10+8)
MapPutGrow/String/32768-16             5.08MB ± 0%    2.38MB ± 0%      -53.11%  (p=0.000 n=10+10)
MapPutGrow/String/65536-16             10.2MB ± 0%     4.6MB ± 0%      -54.62%  (p=0.000 n=10+10)
MapPutGrow/String/131072-16            20.3MB ± 0%     9.1MB ± 0%      -55.37%  (p=0.000 n=10+9)
MapPutGrow/String/262144-16            40.6MB ± 0%    18.0MB ± 0%      -55.74%  (p=0.000 n=10+10)
MapPutGrow/String/524288-16            81.3MB ± 0%    35.8MB ± 0%      -55.93%  (p=0.000 n=10+10)
MapPutGrow/String/1048576-16            163MB ± 0%      71MB ± 0%      -56.03%  (p=0.000 n=10+8)
MapPutGrow/String/2097152-16            325MB ± 0%     143MB ± 0%      -56.07%  (p=0.000 n=10+10)
MapPutGrow/String/4194304-16            650MB ± 0%     285MB ± 0%      -56.10%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/6-16            0.00B        144.00B ± 0%        +Inf%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/12-16            317B ± 0%      288B ± 0%       -9.15%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/18-16            591B ± 0%      576B ± 0%       -2.54%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/24-16            672B ± 0%      576B ± 0%      -14.29%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/30-16          1.17kB ± 0%    1.15kB ± 0%       -1.20%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/64-16          2.72kB ± 0%    2.30kB ± 0%      -15.29%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/128-16         5.42kB ± 0%    4.86kB ± 0%      -10.23%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/256-16         10.3kB ± 0%     9.5kB ± 0%       -8.02%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/512-16         20.6kB ± 0%    18.4kB ± 0%      -10.39%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/1024-16        41.1kB ± 0%    41.0kB ± 0%       -0.37%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/2048-16        82.2kB ± 0%    73.7kB ± 0%      -10.30%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/4096-16         164kB ± 0%     148kB ± 0%      -10.25%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/8192-16         321kB ± 0%     295kB ± 0%       -7.96%  (p=0.000 n=9+9)
MapPutPreAllocate/Int64/32768-16       1.26MB ± 0%    1.18MB ± 0%       -6.18%  (p=0.000 n=10+9)
MapPutPreAllocate/Int64/65536-16       2.52MB ± 0%    2.36MB ± 0%       -6.19%  (p=0.000 n=9+10)
MapPutPreAllocate/Int64/131072-16      5.03MB ± 0%    4.72MB ± 0%       -6.17%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/262144-16      10.1MB ± 0%     9.4MB ± 0%       -6.11%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/524288-16      20.1MB ± 0%    18.9MB ± 0%       -6.18%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/1048576-16     40.3MB ± 0%    37.8MB ± 0%       -6.20%  (p=0.000 n=8+10)
MapPutPreAllocate/Int64/2097152-16     80.6MB ± 0%    75.5MB ± 0%       -6.24%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/4194304-16      161MB ± 0%     151MB ± 0%       -6.29%  (p=0.000 n=9+10)
MapPutPreAllocate/Int32/6-16            0.00B         80.00B ± 0%        +Inf%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/12-16            179B ± 0%      144B ± 0%      -19.55%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/18-16            330B ± 0%      288B ± 0%      -12.73%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/24-16            385B ± 0%      288B ± 0%      -25.19%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/30-16            649B ± 0%      576B ± 0%      -11.25%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/64-16          1.44kB ± 0%    1.15kB ± 0%      -20.11%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/128-16         3.11kB ± 0%    2.30kB ± 0%      -26.01%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/256-16         6.20kB ± 0%    4.86kB ± 0%      -21.58%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/512-16         11.0kB ± 0%     9.5kB ± 0%      -13.66%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/1024-16        21.9kB ± 0%    18.4kB ± 0%      -15.88%  (p=0.000 n=9+10)
MapPutPreAllocate/Int32/2048-16        49.4kB ± 0%    41.0kB ± 0%      -17.13%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/4096-16        90.6kB ± 0%    82.0kB ± 0%       -9.55%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/8192-16         181kB ± 0%     164kB ± 0%       -9.55%  (p=0.000 n=9+10)
MapPutPreAllocate/Int32/32768-16        701kB ± 0%     656kB ± 0%       -6.42%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/65536-16       1.40MB ± 0%    1.31MB ± 0%       -6.43%  (p=0.000 n=10+9)
MapPutPreAllocate/Int32/131072-16      2.80MB ± 0%    2.62MB ± 0%       -6.39%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/262144-16      5.60MB ± 0%    5.25MB ± 0%       -6.30%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/524288-16      11.2MB ± 0%    10.5MB ± 0%       -6.41%  (p=0.000 n=8+9)
MapPutPreAllocate/Int32/1048576-16     22.4MB ± 0%    21.0MB ± 0%       -6.45%  (p=0.000 n=9+10)
MapPutPreAllocate/Int32/2097152-16     44.9MB ± 0%    42.0MB ± 0%       -6.53%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/4194304-16     89.9MB ± 0%    84.0MB ± 0%       -6.61%  (p=0.000 n=10+8)
MapPutPreAllocate/String/6-16           0.00B        288.00B ± 0%        +Inf%  (p=0.000 n=10+10)
MapPutPreAllocate/String/12-16           618B ± 0%      576B ± 0%       -6.80%  (p=0.002 n=8+10)
MapPutPreAllocate/String/18-16         1.17kB ± 0%    1.15kB ± 0%       -1.87%  (p=0.000 n=10+10)
MapPutPreAllocate/String/24-16         1.29kB ± 0%    1.15kB ± 0%      -10.77%  (p=0.000 n=9+10)
MapPutPreAllocate/String/30-16         2.32kB ± 0%    2.30kB ± 0%       -0.86%  (p=0.000 n=10+10)
MapPutPreAllocate/String/64-16         4.89kB ± 0%    4.86kB ± 0%       -0.59%  (p=0.000 n=10+10)
MapPutPreAllocate/String/128-16        9.50kB ± 0%    9.47kB ± 0%       -0.29%  (p=0.000 n=10+10)
MapPutPreAllocate/String/256-16        19.1kB ± 0%    18.4kB ± 0%       -3.48%  (p=0.000 n=10+10)
MapPutPreAllocate/String/512-16        41.0kB ± 0%    41.0kB ± 0%       -0.06%  (p=0.000 n=10+10)
MapPutPreAllocate/String/1024-16       81.9kB ± 0%    73.7kB ± 0%      -10.03%  (p=0.000 n=10+10)
MapPutPreAllocate/String/2048-16        156kB ± 0%     139kB ± 0%      -10.54%  (p=0.000 n=10+10)
MapPutPreAllocate/String/4096-16        303kB ± 0%     279kB ± 0%       -8.09%  (p=0.002 n=8+10)
MapPutPreAllocate/String/8192-16        598kB ± 0%     557kB ± 0%       -6.83%  (p=0.000 n=10+10)
MapPutPreAllocate/String/32768-16      2.37MB ± 0%    2.23MB ± 0%       -5.86%  (p=0.000 n=10+10)
MapPutPreAllocate/String/65536-16      4.74MB ± 0%    4.46MB ± 0%       -5.86%  (p=0.000 n=10+10)
MapPutPreAllocate/String/131072-16     9.47MB ± 0%    8.92MB ± 0%       -5.86%  (p=0.000 n=10+10)
MapPutPreAllocate/String/262144-16     18.9MB ± 0%    17.8MB ± 0%       -5.86%  (p=0.000 n=9+10)
MapPutPreAllocate/String/524288-16     37.9MB ± 0%    35.7MB ± 0%       -5.86%  (p=0.000 n=10+9)
MapPutPreAllocate/String/1048576-16    75.8MB ± 0%    71.3MB ± 0%       -5.86%  (p=0.000 n=10+8)
MapPutPreAllocate/String/2097152-16     152MB ± 0%     143MB ± 0%       -5.86%  (p=0.000 n=9+10)
MapPutPreAllocate/String/4194304-16     303MB ± 0%     285MB ± 0%       -5.86%  (p=0.000 n=10+10)
MapPutReuse/Int64/6-16                  0.00B          0.00B              ~     (all equal)
MapPutReuse/Int64/12-16                 25.0B ± 0%      0.0B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/18-16                 13.0B ± 0%      0.0B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/24-16                 85.0B ± 0%      0.0B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/30-16                 12.0B ± 0%      0.0B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/64-16                 8.00B ± 0%     0.00B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/128-16                18.0B ± 0%      0.0B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/256-16                34.0B ± 0%      0.0B          -100.00%  (p=0.000 n=9+10)
MapPutReuse/Int64/512-16                66.0B ± 0%      0.0B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/1024-16                128B ± 0%        0B          -100.00%  (p=0.002 n=8+10)
MapPutReuse/Int64/2048-16                252B ± 0%        0B          -100.00%  (p=0.000 n=6+10)
MapPutReuse/Int64/4096-16                506B ± 0%        0B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/8192-16              1.03kB ± 0%    0.00kB          -100.00%  (p=0.000 n=9+10)
MapPutReuse/Int64/32768-16             4.49kB ± 0%    0.00kB          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/65536-16             9.36kB ± 0%    0.00kB          -100.00%  (p=0.000 n=9+10)
MapPutReuse/Int64/131072-16            17.6kB ± 0%     0.0kB          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/262144-16            29.8kB ± 0%     0.0kB          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/524288-16            72.8kB ± 0%     0.0kB          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/1048576-16            155kB ± 0%       0kB          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/2097152-16            352kB ± 9%       0kB          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/4194304-16            761kB ± 0%       0kB          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/6-16                  0.00B          0.00B              ~     (all equal)
MapPutReuse/Int32/12-16                 16.0B ± 0%      0.0B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/18-16                 8.00B ± 0%     0.00B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/24-16                 54.0B ± 0%      0.0B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/30-16                 8.00B ± 0%     0.00B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/64-16                 10.0B ± 0%      0.0B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/128-16                18.0B ± 0%      0.0B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/256-16                34.0B ± 0%      0.0B          -100.00%  (p=0.002 n=8+10)
MapPutReuse/Int32/512-16                66.0B ± 0%      0.0B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/1024-16                128B ± 0%        0B          -100.00%  (p=0.002 n=8+10)
MapPutReuse/Int32/2048-16                252B ± 0%        0B          -100.00%  (p=0.000 n=7+10)
MapPutReuse/Int32/4096-16                505B ± 0%        0B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/8192-16              1.03kB ± 0%    0.00kB          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/32768-16             4.48kB ± 0%    0.00kB          -100.00%  (p=0.000 n=9+10)
MapPutReuse/Int32/65536-16             9.36kB ± 0%    0.00kB          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/131072-16            17.6kB ± 0%     0.0kB          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/262144-16            29.8kB ± 0%     0.0kB          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/524288-16            72.8kB ± 0%     0.0kB          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/1048576-16            155kB ± 0%       0kB          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/2097152-16            348kB ± 8%       0kB          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/4194304-16            761kB ± 0%       0kB          -100.00%  (p=0.000 n=10+10)
MapPutReuse/String/6-16                 0.00B          0.00B              ~     (all equal)
MapPutReuse/String/12-16                41.6B ± 1%      0.0B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/String/18-16                22.0B ± 0%      0.0B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/String/24-16                 139B ± 0%        0B          -100.00%  (p=0.002 n=8+10)
MapPutReuse/String/30-16                20.0B ± 0%      0.0B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/String/64-16                5.00B ± 0%     0.00B          -100.00%  (p=0.000 n=10+10)
MapPutReuse/String/128-16               4.00B ± 0%     0.00B          -100.00%  (p=0.002 n=8+10)
MapPutReuse/String/256-16               0.00B          0.00B              ~     (all equal)
MapPutReuse/String/512-16               0.00B          0.00B              ~     (all equal)
MapPutReuse/String/1024-16              0.00B          0.00B              ~     (all equal)
MapPutReuse/String/2048-16              0.00B          0.00B              ~     (all equal)
MapPutReuse/String/4096-16              0.00B          0.00B              ~     (all equal)
MapPutReuse/String/8192-16              0.00B          0.00B              ~     (all equal)
MapPutReuse/String/32768-16             0.00B          0.00B              ~     (all equal)
MapPutReuse/String/65536-16             0.00B          0.00B              ~     (all equal)
MapPutReuse/String/131072-16            0.00B          0.00B              ~     (all equal)
MapPutReuse/String/262144-16            0.00B          0.00B              ~     (all equal)
MapPutReuse/String/524288-16            0.00B          0.00B              ~     (all equal)
MapPutReuse/String/1048576-16           0.00B          0.00B              ~     (all equal)
MapPutReuse/String/2097152-16           0.00B          0.00B              ~     (all equal)
MapPutReuse/String/4194304-16           0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/6-16                 0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/12-16                0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/18-16                0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/24-16                0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/30-16                0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/64-16                0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/128-16               0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/256-16               0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/512-16               0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/1024-16              0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/2048-16              0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/4096-16              0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/8192-16              0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/32768-16             0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/65536-16             0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/131072-16            0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/262144-16            0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/524288-16            0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/1048576-16           0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/2097152-16           0.00B          0.00B              ~     (all equal)
MapPutDelete/Int64/4194304-16           0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/6-16                 0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/12-16                0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/18-16                0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/24-16                0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/30-16                0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/64-16                0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/128-16               0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/256-16               0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/512-16               0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/1024-16              0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/2048-16              0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/4096-16              0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/8192-16              0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/32768-16             0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/65536-16             0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/131072-16            0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/262144-16            0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/524288-16            0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/1048576-16           0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/2097152-16           0.00B          0.00B              ~     (all equal)
MapPutDelete/Int32/4194304-16           0.00B          0.00B              ~     (all equal)
MapPutDelete/String/6-16                0.00B          0.00B              ~     (all equal)
MapPutDelete/String/12-16               0.00B          0.00B              ~     (all equal)
MapPutDelete/String/18-16               0.00B          0.00B              ~     (all equal)
MapPutDelete/String/24-16               0.00B          0.00B              ~     (all equal)
MapPutDelete/String/30-16               0.00B          0.00B              ~     (all equal)
MapPutDelete/String/64-16               0.00B          0.00B              ~     (all equal)
MapPutDelete/String/128-16              0.00B          0.00B              ~     (all equal)
MapPutDelete/String/256-16              0.00B          0.00B              ~     (all equal)
MapPutDelete/String/512-16              0.00B          0.00B              ~     (all equal)
MapPutDelete/String/1024-16             0.00B          0.00B              ~     (all equal)
MapPutDelete/String/2048-16             0.00B          0.00B              ~     (all equal)
MapPutDelete/String/4096-16             0.00B          0.00B              ~     (all equal)
MapPutDelete/String/8192-16             0.00B          0.00B              ~     (all equal)
MapPutDelete/String/32768-16            0.00B          0.00B              ~     (all equal)
MapPutDelete/String/65536-16            0.00B          0.00B              ~     (all equal)
MapPutDelete/String/131072-16           0.00B          0.00B              ~     (all equal)
MapPutDelete/String/262144-16           0.00B          0.00B              ~     (all equal)
MapPutDelete/String/524288-16           0.00B          0.00B              ~     (all equal)
MapPutDelete/String/1048576-16          0.00B          0.00B              ~     (all equal)
MapPutDelete/String/2097152-16          0.00B          0.00B              ~     (all equal)
MapPutDelete/String/4194304-16          0.00B          0.00B              ~     (all equal)

name                                 old allocs/op  new allocs/op  delta
MapIter/Int/6-16                         0.00           0.00              ~     (all equal)
MapIter/Int/12-16                        0.00           0.00              ~     (all equal)
MapIter/Int/18-16                        0.00           0.00              ~     (all equal)
MapIter/Int/24-16                        0.00           0.00              ~     (all equal)
MapIter/Int/30-16                        0.00           0.00              ~     (all equal)
MapIter/Int/64-16                        0.00           0.00              ~     (all equal)
MapIter/Int/128-16                       0.00           0.00              ~     (all equal)
MapIter/Int/256-16                       0.00           0.00              ~     (all equal)
MapIter/Int/512-16                       0.00           0.00              ~     (all equal)
MapIter/Int/1024-16                      0.00           0.00              ~     (all equal)
MapIter/Int/2048-16                      0.00           0.00              ~     (all equal)
MapIter/Int/4096-16                      0.00           0.00              ~     (all equal)
MapIter/Int/8192-16                      0.00           0.00              ~     (all equal)
MapIter/Int/32768-16                     0.00           0.00              ~     (all equal)
MapIter/Int/65536-16                     0.00           0.00              ~     (all equal)
MapIter/Int/131072-16                    0.00           0.00              ~     (all equal)
MapIter/Int/262144-16                    0.00           0.00              ~     (all equal)
MapIter/Int/524288-16                    0.00           0.00              ~     (all equal)
MapIter/Int/1048576-16                   0.00           0.00              ~     (all equal)
MapIter/Int/2097152-16                   0.00           0.00              ~     (all equal)
MapIter/Int/4194304-16                   0.00           0.00              ~     (all equal)
MapGetHit/Int64/6-16                     0.00           0.00              ~     (all equal)
MapGetHit/Int64/12-16                    0.00           0.00              ~     (all equal)
MapGetHit/Int64/18-16                    0.00           0.00              ~     (all equal)
MapGetHit/Int64/24-16                    0.00           0.00              ~     (all equal)
MapGetHit/Int64/30-16                    0.00           0.00              ~     (all equal)
MapGetHit/Int64/64-16                    0.00           0.00              ~     (all equal)
MapGetHit/Int64/128-16                   0.00           0.00              ~     (all equal)
MapGetHit/Int64/256-16                   0.00           0.00              ~     (all equal)
MapGetHit/Int64/512-16                   0.00           0.00              ~     (all equal)
MapGetHit/Int64/1024-16                  0.00           0.00              ~     (all equal)
MapGetHit/Int64/2048-16                  0.00           0.00              ~     (all equal)
MapGetHit/Int64/4096-16                  0.00           0.00              ~     (all equal)
MapGetHit/Int64/8192-16                  0.00           0.00              ~     (all equal)
MapGetHit/Int64/32768-16                 0.00           0.00              ~     (all equal)
MapGetHit/Int64/65536-16                 0.00           0.00              ~     (all equal)
MapGetHit/Int64/131072-16                0.00           0.00              ~     (all equal)
MapGetHit/Int64/262144-16                0.00           0.00              ~     (all equal)
MapGetHit/Int64/524288-16                0.00           0.00              ~     (all equal)
MapGetHit/Int64/1048576-16               0.00           0.00              ~     (all equal)
MapGetHit/Int64/2097152-16               0.00           0.00              ~     (all equal)
MapGetHit/Int64/4194304-16               0.00           0.00              ~     (all equal)
MapGetHit/Int32/6-16                     0.00           0.00              ~     (all equal)
MapGetHit/Int32/12-16                    0.00           0.00              ~     (all equal)
MapGetHit/Int32/18-16                    0.00           0.00              ~     (all equal)
MapGetHit/Int32/24-16                    0.00           0.00              ~     (all equal)
MapGetHit/Int32/30-16                    0.00           0.00              ~     (all equal)
MapGetHit/Int32/64-16                    0.00           0.00              ~     (all equal)
MapGetHit/Int32/128-16                   0.00           0.00              ~     (all equal)
MapGetHit/Int32/256-16                   0.00           0.00              ~     (all equal)
MapGetHit/Int32/512-16                   0.00           0.00              ~     (all equal)
MapGetHit/Int32/1024-16                  0.00           0.00              ~     (all equal)
MapGetHit/Int32/2048-16                  0.00           0.00              ~     (all equal)
MapGetHit/Int32/4096-16                  0.00           0.00              ~     (all equal)
MapGetHit/Int32/8192-16                  0.00           0.00              ~     (all equal)
MapGetHit/Int32/32768-16                 0.00           0.00              ~     (all equal)
MapGetHit/Int32/65536-16                 0.00           0.00              ~     (all equal)
MapGetHit/Int32/131072-16                0.00           0.00              ~     (all equal)
MapGetHit/Int32/262144-16                0.00           0.00              ~     (all equal)
MapGetHit/Int32/524288-16                0.00           0.00              ~     (all equal)
MapGetHit/Int32/1048576-16               0.00           0.00              ~     (all equal)
MapGetHit/Int32/2097152-16               0.00           0.00              ~     (all equal)
MapGetHit/Int32/4194304-16               0.00           0.00              ~     (all equal)
MapGetHit/String/6-16                    0.00           0.00              ~     (all equal)
MapGetHit/String/12-16                   0.00           0.00              ~     (all equal)
MapGetHit/String/18-16                   0.00           0.00              ~     (all equal)
MapGetHit/String/24-16                   0.00           0.00              ~     (all equal)
MapGetHit/String/30-16                   0.00           0.00              ~     (all equal)
MapGetHit/String/64-16                   0.00           0.00              ~     (all equal)
MapGetHit/String/128-16                  0.00           0.00              ~     (all equal)
MapGetHit/String/256-16                  0.00           0.00              ~     (all equal)
MapGetHit/String/512-16                  0.00           0.00              ~     (all equal)
MapGetHit/String/1024-16                 0.00           0.00              ~     (all equal)
MapGetHit/String/2048-16                 0.00           0.00              ~     (all equal)
MapGetHit/String/4096-16                 0.00           0.00              ~     (all equal)
MapGetHit/String/8192-16                 0.00           0.00              ~     (all equal)
MapGetHit/String/32768-16                0.00           0.00              ~     (all equal)
MapGetHit/String/65536-16                0.00           0.00              ~     (all equal)
MapGetHit/String/131072-16               0.00           0.00              ~     (all equal)
MapGetHit/String/262144-16               0.00           0.00              ~     (all equal)
MapGetHit/String/524288-16               0.00           0.00              ~     (all equal)
MapGetHit/String/1048576-16              0.00           0.00              ~     (all equal)
MapGetHit/String/2097152-16              0.00           0.00              ~     (all equal)
MapGetHit/String/4194304-16              0.00           0.00              ~     (all equal)
MapGetMiss/Int64/6-16                    0.00           0.00              ~     (all equal)
MapGetMiss/Int64/12-16                   0.00           0.00              ~     (all equal)
MapGetMiss/Int64/18-16                   0.00           0.00              ~     (all equal)
MapGetMiss/Int64/24-16                   0.00           0.00              ~     (all equal)
MapGetMiss/Int64/30-16                   0.00           0.00              ~     (all equal)
MapGetMiss/Int64/64-16                   0.00           0.00              ~     (all equal)
MapGetMiss/Int64/128-16                  0.00           0.00              ~     (all equal)
MapGetMiss/Int64/256-16                  0.00           0.00              ~     (all equal)
MapGetMiss/Int64/512-16                  0.00           0.00              ~     (all equal)
MapGetMiss/Int64/1024-16                 0.00           0.00              ~     (all equal)
MapGetMiss/Int64/2048-16                 0.00           0.00              ~     (all equal)
MapGetMiss/Int64/4096-16                 0.00           0.00              ~     (all equal)
MapGetMiss/Int64/8192-16                 0.00           0.00              ~     (all equal)
MapGetMiss/Int64/32768-16                0.00           0.00              ~     (all equal)
MapGetMiss/Int64/65536-16                0.00           0.00              ~     (all equal)
MapGetMiss/Int64/131072-16               0.00           0.00              ~     (all equal)
MapGetMiss/Int64/262144-16               0.00           0.00              ~     (all equal)
MapGetMiss/Int64/524288-16               0.00           0.00              ~     (all equal)
MapGetMiss/Int64/1048576-16              0.00           0.00              ~     (all equal)
MapGetMiss/Int64/2097152-16              0.00           0.00              ~     (all equal)
MapGetMiss/Int64/4194304-16              0.00           0.00              ~     (all equal)
MapGetMiss/Int32/6-16                    0.00           0.00              ~     (all equal)
MapGetMiss/Int32/12-16                   0.00           0.00              ~     (all equal)
MapGetMiss/Int32/18-16                   0.00           0.00              ~     (all equal)
MapGetMiss/Int32/24-16                   0.00           0.00              ~     (all equal)
MapGetMiss/Int32/30-16                   0.00           0.00              ~     (all equal)
MapGetMiss/Int32/64-16                   0.00           0.00              ~     (all equal)
MapGetMiss/Int32/128-16                  0.00           0.00              ~     (all equal)
MapGetMiss/Int32/256-16                  0.00           0.00              ~     (all equal)
MapGetMiss/Int32/512-16                  0.00           0.00              ~     (all equal)
MapGetMiss/Int32/1024-16                 0.00           0.00              ~     (all equal)
MapGetMiss/Int32/2048-16                 0.00           0.00              ~     (all equal)
MapGetMiss/Int32/4096-16                 0.00           0.00              ~     (all equal)
MapGetMiss/Int32/8192-16                 0.00           0.00              ~     (all equal)
MapGetMiss/Int32/32768-16                0.00           0.00              ~     (all equal)
MapGetMiss/Int32/65536-16                0.00           0.00              ~     (all equal)
MapGetMiss/Int32/131072-16               0.00           0.00              ~     (all equal)
MapGetMiss/Int32/262144-16               0.00           0.00              ~     (all equal)
MapGetMiss/Int32/524288-16               0.00           0.00              ~     (all equal)
MapGetMiss/Int32/1048576-16              0.00           0.00              ~     (all equal)
MapGetMiss/Int32/2097152-16              0.00           0.00              ~     (all equal)
MapGetMiss/Int32/4194304-16              0.00           0.00              ~     (all equal)
MapGetMiss/String/6-16                   0.00           0.00              ~     (all equal)
MapGetMiss/String/12-16                  0.00           0.00              ~     (all equal)
MapGetMiss/String/18-16                  0.00           0.00              ~     (all equal)
MapGetMiss/String/24-16                  0.00           0.00              ~     (all equal)
MapGetMiss/String/30-16                  0.00           0.00              ~     (all equal)
MapGetMiss/String/64-16                  0.00           0.00              ~     (all equal)
MapGetMiss/String/128-16                 0.00           0.00              ~     (all equal)
MapGetMiss/String/256-16                 0.00           0.00              ~     (all equal)
MapGetMiss/String/512-16                 0.00           0.00              ~     (all equal)
MapGetMiss/String/1024-16                0.00           0.00              ~     (all equal)
MapGetMiss/String/2048-16                0.00           0.00              ~     (all equal)
MapGetMiss/String/4096-16                0.00           0.00              ~     (all equal)
MapGetMiss/String/8192-16                0.00           0.00              ~     (all equal)
MapGetMiss/String/32768-16               0.00           0.00              ~     (all equal)
MapGetMiss/String/65536-16               0.00           0.00              ~     (all equal)
MapGetMiss/String/131072-16              0.00           0.00              ~     (all equal)
MapGetMiss/String/262144-16              0.00           0.00              ~     (all equal)
MapGetMiss/String/524288-16              0.00           0.00              ~     (all equal)
MapGetMiss/String/1048576-16             0.00           0.00              ~     (all equal)
MapGetMiss/String/2097152-16             0.00           0.00              ~     (all equal)
MapGetMiss/String/4194304-16             0.00           0.00              ~     (all equal)
MapPutGrow/Int64/6-16                    0.00           1.00 ± 0%        +Inf%  (p=0.000 n=10+10)
MapPutGrow/Int64/12-16                   1.00 ± 0%      2.00 ± 0%     +100.00%  (p=0.000 n=10+10)
MapPutGrow/Int64/18-16                   3.00 ± 0%      3.00 ± 0%         ~     (all equal)
MapPutGrow/Int64/24-16                   4.00 ± 0%      3.00 ± 0%      -25.00%  (p=0.000 n=10+10)
MapPutGrow/Int64/30-16                   6.00 ± 0%      4.00 ± 0%      -33.33%  (p=0.000 n=10+10)
MapPutGrow/Int64/64-16                   12.0 ± 0%       5.0 ± 0%      -58.33%  (p=0.000 n=10+10)
MapPutGrow/Int64/128-16                  19.0 ± 0%       6.0 ± 0%      -68.42%  (p=0.000 n=10+10)
MapPutGrow/Int64/256-16                  27.0 ± 0%       7.0 ± 0%      -74.07%  (p=0.000 n=10+10)
MapPutGrow/Int64/512-16                  42.0 ± 0%       8.0 ± 0%      -80.95%  (p=0.000 n=10+10)
MapPutGrow/Int64/1024-16                 64.0 ± 0%       9.0 ± 0%      -85.94%  (p=0.000 n=10+10)
MapPutGrow/Int64/2048-16                 99.0 ± 0%      10.0 ± 0%      -89.90%  (p=0.002 n=8+10)
MapPutGrow/Int64/4096-16                  161 ± 0%        12 ± 0%      -92.57%  (p=0.000 n=10+10)
MapPutGrow/Int64/8192-16                  274 ± 0%        15 ± 0%      -94.53%  (p=0.000 n=7+10)
MapPutGrow/Int64/32768-16               1.13k ± 0%     0.03k ± 0%      -97.43%  (p=0.000 n=9+10)
MapPutGrow/Int64/65536-16               2.35k ± 0%     0.05k ± 0%      -98.04%  (p=0.000 n=10+10)
MapPutGrow/Int64/131072-16              4.76k ± 0%     0.08k ± 0%      -98.34%  (p=0.000 n=10+10)
MapPutGrow/Int64/262144-16              9.58k ± 0%     0.14k ± 0%      -98.50%  (p=0.000 n=10+10)
MapPutGrow/Int64/524288-16              19.2k ± 0%      0.3k ± 0%      -98.58%  (p=0.000 n=10+10)
MapPutGrow/Int64/1048576-16             38.4k ± 0%      0.5k ± 0%      -98.62%  (p=0.000 n=10+10)
MapPutGrow/Int64/2097152-16             76.8k ± 0%      1.0k ± 0%      -98.64%  (p=0.000 n=10+10)
MapPutGrow/Int64/4194304-16              154k ± 0%        2k ± 0%      -98.65%  (p=0.000 n=10+10)
MapPutGrow/Int32/6-16                    0.00           1.00 ± 0%        +Inf%  (p=0.000 n=10+10)
MapPutGrow/Int32/12-16                   1.00 ± 0%      2.00 ± 0%     +100.00%  (p=0.000 n=10+10)
MapPutGrow/Int32/18-16                   3.00 ± 0%      3.00 ± 0%         ~     (all equal)
MapPutGrow/Int32/24-16                   4.00 ± 0%      3.00 ± 0%      -25.00%  (p=0.000 n=10+10)
MapPutGrow/Int32/30-16                   6.00 ± 0%      4.00 ± 0%      -33.33%  (p=0.000 n=10+10)
MapPutGrow/Int32/64-16                   12.0 ± 0%       5.0 ± 0%      -58.33%  (p=0.000 n=10+10)
MapPutGrow/Int32/128-16                  20.0 ± 0%       6.0 ± 0%      -70.00%  (p=0.000 n=10+10)
MapPutGrow/Int32/256-16                  28.0 ± 0%       7.0 ± 0%      -75.00%  (p=0.000 n=10+10)
MapPutGrow/Int32/512-16                  37.3 ± 2%       8.0 ± 0%      -78.55%  (p=0.000 n=10+10)
MapPutGrow/Int32/1024-16                 65.0 ± 0%       9.0 ± 0%      -86.15%  (p=0.002 n=8+10)
MapPutGrow/Int32/2048-16                  113 ± 0%        10 ± 0%      -91.15%  (p=0.000 n=10+10)
MapPutGrow/Int32/4096-16                  130 ± 0%        12 ± 0%      -90.77%  (p=0.000 n=9+10)
MapPutGrow/Int32/8192-16                  254 ± 0%        15 ± 0%      -94.08%  (p=0.000 n=10+10)
MapPutGrow/Int32/32768-16               1.05k ± 0%     0.03k ± 0%      -97.24%  (p=0.000 n=10+10)
MapPutGrow/Int32/65536-16               2.27k ± 0%     0.05k ± 0%      -97.97%  (p=0.000 n=10+10)
MapPutGrow/Int32/131072-16              4.68k ± 0%     0.08k ± 0%      -98.31%  (p=0.000 n=10+10)
MapPutGrow/Int32/262144-16              9.50k ± 0%     0.14k ± 0%      -98.48%  (p=0.000 n=10+10)
MapPutGrow/Int32/524288-16              19.1k ± 0%      0.3k ± 0%      -98.57%  (p=0.000 n=10+10)
MapPutGrow/Int32/1048576-16             38.3k ± 0%      0.5k ± 0%      -98.62%  (p=0.000 n=9+10)
MapPutGrow/Int32/2097152-16             76.8k ± 0%      1.0k ± 0%      -98.64%  (p=0.000 n=9+10)
MapPutGrow/Int32/4194304-16              154k ± 0%        2k ± 0%      -98.65%  (p=0.000 n=9+10)
MapPutGrow/String/6-16                   0.00           1.00 ± 0%        +Inf%  (p=0.000 n=10+10)
MapPutGrow/String/12-16                  1.00 ± 0%      2.00 ± 0%     +100.00%  (p=0.000 n=10+10)
MapPutGrow/String/18-16                  2.00 ± 0%      3.00 ± 0%      +50.00%  (p=0.000 n=10+10)
MapPutGrow/String/24-16                  2.00 ± 0%      3.00 ± 0%      +50.00%  (p=0.000 n=10+10)
MapPutGrow/String/30-16                  4.00 ± 0%      4.00 ± 0%         ~     (all equal)
MapPutGrow/String/64-16                  7.00 ± 0%      5.00 ± 0%      -28.57%  (p=0.000 n=10+10)
MapPutGrow/String/128-16                 10.0 ± 0%       6.0 ± 0%      -40.00%  (p=0.000 n=10+10)
MapPutGrow/String/256-16                 16.0 ± 0%       7.0 ± 0%      -56.25%  (p=0.000 n=10+10)
MapPutGrow/String/512-16                 24.0 ± 0%       8.0 ± 0%      -66.67%  (p=0.000 n=10+10)
MapPutGrow/String/1024-16                30.0 ± 0%       9.0 ± 0%      -70.00%  (p=0.000 n=10+10)
MapPutGrow/String/2048-16                39.0 ± 0%      10.0 ± 0%      -74.36%  (p=0.000 n=9+10)
MapPutGrow/String/4096-16                87.0 ± 0%      12.0 ± 0%      -86.21%  (p=0.000 n=9+10)
MapPutGrow/String/8192-16                 212 ± 0%        15 ± 0%      -92.92%  (p=0.002 n=8+10)
MapPutGrow/String/32768-16              1.08k ± 0%     0.03k ± 0%      -97.30%  (p=0.000 n=10+10)
MapPutGrow/String/65536-16              2.28k ± 0%     0.05k ± 0%      -97.98%  (p=0.000 n=10+10)
MapPutGrow/String/131072-16             4.68k ± 0%     0.08k ± 0%      -98.31%  (p=0.000 n=10+10)
MapPutGrow/String/262144-16             9.47k ± 0%     0.14k ± 0%      -98.48%  (p=0.000 n=10+10)
MapPutGrow/String/524288-16             19.1k ± 0%      0.3k ± 0%      -98.57%  (p=0.000 n=10+10)
MapPutGrow/String/1048576-16            38.3k ± 0%      0.5k ± 0%      -98.62%  (p=0.000 n=10+10)
MapPutGrow/String/2097152-16            76.7k ± 0%      1.0k ± 0%      -98.64%  (p=0.000 n=10+10)
MapPutGrow/String/4194304-16             153k ± 1%        2k ± 0%      -98.65%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/6-16             0.00           1.00 ± 0%        +Inf%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/12-16            1.00 ± 0%      1.00 ± 0%         ~     (all equal)
MapPutPreAllocate/Int64/18-16            1.00 ± 0%      1.00 ± 0%         ~     (all equal)
MapPutPreAllocate/Int64/24-16            2.00 ± 0%      1.00 ± 0%      -50.00%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/30-16            1.00 ± 0%      1.00 ± 0%         ~     (all equal)
MapPutPreAllocate/Int64/64-16            2.00 ± 0%      1.00 ± 0%      -50.00%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/128-16           3.00 ± 0%      1.00 ± 0%      -66.67%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/256-16           4.00 ± 0%      1.00 ± 0%      -75.00%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/512-16           5.00 ± 0%      1.00 ± 0%      -80.00%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/1024-16          6.00 ± 0%      1.00 ± 0%      -83.33%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/2048-16          7.00 ± 0%      1.00 ± 0%      -85.71%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/4096-16          8.00 ± 0%      3.00 ± 0%      -62.50%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/8192-16          9.00 ± 0%      5.00 ± 0%      -44.44%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/32768-16         12.0 ± 0%      17.0 ± 0%      +41.67%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/65536-16         13.0 ± 0%      33.0 ± 0%     +153.85%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/131072-16        14.0 ± 0%      65.0 ± 0%     +364.29%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/262144-16        15.0 ± 0%     129.0 ± 0%     +760.00%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/524288-16        17.0 ± 0%     257.0 ± 0%    +1411.76%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/1048576-16       19.0 ± 0%     513.0 ± 0%    +2600.00%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/2097152-16       21.0 ± 0%    1025.0 ± 0%    +4780.95%  (p=0.000 n=10+10)
MapPutPreAllocate/Int64/4194304-16       24.0 ± 0%    2049.0 ± 0%    +8437.50%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/6-16             0.00           1.00 ± 0%        +Inf%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/12-16            1.00 ± 0%      1.00 ± 0%         ~     (all equal)
MapPutPreAllocate/Int32/18-16            1.00 ± 0%      1.00 ± 0%         ~     (all equal)
MapPutPreAllocate/Int32/24-16            2.00 ± 0%      1.00 ± 0%      -50.00%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/30-16            1.00 ± 0%      1.00 ± 0%         ~     (all equal)
MapPutPreAllocate/Int32/64-16            2.00 ± 0%      1.00 ± 0%      -50.00%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/128-16           3.00 ± 0%      1.00 ± 0%      -66.67%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/256-16           4.00 ± 0%      1.00 ± 0%      -75.00%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/512-16           5.00 ± 0%      1.00 ± 0%      -80.00%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/1024-16          6.00 ± 0%      1.00 ± 0%      -83.33%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/2048-16          7.00 ± 0%      1.00 ± 0%      -85.71%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/4096-16          8.00 ± 0%      3.00 ± 0%      -62.50%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/8192-16          9.00 ± 0%      5.00 ± 0%      -44.44%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/32768-16         12.0 ± 0%      17.0 ± 0%      +41.67%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/65536-16         13.0 ± 0%      33.0 ± 0%     +153.85%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/131072-16        14.0 ± 0%      65.0 ± 0%     +364.29%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/262144-16        15.0 ± 0%     129.0 ± 0%     +760.00%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/524288-16        17.0 ± 0%     257.0 ± 0%    +1411.76%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/1048576-16       19.0 ± 0%     513.0 ± 0%    +2600.00%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/2097152-16       21.0 ± 0%    1025.0 ± 0%    +4780.95%  (p=0.000 n=10+10)
MapPutPreAllocate/Int32/4194304-16       24.0 ± 0%    2049.0 ± 0%    +8437.50%  (p=0.000 n=10+10)
MapPutPreAllocate/String/6-16            0.00           1.00 ± 0%        +Inf%  (p=0.000 n=10+10)
MapPutPreAllocate/String/12-16           1.00 ± 0%      1.00 ± 0%         ~     (all equal)
MapPutPreAllocate/String/18-16           1.00 ± 0%      1.00 ± 0%         ~     (all equal)
MapPutPreAllocate/String/24-16           1.00 ± 0%      1.00 ± 0%         ~     (all equal)
MapPutPreAllocate/String/30-16           1.00 ± 0%      1.00 ± 0%         ~     (all equal)
MapPutPreAllocate/String/64-16           2.00 ± 0%      1.00 ± 0%      -50.00%  (p=0.000 n=10+10)
MapPutPreAllocate/String/128-16          2.00 ± 0%      1.00 ± 0%      -50.00%  (p=0.000 n=10+10)
MapPutPreAllocate/String/256-16          2.00 ± 0%      1.00 ± 0%      -50.00%  (p=0.000 n=10+10)
MapPutPreAllocate/String/512-16          2.00 ± 0%      1.00 ± 0%      -50.00%  (p=0.000 n=10+10)
MapPutPreAllocate/String/1024-16         2.00 ± 0%      1.00 ± 0%      -50.00%  (p=0.000 n=10+10)
MapPutPreAllocate/String/2048-16         2.00 ± 0%      1.00 ± 0%      -50.00%  (p=0.000 n=10+10)
MapPutPreAllocate/String/4096-16         2.00 ± 0%      3.00 ± 0%      +50.00%  (p=0.000 n=10+10)
MapPutPreAllocate/String/8192-16         2.00 ± 0%      5.00 ± 0%     +150.00%  (p=0.000 n=10+10)
MapPutPreAllocate/String/32768-16        2.00 ± 0%     17.00 ± 0%     +750.00%  (p=0.000 n=10+10)
MapPutPreAllocate/String/65536-16        2.00 ± 0%     33.00 ± 0%    +1550.00%  (p=0.000 n=10+10)
MapPutPreAllocate/String/131072-16       2.00 ± 0%     65.00 ± 0%    +3150.00%  (p=0.000 n=10+10)
MapPutPreAllocate/String/262144-16       2.00 ± 0%    129.00 ± 0%    +6350.00%  (p=0.000 n=10+10)
MapPutPreAllocate/String/524288-16       2.00 ± 0%    257.00 ± 0%   +12750.00%  (p=0.000 n=10+10)
MapPutPreAllocate/String/1048576-16      2.00 ± 0%    513.00 ± 0%   +25550.00%  (p=0.000 n=10+10)
MapPutPreAllocate/String/2097152-16      2.00 ± 0%   1025.00 ± 0%   +51150.00%  (p=0.000 n=10+10)
MapPutPreAllocate/String/4194304-16      2.00 ± 0%   2049.00 ± 0%  +102350.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/6-16                   0.00           0.00              ~     (all equal)
MapPutReuse/Int64/12-16                  0.00           0.00              ~     (all equal)
MapPutReuse/Int64/18-16                  0.00           0.00              ~     (all equal)
MapPutReuse/Int64/24-16                  1.00 ± 0%      0.00          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/30-16                  0.00           0.00              ~     (all equal)
MapPutReuse/Int64/64-16                  0.00           0.00              ~     (all equal)
MapPutReuse/Int64/128-16                 1.00 ± 0%      0.00          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/256-16                 2.00 ± 0%      0.00          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/512-16                 3.00 ± 0%      0.00          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/1024-16                4.00 ± 0%      0.00          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/2048-16                5.00 ± 0%      0.00          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/4096-16                6.00 ± 0%      0.00          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/8192-16                7.00 ± 0%      0.00          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/32768-16               9.00 ± 0%      0.00          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/65536-16               11.0 ± 0%       0.0          -100.00%  (p=0.000 n=9+10)
MapPutReuse/Int64/131072-16              12.0 ± 0%       0.0          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/262144-16              13.0 ± 0%       0.0          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/524288-16              15.0 ± 0%       0.0          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/1048576-16             17.0 ± 0%       0.0          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/2097152-16             19.0 ± 0%       0.0          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int64/4194304-16             22.0 ± 0%       0.0          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/6-16                   0.00           0.00              ~     (all equal)
MapPutReuse/Int32/12-16                  0.00           0.00              ~     (all equal)
MapPutReuse/Int32/18-16                  0.00           0.00              ~     (all equal)
MapPutReuse/Int32/24-16                  1.00 ± 0%      0.00          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/30-16                  0.00           0.00              ~     (all equal)
MapPutReuse/Int32/64-16                  0.00           0.00              ~     (all equal)
MapPutReuse/Int32/128-16                 1.00 ± 0%      0.00          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/256-16                 2.00 ± 0%      0.00          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/512-16                 3.00 ± 0%      0.00          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/1024-16                4.00 ± 0%      0.00          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/2048-16                5.00 ± 0%      0.00          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/4096-16                6.00 ± 0%      0.00          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/8192-16                7.00 ± 0%      0.00          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/32768-16               9.00 ± 0%      0.00          -100.00%  (p=0.000 n=9+10)
MapPutReuse/Int32/65536-16               11.0 ± 0%       0.0          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/131072-16              12.0 ± 0%       0.0          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/262144-16              13.0 ± 0%       0.0          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/524288-16              15.0 ± 0%       0.0          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/1048576-16             17.0 ± 0%       0.0          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/2097152-16             19.0 ± 0%       0.0          -100.00%  (p=0.000 n=10+10)
MapPutReuse/Int32/4194304-16             22.0 ± 0%       0.0          -100.00%  (p=0.000 n=10+10)
MapPutReuse/String/6-16                  0.00           0.00              ~     (all equal)
MapPutReuse/String/12-16                 0.00           0.00              ~     (all equal)
MapPutReuse/String/18-16                 0.00           0.00              ~     (all equal)
MapPutReuse/String/24-16                 0.00           0.00              ~     (all equal)
MapPutReuse/String/30-16                 0.00           0.00              ~     (all equal)
MapPutReuse/String/64-16                 0.00           0.00              ~     (all equal)
MapPutReuse/String/128-16                0.00           0.00              ~     (all equal)
MapPutReuse/String/256-16                0.00           0.00              ~     (all equal)
MapPutReuse/String/512-16                0.00           0.00              ~     (all equal)
MapPutReuse/String/1024-16               0.00           0.00              ~     (all equal)
MapPutReuse/String/2048-16               0.00           0.00              ~     (all equal)
MapPutReuse/String/4096-16               0.00           0.00              ~     (all equal)
MapPutReuse/String/8192-16               0.00           0.00              ~     (all equal)
MapPutReuse/String/32768-16              0.00           0.00              ~     (all equal)
MapPutReuse/String/65536-16              0.00           0.00              ~     (all equal)
MapPutReuse/String/131072-16             0.00           0.00              ~     (all equal)
MapPutReuse/String/262144-16             0.00           0.00              ~     (all equal)
MapPutReuse/String/524288-16             0.00           0.00              ~     (all equal)
MapPutReuse/String/1048576-16            0.00           0.00              ~     (all equal)
MapPutReuse/String/2097152-16            0.00           0.00              ~     (all equal)
MapPutReuse/String/4194304-16            0.00           0.00              ~     (all equal)
MapPutDelete/Int64/6-16                  0.00           0.00              ~     (all equal)
MapPutDelete/Int64/12-16                 0.00           0.00              ~     (all equal)
MapPutDelete/Int64/18-16                 0.00           0.00              ~     (all equal)
MapPutDelete/Int64/24-16                 0.00           0.00              ~     (all equal)
MapPutDelete/Int64/30-16                 0.00           0.00              ~     (all equal)
MapPutDelete/Int64/64-16                 0.00           0.00              ~     (all equal)
MapPutDelete/Int64/128-16                0.00           0.00              ~     (all equal)
MapPutDelete/Int64/256-16                0.00           0.00              ~     (all equal)
MapPutDelete/Int64/512-16                0.00           0.00              ~     (all equal)
MapPutDelete/Int64/1024-16               0.00           0.00              ~     (all equal)
MapPutDelete/Int64/2048-16               0.00           0.00              ~     (all equal)
MapPutDelete/Int64/4096-16               0.00           0.00              ~     (all equal)
MapPutDelete/Int64/8192-16               0.00           0.00              ~     (all equal)
MapPutDelete/Int64/32768-16              0.00           0.00              ~     (all equal)
MapPutDelete/Int64/65536-16              0.00           0.00              ~     (all equal)
MapPutDelete/Int64/131072-16             0.00           0.00              ~     (all equal)
MapPutDelete/Int64/262144-16             0.00           0.00              ~     (all equal)
MapPutDelete/Int64/524288-16             0.00           0.00              ~     (all equal)
MapPutDelete/Int64/1048576-16            0.00           0.00              ~     (all equal)
MapPutDelete/Int64/2097152-16            0.00           0.00              ~     (all equal)
MapPutDelete/Int64/4194304-16            0.00           0.00              ~     (all equal)
MapPutDelete/Int32/6-16                  0.00           0.00              ~     (all equal)
MapPutDelete/Int32/12-16                 0.00           0.00              ~     (all equal)
MapPutDelete/Int32/18-16                 0.00           0.00              ~     (all equal)
MapPutDelete/Int32/24-16                 0.00           0.00              ~     (all equal)
MapPutDelete/Int32/30-16                 0.00           0.00              ~     (all equal)
MapPutDelete/Int32/64-16                 0.00           0.00              ~     (all equal)
MapPutDelete/Int32/128-16                0.00           0.00              ~     (all equal)
MapPutDelete/Int32/256-16                0.00           0.00              ~     (all equal)
MapPutDelete/Int32/512-16                0.00           0.00              ~     (all equal)
MapPutDelete/Int32/1024-16               0.00           0.00              ~     (all equal)
MapPutDelete/Int32/2048-16               0.00           0.00              ~     (all equal)
MapPutDelete/Int32/4096-16               0.00           0.00              ~     (all equal)
MapPutDelete/Int32/8192-16               0.00           0.00              ~     (all equal)
MapPutDelete/Int32/32768-16              0.00           0.00              ~     (all equal)
MapPutDelete/Int32/65536-16              0.00           0.00              ~     (all equal)
MapPutDelete/Int32/131072-16             0.00           0.00              ~     (all equal)
MapPutDelete/Int32/262144-16             0.00           0.00              ~     (all equal)
MapPutDelete/Int32/524288-16             0.00           0.00              ~     (all equal)
MapPutDelete/Int32/1048576-16            0.00           0.00              ~     (all equal)
MapPutDelete/Int32/2097152-16            0.00           0.00              ~     (all equal)
MapPutDelete/Int32/4194304-16            0.00           0.00              ~     (all equal)
MapPutDelete/String/6-16                 0.00           0.00              ~     (all equal)
MapPutDelete/String/12-16                0.00           0.00              ~     (all equal)
MapPutDelete/String/18-16                0.00           0.00              ~     (all equal)
MapPutDelete/String/24-16                0.00           0.00              ~     (all equal)
MapPutDelete/String/30-16                0.00           0.00              ~     (all equal)
MapPutDelete/String/64-16                0.00           0.00              ~     (all equal)
MapPutDelete/String/128-16               0.00           0.00              ~     (all equal)
MapPutDelete/String/256-16               0.00           0.00              ~     (all equal)
MapPutDelete/String/512-16               0.00           0.00              ~     (all equal)
MapPutDelete/String/1024-16              0.00           0.00              ~     (all equal)
MapPutDelete/String/2048-16              0.00           0.00              ~     (all equal)
MapPutDelete/String/4096-16              0.00           0.00              ~     (all equal)
MapPutDelete/String/8192-16              0.00           0.00              ~     (all equal)
MapPutDelete/String/32768-16             0.00           0.00              ~     (all equal)
MapPutDelete/String/65536-16             0.00           0.00              ~     (all equal)
MapPutDelete/String/131072-16            0.00           0.00              ~     (all equal)
MapPutDelete/String/262144-16            0.00           0.00              ~     (all equal)
MapPutDelete/String/524288-16            0.00           0.00              ~     (all equal)
MapPutDelete/String/1048576-16           0.00           0.00              ~     (all equal)
MapPutDelete/String/2097152-16           0.00           0.00              ~     (all equal)
MapPutDelete/String/4194304-16           0.00           0.00              ~     (all equal)
```
</details>

On top of the base Swiss Tables design, `swiss.Map` adds an [extendible
hashing](https://en.wikipedia.org/wiki/Extendible_hashing) layer in order to
enable incremental resizing of large maps which significantly reduces tail
latency for `Put` operations in maps with hundreds of thousands of entries or
more.

`swiss.Map` provides pseudo-randomized iteration (iteration order will change
from one iteration to the next) and iteration stability akin to Go's builtin
map if the map is mutated during iteration.

## Caveats

- Go's builtin map has a fast-path for comparing strings that [share their
  underlying
  storage](https://github.com/golang/go/blob/4a7f3ac8eb4381ea62caa1741eeeec28363245b4/src/runtime/map_faststr.go#L100).
  This fast-path is feasible because `map[string]T` is specialized for string
  keys which isn't currently possible with Go's generics.
- Go's builtin map has a fast-path for maps with int32, int64, and string keys
  that fit in a single bucket (8 entries) which avoids performing `hash(key)`
  and simply linearly searches through the bucket. Similar to the above, this
  fast-path is feasible because the runtime can specialize the implementation
  on the key type.

## TODO

- Add support for SIMD searching on x86 and [8-byte Neon SIMD searching on
  arm64](https://github.com/abseil/abseil-cpp/commit/6481443560a92d0a3a55a31807de0cd712cd4f88)
  - This appears to be somewhat difficult. Naively implementing the match
    routines in assembly isn't workable as the function call overhead
    dominates the performance improvement from the SIMD comparisons. The
    Abseil implementation is leveraring gcc/llvm assembly intrinsics which are
    not currently available in Go. In order to take advantage of SIMD we'll
    have to write most/all of the probing loop in assembly.
