#!/usr/bin/env python3
# Refresh shared modules so that PluginDownloader downloads don't break.

CONFIG = {'accountsdb.py': ('LastFM/local', 'NuWeather/local')}

import os
import time

for filename, paths in CONFIG.items():
    with open(filename) as f:
        data = f.read()
    for path in paths:
        target = os.path.join(path, filename)
        if os.path.exists(target):
            print("Deleting existing %s" % target)
            os.remove(target)
        print("Writing %s => %s" % (filename, target))
        with open(target, 'w') as wf:
            wf.write('# Autogenerated by update-modules.py on %s - DO NOT EDIT THIS COPY DIRECTLY!\n' % time.ctime())
            wf.write(data)
