/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.datagrid.color.ColorLayer;
import com.intellij.database.datagrid.color.MutationsColorLayer;
import com.intellij.database.run.ui.CellViewer;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.EditMaximizedViewRequestPlace;
import com.intellij.database.run.ui.UpdateEvent;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.database.run.ui.treetable.TreeTableResultView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.observable.util.ListenerUiUtil;
import com.intellij.openapi.observable.util.RevertOnDisposeUtilKt;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.profile.codeInspection.ui.InspectionUiUtilKt;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.hover.HoverListener;
import com.intellij.ui.hover.HoverStateListener;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 02\u00020\u00012\u00020\u0002:\u0007*+,-./0B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\"\u001a\u00020\u00072\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\b\u0010%\u001a\u00020\u0007H\u0016J\u0006\u0010&\u001a\u00020\u000bJ\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR/\u0010\u0011\u001a#\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00150\u00150\u0012\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00060\u0018R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0019\u001a\u00060\u0018R\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001f\u00a8\u00061"}, d2={"Lcom/intellij/database/run/ui/RecordView;", "Lcom/intellij/database/run/ui/CellViewer;", "Lcom/intellij/openapi/Disposable;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "openValueEditorTab", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;Lkotlin/jvm/functions/Function0;)V", "isTwoColumnsLayout", "", "()Z", "setTwoColumnsLayout", "(Z)V", "isValidPanel", "setValidPanel", "dataModel", "Lcom/intellij/database/datagrid/GridModel;", "Lcom/intellij/database/datagrid/GridRow;", "kotlin.jvm.PlatformType", "Lcom/intellij/database/datagrid/GridColumn;", "Lorg/jetbrains/annotations/NotNull;", "panelData", "Lcom/intellij/database/run/ui/RecordView$PanelController;", "panelDataView", "getPanelDataView", "()Lcom/intellij/database/run/ui/RecordView$PanelController;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "preferedFocusComponent", "getPreferedFocusComponent", "update", "event", "Lcom/intellij/database/run/ui/UpdateEvent;", "dispose", "validateIfNeeded", "collectColumnInfos", "", "Lcom/intellij/database/run/ui/RecordView$ColumnInfo;", "ColumnInfo", "PanelComponents", "TwoColumnPanel", "SingleColumnPanel", "MyTextField", "PanelController", "Companion", "intellij.grid.impl"})
@SourceDebugExtension(value={"SMAP\nRecordView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecordView.kt\ncom/intellij/database/run/ui/RecordView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,416:1\n1611#2,9:417\n1863#2:426\n1864#2:428\n1620#2:429\n1#3:427\n*S KotlinDebug\n*F\n+ 1 RecordView.kt\ncom/intellij/database/run/ui/RecordView\n*L\n89#1:417,9\n89#1:426\n89#1:428\n89#1:429\n89#1:427\n*E\n"})
public final class RecordView
implements CellViewer,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataGrid grid;
    @NotNull
    private final Function0<Unit> openValueEditorTab;
    private volatile boolean isTwoColumnsLayout;
    private volatile boolean isValidPanel;
    @NotNull
    private final GridModel<GridRow, GridColumn> dataModel;
    @NotNull
    private PanelController panelData;

    public RecordView(@NotNull DataGrid grid, @NotNull Function0<Unit> openValueEditorTab) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter(openValueEditorTab, (String)"openValueEditorTab");
        this.grid = grid;
        this.openValueEditorTab = openValueEditorTab;
        this.isValidPanel = true;
        GridModel gridModel = this.grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
        this.dataModel = gridModel;
        this.panelData = new PanelController(this.collectColumnInfos(), this.isTwoColumnsLayout);
    }

    public final boolean isTwoColumnsLayout() {
        return this.isTwoColumnsLayout;
    }

    public final void setTwoColumnsLayout(boolean bl) {
        this.isTwoColumnsLayout = bl;
    }

    public final boolean isValidPanel() {
        return this.isValidPanel;
    }

    public final void setValidPanel(boolean bl) {
        this.isValidPanel = bl;
    }

    @NotNull
    public final PanelController getPanelDataView() {
        return this.panelData;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.panelData.getPanel();
    }

    @Override
    @NotNull
    public JComponent getPreferedFocusComponent() {
        return this.panelData.getPanel();
    }

    @Override
    public void update(@Nullable UpdateEvent event) {
        if (Intrinsics.areEqual((Object)event, (Object)UpdateEvent.SettingsChanged.INSTANCE)) {
            this.panelData = new PanelController(this.collectColumnInfos(), this.isTwoColumnsLayout);
            this.isValidPanel = false;
            return;
        }
        if (!this.panelData.onSelectionUpdated()) {
            this.panelData = new PanelController(this.collectColumnInfos(), this.isTwoColumnsLayout);
            this.isValidPanel = false;
            return;
        }
        if (event == null || Intrinsics.areEqual((Object)event, (Object)UpdateEvent.SelectionChanged.INSTANCE)) {
            return;
        }
        if (Intrinsics.areEqual((Object)event, (Object)UpdateEvent.ContentChanged.INSTANCE)) {
            this.panelData.updateTextFields();
            return;
        }
    }

    public void dispose() {
    }

    public final boolean validateIfNeeded() {
        if (this.isValidPanel) {
            return true;
        }
        this.isValidPanel = true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ColumnInfo> collectColumnInfos() {
        void $this$mapNotNullTo$iv$iv;
        JBIterable jBIterable = this.grid.getVisibleColumns().asIterable();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"asIterable(...)");
        Iterable $this$mapNotNull$iv = (Iterable)jBIterable;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ColumnInfo columnInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ModelIndex columnIdx = (ModelIndex)element$iv$iv;
            boolean bl2 = false;
            if ((GridColumn)this.dataModel.getColumn(columnIdx) == null) {
                columnInfo = null;
            } else {
                GridColumn column;
                Intrinsics.checkNotNull((Object)columnIdx);
                String string = column.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                columnInfo = new ColumnInfo((ModelIndex<GridColumn>)columnIdx, string, column);
            }
            if (columnInfo == null) continue;
            ColumnInfo it$iv$iv = columnInfo;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    private static final boolean isCellEditable(DataGrid grid, ModelIndex<GridRow> rowIdx, ModelIndex<GridColumn> columnIdx) {
        return RecordView.Companion.isCellEditable(grid, (ModelIndex<GridRow>)rowIdx, (ModelIndex<GridColumn>)columnIdx);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0004H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/run/ui/RecordView$ColumnInfo;", "", "idx", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/GridColumn;", "name", "", "column", "<init>", "(Lcom/intellij/database/datagrid/ModelIndex;Ljava/lang/String;Lcom/intellij/database/datagrid/GridColumn;)V", "getIdx", "()Lcom/intellij/database/datagrid/ModelIndex;", "getName", "()Ljava/lang/String;", "getColumn", "()Lcom/intellij/database/datagrid/GridColumn;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.grid.impl"})
    public static final class ColumnInfo {
        @NotNull
        private final ModelIndex<GridColumn> idx;
        @NotNull
        private final String name;
        @NotNull
        private final GridColumn column;

        public ColumnInfo(@NotNull ModelIndex<GridColumn> idx, @NlsSafe @NotNull String name, @NotNull GridColumn column) {
            Intrinsics.checkNotNullParameter(idx, (String)"idx");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            this.idx = idx;
            this.name = name;
            this.column = column;
        }

        @NotNull
        public final ModelIndex<GridColumn> getIdx() {
            return this.idx;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final GridColumn getColumn() {
            return this.column;
        }

        @NotNull
        public final ModelIndex<GridColumn> component1() {
            return this.idx;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final GridColumn component3() {
            return this.column;
        }

        @NotNull
        public final ColumnInfo copy(@NotNull ModelIndex<GridColumn> idx, @NlsSafe @NotNull String name, @NotNull GridColumn column) {
            Intrinsics.checkNotNullParameter(idx, (String)"idx");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            return new ColumnInfo(idx, name, column);
        }

        public static /* synthetic */ ColumnInfo copy$default(ColumnInfo columnInfo, ModelIndex modelIndex, String string, GridColumn gridColumn, int n, Object object) {
            if ((n & 1) != 0) {
                modelIndex = columnInfo.idx;
            }
            if ((n & 2) != 0) {
                string = columnInfo.name;
            }
            if ((n & 4) != 0) {
                gridColumn = columnInfo.column;
            }
            return columnInfo.copy(modelIndex, string, gridColumn);
        }

        @NotNull
        public String toString() {
            return "ColumnInfo(idx=" + this.idx + ", name=" + this.name + ", column=" + this.column + ")";
        }

        public int hashCode() {
            int result = this.idx.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.column.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ColumnInfo)) {
                return false;
            }
            ColumnInfo columnInfo = (ColumnInfo)other;
            if (!Intrinsics.areEqual(this.idx, columnInfo.idx)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)columnInfo.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.column, (Object)columnInfo.column);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u0003\u00a8\u0006\r"}, d2={"Lcom/intellij/database/run/ui/RecordView$Companion;", "", "<init>", "()V", "isCellEditable", "", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "rowIdx", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/GridRow;", "columnIdx", "Lcom/intellij/database/datagrid/GridColumn;", "intellij.grid.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final boolean isCellEditable(DataGrid grid, ModelIndex<GridRow> rowIdx, ModelIndex<GridColumn> columnIdx) {
            if (!grid.isEditable()) {
                return false;
            }
            Object object = GridCellEditorFactoryProvider.get(grid);
            if (object == null || (object = object.getEditorFactory(grid, rowIdx, columnIdx)) == null) {
                return false;
            }
            Object factory = object;
            Object value = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(rowIdx, columnIdx);
            return factory.getIsEditableChecker().isEditable(value, grid, columnIdx);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0017\u001a\u00020\u0004J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/run/ui/RecordView$MyTextField;", "Lcom/intellij/ui/components/fields/ExtendableTextField;", "openValueEditorTab", "Lkotlin/Function0;", "", "columns", "", "<init>", "(Lkotlin/jvm/functions/Function0;I)V", "originalBackground", "Ljava/awt/Color;", "kotlin.jvm.PlatformType", "getOriginalBackground", "()Ljava/awt/Color;", "Ljava/awt/Color;", "isSelected", "", "()Z", "setSelected", "(Z)V", "hovered", "extension", "Lcom/intellij/ui/components/fields/ExtendableTextComponent$Extension;", "updateExtension", "hasFocus", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "intellij.grid.impl"})
    public static final class MyTextField
    extends ExtendableTextField {
        @NotNull
        private final Function0<Unit> openValueEditorTab;
        private final Color originalBackground;
        private boolean isSelected;
        private boolean hovered;
        @NotNull
        private final ExtendableTextComponent.Extension extension;

        public MyTextField(@NotNull Function0<Unit> openValueEditorTab, int columns) {
            Intrinsics.checkNotNullParameter(openValueEditorTab, (String)"openValueEditorTab");
            super(columns);
            this.openValueEditorTab = openValueEditorTab;
            this.originalBackground = this.getBackground();
            ExtendableTextComponent.Extension extension = ExtendableTextComponent.Extension.create((Icon)AllIcons.General.ExpandComponent, (Icon)AllIcons.General.ExpandComponentHover, (String)DataGridBundle.message((String)"EditMaximized.Record.to.value.editor.control", (Object[])new Object[0]), () -> MyTextField.extension$lambda$0(this));
            Intrinsics.checkNotNullExpressionValue((Object)extension, (String)"create(...)");
            this.extension = extension;
            RevertOnDisposeUtilKt.addMouseHoverListener((JComponent)((JComponent)((Object)this)), null, (HoverListener)((HoverListener)new HoverStateListener(){

                protected void hoverChanged(Component component, boolean hovered) {
                    Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                    hovered = hovered;
                    this.updateExtension();
                }
            }));
        }

        public final Color getOriginalBackground() {
            return this.originalBackground;
        }

        public final boolean isSelected() {
            return this.isSelected;
        }

        public final void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        public final void updateExtension() {
            boolean shouldShow;
            boolean bl = shouldShow = this.isSelected || this.hovered;
            if (shouldShow) {
                this.addExtension(this.extension);
            } else {
                this.removeExtension(this.extension);
            }
            this.repaint();
        }

        public boolean hasFocus() {
            return this.isSelected;
        }

        @NotNull
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @NotNull
        public Dimension getPreferredSize() {
            return new Dimension(JBUIScale.scale((int)100), super.getMinimumSize().height);
        }

        private static final void extension$lambda$0(MyTextField this$0) {
            this$0.openValueEditorTab.invoke();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/run/ui/RecordView$PanelComponents;", "", "valueField", "Lcom/intellij/ui/components/fields/ExtendableTextField;", "name", "Ljavax/swing/JLabel;", "<init>", "(Lcom/intellij/ui/components/fields/ExtendableTextField;Ljavax/swing/JLabel;)V", "getValueField", "()Lcom/intellij/ui/components/fields/ExtendableTextField;", "getName", "()Ljavax/swing/JLabel;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.grid.impl"})
    public static final class PanelComponents {
        @NotNull
        private final ExtendableTextField valueField;
        @NotNull
        private final JLabel name;

        public PanelComponents(@NotNull ExtendableTextField valueField, @NotNull JLabel name) {
            Intrinsics.checkNotNullParameter((Object)valueField, (String)"valueField");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.valueField = valueField;
            this.name = name;
        }

        @NotNull
        public final ExtendableTextField getValueField() {
            return this.valueField;
        }

        @NotNull
        public final JLabel getName() {
            return this.name;
        }

        @NotNull
        public final ExtendableTextField component1() {
            return this.valueField;
        }

        @NotNull
        public final JLabel component2() {
            return this.name;
        }

        @NotNull
        public final PanelComponents copy(@NotNull ExtendableTextField valueField, @NotNull JLabel name) {
            Intrinsics.checkNotNullParameter((Object)valueField, (String)"valueField");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new PanelComponents(valueField, name);
        }

        public static /* synthetic */ PanelComponents copy$default(PanelComponents panelComponents, ExtendableTextField extendableTextField, JLabel jLabel, int n, Object object) {
            if ((n & 1) != 0) {
                extendableTextField = panelComponents.valueField;
            }
            if ((n & 2) != 0) {
                jLabel = panelComponents.name;
            }
            return panelComponents.copy(extendableTextField, jLabel);
        }

        @NotNull
        public String toString() {
            return "PanelComponents(valueField=" + this.valueField + ", name=" + this.name + ")";
        }

        public int hashCode() {
            int result = this.valueField.hashCode();
            result = result * 31 + this.name.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PanelComponents)) {
                return false;
            }
            PanelComponents panelComponents = (PanelComponents)other;
            if (!Intrinsics.areEqual((Object)this.valueField, (Object)panelComponents.valueField)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)panelComponents.name);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\b\u0086\u0004\u0018\u00002\u00020\u0001:\u0001)B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010 J\u001b\u0010!\u001a\u0004\u0018\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010 J\u001b\u0010\"\u001a\u0004\u0018\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010 J\u0014\u0010#\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u001b\u0010$\u001a\u0004\u0018\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010 J\u001b\u0010%\u001a\u0004\u0018\u00010\u00062\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010&J\u0006\u0010'\u001a\u00020\u0006J\u0006\u0010(\u001a\u00020\u001eR#\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0016\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0012\n0\u0017R\u00060\u0000R\u00020\u00180\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/database/run/ui/RecordView$PanelController;", "", "columnInfos", "", "Lcom/intellij/database/run/ui/RecordView$ColumnInfo;", "isTwoColumnLayout", "", "<init>", "(Lcom/intellij/database/run/ui/RecordView;Ljava/util/List;Z)V", "textFields", "", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/GridColumn;", "Lcom/intellij/database/run/ui/RecordView$MyTextField;", "getTextFields", "()Ljava/util/Map;", "panel", "Ljavax/swing/JComponent;", "getPanel", "()Ljavax/swing/JComponent;", "colorLayer", "Lcom/intellij/database/datagrid/color/ColorLayer;", "textConvertors", "Lcom/intellij/database/run/ui/RecordView$PanelController$Convertor;", "Lcom/intellij/database/run/ui/RecordView;", "rowIdx", "Lcom/intellij/database/datagrid/GridRow;", "selectedColumnIdx", "isValidRow", "updateColor", "", "columnIdx", "(Lcom/intellij/database/datagrid/ModelIndex;)Lkotlin/Unit;", "updateText", "updateSelection", "updateConvertor", "setTextInGrid", "setSelectionInGrid", "(Lcom/intellij/database/datagrid/ModelIndex;)Ljava/lang/Boolean;", "onSelectionUpdated", "updateTextFields", "Convertor", "intellij.grid.impl"})
    @SourceDebugExtension(value={"SMAP\nRecordView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecordView.kt\ncom/intellij/database/run/ui/RecordView$PanelController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,416:1\n1863#2,2:417\n1863#2,2:419\n*S KotlinDebug\n*F\n+ 1 RecordView.kt\ncom/intellij/database/run/ui/RecordView$PanelController\n*L\n251#1:417,2\n387#1:419,2\n*E\n"})
    public final class PanelController {
        @NotNull
        private final Map<ModelIndex<GridColumn>, MyTextField> textFields;
        @NotNull
        private final JComponent panel;
        @NotNull
        private final ColorLayer colorLayer;
        @NotNull
        private final Map<ModelIndex<GridColumn>, Convertor> textConvertors;
        @NotNull
        private ModelIndex<GridRow> rowIdx;
        @NotNull
        private ModelIndex<GridColumn> selectedColumnIdx;
        private boolean isValidRow;

        /*
         * WARNING - void declaration
         */
        public PanelController(List<ColumnInfo> columnInfos, boolean isTwoColumnLayout) {
            Intrinsics.checkNotNullParameter(columnInfos, (String)"columnInfos");
            this.textFields = new LinkedHashMap();
            this.colorLayer = new MutationsColorLayer(GridUtil.getDatabaseMutator(RecordView.this.grid));
            this.textConvertors = new LinkedHashMap();
            ModelIndex modelIndex = ModelIndex.forRow((CoreGrid)RecordView.this.grid, (int)-1);
            Intrinsics.checkNotNullExpressionValue((Object)modelIndex, (String)"forRow(...)");
            this.rowIdx = modelIndex;
            ModelIndex modelIndex2 = ModelIndex.forColumn((CoreGrid)RecordView.this.grid, (int)-1);
            Intrinsics.checkNotNullExpressionValue((Object)modelIndex2, (String)"forColumn(...)");
            this.selectedColumnIdx = modelIndex2;
            this.rowIdx = RecordView.this.grid.getSelectionModel().getSelectedRow();
            this.isValidRow = this.rowIdx.isValid((CoreGrid)RecordView.this.grid);
            this.selectedColumnIdx = RecordView.this.grid.getSelectionModel().getSelectedColumn();
            if (!this.isValidRow) {
                this.panel = (JComponent)new JBPanelWithEmptyText();
            } else {
                void $this$_init__u24lambda_u244;
                Iterator<Map.Entry<ModelIndex<GridColumn>, MyTextField>> $this$forEach$iv;
                List componentGroups = new ArrayList();
                Iterable iterable = columnInfos;
                RecordView recordView = RecordView.this;
                boolean $i$f$forEach22 = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    JLabel jLabel;
                    MyTextField myTextField;
                    GridHelper helper;
                    Object element$iv = iterator.next();
                    ColumnInfo columnInfo = (ColumnInfo)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)GridHelper.get(recordView.grid), (String)"get(...)");
                    Icon icon = helper.getColumnIcon((CoreGrid<GridRow, GridColumn>)((CoreGrid)recordView.grid), columnInfo.getColumn(), true);
                    String tooltip = helper.getColumnTooltipHtml((CoreGrid<GridRow, GridColumn>)((CoreGrid)recordView.grid), columnInfo.getIdx());
                    MyTextField $this$lambda_u243_u24lambda_u241 = myTextField = new MyTextField((Function0<Unit>)recordView.openValueEditorTab, 18);
                    boolean bl2 = false;
                    ListenerUiUtil.whenTextChangedFromUi$default((JTextComponent)((JTextComponent)((Object)$this$lambda_u243_u24lambda_u241)), null, arg_0 -> PanelController.lambda$3$lambda$1$lambda$0(this, columnInfo, arg_0), (int)1, null);
                    $this$lambda_u243_u24lambda_u241.addKeyListener(new KeyAdapter(recordView, $this$lambda_u243_u24lambda_u241){
                        final /* synthetic */ RecordView this$0;
                        final /* synthetic */ MyTextField $this_apply;
                        {
                            this.this$0 = $receiver;
                            this.$this_apply = $receiver2;
                        }

                        public void keyPressed(KeyEvent e) {
                            KeyEvent keyEvent = e;
                            boolean bl = keyEvent != null ? keyEvent.getKeyCode() == 27 : false;
                            if (bl) {
                                RecordView.access$getGrid$p(this.this$0).getResultView().getPreferredFocusedComponent().requestFocusInWindow();
                                e.consume();
                            }
                            KeyEvent keyEvent2 = e;
                            boolean bl2 = keyEvent2 != null ? keyEvent2.getKeyCode() == 10 : false;
                            if (bl2) {
                                this.$this_apply.transferFocus();
                                e.consume();
                            }
                        }
                    });
                    $this$lambda_u243_u24lambda_u241.addFocusListener(new FocusAdapter(this, columnInfo){
                        final /* synthetic */ PanelController this$0;
                        final /* synthetic */ ColumnInfo $columnInfo;
                        {
                            this.this$0 = $receiver;
                            this.$columnInfo = $columnInfo;
                        }

                        public void focusGained(FocusEvent e) {
                            if (Intrinsics.areEqual((Object)PanelController.access$getSelectedColumnIdx$p(this.this$0), this.$columnInfo.getIdx())) {
                                return;
                            }
                            this.this$0.setSelectionInGrid(this.$columnInfo.getIdx());
                        }
                    });
                    $this$lambda_u243_u24lambda_u241.setEditable(Companion.isCellEditable(recordView.grid, (ModelIndex<GridRow>)this.rowIdx, (ModelIndex<GridColumn>)columnInfo.getIdx()));
                    if (!$this$lambda_u243_u24lambda_u241.isEditable()) {
                        $this$lambda_u243_u24lambda_u241.setToolTipText(EditorBundle.message((String)"editing.viewer.hint", (Object[])new Object[0]));
                    }
                    MyTextField field2 = myTextField;
                    JLabel $this$lambda_u243_u24lambda_u242 = jLabel = new JLabel(columnInfo.getName());
                    boolean bl3 = false;
                    $this$lambda_u243_u24lambda_u242.setIcon(icon);
                    $this$lambda_u243_u24lambda_u242.setToolTipText(tooltip);
                    JLabel label = jLabel;
                    this.textFields.put(columnInfo.getIdx(), field2);
                    componentGroups.add(new PanelComponents(field2, label));
                }
                for (Map.Entry<ModelIndex<GridColumn>, MyTextField> kv : this.textFields.entrySet()) {
                    this.updateConvertor(kv.getKey());
                    this.updateText(kv.getKey());
                    this.updateColor(kv.getKey());
                    this.updateSelection(kv.getKey());
                }
                JBPanel innerPanel = isTwoColumnLayout ? (JBPanel)new TwoColumnPanel(componentGroups) : (JBPanel)new SingleColumnPanel(componentGroups);
                RecordView $i$f$forEach22 = recordView = innerPanel;
                PanelController panelController = this;
                boolean bl = false;
                $this$_init__u24lambda_u244.setFocusCycleRoot(true);
                $this$_init__u24lambda_u244.setFocusTraversalPolicyProvider(true);
                $this$_init__u24lambda_u244.setFocusTraversalPolicy((FocusTraversalPolicy)new LayoutFocusTraversalPolicy(this){
                    final /* synthetic */ PanelController this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public Component getDefaultComponent(Container aContainer) {
                        Component component;
                        MyTextField myTextField = this.this$0.getTextFields().get(PanelController.access$getSelectedColumnIdx$p(this.this$0));
                        if (myTextField != null) {
                            component = (Component)((Object)myTextField);
                        } else {
                            Component component2 = super.getDefaultComponent(aContainer);
                            component = component2;
                            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"getDefaultComponent(...)");
                        }
                        return component;
                    }
                });
                panelController.panel = InspectionUiUtilKt.addScrollPaneIfNecessary((JComponent)((JComponent)((Object)recordView)));
            }
        }

        @NotNull
        public final Map<ModelIndex<GridColumn>, MyTextField> getTextFields() {
            return this.textFields;
        }

        @NotNull
        public final JComponent getPanel() {
            return this.panel;
        }

        @Nullable
        public final Unit updateColor(@NotNull ModelIndex<GridColumn> columnIdx) {
            Unit unit;
            Intrinsics.checkNotNullParameter(columnIdx, (String)"columnIdx");
            MyTextField myTextField = this.textFields.get(columnIdx);
            if (myTextField != null) {
                MyTextField myTextField2 = myTextField;
                RecordView recordView = RecordView.this;
                MyTextField textField = myTextField2;
                boolean bl = false;
                Color color = this.colorLayer.getCellBackground(this.rowIdx, columnIdx, recordView.grid, null);
                if (color == null) {
                    color = textField.getOriginalBackground();
                }
                textField.setBackground(color);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return unit;
        }

        @Nullable
        public final Unit updateText(@NotNull ModelIndex<GridColumn> columnIdx) {
            Unit unit;
            Intrinsics.checkNotNullParameter(columnIdx, (String)"columnIdx");
            MyTextField myTextField = this.textFields.get(columnIdx);
            if (myTextField != null) {
                MyTextField myTextField2 = myTextField;
                RecordView recordView = RecordView.this;
                MyTextField textField = myTextField2;
                boolean bl = false;
                Convertor convertor = this.textConvertors.get(columnIdx);
                String string = convertor != null ? convertor.toText(recordView.dataModel.getValueAt(this.rowIdx, columnIdx)) : null;
                Intrinsics.checkNotNull(string);
                textField.setText(string);
                textField.setCaretPosition(0);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return unit;
        }

        @Nullable
        public final Unit updateSelection(@NotNull ModelIndex<GridColumn> columnIdx) {
            Unit unit;
            Intrinsics.checkNotNullParameter(columnIdx, (String)"columnIdx");
            MyTextField myTextField = this.textFields.get(columnIdx);
            if (myTextField != null) {
                MyTextField textField = myTextField;
                boolean bl = false;
                boolean isCurrentSelected = Intrinsics.areEqual(columnIdx, this.selectedColumnIdx);
                textField.setSelected(isCurrentSelected);
                textField.updateExtension();
                if (isCurrentSelected) {
                    JComponent jComponent = (JComponent)textField.getParent();
                    if (jComponent != null) {
                        jComponent.scrollRectToVisible(textField.getBounds());
                    }
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return unit;
        }

        public final void updateConvertor(@NotNull ModelIndex<GridColumn> columnIdx) {
            Intrinsics.checkNotNullParameter(columnIdx, (String)"columnIdx");
            Convertor currentConvertor = this.textConvertors.get(columnIdx);
            if (currentConvertor == null || !Intrinsics.areEqual(currentConvertor.getRowIdx(), this.rowIdx) || !Intrinsics.areEqual(currentConvertor.getColumnIdx(), columnIdx)) {
                this.textConvertors.put(columnIdx, new Convertor(this.rowIdx, columnIdx));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Unit setTextInGrid(@NotNull ModelIndex<GridColumn> columnIdx) {
            Unit unit;
            Intrinsics.checkNotNullParameter(columnIdx, (String)"columnIdx");
            MyTextField myTextField = this.textFields.get(columnIdx);
            if (myTextField != null) {
                void $this$setTextInGrid_u24lambda_u2410_u24lambda_u249;
                GridRequestSource gridRequestSource;
                Object object;
                MyTextField myTextField2 = myTextField;
                RecordView recordView = RecordView.this;
                MyTextField textField = myTextField2;
                boolean bl = false;
                Convertor convertor = this.textConvertors.get(columnIdx);
                if (convertor != null) {
                    String string = textField.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    object = convertor.fromText(string);
                } else {
                    object = null;
                }
                Object parsed = object;
                GridRequestSource gridRequestSource2 = gridRequestSource = new GridRequestSource((GridRequestSource.RequestPlace)new EditMaximizedViewRequestPlace(recordView.grid, recordView));
                boolean bl2 = false;
                ModelIndex<GridColumn> modelIndex = columnIdx;
                ModelIndex<GridRow> modelIndex2 = this.rowIdx;
                Object object2 = parsed;
                ResultView resultView = recordView.grid.getResultView();
                boolean bl3 = false;
                $this$setTextInGrid_u24lambda_u2410_u24lambda_u249.getActionCallback().doWhenProcessed(() -> PanelController.setTextInGrid$lambda$10$lambda$9$lambda$8(this, columnIdx));
                Unit unit2 = Unit.INSTANCE;
                resultView.setValueAt(object2, modelIndex2, modelIndex, bl2, gridRequestSource);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return unit;
        }

        @Nullable
        public final Boolean setSelectionInGrid(@NotNull ModelIndex<GridColumn> columnIdx) {
            Boolean bl;
            Intrinsics.checkNotNullParameter(columnIdx, (String)"columnIdx");
            MyTextField myTextField = this.textFields.get(columnIdx);
            if (myTextField != null) {
                MyTextField myTextField2 = myTextField;
                RecordView recordView = RecordView.this;
                MyTextField textField = myTextField2;
                boolean bl2 = false;
                ResultView resultView = recordView.grid.getResultView();
                Intrinsics.checkNotNullExpressionValue((Object)resultView, (String)"getResultView(...)");
                ResultView resultView2 = resultView;
                if (resultView2 instanceof TreeTableResultView) {
                    ((TreeTableResultView)resultView2).tryExpand(this.rowIdx);
                }
                recordView.grid.getSelectionModel().setSelection(this.rowIdx, columnIdx);
                for (Map.Entry<ModelIndex<GridColumn>, MyTextField> kv : this.textFields.entrySet()) {
                    this.updateSelection(kv.getKey());
                }
                bl = textField.requestFocusInWindow();
            } else {
                bl = null;
            }
            return bl;
        }

        public final boolean onSelectionUpdated() {
            ModelIndex<GridRow> oldRowIdx = this.rowIdx;
            this.rowIdx = RecordView.this.grid.getSelectionModel().getSelectedRow();
            ModelIndex<GridColumn> oldSelectedColumnIdx = this.selectedColumnIdx;
            this.selectedColumnIdx = RecordView.this.grid.getSelectionModel().getSelectedColumn();
            if (this.rowIdx.isValid((CoreGrid)RecordView.this.grid) != this.isValidRow) {
                return false;
            }
            this.isValidRow = this.rowIdx.isValid((CoreGrid)RecordView.this.grid);
            if (!Intrinsics.areEqual(oldRowIdx, this.rowIdx)) {
                for (Map.Entry<ModelIndex<GridColumn>, MyTextField> kv : this.textFields.entrySet()) {
                    this.updateConvertor(kv.getKey());
                    this.updateText(kv.getKey());
                    this.updateColor(kv.getKey());
                }
            }
            if (!Intrinsics.areEqual(oldSelectedColumnIdx, this.selectedColumnIdx)) {
                for (Map.Entry<ModelIndex<GridColumn>, MyTextField> kv : this.textFields.entrySet()) {
                    this.updateSelection(kv.getKey());
                }
            }
            return true;
        }

        public final void updateTextFields() {
            Iterable $this$forEach$iv = this.textFields.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModelIndex columnIdx = (ModelIndex)element$iv;
                boolean bl = false;
                this.updateText((ModelIndex<GridColumn>)columnIdx);
                this.updateColor((ModelIndex<GridColumn>)columnIdx);
            }
        }

        private static final Unit lambda$3$lambda$1$lambda$0(PanelController this$0, ColumnInfo $columnInfo, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.setTextInGrid($columnInfo.getIdx());
            return Unit.INSTANCE;
        }

        private static final void setTextInGrid$lambda$10$lambda$9$lambda$8(PanelController this$0, ModelIndex $columnIdx) {
            this$0.updateColor((ModelIndex<GridColumn>)$columnIdx);
        }

        public static final /* synthetic */ ModelIndex access$getSelectedColumnIdx$p(PanelController $this) {
            return $this.selectedColumnIdx;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0016\u001a\u00020\u0013R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0015\u0010\f\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000f\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/run/ui/RecordView$PanelController$Convertor;", "", "rowIdx", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/GridRow;", "columnIdx", "Lcom/intellij/database/datagrid/GridColumn;", "<init>", "(Lcom/intellij/database/run/ui/RecordView$PanelController;Lcom/intellij/database/datagrid/ModelIndex;Lcom/intellij/database/datagrid/ModelIndex;)V", "getRowIdx", "()Lcom/intellij/database/datagrid/ModelIndex;", "getColumnIdx", "factory", "Lcom/intellij/database/run/ui/grid/editors/GridCellEditorFactory;", "Lorg/jetbrains/annotations/Nullable;", "valueParser", "Lcom/intellij/database/run/ui/grid/editors/GridCellEditorFactory$ValueParser;", "Lorg/jetbrains/annotations/NotNull;", "toText", "", "value", "fromText", "text", "intellij.grid.impl"})
        public final class Convertor {
            @NotNull
            private final ModelIndex<GridRow> rowIdx;
            @NotNull
            private final ModelIndex<GridColumn> columnIdx;
            @Nullable
            private final GridCellEditorFactory factory;
            @Nullable
            private final GridCellEditorFactory.ValueParser valueParser;

            public Convertor(@NotNull ModelIndex<GridRow> rowIdx, ModelIndex<GridColumn> columnIdx) {
                Intrinsics.checkNotNullParameter(rowIdx, (String)"rowIdx");
                Intrinsics.checkNotNullParameter(columnIdx, (String)"columnIdx");
                this.rowIdx = rowIdx;
                this.columnIdx = columnIdx;
                GridCellEditorFactoryProvider gridCellEditorFactoryProvider = GridCellEditorFactoryProvider.get(RecordView.this.grid);
                GridCellEditorFactory gridCellEditorFactory = this.factory = gridCellEditorFactoryProvider != null ? gridCellEditorFactoryProvider.getEditorFactory(RecordView.this.grid, this.rowIdx, this.columnIdx) : null;
                this.valueParser = gridCellEditorFactory != null ? gridCellEditorFactory.getValueParser(RecordView.this.grid, this.rowIdx, this.columnIdx) : null;
            }

            @NotNull
            public final ModelIndex<GridRow> getRowIdx() {
                return this.rowIdx;
            }

            @NotNull
            public final ModelIndex<GridColumn> getColumnIdx() {
                return this.columnIdx;
            }

            @NotNull
            public final String toText(@Nullable Object value) {
                Object object = this.factory;
                if (object == null || (object = object.getValueFormatter(RecordView.this.grid, this.rowIdx, this.columnIdx, value)) == null || (object = object.format()) == null || (object = ((GridCellEditorFactory.ValueFormatterResult)object).text) == null) {
                    String string = GridUtil.getText(RecordView.this.grid, this.rowIdx, this.columnIdx);
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                }
                return object;
            }

            @Nullable
            public final Object fromText(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                GridCellEditorFactory.ValueParser valueParser = this.valueParser;
                return valueParser != null ? valueParser.parse(text, null) : null;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/run/ui/RecordView$SingleColumnPanel;", "Lcom/intellij/ui/components/JBPanel;", "uiElements", "", "Lcom/intellij/database/run/ui/RecordView$PanelComponents;", "<init>", "(Ljava/util/Collection;)V", "intellij.grid.impl"})
    @SourceDebugExtension(value={"SMAP\nRecordView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecordView.kt\ncom/intellij/database/run/ui/RecordView$SingleColumnPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,416:1\n1863#2,2:417\n*S KotlinDebug\n*F\n+ 1 RecordView.kt\ncom/intellij/database/run/ui/RecordView$SingleColumnPanel\n*L\n152#1:417,2\n*E\n"})
    public static final class SingleColumnPanel
    extends JBPanel<SingleColumnPanel> {
        public SingleColumnPanel(@NotNull Collection<PanelComponents> uiElements) {
            Intrinsics.checkNotNullParameter(uiElements, (String)"uiElements");
            GroupLayout layout = new GroupLayout((Container)((Object)this));
            this.setLayout(layout);
            GroupLayout.ParallelGroup hGroup = layout.createParallelGroup();
            GroupLayout.ParallelGroup vGroup = layout.createParallelGroup();
            GroupLayout.SequentialGroup vGroupColumn1 = layout.createSequentialGroup();
            Iterable $this$forEach$iv = uiElements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PanelComponents panelComponents = (PanelComponents)element$iv;
                boolean bl = false;
                ExtendableTextField field2 = panelComponents.component1();
                JLabel nameLabel = panelComponents.component2();
                GroupLayout.SequentialGroup hGroupNameRow = layout.createSequentialGroup();
                hGroupNameRow.addGap(JBUIScale.scale((int)12));
                hGroupNameRow.addComponent(nameLabel);
                hGroupNameRow.addGap(JBUIScale.scale((int)12));
                hGroup.addGroup(hGroupNameRow);
                GroupLayout.SequentialGroup hGroupValueRow = layout.createSequentialGroup();
                hGroupValueRow.addGap(JBUIScale.scale((int)9));
                hGroupValueRow.addComponent((Component)field2, -1, -1, Short.MAX_VALUE);
                hGroupValueRow.addGap(JBUIScale.scale((int)9));
                hGroup.addGroup(hGroupValueRow);
                int fieldPreferredHeight = field2.getPreferredSize().height;
                vGroupColumn1.addContainerGap();
                vGroupColumn1.addComponent(nameLabel, fieldPreferredHeight, fieldPreferredHeight, fieldPreferredHeight);
                vGroupColumn1.addComponent((Component)field2, fieldPreferredHeight, fieldPreferredHeight, fieldPreferredHeight);
            }
            vGroup.addGroup(vGroupColumn1);
            layout.setVerticalGroup(vGroup);
            layout.setHorizontalGroup(hGroup);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/run/ui/RecordView$TwoColumnPanel;", "Lcom/intellij/ui/components/JBPanel;", "uiElements", "", "Lcom/intellij/database/run/ui/RecordView$PanelComponents;", "<init>", "(Ljava/util/Collection;)V", "intellij.grid.impl"})
    @SourceDebugExtension(value={"SMAP\nRecordView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecordView.kt\ncom/intellij/database/run/ui/RecordView$TwoColumnPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,416:1\n1#2:417\n1863#3,2:418\n*S KotlinDebug\n*F\n+ 1 RecordView.kt\ncom/intellij/database/run/ui/RecordView$TwoColumnPanel\n*L\n118#1:418,2\n*E\n"})
    public static final class TwoColumnPanel
    extends JBPanel<TwoColumnPanel> {
        public TwoColumnPanel(@NotNull Collection<PanelComponents> uiElements) {
            Object object;
            Intrinsics.checkNotNullParameter(uiElements, (String)"uiElements");
            GroupLayout layout = new GroupLayout((Container)((Object)this));
            this.setLayout(layout);
            GroupLayout.ParallelGroup hGroup = layout.createParallelGroup();
            GroupLayout.ParallelGroup vGroup = layout.createParallelGroup();
            GroupLayout.SequentialGroup vGroupColumn1 = layout.createSequentialGroup();
            GroupLayout.SequentialGroup vGroupColumn2 = layout.createSequentialGroup();
            Iterator iterator = ((Iterable)uiElements).iterator();
            if (!iterator.hasNext()) {
                object = null;
            } else {
                Object object2 = (PanelComponents)iterator.next();
                boolean bl2 = false;
                JLabel label = ((PanelComponents)object2).component2();
                JComponent jComponent = label;
                String string = label.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                Icon icon = label.getIcon();
                object2 = UiSizeUtilKt.getTextWidth((JComponent)jComponent, (String)string) + (icon != null ? icon.getIconWidth() : 0) + label.getIconTextGap();
                while (iterator.hasNext()) {
                    Object bl2 = (PanelComponents)iterator.next();
                    boolean $i$a$-maxOfOrNull-RecordView$TwoColumnPanel$maxDesiredNameSize$2 = false;
                    JLabel label2 = ((PanelComponents)bl2).component2();
                    JComponent jComponent2 = label2;
                    String string2 = label2.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                    Icon icon2 = label2.getIcon();
                    bl2 = UiSizeUtilKt.getTextWidth((JComponent)jComponent2, (String)string2) + (icon2 != null ? icon2.getIconWidth() : 0) + label2.getIconTextGap();
                    if (object2.compareTo(bl2) >= 0) continue;
                    object2 = bl2;
                }
                object = object2;
            }
            Integer n = (Integer)object;
            int maxDesiredNameSize = n != null ? n : 0;
            int nameSize = RangesKt.coerceIn((int)maxDesiredNameSize, (ClosedRange)((ClosedRange)new IntRange(JBUI.scale((int)40), JBUI.scale((int)250))));
            Iterable $this$forEach$iv = uiElements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PanelComponents panelComponents = (PanelComponents)element$iv;
                boolean bl = false;
                ExtendableTextField field2 = panelComponents.component1();
                JLabel label = panelComponents.component2();
                GroupLayout.SequentialGroup hGroupRow = layout.createSequentialGroup();
                hGroupRow.addContainerGap();
                hGroupRow.addComponent(label, nameSize, nameSize, nameSize);
                hGroupRow.addGap(JBUIScale.scale((int)6));
                hGroupRow.addComponent((Component)field2, -1, -1, Short.MAX_VALUE);
                hGroup.addGroup(hGroupRow);
                int fieldPreferredHeight = field2.getPreferredSize().height;
                vGroupColumn1.addContainerGap();
                vGroupColumn1.addComponent(label, fieldPreferredHeight, fieldPreferredHeight, fieldPreferredHeight);
                vGroupColumn1.addGap(JBUIScale.scale((int)10));
                vGroupColumn2.addContainerGap();
                vGroupColumn2.addComponent((Component)field2, fieldPreferredHeight, fieldPreferredHeight, fieldPreferredHeight);
                vGroupColumn2.addGap(JBUIScale.scale((int)10));
            }
            vGroup.addGroup(vGroupColumn1);
            vGroup.addGroup(vGroupColumn2);
            layout.setVerticalGroup(vGroup);
            layout.setHorizontalGroup(hGroup);
        }
    }
}

