/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.backend;

import com.intellij.database.DatabaseBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcZipFile
implements Closeable {
    private static final Logger LOG = Logger.getInstance(DbSrcZipFile.class);
    private final File myPath;
    @Nullable
    private final ZipFile myInputFile;
    @Nullable
    private JBZipFile myTmpFile;
    @Nullable
    private Set<String> myRemoved;

    public DbSrcZipFile(@NotNull File path) throws IOException {
        if (path == null) {
            DbSrcZipFile.$$$reportNull$$$0(0);
        }
        this.myPath = path;
        this.myInputFile = DbSrcZipFile.createInputFile(path);
    }

    public boolean fileExists() {
        return this.myPath.exists();
    }

    @Nullable
    private static ZipFile createInputFile(@NotNull File path) throws IOException {
        if (path == null) {
            DbSrcZipFile.$$$reportNull$$$0(1);
        }
        if (!path.exists()) {
            return null;
        }
        try {
            return new ZipFile(path);
        }
        catch (ZipException e) {
            LOG.warn("Ignoring zip content " + String.valueOf(path), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void putData(@NotNull String name2, byte @NotNull [] data, long timestamp, @Nullable String string) throws IOException {
        if (name2 == null) {
            DbSrcZipFile.$$$reportNull$$$0(2);
        }
        if (data == null) {
            DbSrcZipFile.$$$reportNull$$$0(3);
        }
        JBZipFile file = this.getTmpFile();
        if (this.myRemoved != null) {
            this.myRemoved.remove(name2);
        }
        JBZipEntry entry = file.getOrCreateEntry(name2);
        try {
            void comment;
            entry.setComment((String)comment);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        entry.setData(data, timestamp);
    }

    public byte @Nullable [] getData(@NotNull String name2) throws IOException {
        JBZipEntry entry;
        if (name2 == null) {
            DbSrcZipFile.$$$reportNull$$$0(4);
        }
        if (this.myRemoved != null && this.myRemoved.contains(name2)) {
            return null;
        }
        if (this.myTmpFile != null && (entry = this.myTmpFile.getEntry(name2)) != null) {
            return entry.getData();
        }
        ZipArchiveEntry zipArchiveEntry = entry = this.myInputFile == null ? null : this.myInputFile.getEntry(name2);
        if (entry == null) {
            return null;
        }
        return FileUtil.loadBytes((InputStream)this.myInputFile.getInputStream((ZipArchiveEntry)entry));
    }

    public void eraseEntry(@NotNull String name2) throws IOException {
        JBZipEntry entry;
        ZipArchiveEntry e;
        if (name2 == null) {
            DbSrcZipFile.$$$reportNull$$$0(5);
        }
        ZipArchiveEntry zipArchiveEntry = e = this.myInputFile == null ? null : this.myInputFile.getEntry(name2);
        if (e != null) {
            if (this.myRemoved == null) {
                this.myRemoved = new HashSet<String>();
            }
            this.myRemoved.add(name2);
        }
        if (this.myTmpFile != null && (entry = this.myTmpFile.getEntry(name2)) != null) {
            entry.erase();
        }
    }

    @NotNull
    private JBZipFile getTmpFile() throws IOException {
        if (this.myTmpFile == null) {
            this.myTmpFile = DbSrcZipFile.recreateZipFile(new File(this.myPath.getAbsolutePath() + ".tmp"));
        }
        JBZipFile jBZipFile = this.myTmpFile;
        if (jBZipFile == null) {
            DbSrcZipFile.$$$reportNull$$$0(6);
        }
        return jBZipFile;
    }

    @NotNull
    private static JBZipFile recreateZipFile(@NotNull File path) throws IOException {
        if (path == null) {
            DbSrcZipFile.$$$reportNull$$$0(7);
        }
        FileUtil.createParentDirs((File)path);
        FileUtil.delete((File)path);
        return new JBZipFile(path);
    }

    @Override
    public void close() throws IOException {
        boolean needSwap = false;
        try {
            needSwap = this.writeOutTemp();
        }
        finally {
            if (this.myInputFile != null) {
                this.myInputFile.close();
            }
            if (!needSwap) {
                FileUtil.delete((File)new File(this.myPath.getAbsolutePath() + ".tmp"));
            }
        }
        if (needSwap) {
            this.swapFiles();
        }
    }

    private void swapFiles() throws IOException {
        File oldFile = new File(this.myPath.getAbsolutePath() + ".old");
        File tmpFile = new File(this.myPath.getAbsolutePath() + ".tmp");
        if (oldFile.exists() && !FileUtil.delete((File)oldFile)) {
            FileUtil.delete((File)tmpFile);
            throw new IOException(DatabaseBundle.message("src.zip.safe.write.drop.old", this.myPath, oldFile.getName()));
        }
        try {
            FileUtil.rename((File)this.myPath, (File)oldFile);
        }
        catch (IOException e) {
            throw new IOException(DatabaseBundle.message("src.zip.safe.write.rename.original", this.myPath, tmpFile.getName()), e);
        }
        try {
            FileUtil.rename((File)tmpFile, (File)this.myPath);
        }
        catch (IOException e) {
            throw new IOException(DatabaseBundle.message("src.zip.safe.write.rename.backup", this.myPath, oldFile.getName(), tmpFile.getName()), e);
        }
        if (!FileUtil.delete((File)oldFile)) {
            throw new IOException(DatabaseBundle.message("src.zip.safe.write.drop.old", this.myPath, oldFile.getName()));
        }
    }

    private boolean writeOutTemp() throws IOException {
        boolean noCreateModify;
        boolean noRemove = this.myRemoved == null || this.myRemoved.isEmpty();
        boolean bl = noCreateModify = this.myTmpFile == null || this.myTmpFile.getEntries().isEmpty();
        Boolean toReturn = noCreateModify && noRemove ? Boolean.valueOf(false) : (this.myInputFile == null ? Boolean.valueOf(true) : null);
        try (JBZipFile tmpFile = toReturn == null ? this.getTmpFile() : this.myTmpFile;){
            if (toReturn != null) {
                boolean bl2 = toReturn;
                return bl2;
            }
            Enumeration it = this.myInputFile.getEntries();
            while (it.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)it.nextElement();
                String name2 = entry.getName();
                if (this.myRemoved != null && this.myRemoved.contains(name2) || tmpFile.getEntry(name2) != null) continue;
                JBZipEntry newEntry = tmpFile.getOrCreateEntry(name2);
                try {
                    newEntry.setComment(entry.getComment());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                newEntry.setData(FileUtil.loadBytes((InputStream)this.myInputFile.getInputStream(entry)), entry.getTime());
            }
            boolean bl3 = true;
            return bl3;
        }
    }

    @NotNull
    public It iterate() {
        return new It();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcZipFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcZipFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTmpFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createInputFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "eraseEntry";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "recreateZipFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    public class It
    extends JBIterator<Object> {
        private Enumeration<ZipArchiveEntry> myBaseIt;
        private Iterator<JBZipEntry> myTmpIt;

        public It() {
            this.myBaseIt = DbSrcZipFile.this.myInputFile == null ? null : DbSrcZipFile.this.myInputFile.getEntries();
        }

        protected Object nextImpl() {
            if (this.myBaseIt != null) {
                if (this.myBaseIt.hasMoreElements()) {
                    ZipArchiveEntry entry = this.myBaseIt.nextElement();
                    if (DbSrcZipFile.this.myRemoved != null && DbSrcZipFile.this.myRemoved.contains(entry.getName())) {
                        return this.skip();
                    }
                    if (DbSrcZipFile.this.myTmpFile != null && DbSrcZipFile.this.myTmpFile.getEntry(entry.getName()) != null) {
                        return this.skip();
                    }
                    return entry;
                }
                this.myBaseIt = null;
            }
            if (this.myTmpIt == null) {
                if (DbSrcZipFile.this.myTmpFile == null) {
                    return this.stop();
                }
                this.myTmpIt = new ArrayList(DbSrcZipFile.this.myTmpFile.getEntries()).iterator();
            }
            return this.myTmpIt.hasNext() ? this.myTmpIt.next() : this.stop();
        }

        @NotNull
        public String getName() {
            ZipArchiveEntry entry = (ZipArchiveEntry)ObjectUtils.tryCast((Object)this.current(), ZipArchiveEntry.class);
            if (entry != null) {
                String string = entry.getName();
                if (string == null) {
                    It.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = ((JBZipEntry)this.current()).getName();
            if (string == null) {
                It.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isDirectory() {
            ZipArchiveEntry entry = (ZipArchiveEntry)ObjectUtils.tryCast((Object)this.current(), ZipArchiveEntry.class);
            if (entry != null) {
                return entry.isDirectory();
            }
            return ((JBZipEntry)this.current()).isDirectory();
        }

        public void drop() throws IOException {
            String name2 = this.getName();
            JBZipEntry e = (JBZipEntry)ObjectUtils.tryCast((Object)this.current(), JBZipEntry.class);
            if (e != null) {
                e.erase();
                if (DbSrcZipFile.this.myInputFile == null || DbSrcZipFile.this.myInputFile.getEntry(name2) == null) {
                    return;
                }
            }
            if (DbSrcZipFile.this.myRemoved == null) {
                DbSrcZipFile.this.myRemoved = new HashSet<String>();
            }
            DbSrcZipFile.this.myRemoved.add(name2);
        }

        public long getTimestamp() {
            ZipArchiveEntry entry = (ZipArchiveEntry)ObjectUtils.tryCast((Object)this.current(), ZipArchiveEntry.class);
            if (entry != null) {
                return entry.getTime();
            }
            return ((JBZipEntry)this.current()).getTime();
        }

        public long getSize() {
            ZipArchiveEntry entry = (ZipArchiveEntry)ObjectUtils.tryCast((Object)this.current(), ZipArchiveEntry.class);
            if (entry != null) {
                return entry.getSize();
            }
            return ((JBZipEntry)this.current()).getSize();
        }

        public byte[] getData() throws IOException {
            ZipArchiveEntry entry = (ZipArchiveEntry)ObjectUtils.tryCast((Object)this.current(), ZipArchiveEntry.class);
            if (entry != null) {
                return DbSrcZipFile.this.myInputFile == null ? null : FileUtil.loadBytes((InputStream)DbSrcZipFile.this.myInputFile.getInputStream(entry));
            }
            return ((JBZipEntry)this.current()).getData();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/backend/DbSrcZipFile$It", "getName"));
        }
    }
}

