/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.FixWithProgress;
import com.intellij.database.dialects.DatabaseFixFactory;
import com.intellij.database.view.ui.ActualConfigInfoProvider;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.ModalityUiUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AuthProviderValidator
extends DatabaseConfigValidator<LocalDataSource> {
    @Override
    public Class<? extends LocalDataSource> getTargetClass() {
        return LocalDataSource.class;
    }

    @Override
    public void collectProblems(@NotNull Project project, @NotNull LocalDataSource target2, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable ActualConfigInfoProvider configInfoProvider) {
        if (project == null) {
            AuthProviderValidator.$$$reportNull$$$0(0);
        }
        if (target2 == null) {
            AuthProviderValidator.$$$reportNull$$$0(1);
        }
        if (problems == null) {
            AuthProviderValidator.$$$reportNull$$$0(2);
        }
        if (target2.getAuthProviderId().equals("no-auth")) {
            return;
        }
        DatabaseAuthProvider current = DatabaseAuthProvider.get(target2);
        if (DatabaseAuthProvider.isPreferred(current, target2)) {
            return;
        }
        DatabaseAuthProvider preferred = DatabaseAuthProvider.getPreferred(target2);
        if (preferred == null) {
            return;
        }
        DatabaseAuthProvider noAuth = Objects.requireNonNull(DatabaseAuthProvider.get("no-auth"));
        FixWithProgress setPreferred = AuthProviderValidator.getQuickFix(project, target2, preferred);
        FixWithProgress setNoAuth = AuthProviderValidator.getQuickFix(project, target2, noAuth);
        DataSourceProblem.HyperText text2 = new DataSourceProblem.HyperText(DatabaseBundle.message("notification.title.authentication", new Object[0]), DatabaseBundle.message("notification.content.href.action0.preferred.or.use.href.action1", preferred.getDisplayName(), noAuth.getDisplayName()), DatabaseBundle.message("notification.content.preferred", preferred.getDisplayName()), setPreferred, setNoAuth);
        DataSourceProblem problem = new DataSourceProblem(target2, null, DataSourceProblem.Level.HINT, text2, setPreferred);
        problems.consume((Object)problem);
    }

    @Nullable
    private static FixWithProgress getQuickFix(final @NotNull Project project, @NotNull LocalDataSource target2, DatabaseAuthProvider preferred) {
        if (project == null) {
            AuthProviderValidator.$$$reportNull$$$0(3);
        }
        if (target2 == null) {
            AuthProviderValidator.$$$reportNull$$$0(4);
        }
        String providerId = preferred.getId();
        DatabaseFixFactory fixFactory = DatabaseFixFactory.getInstance();
        final ErrorInfo.Fix fix = fixFactory == null ? null : fixFactory.setAuthProvider(target2, DatabaseBundle.message("use.0.auth", preferred.getDisplayName()), providerId);
        return fix == null ? null : new FixWithProgress(fix.getName()){

            @Override
            public void run(@NotNull ProgressIndicator indicator, @Nullable DatabaseConfigEditor editor2) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> DataSourceUiUtil.applyFix(project, fix, editor2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/validation/AuthProviderValidator$1", "run"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/validation/AuthProviderValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectProblems";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getQuickFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

