/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelper;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.AlterProducerBase;
import com.intellij.database.dialects.base.generator.producers.BaseProducersKt;
import com.intellij.database.dialects.base.generator.producers.CreateProducer;
import com.intellij.database.dialects.base.generator.producers.DropProducer;
import com.intellij.database.dialects.cassandra.generator.producers.CassAlterAggregate;
import com.intellij.database.dialects.cassandra.generator.producers.CassAlterDefType;
import com.intellij.database.dialects.cassandra.generator.producers.CassAlterDefTypeAttribute;
import com.intellij.database.dialects.cassandra.generator.producers.CassAlterFunction;
import com.intellij.database.dialects.cassandra.generator.producers.CassAlterIndex;
import com.intellij.database.dialects.cassandra.generator.producers.CassAlterKey;
import com.intellij.database.dialects.cassandra.generator.producers.CassAlterMatView;
import com.intellij.database.dialects.cassandra.generator.producers.CassAlterMatViewColumn;
import com.intellij.database.dialects.cassandra.generator.producers.CassAlterRole;
import com.intellij.database.dialects.cassandra.generator.producers.CassAlterSchema;
import com.intellij.database.dialects.cassandra.generator.producers.CassAlterTable;
import com.intellij.database.dialects.cassandra.generator.producers.CassAlterTableColumn;
import com.intellij.database.dialects.cassandra.generator.producers.CassAlterTrigger;
import com.intellij.database.dialects.cassandra.generator.producers.CassCreateAggregate;
import com.intellij.database.dialects.cassandra.generator.producers.CassCreateDefType;
import com.intellij.database.dialects.cassandra.generator.producers.CassCreateDefTypeAttribute;
import com.intellij.database.dialects.cassandra.generator.producers.CassCreateFunction;
import com.intellij.database.dialects.cassandra.generator.producers.CassCreateIndex;
import com.intellij.database.dialects.cassandra.generator.producers.CassCreateKey;
import com.intellij.database.dialects.cassandra.generator.producers.CassCreateMatView;
import com.intellij.database.dialects.cassandra.generator.producers.CassCreateMatViewColumn;
import com.intellij.database.dialects.cassandra.generator.producers.CassCreateRole;
import com.intellij.database.dialects.cassandra.generator.producers.CassCreateSchema;
import com.intellij.database.dialects.cassandra.generator.producers.CassCreateTable;
import com.intellij.database.dialects.cassandra.generator.producers.CassCreateTableColumn;
import com.intellij.database.dialects.cassandra.generator.producers.CassCreateTrigger;
import com.intellij.database.dialects.cassandra.generator.producers.CassDropDefType;
import com.intellij.database.dialects.cassandra.generator.producers.CassDropDefTypeAttribute;
import com.intellij.database.dialects.cassandra.generator.producers.CassDropIndex;
import com.intellij.database.dialects.cassandra.generator.producers.CassDropKey;
import com.intellij.database.dialects.cassandra.generator.producers.CassDropMatView;
import com.intellij.database.dialects.cassandra.generator.producers.CassDropRole;
import com.intellij.database.dialects.cassandra.generator.producers.CassDropRoutine;
import com.intellij.database.dialects.cassandra.generator.producers.CassDropSchema;
import com.intellij.database.dialects.cassandra.generator.producers.CassDropTable;
import com.intellij.database.dialects.cassandra.generator.producers.CassDropTableColumn;
import com.intellij.database.dialects.cassandra.generator.producers.CassDropTrigger;
import com.intellij.database.dialects.cassandra.model.CassAggregate;
import com.intellij.database.dialects.cassandra.model.CassDefType;
import com.intellij.database.dialects.cassandra.model.CassDefTypeAttribute;
import com.intellij.database.dialects.cassandra.model.CassFunction;
import com.intellij.database.dialects.cassandra.model.CassIndex;
import com.intellij.database.dialects.cassandra.model.CassKey;
import com.intellij.database.dialects.cassandra.model.CassLikeTable;
import com.intellij.database.dialects.cassandra.model.CassMatView;
import com.intellij.database.dialects.cassandra.model.CassMatViewColumn;
import com.intellij.database.dialects.cassandra.model.CassRole;
import com.intellij.database.dialects.cassandra.model.CassRoutine;
import com.intellij.database.dialects.cassandra.model.CassSchema;
import com.intellij.database.dialects.cassandra.model.CassTable;
import com.intellij.database.dialects.cassandra.model.CassTableColumn;
import com.intellij.database.dialects.cassandra.model.CassTrigger;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.script.generator.ScriptingOption;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/cassandra/generator/CassScriptGeneratorHelper;", "Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "<init>", "()V", "supportsCreateIfNotExists", "", "Lcom/intellij/database/model/ObjectKind;", "getSupportsCreateIfNotExists", "()Ljava/util/Set;", "createProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducer;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "createDropProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/DropProducer;", "createAlterProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/AlterProducerBase;", "elements", "Lcom/intellij/database/model/ElementAlteration;", "isOptionSupported", "", "option", "Lcom/intellij/database/script/generator/ScriptingOption;", "intellij.database.dialects.cassandra"})
public final class CassScriptGeneratorHelper
extends ScriptGeneratorHelper {
    @NotNull
    public static final CassScriptGeneratorHelper INSTANCE = new CassScriptGeneratorHelper();

    private CassScriptGeneratorHelper() {
        Dbms dbms = Dbms.CASSANDRA;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"CASSANDRA");
        super(dbms);
    }

    @Override
    @NotNull
    protected Set<ObjectKind> getSupportsCreateIfNotExists() {
        Object[] objectArray = new ObjectKind[]{ObjectKind.SCHEMA, ObjectKind.INDEX, ObjectKind.TABLE, ObjectKind.MAT_VIEW, ObjectKind.ROLE, ObjectKind.ROUTINE, ObjectKind.AGGREGATE, ObjectKind.OBJECT_TYPE, ObjectKind.TRIGGER};
        return SetsKt.setOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public CreateProducer<?> createProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof CassSchema ? (CreateProducer)new CassCreateSchema(context, (CassSchema)element) : (basicElement instanceof CassTable ? (CreateProducer)new CassCreateTable(context, (CassTable)element) : (basicElement instanceof CassTableColumn ? (CreateProducer)new CassCreateTableColumn(context, (CassTableColumn)element) : (basicElement instanceof CassKey ? (CreateProducer)new CassCreateKey(context, (CassKey)element) : (basicElement instanceof CassMatView ? (CreateProducer)new CassCreateMatView(context, (CassMatView)element) : (basicElement instanceof CassMatViewColumn ? (CreateProducer)new CassCreateMatViewColumn(context, (CassMatViewColumn)element) : (basicElement instanceof CassDefType ? (CreateProducer)new CassCreateDefType(context, (CassDefType)element) : (basicElement instanceof CassDefTypeAttribute ? (CreateProducer)new CassCreateDefTypeAttribute(context, (CassDefTypeAttribute)element) : (basicElement instanceof CassIndex ? (CreateProducer)new CassCreateIndex(context, (CassIndex)element) : (basicElement instanceof CassFunction ? (CreateProducer)new CassCreateFunction(context, (CassFunction)element) : (basicElement instanceof CassAggregate ? (CreateProducer)new CassCreateAggregate(context, (CassAggregate)element) : (basicElement instanceof CassTrigger ? (CreateProducer)new CassCreateTrigger(context, (CassTrigger)element) : (basicElement instanceof CassRole ? (CreateProducer)new CassCreateRole(context, (CassRole)element) : super.createProducerImpl(context, element)))))))))))));
    }

    @Override
    @NotNull
    public DropProducer<?> createDropProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof CassSchema ? (DropProducer)new CassDropSchema(context, (CassSchema)element) : (basicElement instanceof CassTable ? (DropProducer)new CassDropTable(context, (CassTable)element) : (basicElement instanceof CassTableColumn ? (DropProducer)new CassDropTableColumn(context, (CassTableColumn)element) : (basicElement instanceof CassKey ? (DropProducer)new CassDropKey(context, (CassKey)element) : (basicElement instanceof CassMatView ? (DropProducer)new CassDropMatView(context, (CassMatView)element) : (basicElement instanceof CassDefType ? (DropProducer)new CassDropDefType(context, (CassDefType)element) : (basicElement instanceof CassDefTypeAttribute ? (DropProducer)new CassDropDefTypeAttribute(context, (CassDefTypeAttribute)element) : (basicElement instanceof CassIndex ? (DropProducer)new CassDropIndex(context, (CassIndex)element) : (basicElement instanceof CassFunction ? (DropProducer)new CassDropRoutine(context, (CassRoutine)element) : (basicElement instanceof CassAggregate ? (DropProducer)new CassDropRoutine(context, (CassRoutine)element) : (basicElement instanceof CassTrigger ? (DropProducer)new CassDropTrigger(context, (CassTrigger)element) : (basicElement instanceof CassRole ? (DropProducer)new CassDropRole(context, (CassRole)element) : super.createDropProducerImpl(context, element))))))))))));
    }

    @Override
    @NotNull
    public AlterProducerBase<?> createAlterProducerImpl(@NotNull ScriptingContext context, @NotNull ElementAlteration<?> elements) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Object it = elements.getSourceElement();
        boolean bl = false;
        Object obj2 = it;
        return obj2 instanceof CassSchema ? (AlterProducerBase)new CassAlterSchema(context, (ElementAlteration<? extends CassSchema>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof CassTable ? (AlterProducerBase)new CassAlterTable(context, (ElementAlteration<? extends CassLikeTable>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof CassTableColumn ? (AlterProducerBase)new CassAlterTableColumn(context, (ElementAlteration<? extends CassTableColumn>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof CassKey ? (AlterProducerBase)new CassAlterKey(context, (ElementAlteration<? extends CassKey>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof CassMatView ? (AlterProducerBase)new CassAlterMatView(context, (ElementAlteration<? extends CassMatView>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof CassMatViewColumn ? (AlterProducerBase)new CassAlterMatViewColumn(context, (ElementAlteration<? extends CassMatViewColumn>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof CassDefType ? (AlterProducerBase)new CassAlterDefType(context, (ElementAlteration<? extends CassDefType>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof CassDefTypeAttribute ? (AlterProducerBase)new CassAlterDefTypeAttribute(context, (ElementAlteration<? extends CassDefTypeAttribute>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof CassIndex ? (AlterProducerBase)new CassAlterIndex(context, (ElementAlteration<? extends CassIndex>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof CassFunction ? (AlterProducerBase)new CassAlterFunction(context, (ElementAlteration<? extends CassFunction>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof CassAggregate ? (AlterProducerBase)new CassAlterAggregate(context, (ElementAlteration<? extends CassAggregate>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof CassTrigger ? (AlterProducerBase)new CassAlterTrigger(context, (ElementAlteration<? extends CassTrigger>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof CassRole ? (AlterProducerBase)new CassAlterRole(context, (ElementAlteration<? extends CassRole>)BaseProducersKt.cast(elements, it)) : super.createAlterProducerImpl(context, elements)))))))))))));
    }

    @Override
    public boolean isOptionSupported(@NotNull ScriptingOption<?> option) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        ScriptingOption<?> scriptingOption = option;
        return Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.CREATE_OR_REPLACE) || Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.CREATE_IF_NOT_EXISTS) || Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.IF_EXISTS) ? true : (Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.USE_DELETE) ? false : super.isOptionSupported(option));
    }
}

