/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.DescriptionOptions;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.ModelDescribing;
import com.intellij.database.model.ModelDescriptionAnnotation;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicMultiLevelIntrospectableArea;
import com.intellij.database.model.basic.BasicMultiLevelObject;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.properties.Level;
import com.intellij.database.util.CodeBuilder;
import com.intellij.database.util.CodeWithMarkers;
import com.intellij.database.util.common.NumberFun;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\b\u0012\u0004\u0012\u00020\f0\u000b\u001a\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u000f\u001a\u00020\u0001*\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007\u001a\"\u0010\u000f\u001a\u00020\u0010*\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u001c\u0010\u000f\u001a\u00020\u0010*\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a \u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"indentStep", "", "eoln", "", "braceLAL", "braceLAR", "braceLDL", "braceLDR", "describeForest", "Lcom/intellij/database/util/CodeWithMarkers;", "Lcom/intellij/database/model/ModelDescriptionAnnotation;", "", "Lcom/intellij/database/model/basic/BasicNode;", "options", "Lcom/intellij/database/model/DescriptionOptions;", "describeTree", "", "cb", "Lcom/intellij/database/util/CodeBuilder;", "service", "Lcom/intellij/database/model/DescriptionService;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeTreeRecursively", "e", "Lcom/intellij/database/model/basic/BasicElement;", "intellij.database.impl"})
@JvmName(name="ModelDescribing")
@SourceDebugExtension(value={"SMAP\nModelDescribing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelDescribing.kt\ncom/intellij/database/model/ModelDescribing\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CodeBuilder.kt\ncom/intellij/database/util/CodeBuilder\n+ 4 DescriptionService.kt\ncom/intellij/database/model/DescriptionService$Context\n*L\n1#1,181:1\n1863#2,2:182\n1863#2,2:184\n1010#2,2:191\n71#3:186\n71#3:188\n71#3:189\n71#3:190\n71#3:193\n70#4:187\n*S KotlinDebug\n*F\n+ 1 ModelDescribing.kt\ncom/intellij/database/model/ModelDescribing\n*L\n37#1:182,2\n60#1:184,2\n163#1:191,2\n61#1:186\n111#1:188\n127#1:189\n147#1:190\n168#1:193\n72#1:187\n*E\n"})
public final class ModelDescribing {
    @NotNull
    private static final String indentStep = "    ";
    private static final char eoln = '\n';
    public static final char braceLAL = '\u2308';
    public static final char braceLAR = '\u2309';
    public static final char braceLDL = '\u230a';
    public static final char braceLDR = '\u230b';

    @NotNull
    public static final CodeWithMarkers<ModelDescriptionAnnotation> describeForest(@NotNull Iterable<? extends BasicNode> $this$describeForest) {
        Intrinsics.checkNotNullParameter($this$describeForest, (String)"<this>");
        return ModelDescribing.describeForest($this$describeForest, DescriptionOptions.EMPTY);
    }

    @NotNull
    public static final CodeWithMarkers<ModelDescriptionAnnotation> describeForest(@NotNull Iterable<? extends BasicNode> $this$describeForest, @NotNull DescriptionOptions options) {
        Intrinsics.checkNotNullParameter($this$describeForest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        CodeBuilder<ModelDescriptionAnnotation> cb = new CodeBuilder<ModelDescriptionAnnotation>();
        cb.setDefaultIndentation(indentStep);
        Iterable<? extends BasicNode> $this$forEach$iv = $this$describeForest;
        boolean $i$f$forEach = false;
        Iterator<? extends BasicNode> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            BasicNode element$iv;
            BasicNode it = element$iv = iterator.next();
            boolean bl = false;
            ModelDescribing.describeTree(it, cb, options);
        }
        return cb.getResult();
    }

    @JvmOverloads
    @NotNull
    public static final String describeTree(@NotNull BasicNode $this$describeTree, @NotNull DescriptionOptions options) {
        Intrinsics.checkNotNullParameter((Object)$this$describeTree, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        CodeBuilder<ModelDescriptionAnnotation> cb = new CodeBuilder<ModelDescriptionAnnotation>();
        cb.setDefaultIndentation(indentStep);
        ModelDescribing.describeTree($this$describeTree, cb, options);
        return cb.getText();
    }

    public static /* synthetic */ String describeTree$default(BasicNode basicNode, DescriptionOptions descriptionOptions, int n, Object object) {
        if ((n & 1) != 0) {
            descriptionOptions = DescriptionOptions.EMPTY;
        }
        return ModelDescribing.describeTree(basicNode, descriptionOptions);
    }

    private static final void describeTree(BasicNode $this$describeTree, CodeBuilder<ModelDescriptionAnnotation> cb, DescriptionOptions options) {
        Object object = $this$describeTree.getModel();
        if (object == null || (object = object.getDbms()) == null) {
            object = Dbms.UNKNOWN;
        }
        DescriptionService descriptionService = ModelFacade.forDbms((Dbms)object).getDescriptionService();
        Intrinsics.checkNotNullExpressionValue((Object)descriptionService, (String)"getDescriptionService(...)");
        DescriptionService service = descriptionService;
        DescriptionService.Context context = new DescriptionService.Context(options, cb);
        context.setIndent("");
        ModelDescribing.describeTree($this$describeTree, service, context);
    }

    /*
     * WARNING - void declaration
     */
    private static final void describeTree(BasicNode $this$describeTree, DescriptionService service, DescriptionService.Context context) {
        BasicNode basicNode = $this$describeTree;
        if (basicNode instanceof BasicElement) {
            ModelDescribing.describeTreeRecursively(service, context, (BasicElement)$this$describeTree);
        } else if (basicNode instanceof Family) {
            Iterable $this$forEach$iv = (Iterable)((Object)$this$describeTree);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BasicElement it = (BasicElement)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                ModelDescribing.describeTree((BasicNode)it, service, context);
            }
        } else {
            void $this$iv;
            CodeBuilder<ModelDescriptionAnnotation> $this$forEach$iv = context.getCb();
            CharSequence[] $i$f$forEach = new CharSequence[]{$this$describeTree.toString()};
            CharSequence[] words$iv = $i$f$forEach;
            Object annotation$iv = null;
            boolean $i$f$phraseLn = false;
            $this$iv.phrase(Arrays.copyOf(words$iv, words$iv.length), annotation$iv, true);
        }
    }

    private static final void describeTreeRecursively(DescriptionService service, DescriptionService.Context context, BasicElement e) {
        List<NameValue> describedReferences;
        List<DescriptionService.NameAndValue> describedProperties;
        Collection<String> dependsOnNames;
        CharSequence[] charSequenceArray;
        String name2;
        context.getDescribed().clear();
        service.considerAlwaysDescribedProperties(context);
        CodeBuilder<ModelDescriptionAnnotation> cb = context.getCb();
        DescriptionService.Context this_$iv = context;
        boolean $i$f$getWithSurrogates = false;
        boolean withSurrogates = this_$iv.getOptions().getWithSurrogates();
        String string = name2 = e.getParent() instanceof BasicView && Intrinsics.areEqual((Object)e.getKind(), (Object)ObjectKind.COLUMN) && e instanceof BasicNamedElement && ((BasicNamedElement)e).isNameSurrogate() && ((BasicNamedElement)e).isNameScripted() ? ((BasicNamedElement)e).getRealName() : e.identity(withSurrogates);
        if (context.getOptions().getWithLevels()) {
            if (e instanceof BasicMultiLevelObject) {
                Level detailsLevel;
                Level level = detailsLevel = ((BasicMultiLevelObject)e).getDetailsLevel();
                char dlc = level != null ? NumberFun.getOneDigitChar(level.level) : (char)'-';
                charSequenceArray = new CharSequence[]{"\u230a" + dlc + "\u230b"};
                CodeBuilder.phrase$default(cb, charSequenceArray, (Object)ModelDescriptionAnnotation.MdaDetailsLevel, false, 4, null);
            }
            if (e instanceof BasicMultiLevelIntrospectableArea) {
                Level introspectionLevel;
                Level level = introspectionLevel = ((BasicMultiLevelIntrospectableArea)e).getExplicitIntrospectionLevel();
                char ilc = level != null ? NumberFun.getOneDigitChar(level.level) : (char)'-';
                charSequenceArray = new CharSequence[]{"\u2308" + ilc + "\u2309"};
                CodeBuilder.phrase$default(cb, charSequenceArray, (Object)ModelDescriptionAnnotation.MdaIntrospectionLevel, false, 4, null);
            }
        }
        if (withSurrogates && e instanceof BasicArrangedElement && ((BasicArrangedElement)e).getPosition() != 0) {
            String position = String.valueOf(((BasicArrangedElement)e).getPosition());
            CharSequence[] ilc = new CharSequence[]{"[" + position + "]"};
            CodeBuilder.phrase$default(cb, ilc, (Object)ModelDescriptionAnnotation.MdaPosition, false, 4, null);
        }
        CharSequence[] position = new CharSequence[]{name2};
        CodeBuilder.phrase$default(cb, position, (Object)ModelDescriptionAnnotation.MdaName, false, 4, null);
        if (withSurrogates && e instanceof BasicIdentifiedElement && ((BasicIdentifiedElement)e).getObjectId() != Long.MIN_VALUE) {
            String objectId = String.valueOf(((BasicIdentifiedElement)e).getObjectId());
            CharSequence[] ilc = new CharSequence[]{"#" + objectId};
            CodeBuilder.phrase$default(cb, ilc, (Object)ModelDescriptionAnnotation.MdaObjectId, false, 4, null);
        }
        cb.append(":");
        String content = ((Object)StringsKt.trim((CharSequence)service.content(e, context))).toString();
        String options = ((Object)StringsKt.trim((CharSequence)service.options(e, context))).toString();
        charSequenceArray = new CharSequence[]{content};
        CodeBuilder.phrase$default(cb, charSequenceArray, null, false, 6, null);
        charSequenceArray = new CharSequence[]{options};
        CodeBuilder.phrase$default(cb, charSequenceArray, (Object)ModelDescriptionAnnotation.MdaAdditionalOptions, false, 4, null);
        cb.nl();
        String comment = e.getComment();
        CharSequence charSequence = comment;
        if (!(charSequence == null || charSequence.length() == 0)) {
            StringBuilder stringBuilder = StringUtil.escapeStringCharacters((int)comment.length(), (String)comment, null, (boolean)false, (boolean)false, (StringBuilder)new StringBuilder(comment.length()));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"escapeStringCharacters(...)");
            StringBuilder escapedComment = stringBuilder;
            cb.indenting((Function0<Unit>)((Function0)() -> ModelDescribing.describeTreeRecursively$lambda$2(cb, escapedComment)));
        }
        if (!(dependsOnNames = service.getDependsOnNames(e, context.getOptions().getWithSurrogates())).isEmpty()) {
            cb.indenting((Function0<Unit>)((Function0)() -> ModelDescribing.describeTreeRecursively$lambda$3(cb, dependsOnNames)));
        }
        if (!((Collection)(describedProperties = service.describeProperties(e, context))).isEmpty()) {
            cb.indenting((Function0<Unit>)((Function0)() -> ModelDescribing.describeTreeRecursively$lambda$5(cb, describedProperties)));
        }
        if (!((Collection)(describedReferences = service.describeReferences(e, context))).isEmpty()) {
            cb.indenting((Function0<Unit>)((Function0)() -> ModelDescribing.describeTreeRecursively$lambda$7(cb, describedReferences)));
        }
        List<? extends Family<? extends BasicElement>> list = e.getFamilies();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getFamilies(...)");
        List families = CollectionsKt.toMutableList((Collection)list);
        if (!((Collection)families).isEmpty()) {
            cb.indenting((Function0<Unit>)((Function0)() -> ModelDescribing.describeTreeRecursively$lambda$11(context, families, cb, service)));
        }
    }

    @JvmOverloads
    @NotNull
    public static final String describeTree(@NotNull BasicNode $this$describeTree) {
        Intrinsics.checkNotNullParameter((Object)$this$describeTree, (String)"<this>");
        return ModelDescribing.describeTree$default($this$describeTree, null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit describeTreeRecursively$lambda$2(CodeBuilder $cb, StringBuilder $escapedComment) {
        void words$iv;
        void this_$iv;
        CodeBuilder codeBuilder = $cb;
        CharSequence[] charSequenceArray = new CharSequence[]{"--  ", $escapedComment};
        ModelDescriptionAnnotation annotation$iv = ModelDescriptionAnnotation.MdaComment;
        boolean $i$f$phraseLn = false;
        this_$iv.phrase((CharSequence[])Arrays.copyOf(words$iv, ((void)words$iv).length), annotation$iv, true);
        return Unit.INSTANCE;
    }

    private static final Unit describeTreeRecursively$lambda$3(CodeBuilder $cb, Collection $dependsOnNames) {
        CharSequence[] charSequenceArray = new CharSequence[]{"^", "depends on"};
        CodeBuilder.phrase$default($cb, charSequenceArray, null, false, 6, null);
        charSequenceArray = new CharSequence[]{CollectionsKt.joinToString$default((Iterable)$dependsOnNames, null, null, null, (int)0, null, null, (int)63, null)};
        CodeBuilder.phrase$default($cb, charSequenceArray, null, false, 6, null);
        $cb.nl();
        return Unit.INSTANCE;
    }

    private static final Unit describeTreeRecursively$lambda$5$lambda$4(List $describedProperties, CodeBuilder $cb) {
        for (DescriptionService.NameAndValue p2 : $describedProperties) {
            CharSequence[] charSequenceArray = new CharSequence[]{p2.getName()};
            CodeBuilder.phrase$default($cb, charSequenceArray, null, false, 6, null);
            String v = p2.getValue();
            if (v == DescriptionService.Companion.getNULL_STR()) {
                var5_5 = new CharSequence[]{"is null"};
                CodeBuilder.phrase$default($cb, var5_5, null, false, 6, null);
            } else if (v == DescriptionService.Companion.getTRUE_STR()) {
                var5_5 = new CharSequence[]{"+"};
                CodeBuilder.phrase$default($cb, var5_5, null, false, 6, null);
            } else if (v == DescriptionService.Companion.getFALSE_STR()) {
                var5_5 = new CharSequence[]{"-"};
                CodeBuilder.phrase$default($cb, var5_5, null, false, 6, null);
            } else {
                var5_5 = new CharSequence[]{"=", v};
                CodeBuilder.phrase$default($cb, var5_5, null, false, 6, null);
            }
            $cb.nl();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit describeTreeRecursively$lambda$5(CodeBuilder $cb, List $describedProperties) {
        void words$iv;
        CharSequence[] charSequenceArray = new CharSequence[]{".", "properties"};
        Object annotation$iv = null;
        boolean $i$f$phraseLn = false;
        $cb.phrase((CharSequence[])Arrays.copyOf(words$iv, ((void)words$iv).length), annotation$iv, true);
        $cb.indenting((Function0<Unit>)((Function0)() -> ModelDescribing.describeTreeRecursively$lambda$5$lambda$4($describedProperties, $cb)));
        return Unit.INSTANCE;
    }

    private static final Unit describeTreeRecursively$lambda$7$lambda$6(List $describedReferences, CodeBuilder $cb) {
        for (NameValue r : $describedReferences) {
            CharSequence[] charSequenceArray = new CharSequence[]{r.getName()};
            CodeBuilder.phrase$default($cb, charSequenceArray, null, false, 6, null);
            String v = r.getValue();
            if (v == DescriptionService.Companion.getNULL_STR()) {
                var5_5 = new CharSequence[]{DescriptionService.Companion.getNULL_STR()};
                CodeBuilder.phrase$default($cb, var5_5, null, false, 6, null);
            } else {
                var5_5 = new CharSequence[]{"=", v};
                CodeBuilder.phrase$default($cb, var5_5, null, false, 6, null);
            }
            $cb.nl();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit describeTreeRecursively$lambda$7(CodeBuilder $cb, List $describedReferences) {
        void words$iv;
        CharSequence[] charSequenceArray = new CharSequence[]{".", "references"};
        Object annotation$iv = null;
        boolean $i$f$phraseLn = false;
        $cb.phrase((CharSequence[])Arrays.copyOf(words$iv, ((void)words$iv).length), annotation$iv, true);
        $cb.indenting((Function0<Unit>)((Function0)() -> ModelDescribing.describeTreeRecursively$lambda$7$lambda$6($describedReferences, $cb)));
        return Unit.INSTANCE;
    }

    private static final boolean describeTreeRecursively$lambda$11$lambda$9(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit describeTreeRecursively$lambda$11$lambda$10(DescriptionService $service, DescriptionService.Context $context, BasicElement $child) {
        Intrinsics.checkNotNull((Object)$child);
        ModelDescribing.describeTreeRecursively($service, $context, $child);
        return Unit.INSTANCE;
    }

    private static final Unit describeTreeRecursively$lambda$11(DescriptionService.Context $context, List $families, CodeBuilder $cb, DescriptionService $service) {
        if ($context.getOptions().getOrdered()) {
            List $this$sortBy$iv = $families;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Family it = (Family)a;
                        boolean bl = false;
                        it = (Family)b;
                        Comparable comparable = it.getMetaObject().kind;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)it.getMetaObject().kind);
                    }
                });
            }
        }
        for (Family family : $families) {
            JBIterable children2;
            if (family.isEmpty()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)family.jbi().filter(arg_0 -> ModelDescribing.describeTreeRecursively$lambda$11$lambda$9(describeTreeRecursively.5.children.1.INSTANCE, arg_0)), (String)"filter(...)");
            if (!children2.isNotEmpty()) continue;
            CharSequence[] charSequenceArray = new CharSequence[]{"+", StringUtil.pluralize((String)family.getMetaObject().kind.code())};
            CharSequence[] words$iv = charSequenceArray;
            Object annotation$iv = null;
            boolean $i$f$phraseLn = false;
            $cb.phrase(Arrays.copyOf(words$iv, words$iv.length), annotation$iv, true);
            for (BasicElement child : children2) {
                $cb.indenting((Function0<Unit>)((Function0)() -> ModelDescribing.describeTreeRecursively$lambda$11$lambda$10($service, $context, child)));
            }
        }
        return Unit.INSTANCE;
    }
}

