/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dbimport.DbElementTreeCellRenderer;
import com.intellij.database.fulltextsearch.FtsUtilKt;
import com.intellij.database.fulltextsearch.FullTextSearchOptions;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.ui.SqlPreviewPanel;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FullTextSearchForm {
    private EditorTextField mySearchText;
    private IntegerField myMaximumHitsCount;
    public JPanel myPanel;
    private JBCheckBox myMatchCaseCheckBox;
    private ComboBox<FullTextSearchOptions.SearchScope> mySearchCombobox;
    private ComboBox<FullTextSearchOptions.Location> myLocationInStringCombobox;
    private JPanel mySqlPreviewPanel;
    private Tree myTargetsTree;
    private Collection<DbTable> myTargets;
    private final Project myProject;

    public FullTextSearchForm(@NotNull Project project) {
        if (project == null) {
            FullTextSearchForm.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myTargets = new ArrayList<DbTable>();
        this.myProject = project;
        this.mySearchCombobox.setModel((ComboBoxModel)new EnumComboBoxModel(FullTextSearchOptions.SearchScope.class));
        this.mySearchCombobox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", FullTextSearchOptions.SearchScope::getName));
        this.myLocationInStringCombobox.setModel((ComboBoxModel)new EnumComboBoxModel(FullTextSearchOptions.Location.class));
        this.myLocationInStringCombobox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", FullTextSearchOptions.Location::getName));
        this.myTargetsTree.setCellRenderer((TreeCellRenderer)((Object)new DbElementTreeCellRenderer(){

            @Override
            @Nullable
            protected DbElement getDbElement(@NotNull Object value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (DbElement)ObjectUtils.tryCast((Object)value, DbElement.class);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/view/ui/FullTextSearchForm$1", "getDbElement"));
            }
        }));
        this.myTargetsTree.getSelectionModel().setSelectionMode(1);
    }

    private void addUpdateSqlPreviewListeners() {
        this.myTargetsTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FullTextSearchForm.this.updateSqlPreview(true);
            }
        });
        this.mySearchText.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                FullTextSearchForm.this.updateSqlPreview();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/view/ui/FullTextSearchForm$3", "documentChanged"));
            }
        });
        this.myMaximumHitsCount.getDocument().addDocumentListener(new javax.swing.event.DocumentListener(){

            @Override
            public void insertUpdate(javax.swing.event.DocumentEvent e) {
                FullTextSearchForm.this.updateSqlPreview();
            }

            @Override
            public void removeUpdate(javax.swing.event.DocumentEvent e) {
                FullTextSearchForm.this.updateSqlPreview();
            }

            @Override
            public void changedUpdate(javax.swing.event.DocumentEvent e) {
                FullTextSearchForm.this.updateSqlPreview();
            }
        });
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                FullTextSearchForm.this.updateSqlPreview();
            }
        };
        this.myLocationInStringCombobox.addItemListener(itemListener);
        this.mySearchCombobox.addItemListener(itemListener);
        this.myMatchCaseCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FullTextSearchForm.this.updateSqlPreview();
            }
        });
    }

    public void updateSqlPreview() {
        this.updateSqlPreview(false);
    }

    public void updateSqlPreview(boolean recreatePanel) {
        DbElement selectedElement = this.getSelectedDbElement();
        if (selectedElement == null) {
            return;
        }
        List<DbTable> tables = this.getSelectedTables();
        if (tables.isEmpty()) {
            return;
        }
        SqlPreviewPanel oldPanel = null;
        if (this.mySqlPreviewPanel.getComponentCount() == 1 && (oldPanel = (SqlPreviewPanel)ObjectUtils.tryCast((Object)this.mySqlPreviewPanel.getComponent(0), SqlPreviewPanel.class)) != null && !oldPanel.getHideableDecorator().isExpanded()) {
            return;
        }
        SqlPreviewPanel preview = oldPanel;
        if (recreatePanel || preview == null) {
            this.mySqlPreviewPanel.removeAll();
            preview = new SqlPreviewPanel(this.myProject, selectedElement.getDataSource(), null, "", this.getClass().getName(), true, () -> {});
            this.mySqlPreviewPanel.add((Component)preview, "Center");
        }
        String query = FtsUtilKt.getQueryForFirstNElements(tables, 100, this.getOptions());
        preview.getPreviewComponent().setQuery(query);
        String name2 = StringUtil.shortenTextWithEllipsis((String)selectedElement.getName(), (int)40, (int)10);
        preview.setTitle(DatabaseBundle.message("FullTextSearch.preview", name2));
    }

    @Nullable
    private DbElement getSelectedDbElement() {
        return (DbElement)ObjectUtils.tryCast((Object)TreeUtil.getLastUserObject((TreePath)this.myTargetsTree.getSelectionPath()), DbElement.class);
    }

    @NotNull
    private List<DbTable> getSelectedTables() {
        TreePath path = this.myTargetsTree.getSelectionPath();
        if (path == null) {
            List<DbTable> list = Collections.emptyList();
            if (list == null) {
                FullTextSearchForm.$$$reportNull$$$0(1);
            }
            return list;
        }
        JBTreeTraverser tableNodes = (JBTreeTraverser)TreeUtil.treeNodeTraverser((TreeNode)((TreeNode)path.getLastPathComponent())).filter(node -> TreeUtil.getUserObject((Object)node) instanceof DbTable);
        List list = ContainerUtil.mapNotNull((Iterable)tableNodes, node -> (DbTable)ObjectUtils.tryCast((Object)TreeUtil.getUserObject((Object)node), DbTable.class));
        if (list == null) {
            FullTextSearchForm.$$$reportNull$$$0(2);
        }
        return list;
    }

    public boolean isValid() {
        try {
            this.myMaximumHitsCount.validateContent();
            return true;
        }
        catch (ConfigurationException ignored) {
            return false;
        }
    }

    public EditorTextField getSearchText() {
        return this.mySearchText;
    }

    public IntegerField getMaximumHitsCount() {
        return this.myMaximumHitsCount;
    }

    @NotNull
    public FullTextSearchOptions.Location getLocation() {
        FullTextSearchOptions.Location location = (FullTextSearchOptions.Location)((Object)this.myLocationInStringCombobox.getModel().getSelectedItem());
        if (location == null) {
            FullTextSearchForm.$$$reportNull$$$0(3);
        }
        return location;
    }

    public void apply(@NotNull FullTextSearchOptions options, @NotNull Collection<DbTable> targets) {
        int maxNumOfFetchedRows;
        if (options == null) {
            FullTextSearchForm.$$$reportNull$$$0(4);
        }
        if (targets == null) {
            FullTextSearchForm.$$$reportNull$$$0(5);
        }
        if ((maxNumOfFetchedRows = options.getMaxNumOfFetchedRows()) >= this.myMaximumHitsCount.getMinValue() && maxNumOfFetchedRows <= this.myMaximumHitsCount.getMaxValue()) {
            this.myMaximumHitsCount.setValue(Integer.valueOf(maxNumOfFetchedRows));
        }
        this.mySearchText.setText(options.getText());
        this.mySearchText.selectAll();
        ((EnumComboBoxModel)this.myLocationInStringCombobox.getModel()).setSelectedItem((Enum)options.getLocation());
        ((EnumComboBoxModel)this.mySearchCombobox.getModel()).setSelectedItem((Enum)options.getSearchScope());
        this.myTargets = targets;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myTargetsTree.getModel().getRoot();
        for (DbElement dbElement : this.myTargets) {
            FullTextSearchForm.addNode(root, dbElement);
        }
        this.addUpdateSqlPreviewListeners();
        TreeUtil.expandAll((JTree)this.myTargetsTree);
        TreeUtil.selectFirstNode((JTree)this.myTargetsTree);
        DbElement selectedValue = Objects.requireNonNull(this.getSelectedDbElement());
        boolean bl = DbImplUtilCore.getJdbcHelper(selectedValue.getDbms()).supportsIlike();
        this.myMatchCaseCheckBox.setEnabled(bl);
        this.myMatchCaseCheckBox.setSelected(!bl || options.isMatchCase());
    }

    private static void addNode(@NotNull DefaultMutableTreeNode root, @NotNull DbElement target2) {
        if (root == null) {
            FullTextSearchForm.$$$reportNull$$$0(6);
        }
        if (target2 == null) {
            FullTextSearchForm.$$$reportNull$$$0(7);
        }
        DefaultMutableTreeNode currentNode = root;
        for (DbElement dbElement : ContainerUtil.reverse((List)JBIterable.generate((Object)target2, el -> el.getParent()).toList())) {
            DefaultMutableTreeNode newNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)currentNode, (Object)dbElement);
            if (newNode == null) {
                newNode = new DefaultMutableTreeNode(dbElement);
                currentNode.add(newNode);
            }
            currentNode = newNode;
        }
    }

    @NotNull
    public String getText() {
        String string = StringUtil.notNullize((String)this.mySearchText.getText());
        if (string == null) {
            FullTextSearchForm.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public Collection<DbTable> getTargets() {
        Collection<DbTable> collection = this.myTargets;
        if (collection == null) {
            FullTextSearchForm.$$$reportNull$$$0(9);
        }
        return collection;
    }

    public ComboBox<FullTextSearchOptions.SearchScope> getSearchScopeCombobox() {
        return this.mySearchCombobox;
    }

    @NotNull
    public FullTextSearchOptions getOptions() {
        return new FullTextSearchOptions(this.getText(), this.myMatchCaseCheckBox.isSelected(), (FullTextSearchOptions.SearchScope)((Object)ObjectUtils.notNull((Object)((Object)((FullTextSearchOptions.SearchScope)((Object)this.mySearchCombobox.getSelectedItem()))), (Object)((Object)FullTextSearchOptions.DEFAULT_SEARCH_SCOPE))), (FullTextSearchOptions.Location)((Object)ObjectUtils.notNull((Object)((Object)((FullTextSearchOptions.Location)((Object)this.myLocationInStringCombobox.getSelectedItem()))), (Object)((Object)FullTextSearchOptions.DEFAULT_LOCATION))), this.myMaximumHitsCount.getValue());
    }

    private void createUIComponents() {
        this.myTargetsTree = new Tree((TreeNode)new DefaultMutableTreeNode());
        this.myTargetsTree.setRootVisible(false);
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)this.myTargetsTree);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        ComboBox comboBox;
        IntegerField integerField;
        ComboBox comboBox2;
        JBCheckBox jBCheckBox;
        EditorTextField editorTextField2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 2, 0, 3, 3, 1, null, null, null));
        this.mySearchText = editorTextField2 = new EditorTextField();
        jPanel3.add((Component)editorTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, new Dimension(300, -1), null));
        this.myMatchCaseCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DatabaseBundle", FullTextSearchForm.class).getString("FullTextSearch.match.case"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLocationInStringCombobox = comboBox2 = new ComboBox();
        jPanel3.add((Component)comboBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(20, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(2, 1, 1, 2, 8, 2, 3, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setHorizontalAlignment(2);
        jBLabel.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", FullTextSearchForm.class).getString("FullTextSearch.show.first"));
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMaximumHitsCount = integerField = new IntegerField();
        integerField.setHorizontalAlignment(4);
        integerField.setMaxValue(1000);
        integerField.setMinValue(1);
        jPanel4.add((Component)integerField, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, new Dimension(50, -1), new Dimension(50, 30), new Dimension(50, -1)));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", FullTextSearchForm.class).getString("FullTextSearch.matches.per.table"));
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", FullTextSearchForm.class).getString("FullTextSearch.search.in"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySearchCombobox = comboBox = new ComboBox();
        comboBox.setEditable(false);
        jPanel2.add((Component)comboBox, new GridConstraints(1, 2, 1, 1, 8, 0, 2, 0, null, null, null));
        this.mySqlPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 1, 2, 2, 0, 3, 3, 7, null, new Dimension(400, 200), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 5, 1, 0, 3, 3, 3, null, new Dimension(250, -1), null));
        Tree tree2 = this.myTargetsTree;
        jBScrollPane.setViewportView((Component)tree2);
        jBLabel3.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/FullTextSearchForm";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/FullTextSearchForm";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedTables";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 8, 9 -> new IllegalStateException(string);
        };
    }
}

