/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.SqlJoinCountInspection;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/inspections/SqlJoinCountInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "maxJoinCount", "", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "intellij.database.sql.impl"})
public final class SqlJoinCountInspection
extends SqlInspectionBase {
    @JvmField
    public int maxJoinCount = 3;

    @Override
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, this, onTheFly){
            final /* synthetic */ SqlJoinCountInspection this$0;
            final /* synthetic */ boolean $onTheFly;
            {
                this.this$0 = $receiver;
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            public void visitSqlQueryExpression(SqlQueryExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitSqlQueryExpression(o);
                SqlTableExpression sqlTableExpression = o.getTableExpression();
                SqlExpression sqlExpression = sqlTableExpression != null && (sqlTableExpression = sqlTableExpression.getFromClause()) != null ? sqlTableExpression.getFromExpression() : null;
                SqlJoinExpression sqlJoinExpression = sqlExpression instanceof SqlJoinExpression ? (SqlJoinExpression)sqlExpression : null;
                if (sqlJoinExpression == null) {
                    return;
                }
                SqlJoinExpression fromExpression = sqlJoinExpression;
                sqlExpression = ((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)fromExpression).expand(arg_0 -> createAnnotationVisitor.1.visitSqlQueryExpression$lambda$1(createAnnotationVisitor.1::visitSqlQueryExpression$lambda$0, arg_0))).filter(SqlJoinExpression.class);
                Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"filter(...)");
                int joinCount = CollectionsKt.count((Iterable)((Iterable)sqlExpression));
                if (joinCount > this.this$0.maxJoinCount) {
                    PsiElement psiElement = (PsiElement)fromExpression;
                    String string = SqlBundle.message((String)"inspection.message.too.many.joins", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.reportProblem(psiElement, string);
                }
            }

            private final void reportProblem(PsiElement anchor, @InspectionMessage String message) {
                this.addDescriptor(this.myManager.createProblemDescriptor(anchor, message, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
            }

            private static final boolean visitSqlQueryExpression$lambda$0(PsiElement it) {
                return it instanceof SqlJoinExpression || it instanceof SqlParenthesizedExpression;
            }

            private static final boolean visitSqlQueryExpression$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.number((String)"maxJoinCount", (String)SqlBundle.message((String)"inspection.join.count.dropdown.label.report", (Object[])new Object[0]), (int)1, (int)Integer.MAX_VALUE)};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }
}

