/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsDefaults;
import org.jetbrains.letsPlot.core.plot.base.geom.CrossBarGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.util.BoxHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.FlippableGeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .2\u00020\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0002J0\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J&\u0010&\u001a\u0010\u0012\u0004\u0012\u00020(\u0012\u0006\u0012\u0004\u0018\u00010\u00170'2\u0006\u0010$\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006/"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "isVertical", "", "(Z)V", "fattenMidline", "", "getFattenMidline", "()D", "setFattenMidline", "(D)V", "flipHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/FlippableGeomHelper;", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "wontRender", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "getWontRender", "()Ljava/util/List;", "afterRotation", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "rectangle", "aes", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "clientRectByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "updateAestheticsDefaults", "Lorg/jetbrains/letsPlot/core/plot/base/aes/AestheticsDefaults;", "aestheticDefaults", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nCrossBarGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrossBarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1549#2:122\n1620#2,3:123\n1549#2:126\n1620#2,3:127\n*S KotlinDebug\n*F\n+ 1 CrossBarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom\n*L\n32#1:122\n32#1:123,3\n76#1:126\n76#1:127,3\n*E\n"})
public final class CrossBarGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isVertical;
    @NotNull
    private final FlippableGeomHelper flipHelper;
    private double fattenMidline;
    public static final boolean HANDLES_GROUPS = false;
    @NotNull
    private static final LegendKeyElementFactory LEGEND_FACTORY = BoxHelper.INSTANCE.legendFactory(false);

    public CrossBarGeom(boolean isVertical) {
        this.isVertical = isVertical;
        this.flipHelper = new FlippableGeomHelper(this.isVertical);
        this.fattenMidline = 2.5;
    }

    public final double getFattenMidline() {
        return this.fattenMidline;
    }

    public final void setFattenMidline(double d) {
        this.fattenMidline = d;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return LEGEND_FACTORY;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Aes<?>> getWontRender() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Aes[]{Aes.Companion.getXMIN(), Aes.Companion.getXMAX()};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Aes aes2 = (Aes)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.afterRotation((Aes<Double>)p0));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public AestheticsDefaults updateAestheticsDefaults(@NotNull AestheticsDefaults aestheticDefaults) {
        Intrinsics.checkNotNullParameter((Object)aestheticDefaults, (String)"aestheticDefaults");
        return this.isVertical ? aestheticDefaults.with(Aes.Companion.getY(), Double.NaN) : aestheticDefaults.with(Aes.Companion.getX(), Double.NaN);
    }

    private final Aes<Double> afterRotation(Aes<Double> aes2) {
        return this.flipHelper.getEffectiveAes(aes2);
    }

    private final DoubleRectangle afterRotation(DoubleRectangle rectangle) {
        return this.flipHelper.flip(rectangle);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        BoxHelper.INSTANCE.buildBoxes(root, aesthetics2, pos, coord, ctx2, this.clientRectByDataPoint(ctx2, geomHelper));
        BoxHelper.INSTANCE.buildMidlines(root, aesthetics2, this.afterRotation(Aes.Companion.getX()), this.afterRotation(Aes.Companion.getY()), Aes.Companion.getWIDTH(), ctx2, geomHelper, this.fattenMidline, !this.isVertical);
        Object object = new Aes[]{Aes.Companion.getYMIN(), Aes.Companion.getY(), Aes.Companion.getYMAX()};
        object = CollectionsKt.listOf((Object[])object);
        FlippableGeomHelper flippableGeomHelper = this.flipHelper;
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Aes aes2 = (Aes)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.afterRotation((Aes<Double>)p0));
        }
        FlippableGeomHelper.buildHints$default(flippableGeomHelper, (List)destination$iv$iv, aesthetics2, pos, coord, ctx2, this.clientRectByDataPoint(ctx2, geomHelper), buildIntern.2.INSTANCE, null, TipLayoutHint.Kind.CURSOR_TOOLTIP, 128, null);
    }

    private final Function1<DataPointAesthetics, DoubleRectangle> clientRectByDataPoint(GeomContext ctx2, GeomHelper geomHelper) {
        Aes<Double> xAes = this.afterRotation(Aes.Companion.getX());
        Aes<Double> yAes = this.afterRotation(Aes.Companion.getY());
        Aes<Double> yMinAes = this.afterRotation(Aes.Companion.getYMIN());
        Aes<Double> yMaxAes = this.afterRotation(Aes.Companion.getYMAX());
        Aes<Double> widthAes = Aes.Companion.getWIDTH();
        return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(xAes, yMinAes, yMaxAes, widthAes, ctx2, geomHelper, this){
            final /* synthetic */ Aes<Double> $xAes;
            final /* synthetic */ Aes<Double> $yMinAes;
            final /* synthetic */ Aes<Double> $yMaxAes;
            final /* synthetic */ Aes<Double> $widthAes;
            final /* synthetic */ GeomContext $ctx;
            final /* synthetic */ GeomHelper $geomHelper;
            final /* synthetic */ CrossBarGeom this$0;
            {
                this.$xAes = $xAes;
                this.$yMinAes = $yMinAes;
                this.$yMaxAes = $yMaxAes;
                this.$widthAes = $widthAes;
                this.$ctx = $ctx;
                this.$geomHelper = $geomHelper;
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final DoubleRectangle invoke(@NotNull DataPointAesthetics p) {
                DoubleRectangle doubleRectangle;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                DoubleRectangle doubleRectangle2 = CrossBarGeom.access$clientRectByDataPoint$factory(this.$xAes, this.$yMinAes, this.$yMaxAes, this.$widthAes, this.$ctx, p);
                if (doubleRectangle2 != null) {
                    DoubleRectangle doubleRectangle3 = doubleRectangle2;
                    GeomHelper geomHelper = this.$geomHelper;
                    CrossBarGeom crossBarGeom = this.this$0;
                    DoubleRectangle rect2 = doubleRectangle3;
                    boolean bl = false;
                    doubleRectangle = geomHelper.toClient(CrossBarGeom.access$afterRotation(crossBarGeom, rect2), p);
                } else {
                    doubleRectangle = null;
                }
                return doubleRectangle;
            }
        };
    }

    private static final DoubleRectangle clientRectByDataPoint$factory(Aes<Double> xAes, Aes<Double> yMinAes, Aes<Double> yMaxAes, Aes<Double> widthAes, GeomContext $ctx, DataPointAesthetics p) {
        Double d = p.finiteOrNull(xAes);
        if (d == null) {
            return null;
        }
        double x2 = d;
        Double d2 = p.finiteOrNull(yMinAes);
        if (d2 == null) {
            return null;
        }
        double ymin = d2;
        Double d3 = p.finiteOrNull(yMaxAes);
        if (d3 == null) {
            return null;
        }
        double ymax = d3;
        Double d4 = p.finiteOrNull(widthAes);
        if (d4 == null) {
            return null;
        }
        double w = d4;
        double width2 = w * $ctx.getResolution(xAes);
        DoubleVector origin = new DoubleVector(x2 - width2 / (double)2, ymin);
        DoubleVector dimension = new DoubleVector(width2, ymax - ymin);
        return new DoubleRectangle(origin, dimension);
    }

    public static final /* synthetic */ DoubleRectangle access$clientRectByDataPoint$factory(Aes xAes, Aes yMinAes, Aes yMaxAes, Aes widthAes, GeomContext $ctx, DataPointAesthetics p) {
        return CrossBarGeom.clientRectByDataPoint$factory(xAes, yMinAes, yMaxAes, widthAes, $ctx, p);
    }

    public static final /* synthetic */ DoubleRectangle access$afterRotation(CrossBarGeom $this, DoubleRectangle rectangle) {
        return $this.afterRotation(rectangle);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "LEGEND_FACTORY", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

