/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.packages.ninja.endpoints;

import com.intellij.microservices.url.UrlConstants;
import com.intellij.psi.util.QualifiedName;
import com.intellij.python.django.packages.ninja.NinjaFQNamesProvider;
import com.intellij.python.endpoints.CommonKt;
import com.intellij.python.endpoints.HttpHandler;
import com.intellij.python.endpoints.ObjectUID;
import com.intellij.python.endpoints.PsiFileAnchor;
import com.intellij.python.endpoints.RouterAttachment;
import com.intellij.python.endpoints.RouterIndexKt;
import com.intellij.python.endpoints.Variable;
import com.intellij.python.endpoints.VariablesCallsVisitor;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J.\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/python/django/packages/ninja/endpoints/NinjaVariablesCallsVisitor;", "Lcom/intellij/python/endpoints/VariablesCallsVisitor;", "variables", "", "", "Lcom/intellij/python/endpoints/Variable;", "<init>", "(Ljava/util/Map;)V", "onIncludeRouter", "", "objectUID", "Lcom/intellij/python/endpoints/ObjectUID;", "node", "Lcom/jetbrains/python/psi/PyCallExpression;", "onHttpHandler", "Lcom/jetbrains/python/psi/PyDecorator;", "httpMethods", "", "isApiOperationMethod", "", "visitPyCallExpression", "visitPyDecorator", "intellij.python.django"})
@SourceDebugExtension(value={"SMAP\nNinjaRouterIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NinjaRouterIndex.kt\ncom/intellij/python/django/packages/ninja/endpoints/NinjaVariablesCallsVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,79:1\n1#2:80\n1#2:91\n11476#3,9:81\n13402#3:90\n13403#3:92\n11485#3:93\n*S KotlinDebug\n*F\n+ 1 NinjaRouterIndex.kt\ncom/intellij/python/django/packages/ninja/endpoints/NinjaVariablesCallsVisitor\n*L\n51#1:91\n51#1:81,9\n51#1:90\n51#1:92\n51#1:93\n*E\n"})
public final class NinjaVariablesCallsVisitor
extends VariablesCallsVisitor {
    public NinjaVariablesCallsVisitor(@NotNull Map<String, Variable> variables) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        super(variables);
    }

    private final void onIncludeRouter(ObjectUID objectUID, PyCallExpression node) {
        PyReferenceExpression pyReferenceExpression = (PyReferenceExpression)node.getArgument(0, "router", PyReferenceExpression.class);
        if (pyReferenceExpression == null) {
            return;
        }
        PyReferenceExpression router = pyReferenceExpression;
        QualifiedName qualifiedName = router.asQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        QualifiedName refName = qualifiedName;
        Variable variable = (Variable)this.getVariables().get(refName.getFirstComponent());
        if (variable == null || (variable = variable.getObjectUID()) == null) {
            return;
        }
        Variable refObjectUID = variable;
        String string = CommonKt.resolveStringArgument$default((PyCallExpression)node, null, (String)"prefix", (int)1, null);
        if (string == null) {
            string = "";
        }
        String prefix = string;
        PsiFileAnchor psiFileAnchor = RouterIndexKt.toPsiFileAnchor((PyElement)((PyElement)router));
        PsiFileAnchor psiFileAnchor2 = RouterIndexKt.toPsiFileAnchor((PyElement)((PyElement)router));
        String string2 = refName.removeHead(1).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        RouterAttachment attachment = new RouterAttachment(psiFileAnchor, psiFileAnchor2, prefix, (ObjectUID)refObjectUID, string2, null, 32, null);
        this.getBuilder().addAttachment(objectUID, attachment);
    }

    private final void onHttpHandler(ObjectUID objectUID, PyDecorator node, List<String> httpMethods, boolean isApiOperationMethod) {
        String string = CommonKt.resolveStringArgument((PyCallExpression)((PyCallExpression)node), (Integer)(isApiOperationMethod ? 1 : 0), (String)"path");
        if (string == null) {
            return;
        }
        String path = string;
        HttpHandler httpHandler = new HttpHandler(path, httpMethods, RouterIndexKt.toPsiFileAnchor((PyElement)((PyElement)node)));
        this.getBuilder().addHttpHandler(objectUID, httpHandler);
    }

    public void visitPyCallExpression(@NotNull PyCallExpression node, @NotNull ObjectUID objectUID) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)objectUID, (String)"objectUID");
        FQNamesProvider[] fQNamesProviderArray = new FQNamesProvider[]{NinjaFQNamesProvider.ADD_ROUTER};
        if (NameResolverTools.isCalleeShortCut((PyCallExpression)node, (FQNamesProvider[])fQNamesProviderArray)) {
            this.onIncludeRouter(objectUID, node);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitPyDecorator(@NotNull PyDecorator node, @NotNull ObjectUID objectUID) {
        block8: {
            List list;
            Object methodName;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)objectUID, (String)"objectUID");
            Object object = node.getCallee();
            if (object == null || (object = object.getName()) == null) {
                return;
            }
            Object object2 = methodName = object;
            if (ArraysKt.contains((Object[])NinjaFQNamesProvider.API_OPERATION.getNames(), (Object)object2)) {
                PySequenceExpression methods;
                PySequenceExpression pySequenceExpression = methods = (PySequenceExpression)node.getArgument(0, "methods", PySequenceExpression.class);
                if (pySequenceExpression != null) {
                    void $this$mapNotNullTo$iv$iv;
                    PySequenceExpression arg = pySequenceExpression;
                    boolean bl = false;
                    PyExpression[] pyExpressionArray = arg.getElements();
                    Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getElements(...)");
                    Object[] $this$mapNotNull$iv = pyExpressionArray;
                    boolean $i$f$mapNotNull = false;
                    Object[] objectArray = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    int n = ((void)$this$forEach$iv$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        String it$iv$iv;
                        void element$iv$iv$iv;
                        void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                        boolean bl2 = false;
                        PyExpression it = (PyExpression)element$iv$iv;
                        boolean bl3 = false;
                        if (PyPsiUtils.strValue((PyExpression)it) == null) continue;
                        boolean bl4 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.emptyList();
                }
            } else {
                String string;
                String string2 = ((String)methodName).toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                String it = string = string2;
                boolean bl = false;
                String string3 = UrlConstants.HTTP_METHODS.contains(it) ? string : null;
                if (string3 != null) {
                    it = string3;
                    boolean bl5 = false;
                    list = CollectionsKt.listOf((Object)it);
                } else {
                    list = null;
                }
            }
            List httpMethods = list;
            boolean isApiOperationMethod = ArraysKt.contains((Object[])NinjaFQNamesProvider.API_OPERATION.getNames(), (Object)methodName);
            List list2 = httpMethods;
            if (list2 == null) break block8;
            List it = list2;
            boolean bl = false;
            this.onHttpHandler(objectUID, node, it, isApiOperationMethod);
        }
    }
}

