/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.qml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.qml.QmlElementTypes;
import com.intellij.lang.qml.psi.impl.QmlElementReferenceExpressionImpl;
import com.intellij.lang.qml.psi.impl.QmlEnumDeclarationImpl;
import com.intellij.lang.qml.psi.impl.QmlImportDeclarationImpl;
import com.intellij.lang.qml.psi.impl.QmlLocalImplicitElementImpl;
import com.intellij.lang.qml.psi.impl.QmlPropertyDeclarationImpl;
import com.intellij.lang.qml.search.usages.QmlFindUsagesHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QmlElementDeclarationImpl
extends JSElementImpl {
    private List<SmartPsiElementPointer<PsiElement>> myBaseProperties = null;
    private List<SmartPsiElementPointer<PsiElement>> myProperties = null;
    private SmartPsiElementPointer<PsiElement> myId = null;
    private String myLastName = null;
    private boolean myHasJsType = false;
    private JSType myLastJSType;
    private List<QmlLocalImplicitElementImpl> myNeighboursInFolder;
    private MessageBusConnection myConnection;

    public QmlElementDeclarationImpl(IElementType elementType) {
        super(elementType);
    }

    @Nullable
    public PsiFile getContainingFile() {
        return SharedImplUtil.getContainingFile((ASTNode)this);
    }

    @Nullable
    private static QmlElementDeclarationImpl getNearestElementDeclaration(PsiElement place) {
        while (place != null && !(place instanceof JSFile)) {
            JSBlockStatement block;
            PsiElement psiElement;
            if (!((place = place.getParent()) instanceof JSBlockStatement) || !((psiElement = (block = (JSBlockStatement)place).getParent()) instanceof QmlElementDeclarationImpl)) continue;
            QmlElementDeclarationImpl elementDeclaration = (QmlElementDeclarationImpl)psiElement;
            return elementDeclaration;
        }
        return null;
    }

    @Nullable
    public synchronized JSType getLastJsType() {
        if (this.myLastJSType == null) {
            this.updatePropertiesAndJsType();
        }
        return this.myLastJSType;
    }

    @Nullable
    public synchronized JSType getLastJsType(@NotNull HashSet<VirtualFile> visitedFiles) {
        VirtualFile virtualFile;
        if (visitedFiles == null) {
            QmlElementDeclarationImpl.$$$reportNull$$$0(0);
        }
        if ((virtualFile = this.getCurrentVirtualFile()) != null && visitedFiles.contains(virtualFile)) {
            return null;
        }
        if (this.myLastJSType == null) {
            this.updatePropertiesAndJsType(visitedFiles);
        }
        return this.myLastJSType;
    }

    @Nullable
    public static JSType getChildTypeFromParentElemDecl(@NotNull PsiElement currentElement, @NotNull String childName) {
        PsiElement parent;
        if (currentElement == null) {
            QmlElementDeclarationImpl.$$$reportNull$$$0(1);
        }
        if (childName == null) {
            QmlElementDeclarationImpl.$$$reportNull$$$0(2);
        }
        for (parent = currentElement.getParent(); parent != null && !(parent instanceof QmlElementDeclarationImpl) && !(parent instanceof PsiFile); parent = parent.getParent()) {
        }
        if (parent instanceof QmlElementDeclarationImpl) {
            QmlElementDeclarationImpl elemDeclParent = (QmlElementDeclarationImpl)parent;
            @Nullable List<SmartPsiElementPointer<PsiElement>> properties = elemDeclParent.getProperties();
            if (properties == null) {
                return null;
            }
            for (SmartPsiElementPointer<PsiElement> property : properties) {
                QmlLocalImplicitElementImpl qmlLocalImplicitElement;
                PsiElement psiElement = property.getElement();
                if (!(psiElement instanceof QmlLocalImplicitElementImpl) || !(qmlLocalImplicitElement = (QmlLocalImplicitElementImpl)psiElement).getName().equals(childName)) continue;
                return qmlLocalImplicitElement.getJSType();
            }
        }
        return null;
    }

    @Nullable
    public static JSType getChildType(@NotNull JSRecordType parent, @NotNull String childName) {
        if (parent == null) {
            QmlElementDeclarationImpl.$$$reportNull$$$0(3);
        }
        if (childName == null) {
            QmlElementDeclarationImpl.$$$reportNull$$$0(4);
        }
        for (JSRecordType.TypeMember member : parent.getTypeMembers()) {
            JSRecordType.PropertySignature propertyMember;
            if (!(member instanceof JSRecordType.PropertySignature) || !(propertyMember = (JSRecordType.PropertySignature)member).getMemberName().equals(childName)) continue;
            @Nullable JSType jsType = propertyMember.getJSType();
            return jsType instanceof JSRecordTypeImpl ? jsType : null;
        }
        return null;
    }

    @Nullable
    private VirtualFile getCurrentVirtualFile() {
        PsiFile file = this.getContainingFile();
        if (file == null) {
            return null;
        }
        @Nullable VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            virtualFile = file.getOriginalFile().getVirtualFile();
        }
        return virtualFile;
    }

    @Nullable
    private synchronized JSType getJsType(@NotNull HashSet<VirtualFile> visitedFiles) {
        PsiFile file;
        if (visitedFiles == null) {
            QmlElementDeclarationImpl.$$$reportNull$$$0(5);
        }
        if ((file = this.getContainingFile()) == null) {
            return null;
        }
        List imports = ContainerUtil.filter((Object[])file.getChildren(), elem -> elem instanceof QmlImportDeclarationImpl);
        List<PsiElement> kindElem = Arrays.stream(this.getChildren()).filter(elem -> elem instanceof QmlElementReferenceExpressionImpl).toList();
        if (kindElem.isEmpty()) {
            return null;
        }
        String elementKindString = kindElem.get(0).getText();
        if (this.getFirstChild().getNode().getElementType().equals(JSTokenTypes.COMPONENT_KEYWORD)) {
            if (kindElem.size() < 2) {
                return null;
            }
            elementKindString = kindElem.get(1).getText();
        }
        for (PsiElement imp : imports) {
            QmlImportDeclarationImpl.QmlComponentTemplate jsType = ((QmlImportDeclarationImpl)imp).getComponent(elementKindString);
            if (jsType == null) continue;
            return jsType.getJSType();
        }
        @Nullable JSType groupPropertyType = QmlElementDeclarationImpl.getChildTypeFromParentElemDecl((PsiElement)this, elementKindString);
        if (groupPropertyType != null) {
            return groupPropertyType;
        }
        this.initNeighboursInFolderWhenNeeded(file);
        for (int i = 0; i < this.myNeighboursInFolder.size(); ++i) {
            Optional<VirtualFile> neighbourFile;
            VirtualFile virtualFile;
            QmlLocalImplicitElementImpl neighbour = this.myNeighboursInFolder.get(i);
            if (!neighbour.getName().equals(elementKindString)) continue;
            @Nullable JSType type = neighbour.getJSType();
            if (type == null && (virtualFile = this.getCurrentVirtualFile()) != null && (neighbourFile = Arrays.stream(virtualFile.getParent().getChildren()).filter(vFile -> vFile.getName().equals(neighbour.getName() + ".qml")).findFirst()).isPresent()) {
                visitedFiles.add(virtualFile);
                @Nullable QmlLocalImplicitElementImpl updatedNeighbour = QmlImportDeclarationImpl.createImplicitElementFromFile(QmlImportDeclarationImpl.readQmlFile(neighbourFile.get(), this.getProject()), true, visitedFiles);
                if (updatedNeighbour != null) {
                    this.myNeighboursInFolder.set(i, updatedNeighbour);
                    type = updatedNeighbour.getJSType();
                    this.myBaseProperties = null;
                }
            }
            return type;
        }
        return null;
    }

    private boolean arePropertiesUninitialized() {
        return this.myBaseProperties == null && this.getContainingFile() != null;
    }

    private synchronized void initNeighboursInFolderWhenNeeded(PsiFile containingFile) {
        VirtualFile currentVirtualFile;
        if (this.myNeighboursInFolder != null) {
            return;
        }
        if (this.myConnection == null && (currentVirtualFile = this.getCurrentVirtualFile()) != null) {
            Disposable disposable = Disposer.newDisposable();
            this.myConnection = this.getProject().getMessageBus().connect(disposable);
            this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                    if (events == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    for (VFileEvent vFileEvent : events) {
                        @Nullable VirtualFile file = vFileEvent.getFile();
                        if (file == null || vFileEvent instanceof VFileContentChangeEvent || !"qml".equals(file.getExtension()) || currentVirtualFile.getName().equals(file.getName())) continue;
                        1 var5_5 = this;
                        synchronized (var5_5) {
                            QmlElementDeclarationImpl.this.myNeighboursInFolder = null;
                            break;
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/lang/qml/psi/impl/QmlElementDeclarationImpl$1", "after"));
                }
            });
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void documentChanged(@NotNull DocumentEvent event) {
                    VirtualFile file;
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if ((file = FileDocumentManager.getInstance().getFile(event.getDocument())) == null) {
                        return;
                    }
                    if ("qml".equals(file.getExtension()) && !currentVirtualFile.getName().equals(file.getName())) {
                        2 var3_3 = this;
                        synchronized (var3_3) {
                            QmlElementDeclarationImpl.this.myNeighboursInFolder = null;
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/qml/psi/impl/QmlElementDeclarationImpl$2", "documentChanged"));
                }
            }, disposable);
        }
        this.myNeighboursInFolder = new ArrayList<QmlLocalImplicitElementImpl>();
        this.myBaseProperties = null;
        @Nullable VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            virtualFile = containingFile.getOriginalFile().getVirtualFile();
        }
        if (virtualFile != null) {
            List<VirtualFile> allQmlFiles = Arrays.stream(virtualFile.getParent().getChildren()).filter(vFile -> vFile.getName().endsWith(".qml")).toList();
            @NotNull @NlsSafe String currentFile = PathUtil.getFileName((String)virtualFile.getPath());
            for (VirtualFile qmlFile : allQmlFiles) {
                QmlLocalImplicitElementImpl item;
                if (qmlFile.getName().equals(currentFile) || (item = QmlImportDeclarationImpl.createImplicitElementFromFile(QmlImportDeclarationImpl.readQmlFile(qmlFile, this.getProject()), false)) == null) continue;
                this.myNeighboursInFolder.add(item);
            }
        }
    }

    private static boolean isNestedAfterDot(@NotNull PsiElement place) {
        PsiElement psiElement;
        if (place == null) {
            QmlElementDeclarationImpl.$$$reportNull$$$0(6);
        }
        if ((psiElement = place.getParent()) instanceof QmlElementReferenceExpressionImpl) {
            QmlElementReferenceExpressionImpl nestedStatement = (QmlElementReferenceExpressionImpl)psiElement;
            return !nestedStatement.getFirstChild().equals(place);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        Object object;
        if (processor == null) {
            QmlElementDeclarationImpl.$$$reportNull$$$0(7);
        }
        if (state == null) {
            QmlElementDeclarationImpl.$$$reportNull$$$0(8);
        }
        if (place == null) {
            QmlElementDeclarationImpl.$$$reportNull$$$0(9);
        }
        if ((object = this.getParent()) instanceof JSFile) {
            JSFile containingFile = (JSFile)object;
            object = this;
            synchronized (object) {
                this.initNeighboursInFolderWhenNeeded((PsiFile)containingFile);
                for (QmlLocalImplicitElementImpl neighbour : this.myNeighboursInFolder) {
                    processor.execute((PsiElement)neighbour, state);
                }
            }
        }
        if (lastParent != null) {
            if (QmlElementDeclarationImpl.isNestedAfterDot(place)) {
                QmlElementDeclarationImpl anotherElemDecl = QmlFindUsagesHandler.Companion.findIdElementDeclarationFromNestedStatement((QmlElementReferenceExpressionImpl)place.getParent());
                if (anotherElemDecl != null) {
                    anotherElemDecl.processDeclarationsWithoutChecks(processor, state);
                } else {
                    QmlImportDeclarationImpl importFromAlias = QmlFindUsagesHandler.Companion.findImportDeclByAliasFromNestedStatement((QmlElementReferenceExpressionImpl)place.getParent());
                    if (importFromAlias != null) {
                        importFromAlias.processDeclarationsWithoutAliasCheck(processor, state, lastParent, place);
                    }
                }
                return super.processDeclarations(processor, state, lastParent, place);
            }
            if (QmlElementDeclarationImpl.getNearestElementDeclaration(place) != this) {
                return super.processDeclarations(processor, state, lastParent, place);
            }
            @Nullable ASTNode nameNode = this.getNode().findChildByType(QmlElementTypes.QML_ELEMENT_REFERENCE_EXPRESSION);
            if (nameNode == null || nameNode.getPsi() == null) {
                return super.processDeclarations(processor, state, lastParent, place);
            }
            this.processDeclarationsWithoutChecks(processor, state);
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    private synchronized void processDeclarationsWithoutChecks(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        QmlLocalImplicitElementImpl idElem;
        PsiElement psiElement;
        if (processor == null) {
            QmlElementDeclarationImpl.$$$reportNull$$$0(10);
        }
        if (state == null) {
            QmlElementDeclarationImpl.$$$reportNull$$$0(11);
        }
        this.updatePropertiesAndJsType();
        for (SmartPsiElementPointer<PsiElement> smartPsiElementPointer : this.myProperties) {
            QmlLocalImplicitElementImpl localImplicitElement;
            PsiElement psiElement2;
            if (smartPsiElementPointer == null || !((psiElement2 = smartPsiElementPointer.getElement()) instanceof QmlLocalImplicitElementImpl) || (localImplicitElement = (QmlLocalImplicitElementImpl)psiElement2).getParent() == null || !localImplicitElement.getParent().isValid()) continue;
            processor.execute((PsiElement)localImplicitElement, state);
        }
        if (this.myId != null && (psiElement = this.myId.getElement()) instanceof QmlLocalImplicitElementImpl && (idElem = (QmlLocalImplicitElementImpl)psiElement).getParent() != null && idElem.getParent().isValid()) {
            processor.execute((PsiElement)idElem, state);
        }
        for (PsiElement parent = this.getParent(); parent != null && !(parent instanceof PsiFile); parent = parent.getParent()) {
            QmlLocalImplicitElementImpl parentIdElem;
            PsiElement psiElement3;
            QmlElementDeclarationImpl qmlElementDeclarationImpl;
            SmartPsiElementPointer<PsiElement> parentId;
            if (!(parent instanceof QmlElementDeclarationImpl) || (parentId = (qmlElementDeclarationImpl = (QmlElementDeclarationImpl)parent).getId(true)) == null || !((psiElement3 = parentId.getElement()) instanceof QmlLocalImplicitElementImpl) || (parentIdElem = (QmlLocalImplicitElementImpl)psiElement3).getParent() == null || !parentIdElem.getParent().isValid()) continue;
            processor.execute((PsiElement)parentIdElem, state);
        }
    }

    private synchronized void updatePropertiesAndJsType() {
        this.updatePropertiesAndJsType(new HashSet<VirtualFile>());
    }

    @Nullable
    private static PsiElement getEnumIdentifier(@NotNull PsiElement enumElement) {
        PsiElement curElement;
        if (enumElement == null) {
            QmlElementDeclarationImpl.$$$reportNull$$$0(12);
        }
        if ((curElement = enumElement.getFirstChild()) == null) {
            return null;
        }
        if ((curElement = curElement.getNextSibling()) == null) {
            return null;
        }
        return curElement.getNextSibling();
    }

    private synchronized void updatePropertiesAndJsType(@NotNull HashSet<VirtualFile> visitedFiles) {
        QmlElementDeclarationImpl inlineElemDecl;
        List<SmartPsiElementPointer<PsiElement>> props;
        List matchingInlineComponent;
        ASTNode nameNode;
        if (visitedFiles == null) {
            QmlElementDeclarationImpl.$$$reportNull$$$0(13);
        }
        if ((nameNode = this.getNode().findChildByType(QmlElementTypes.QML_ELEMENT_REFERENCE_EXPRESSION)) == null || nameNode.getPsi() == null || this.getContainingFile() == null) {
            return;
        }
        List imports = ContainerUtil.filter((Object[])this.getContainingFile().getChildren(), elem -> elem instanceof QmlImportDeclarationImpl);
        JSType jsType = this.getJsType(visitedFiles);
        if (this.myLastName == null || !this.myLastName.equals(nameNode.getText()) || jsType == null == this.myHasJsType) {
            this.myLastName = nameNode.getText();
            this.myHasJsType = jsType != null;
            this.myBaseProperties = null;
        }
        List<PsiElement> blockElem = Arrays.stream(this.getChildren()).filter(elem -> elem instanceof JSBlockStatement).toList();
        if (this.arePropertiesUninitialized()) {
            this.myBaseProperties = new ArrayList<SmartPsiElementPointer<PsiElement>>();
            if (jsType instanceof JSRecordType) {
                JSRecordType recordType = (JSRecordType)jsType;
                block3: for (JSRecordType.TypeMember member : recordType.getTypeMembers()) {
                    Object provider;
                    Object srcElement;
                    if (member instanceof QmlImportDeclarationImpl.QmlPropertySignatureImpl) {
                        QmlImportDeclarationImpl.QmlPropertySignatureImpl property = (QmlImportDeclarationImpl.QmlPropertySignatureImpl)member;
                        switch (property.getKind()) {
                            case Property: 
                            case Signal: {
                                srcElement = property.getSource().getSourceElement();
                                provider = srcElement == null ? this : srcElement;
                                if (!provider.isValid()) continue block3;
                                this.myBaseProperties.add((SmartPsiElementPointer<PsiElement>)SmartPointerManager.createPointer((PsiElement)new QmlLocalImplicitElementImpl(property.getMemberName(), property.getJSType(), (PsiElement)provider, JSImplicitElement.Type.Property)));
                                break;
                            }
                        }
                        continue;
                    }
                    if (member instanceof QmlImportDeclarationImpl.QmlMethodSignatureImpl) {
                        QmlImportDeclarationImpl.QmlMethodSignatureImpl method = (QmlImportDeclarationImpl.QmlMethodSignatureImpl)member;
                        srcElement = method.getSource().getSourceElement();
                        provider = srcElement == null ? this : srcElement;
                        if (!provider.isValid()) continue;
                        this.myBaseProperties.add((SmartPsiElementPointer<PsiElement>)SmartPointerManager.createPointer((PsiElement)new QmlLocalImplicitElementImpl(method.getMemberName(), method.getJSType(), (PsiElement)provider, JSImplicitElement.Type.Method)));
                        continue;
                    }
                    if (!(member instanceof JSCompositeFunctionPropertySignatureImpl)) continue;
                    for (JSRecordType.TypeMember subMember : ((JSCompositeFunctionPropertySignatureImpl)member).getMembers()) {
                        QmlImportDeclarationImpl.QmlMethodSignatureImpl method;
                        PsiElement srcElement2;
                        QmlElementDeclarationImpl provider2;
                        if (!(subMember instanceof QmlImportDeclarationImpl.QmlMethodSignatureImpl) || !(provider2 = (srcElement2 = (method = (QmlImportDeclarationImpl.QmlMethodSignatureImpl)subMember).getSource().getSourceElement()) == null ? this : srcElement2).isValid()) continue;
                        this.myBaseProperties.add((SmartPsiElementPointer<PsiElement>)SmartPointerManager.createPointer((PsiElement)new QmlLocalImplicitElementImpl(method.getMemberName(), method.getJSType(), (PsiElement)provider2, JSImplicitElement.Type.Method)));
                    }
                }
            }
        }
        if (this.myBaseProperties == null) {
            return;
        }
        ArrayList<SmartPsiElementPointer<PsiElement>> allProperties = new ArrayList<SmartPsiElementPointer<PsiElement>>(this.myBaseProperties);
        ArrayList curTypeMembers = new ArrayList();
        if (jsType instanceof JSRecordType) {
            JSRecordType recordType = (JSRecordType)jsType;
            curTypeMembers.addAll(recordType.getTypeMembers());
        }
        if (!(jsType != null || this.getFirstChild().getNode().getElementType().equals(JSTokenTypes.COMPONENT_KEYWORD) || (matchingInlineComponent = ContainerUtil.filter((Object[])this.getParent().getChildren(), elem -> {
            if (elem instanceof QmlElementDeclarationImpl && elem.getFirstChild() != null && elem.getFirstChild().getNode().getElementType().equals(JSTokenTypes.COMPONENT_KEYWORD)) {
                @Nullable @Nullable ASTNode inlineComponentNameNode = elem.getNode().findChildByType(QmlElementTypes.QML_ELEMENT_REFERENCE_EXPRESSION);
                return inlineComponentNameNode != null && inlineComponentNameNode.getText().equals(this.myLastName);
            }
            return false;
        })).isEmpty() || (props = (inlineElemDecl = (QmlElementDeclarationImpl)((Object)matchingInlineComponent.get(0))).getProperties()) == null || props.isEmpty())) {
            allProperties.addAll(props);
            @Nullable JSType inlineElemJsType = inlineElemDecl.getLastJsType();
            if (inlineElemJsType instanceof JSRecordType) {
                JSRecordType inlineElemRecordType = (JSRecordType)inlineElemJsType;
                curTypeMembers.addAll(inlineElemRecordType.getTypeMembers());
            }
        }
        if (!blockElem.isEmpty() && this.getContainingFile() != null) {
            Arrays.stream(blockElem.get(0).getChildren()).filter(elem -> elem instanceof QmlPropertyDeclarationImpl).forEach(elem -> {
                QmlPropertyDeclarationImpl propElem = (QmlPropertyDeclarationImpl)((Object)elem);
                @Nullable ASTNode typeNode = propElem.findChildByType(QmlElementTypes.QML_TYPE_REFERENCE_EXPRESSION);
                @Nullable ASTNode assignment = propElem.findChildByType((IElementType)JSStubElementTypes.ASSIGNMENT_EXPRESSION);
                if (typeNode == null) {
                    return;
                }
                ASTNode propName = null;
                if (assignment == null) {
                    ASTNode refExpr = propElem.findChildByType(JSElementTypes.REFERENCE_EXPRESSION);
                    if (refExpr != null) {
                        propName = refExpr.getFirstChildNode();
                    }
                } else {
                    propName = assignment.getFirstChildNode();
                }
                if (propName == null || propName.getPsi() == null || !propName.getPsi().isValid()) {
                    return;
                }
                String type = typeNode.getText();
                String propNameText = propName.getText();
                JSType propType = null;
                if (!type.equals("var")) {
                    for (PsiElement imp : imports) {
                        QmlImportDeclarationImpl.QmlComponentTemplate propTemplate = ((QmlImportDeclarationImpl)imp).getComponent(type);
                        if (propTemplate != null) {
                            propType = propTemplate.getJSType();
                            break;
                        }
                        propType = ((QmlImportDeclarationImpl)imp).getType(type);
                        if (propType == null) continue;
                        break;
                    }
                }
                allProperties.add(SmartPointerManager.createPointer((PsiElement)new QmlLocalImplicitElementImpl(propNameText, propType, propName.getPsi(), JSImplicitElement.Type.Property){}));
                @NotNull JSTypeSource propSource = JSTypeSourceFactory.createTypeSource((PsiElement)propName.getPsi(), (boolean)true);
                curTypeMembers.add(new QmlImportDeclarationImpl.QmlPropertySignatureImpl(propNameText, propSource, (Ref<JSType>)new Ref((Object)propType), QmlImportDeclarationImpl.QmlMember.Kind.Property));
                String eventName = "on" + StringUtil.capitalize((String)propNameText) + "Changed";
                allProperties.add(SmartPointerManager.createPointer((PsiElement)new QmlLocalImplicitElementImpl(eventName, null, propName.getPsi(), JSImplicitElement.Type.Property)));
                curTypeMembers.add(new QmlImportDeclarationImpl.QmlPropertySignatureImpl(eventName, propSource, (Ref<JSType>)new Ref(), QmlImportDeclarationImpl.QmlMember.Kind.Property));
            });
            Arrays.stream(blockElem.get(0).getChildren()).filter(elem -> elem instanceof QmlEnumDeclarationImpl).forEach(elem -> {
                PsiElement enumIdentifier = QmlElementDeclarationImpl.getEnumIdentifier(elem);
                if (enumIdentifier == null || !enumIdentifier.isValid()) {
                    return;
                }
                String enumTypeName = enumIdentifier.getText();
                List<PsiElement> enumMembers = Arrays.stream(elem.getChildren()).filter(e -> e instanceof QmlElementReferenceExpressionImpl).toList();
                Ref enumTypeRef = new Ref();
                ArrayList<QmlImportDeclarationImpl.QmlPropertySignatureImpl> enumTypeMembers = new ArrayList<QmlImportDeclarationImpl.QmlPropertySignatureImpl>();
                for (PsiElement enumMember : enumMembers) {
                    enumTypeMembers.add(new QmlImportDeclarationImpl.QmlPropertySignatureImpl(enumMember.getFirstChild().getText(), JSTypeSourceFactory.createTypeSource((PsiElement)enumMember, (boolean)true), (Ref<JSType>)enumTypeRef, QmlImportDeclarationImpl.QmlMember.Kind.EnumValue));
                }
                @NotNull JSTypeSource typeSrc = JSTypeSourceFactory.createTypeSource((PsiElement)enumIdentifier, (boolean)true);
                QmlImportDeclarationImpl.QmlRecordType enumJSType = new QmlImportDeclarationImpl.QmlRecordType(typeSrc, enumTypeMembers, enumTypeName, false);
                enumTypeRef.set((Object)enumJSType);
                allProperties.add(SmartPointerManager.createPointer((PsiElement)new QmlLocalImplicitElementImpl(enumTypeName, (JSType)enumJSType, enumIdentifier, JSImplicitElement.Type.Class)));
                for (int i = 0; i < enumTypeMembers.size(); ++i) {
                    PsiElement provider = enumMembers.get(i).getFirstChild();
                    if (provider == null || !provider.isValid()) continue;
                    QmlImportDeclarationImpl.QmlPropertySignatureImpl enumTypeMember = (QmlImportDeclarationImpl.QmlPropertySignatureImpl)((Object)((Object)enumTypeMembers.get(i)));
                    allProperties.add(SmartPointerManager.createPointer((PsiElement)new QmlLocalImplicitElementImpl(enumTypeMember.getMemberName(), (JSType)enumJSType, provider, JSImplicitElement.Type.Property)));
                    curTypeMembers.add(new QmlImportDeclarationImpl.QmlPropertySignatureImpl(enumTypeMember.getMemberName(), typeSrc, (Ref<JSType>)enumTypeRef, QmlImportDeclarationImpl.QmlMember.Kind.EnumValue));
                }
            });
            Arrays.stream(blockElem.get(0).getChildren()).filter(elem -> elem instanceof QmlElementDeclarationImpl && elem.getChildren().length > 2 && elem.getFirstChild().getNode().getElementType().equals(JSTokenTypes.COMPONENT_KEYWORD)).forEach(elem -> {
                @Nullable ASTNode nameElem = elem.getNode().findChildByType(QmlElementTypes.QML_ELEMENT_REFERENCE_EXPRESSION);
                if (nameElem != null && nameElem.getPsi() != null && nameElem.getPsi().isValid()) {
                    allProperties.add(SmartPointerManager.createPointer((PsiElement)new QmlLocalImplicitElementImpl(nameElem.getText(), null, nameElem.getPsi(), JSImplicitElement.Type.Class)));
                }
            });
            Arrays.stream(blockElem.get(0).getChildren()).filter(elem -> elem instanceof JSAssignmentExpression && elem.getChildren().length > 1 && elem.getFirstChild() instanceof QmlElementReferenceExpressionImpl && "id".equals(elem.getFirstChild().getText())).forEach(elem -> {
                QmlElementReferenceExpressionImpl idRefElement;
                PsiElement patt27388$temp;
                PsiElement jsVar;
                PsiElement varStatementPsi;
                @Nullable ASTNode varStatementElement = elem.getNode().findChildByType((IElementType)JSStubElementTypes.VAR_STATEMENT);
                if (varStatementElement != null && (varStatementPsi = varStatementElement.getPsi()) != null && (jsVar = varStatementPsi.getFirstChild()) != null && (patt27388$temp = jsVar.getFirstChild()) instanceof QmlElementReferenceExpressionImpl && (idRefElement = (QmlElementReferenceExpressionImpl)patt27388$temp).isValid()) {
                    this.myId = SmartPointerManager.createPointer((PsiElement)new QmlLocalImplicitElementImpl(idRefElement.getText(), null, (PsiElement)idRefElement, JSImplicitElement.Type.Property));
                }
            });
        }
        this.myProperties = allProperties;
        this.myLastJSType = new QmlImportDeclarationImpl.QmlRecordType(JSTypeSourceFactory.createTypeSource((PsiElement)this, (boolean)true), curTypeMembers, this.myLastName);
    }

    @Nullable
    public synchronized List<SmartPsiElementPointer<PsiElement>> getProperties() {
        if (this.myProperties == null) {
            this.updatePropertiesAndJsType();
        }
        return this.myProperties;
    }

    @Nullable
    public synchronized SmartPsiElementPointer<PsiElement> getId(boolean forceUpdate) {
        if (this.myProperties == null || forceUpdate) {
            this.updatePropertiesAndJsType();
        }
        return this.myId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentElement";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/qml/psi/impl/QmlElementDeclarationImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLastJsType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildTypeFromParentElemDecl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getJsType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isNestedAfterDot";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarations";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarationsWithoutChecks";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnumIdentifier";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePropertiesAndJsType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

