/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.testFramework.ErrorLog;
import com.intellij.testFramework.ErrorLogReportingKt;
import com.intellij.testFramework.LoggedError;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.util.ThrowableRunnable;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\u0004\u001a\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002H\u0000\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a-\u0010\f\u001a\u0002H\r\"\n\b\u0000\u0010\r\u0018\u0001*\u00020\u000e2\u000e\b\b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\u001a/\u0010\f\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\u00122\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0013\u00a2\u0006\u0002\u0010\u0014\u001a3\u0010\f\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\u00122\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0001\u00a2\u0006\u0002\u0010\u0015\u001a3\u0010\f\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u00a2\u0006\u0002\u0010\u0019\u001a\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0002\u001a!\u0010\u001b\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0007\u00a2\u0006\u0002\u0010\u001c\u001a\u0014\u0010\u001b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0007\u001a \u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u001a\u0014\u0010!\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0007\"\u0016\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\""}, d2={"tlErrorLog", "Ljava/lang/ThreadLocal;", "Lcom/intellij/testFramework/ErrorLog;", "withErrorLog", "Lcom/intellij/openapi/application/AccessToken;", "errorLog", "getErrorLog", "()Lcom/intellij/testFramework/ErrorLog;", "assertNoErrorLogged", "", "executable", "Ljava/lang/Runnable;", "assertErrorLogged", "T", "", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Throwable;", "clazz", "Ljava/lang/Class;", "Lcom/intellij/util/ThrowableRunnable;", "(Ljava/lang/Class;Lcom/intellij/util/ThrowableRunnable;)Ljava/lang/Throwable;", "(Ljava/lang/Class;Lkotlin/jvm/functions/Function0;)Ljava/lang/Throwable;", "errors", "", "Lcom/intellij/testFramework/LoggedError;", "(Ljava/lang/Class;Ljava/util/List;)Ljava/lang/Throwable;", "collectErrorsLoggedInTheCurrentThread", "recordErrorsLoggedInTheCurrentThreadAndReportThemAsFailures", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "rethrowLoggedErrors", "", "testFailure", "loggedErrors", "rethrowLoggedErrorsIn", "intellij.platform.testFramework.core"})
public final class TestLoggerKt {
    @NotNull
    private static final ThreadLocal<ErrorLog> tlErrorLog = new ThreadLocal();

    @NotNull
    public static final AccessToken withErrorLog(@Nullable ErrorLog errorLog) {
        return ThreadContext.withThreadLocal(tlErrorLog, arg_0 -> TestLoggerKt.withErrorLog$lambda$0(errorLog, arg_0));
    }

    @Nullable
    public static final ErrorLog getErrorLog() {
        return tlErrorLog.get();
    }

    public static final void assertNoErrorLogged(@NotNull Runnable executable) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        List<LoggedError> errors2 = TestLoggerKt.collectErrorsLoggedInTheCurrentThread((Function0<Unit>)((Function0)new Function0<Unit>((Object)executable){

            public final void invoke() {
                ((Runnable)this.receiver).run();
            }
        }));
        if (!((Collection)errors2).isEmpty()) {
            TestLoggerKt.rethrowLoggedErrors(null, errors2);
            throw new KotlinNothingValueException();
        }
    }

    public static final /* synthetic */ <T extends Throwable> T assertErrorLogged(Function0<Unit> executable) {
        Intrinsics.checkNotNullParameter(executable, (String)"executable");
        boolean $i$f$assertErrorLogged = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)TestLoggerKt.assertErrorLogged(Throwable.class, executable);
    }

    @NotNull
    public static final <T extends Throwable> T assertErrorLogged(@NotNull Class<T> clazz, @NotNull ThrowableRunnable<?> executable) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(executable, (String)"executable");
        return TestLoggerKt.assertErrorLogged(clazz, (Function0<Unit>)((Function0)new Function0<Unit>(executable){

            public final void invoke() {
                ((ThrowableRunnable)this.receiver).run();
            }
        }));
    }

    @PublishedApi
    @NotNull
    public static final <T extends Throwable> T assertErrorLogged(@NotNull Class<T> clazz, @NotNull Function0<Unit> executable) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(executable, (String)"executable");
        List<LoggedError> errors2 = TestLoggerKt.collectErrorsLoggedInTheCurrentThread(executable);
        return TestLoggerKt.assertErrorLogged(clazz, errors2);
    }

    private static final <T extends Throwable> T assertErrorLogged(Class<T> clazz, List<LoggedError> errors2) {
        TestLoggerFactory.TestLoggerAssertionError testLoggerAssertionError;
        switch (errors2.size()) {
            case 0: {
                throw new TestLoggerFactory.TestLoggerAssertionError("No errors were reported", null);
            }
            case 1: {
                Object object = Assertions.assertInstanceOf(clazz, (Object)((LoggedError)CollectionsKt.single(errors2)).getCause());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assertInstanceOf(...)");
                return (T)((Throwable)object);
            }
        }
        TestLoggerFactory.TestLoggerAssertionError it = testLoggerAssertionError = new TestLoggerFactory.TestLoggerAssertionError("Multiple errors were reported", null);
        boolean bl = false;
        for (LoggedError error : errors2) {
            ExceptionsKt.addSuppressed((Throwable)((Throwable)((Object)it)), (Throwable)error);
        }
        throw (Throwable)((Object)testLoggerAssertionError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<LoggedError> collectErrorsLoggedInTheCurrentThread(Function0<Unit> executable) {
        ErrorLog errorLog = new ErrorLog();
        AutoCloseable autoCloseable = (AutoCloseable)TestLoggerKt.withErrorLog(errorLog);
        Throwable throwable = null;
        try {
            AccessToken cfr_ignored_0 = (AccessToken)autoCloseable;
            boolean bl = false;
            executable.invoke();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return errorLog.takeLoggedErrors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static final <T> T recordErrorsLoggedInTheCurrentThreadAndReportThemAsFailures(@NotNull Function0<? extends T> executable) {
        Intrinsics.checkNotNullParameter(executable, (String)"executable");
        if (Intrinsics.areEqual((Object)System.getProperty("intellij.testFramework.rethrow.logged.errors"), (Object)"true")) {
            return (T)executable.invoke();
        }
        ErrorLog errorLog = new ErrorLog();
        try {
            Object object;
            AutoCloseable autoCloseable = (AutoCloseable)TestLoggerKt.withErrorLog(errorLog);
            Throwable throwable = null;
            try {
                AccessToken cfr_ignored_0 = (AccessToken)autoCloseable;
                boolean bl = false;
                object = executable.invoke();
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, throwable);
                    throw throwable3;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            Object object2 = object;
            return (T)object2;
        }
        finally {
            ErrorLogReportingKt.reportAsFailures(errorLog);
        }
    }

    @ApiStatus.Internal
    public static final void recordErrorsLoggedInTheCurrentThreadAndReportThemAsFailures(@NotNull ThrowableRunnable<?> executable) {
        Intrinsics.checkNotNullParameter(executable, (String)"executable");
        TestLoggerKt.recordErrorsLoggedInTheCurrentThreadAndReportThemAsFailures((Function0)new Function0<Unit>(executable){

            public final void invoke() {
                ((ThrowableRunnable)this.receiver).run();
            }
        });
    }

    private static final Void rethrowLoggedErrors(Throwable testFailure, List<LoggedError> loggedErrors) {
        Throwable throwable;
        if (!(!((Collection)loggedErrors).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (testFailure == null) {
            String message = loggedErrors.size() == 1 ? "Error was logged" : "Errors were logged";
            throwable = (Throwable)((Object)new TestLoggerFactory.TestLoggerAssertionError(message, null));
        } else {
            throwable = testFailure;
        }
        Throwable throwable2 = throwable;
        for (LoggedError loggedError : loggedErrors) {
            ExceptionsKt.addSuppressed((Throwable)throwable2, (Throwable)loggedError);
        }
        throw throwable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(message="Re-throwing from Logger.error() makes the test behaviour different from the production run")
    public static final void rethrowLoggedErrorsIn(@NotNull ThrowableRunnable<?> executable) throws Exception {
        Intrinsics.checkNotNullParameter(executable, (String)"executable");
        AutoCloseable autoCloseable = (AutoCloseable)TestLoggerKt.withErrorLog(null);
        Throwable throwable = null;
        try {
            AccessToken cfr_ignored_0 = (AccessToken)autoCloseable;
            boolean bl = false;
            executable.run();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final ErrorLog withErrorLog$lambda$0(ErrorLog $errorLog, ErrorLog it) {
        return $errorLog;
    }
}

