/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.debugger.CommandLineDebugConfigurator;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.execution.NodeBaseRunProfileState;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.testing.JSTestRunnerUtil;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetector;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.mocha.MochaUtil;
import com.jetbrains.nodejs.mocha.coverage.MochaCoverageRunState;
import com.jetbrains.nodejs.mocha.execution.MochaConsoleProperties;
import com.jetbrains.nodejs.mocha.execution.MochaDetector;
import com.jetbrains.nodejs.mocha.execution.MochaRunConfiguration;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettings;
import com.jetbrains.nodejs.mocha.execution.MochaTestKind;
import com.jetbrains.nodejs.util.NodeJsCodeLocator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaRunProfileState
implements NodeBaseRunProfileState {
    private final Project myProject;
    private final MochaRunConfiguration myRunConfiguration;
    private final ExecutionEnvironment myEnv;
    private final NodePackage myMochaPackage;
    private final MochaRunSettings myRunSettings;
    private final MochaCoverageRunState myCoverageRunState;
    private List<List<String>> myRerunActionFailedTests;

    public MochaRunProfileState(@NotNull Project project, @NotNull MochaRunConfiguration runConfiguration, @NotNull ExecutionEnvironment env, @NotNull NodePackage mochaPackage, @NotNull MochaRunSettings runSettings) {
        if (project == null) {
            MochaRunProfileState.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            MochaRunProfileState.$$$reportNull$$$0(1);
        }
        if (env == null) {
            MochaRunProfileState.$$$reportNull$$$0(2);
        }
        if (mochaPackage == null) {
            MochaRunProfileState.$$$reportNull$$$0(3);
        }
        if (runSettings == null) {
            MochaRunProfileState.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
        this.myEnv = env;
        this.myMochaPackage = mochaPackage;
        this.myRunSettings = runSettings;
        this.myCoverageRunState = MochaCoverageRunState.create(env, this.myMochaPackage, runSettings);
    }

    @NotNull
    public ProcessHandler startProcess(@Nullable CommandLineDebugConfigurator configurator) throws ExecutionException {
        NodeJsInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveNotNull(this.myProject);
        NodeTargetRun targetRun = new NodeTargetRun(interpreter, this.myProject, configurator, NodeTargetRunOptions.of((Boolean)NodeTargetRunOptions.shouldUsePtyForTestRunners(), (RunConfigurationBase)this.myRunConfiguration));
        this.configureCommandLine(targetRun, configurator != null);
        ProcessHandler processHandler = targetRun.startProcess();
        if (processHandler == null) {
            MochaRunProfileState.$$$reportNull$$$0(5);
        }
        return processHandler;
    }

    @NotNull
    public ExecutionResult createExecutionResult(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            MochaRunProfileState.$$$reportNull$$$0(6);
        }
        MochaConsoleProperties consoleProperties = this.myRunConfiguration.createTestConsoleProperties(this.myEnv.getExecutor(), this.myRunSettings.getUi(), NodeCommandLineUtil.shouldUseTerminalConsole((ProcessHandler)processHandler));
        File workingDir = StringUtil.isEmpty((String)this.myRunSettings.getWorkingDir()) ? null : new File(this.myRunSettings.getWorkingDir());
        ConsoleView consoleView = this.createSMTRunnerConsoleView(workingDir, consoleProperties);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        consoleView.attachToProcess(processHandler);
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, processHandler);
        executionResult.setRestartActions(new AnAction[]{consoleProperties.createRerunFailedTestsAction(consoleView)});
        DefaultExecutionResult defaultExecutionResult = executionResult;
        if (defaultExecutionResult == null) {
            MochaRunProfileState.$$$reportNull$$$0(7);
        }
        return defaultExecutionResult;
    }

    @NotNull
    private ConsoleView createSMTRunnerConsoleView(@Nullable File workingDirectory, @NotNull MochaConsoleProperties consoleProperties) {
        if (consoleProperties == null) {
            MochaRunProfileState.$$$reportNull$$$0(8);
        }
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createConsole((String)consoleProperties.getTestFrameworkName(), (TestConsoleProperties)consoleProperties);
        consoleProperties.addStackTraceFilter((Filter)new NodeStackTraceFilter(this.myProject, workingDirectory));
        for (Filter filter : consoleProperties.getStackTrackFilters()) {
            consoleView.addMessageFilter(filter);
        }
        consoleView.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(this.myProject, workingDirectory));
        BaseTestsOutputConsoleView baseTestsOutputConsoleView = consoleView;
        if (baseTestsOutputConsoleView == null) {
            MochaRunProfileState.$$$reportNull$$$0(9);
        }
        return baseTestsOutputConsoleView;
    }

    private void configureCommandLine(@NotNull NodeTargetRun targetRun, boolean debugMode) throws ExecutionException {
        String grepPattern;
        if (targetRun == null) {
            MochaRunProfileState.$$$reportNull$$$0(10);
        }
        TargetedCommandLineBuilder commandLine = targetRun.getCommandLineBuilder();
        if (!StringUtil.isEmptyOrSpaces((String)this.myRunSettings.getWorkingDir())) {
            commandLine.setWorkingDirectory(targetRun.path(this.myRunSettings.getWorkingDir()));
        }
        targetRun.setEnvData(this.myRunSettings.getEnvData());
        boolean separateMochaArgs = false;
        if (this.myCoverageRunState != null) {
            separateMochaArgs = this.myCoverageRunState.configure(targetRun);
        }
        if (this.myMochaPackage instanceof YarnPnpNodePackage) {
            Pair binaryInfo = (Pair)ContainerUtil.getFirstItem(MochaRunProfileState.getBinaryInfos(this.myMochaPackage));
            String binaryName = Objects.requireNonNull(binaryInfo != null ? (String)binaryInfo.first : null, "mocha");
            ((YarnPnpNodePackage)this.myMochaPackage).addYarnRunToCommandLine(targetRun, binaryName, true);
        } else {
            Path mainEntryFile = MochaRunProfileState.doGetMochaMainJsFile(targetRun.getInterpreter(), this.myMochaPackage);
            commandLine.addParameter(targetRun.path(mainEntryFile));
        }
        if (MochaUtil.isVueCliService(this.myMochaPackage)) {
            commandLine.addParameter("test:unit");
        }
        targetRun.addNodeOptionsWithExpandedMacros(false, this.myRunSettings.getNodeOptions());
        if (separateMochaArgs) {
            commandLine.addParameter("--");
        }
        List extraMochaOptionList = ParametersListUtil.parse((String)this.myRunSettings.getExtraMochaOptions().trim());
        commandLine.addParameters(extraMochaOptionList);
        if (debugMode) {
            commandLine.addParameter("--timeout");
            commandLine.addParameter("0");
        }
        commandLine.addParameter("--ui");
        commandLine.addParameter(this.myRunSettings.getUi());
        targetRun.path(MochaRunProfileState.getMochaReporterRootDir());
        commandLine.addParameter("--reporter");
        commandLine.addParameter(targetRun.path(MochaRunProfileState.getMochaReporterFile()));
        MochaTestKind testKind = this.myRunSettings.getTestKind();
        if (MochaTestKind.DIRECTORY == testKind) {
            commandLine.addParameter(FileUtil.toSystemDependentName((String)this.myRunSettings.getTestDirPath()));
            if (this.myRunSettings.isRecursive()) {
                commandLine.addParameter("--recursive");
            }
        } else if (MochaTestKind.PATTERN == testKind) {
            String pattern = this.myRunSettings.getTestFilePattern();
            if (!StringUtil.isEmptyOrSpaces((String)pattern)) {
                commandLine.addParameters(ParametersList.parse((String)NodeInterpreterUtil.toRemoteName((String)pattern, (NodeTargetRun)targetRun)));
            }
        } else if (MochaTestKind.TEST_FILE == testKind || MochaTestKind.SUITE == testKind || MochaTestKind.TEST == testKind) {
            commandLine.addParameter(targetRun.path(this.myRunSettings.getTestFilePath()));
        }
        if ((grepPattern = this.getGrepPattern(testKind)) != null) {
            commandLine.addParameter("--grep");
            commandLine.addParameter(grepPattern);
        }
    }

    @Nullable
    private String getGrepPattern(@NotNull MochaTestKind testKind) {
        if (testKind == null) {
            MochaRunProfileState.$$$reportNull$$$0(11);
        }
        if (this.myRerunActionFailedTests != null) {
            return JSTestRunnerUtil.getTestsPattern(this.myRerunActionFailedTests, (boolean)false);
        }
        if (MochaTestKind.SUITE == testKind) {
            return JSTestRunnerUtil.buildTestNamesPattern((Project)this.myProject, (JsTestFrameworkDetector)MochaDetector.Companion.getInstance(), (String)this.myRunSettings.getTestFilePath(), this.myRunSettings.getSuiteNames(), (boolean)true);
        }
        if (MochaTestKind.TEST == testKind) {
            return JSTestRunnerUtil.buildTestNamesPattern((Project)this.myProject, (JsTestFrameworkDetector)MochaDetector.Companion.getInstance(), (String)this.myRunSettings.getTestFilePath(), this.myRunSettings.getTestNames(), (boolean)false);
        }
        return null;
    }

    @NotNull
    public MochaRunSettings getRunSettings() {
        MochaRunSettings mochaRunSettings = this.myRunSettings;
        if (mochaRunSettings == null) {
            MochaRunProfileState.$$$reportNull$$$0(12);
        }
        return mochaRunSettings;
    }

    @Nullable
    public MochaCoverageRunState getCoverageRunState() {
        return this.myCoverageRunState;
    }

    public void setFailedTests(@NotNull List<List<String>> rerunActionFailedTests) {
        if (rerunActionFailedTests == null) {
            MochaRunProfileState.$$$reportNull$$$0(13);
        }
        this.myRerunActionFailedTests = rerunActionFailedTests;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static File getMochaMainJsFile(@NotNull NodeJsInterpreter interpreter, @NotNull NodePackage mochaPackage) throws ExecutionException {
        if (interpreter == null) {
            MochaRunProfileState.$$$reportNull$$$0(14);
        }
        if (mochaPackage == null) {
            MochaRunProfileState.$$$reportNull$$$0(15);
        }
        File file = MochaRunProfileState.doGetMochaMainJsFile(interpreter, mochaPackage).toFile();
        if (file == null) {
            MochaRunProfileState.$$$reportNull$$$0(16);
        }
        return file;
    }

    @NotNull
    private static Path doGetMochaMainJsFile(@NotNull NodeJsInterpreter interpreter, @NotNull NodePackage mochaPackage) throws ExecutionException {
        Path mainJsFile;
        String packageName;
        if (interpreter == null) {
            MochaRunProfileState.$$$reportNull$$$0(17);
        }
        if (mochaPackage == null) {
            MochaRunProfileState.$$$reportNull$$$0(18);
        }
        if ("electron-mocha".equals(packageName = mochaPackage.getName()) && Files.isRegularFile(mainJsFile = interpreter instanceof NodeJsLocalInterpreter && ((NodeJsLocalInterpreter)interpreter).isElectron() ? Path.of(mochaPackage.getSystemDependentPath(), "index.js") : Path.of(mochaPackage.getSystemDependentPath(), "bin", "electron-mocha"), new LinkOption[0])) {
            Path path = mainJsFile;
            if (path == null) {
                MochaRunProfileState.$$$reportNull$$$0(19);
            }
            return path;
        }
        List<Pair<String, String>> binaries = MochaRunProfileState.getBinaryInfos(mochaPackage);
        for (Pair<String, String> binary : binaries) {
            Path mainJsFile2 = mochaPackage.findBinFilePath((String)binary.first, (String)binary.second);
            if (mainJsFile2 == null || !Files.isRegularFile(mainJsFile2, new LinkOption[0])) continue;
            Path path = mainJsFile2;
            if (path == null) {
                MochaRunProfileState.$$$reportNull$$$0(20);
            }
            return path;
        }
        throw new ExecutionException(NodeJSBundle.message("rc.mocha.package_bin_file_not_found.message", packageName));
    }

    @NotNull
    private static List<Pair<String, String>> getBinaryInfos(@NotNull NodePackage mochaPackage) {
        if (mochaPackage == null) {
            MochaRunProfileState.$$$reportNull$$$0(21);
        }
        String packageName = mochaPackage.getName();
        String guessedBinaryName = PackageJsonUtil.guessDefaultBinaryNameOfDependency((NodePackage)mochaPackage);
        Pair predefinedBinaryInfo = MochaUtil.isVueCliService(mochaPackage) ? Pair.create((Object)"vue-cli-service", (Object)"bin/vue-cli-service.js") : ("mocha-webpack".equals(packageName) ? Pair.create((Object)"mocha-webpack", (Object)"bin/mocha-webpack") : ("mocha".equals(packageName) ? Pair.create((Object)"mocha", (Object)"bin/mocha") : Pair.create((Object)guessedBinaryName, null)));
        if (guessedBinaryName.equals(predefinedBinaryInfo.first)) {
            List<Pair<String, String>> list = List.of(predefinedBinaryInfo);
            if (list == null) {
                MochaRunProfileState.$$$reportNull$$$0(22);
            }
            return list;
        }
        List<Pair<String, String>> list = List.of(predefinedBinaryInfo, Pair.create((Object)guessedBinaryName, null));
        if (list == null) {
            MochaRunProfileState.$$$reportNull$$$0(23);
        }
        return list;
    }

    public void configureDebugProcess(@NotNull XDebugProcess process) {
        if (process == null) {
            MochaRunProfileState.$$$reportNull$$$0(24);
        }
        JavaScriptDebugProcess javaScriptDebugProcess = (JavaScriptDebugProcess)process;
        javaScriptDebugProcess.getConnection().executeOnStart(vm -> {
            javaScriptDebugProcess.addFirstLineBreakpointPattern(".*/dist/.*/main\\.js$");
            return null;
        });
    }

    @NotNull
    private static Path getMochaReporterRootDir() throws ExecutionException {
        Path path;
        try {
            path = NodeJsCodeLocator.getFileRelativeToJsDir("mocha-intellij/lib");
        }
        catch (IOException e) {
            throw new ExecutionException(NodeJSBundle.message("rc.mocha.intellij_mocha_reporter_not_found.message", new Object[0]), (Throwable)e);
        }
        if (path == null) {
            MochaRunProfileState.$$$reportNull$$$0(25);
        }
        return path;
    }

    @NotNull
    private static Path getMochaReporterFile() throws ExecutionException {
        Path path;
        try {
            path = NodeJsCodeLocator.getFileRelativeToJsDir("mocha-intellij/lib/mochaIntellijReporter.js");
        }
        catch (IOException e) {
            throw new ExecutionException(NodeJSBundle.message("rc.mocha.intellij_mocha_reporter_not_found.message", new Object[0]), (Throwable)e);
        }
        if (path == null) {
            MochaRunProfileState.$$$reportNull$$$0(26);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 9, 12, 16, 19, 20, 22, 23, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mochaPackage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testKind";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rerunActionFailedTests";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutionResult";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSMTRunnerConsoleView";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunSettings";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getMochaMainJsFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetMochaMainJsFile";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryInfos";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getMochaReporterRootDir";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getMochaReporterFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionResult";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSMTRunnerConsoleView";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "configureCommandLine";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getGrepPattern";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setFailedTests";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMochaMainJsFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doGetMochaMainJsFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryInfos";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "configureDebugProcess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 9, 12, 16, 19, 20, 22, 23, 25, 26 -> new IllegalStateException(string);
        };
    }
}

