/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.injections;

import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import org.jetbrains.annotations.NotNull;

public final class JSFormattableInjectionUtil {
    private static final Key<Boolean> FORMATTABLE_INJECTION_KEY = new Key("js.injection.formattable");

    private JSFormattableInjectionUtil() {
    }

    public static void setReformattableInjection(PsiElement context2, Language language) {
        context2.putUserData(FORMATTABLE_INJECTION_KEY, (Object)true);
        InjectedLanguageUtil.putInjectedFileUserData((PsiElement)context2, (Language)language, FORMATTABLE_INJECTION_KEY, (Object)Boolean.TRUE);
    }

    public static boolean isReformattableInjectedPsi(PsiFile psi) {
        return psi.getUserData(FORMATTABLE_INJECTION_KEY) == Boolean.TRUE;
    }

    public static boolean isFormattableHost(@NotNull PsiElement host) {
        if (host == null) {
            JSFormattableInjectionUtil.$$$reportNull$$$0(0);
        }
        return host.isPhysical() && host instanceof JSStringTemplateExpression;
    }

    public static boolean hostContainsFormattableInjection(@NotNull PsiElement host) {
        if (host == null) {
            JSFormattableInjectionUtil.$$$reportNull$$$0(1);
        }
        if (!JSFormattableInjectionUtil.isFormattableHost(host)) {
            return false;
        }
        if (host.getUserData(FORMATTABLE_INJECTION_KEY) != Boolean.TRUE) {
            return false;
        }
        Ref result2 = Ref.create(null);
        InjectedLanguageManager.getInstance((Project)host.getProject()).enumerate(host, (injectedPsi, places) -> result2.set((Object)JSFormattableInjectionUtil.isReformattableInjectedPsi(injectedPsi)));
        return Boolean.TRUE == result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "host";
        objectArray2[1] = "com/intellij/lang/javascript/injections/JSFormattableInjectionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isFormattableHost";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hostContainsFormattableInjection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

