/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMethodDescriptor
implements MethodDescriptor<JSParameterInfo, String> {
    protected final JSFunction myMethod;
    protected final boolean myForceConstructor;
    private final JSQualifiedNamedElement myMember;

    public JSMethodDescriptor(@NotNull JSFunction method, boolean forceConstructor) {
        if (method == null) {
            JSMethodDescriptor.$$$reportNull$$$0(0);
        }
        this.myMethod = method;
        this.myMember = JSChangeSignatureUtil.getMemberFromFunction(method);
        this.myForceConstructor = forceConstructor;
    }

    public String getName() {
        return StringUtil.notNullize((String)this.myMethod.getName());
    }

    @NotNull
    public List<JSParameterInfo> getParameters() {
        return JSMethodDescriptor.getParameters(this.myMethod);
    }

    public String getReturnType() {
        JSType returnType2 = this.myMethod.getReturnType();
        return StringUtil.notNullize((String)(returnType2 != null ? returnType2.getResolvedTypeText() : null));
    }

    public int getParametersCount() {
        JSParameterList parameterList = this.myMethod.getParameterList();
        return parameterList == null ? 0 : parameterList.getParameters().length;
    }

    @NotNull
    public String getVisibility() {
        if (!this.isActionScript()) {
            String string = JSAttributeList.AccessType.PACKAGE_LOCAL.name();
            if (string == null) {
                JSMethodDescriptor.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = this.getVisibilityImpl(JSAttributeList.AccessType.PACKAGE_LOCAL);
        if (string == null) {
            JSMethodDescriptor.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected final String getVisibilityImpl(JSAttributeList.AccessType defaultAccessType) {
        JSAttributeList.AccessType accessType;
        JSAttributeList attributeList = this.getAttributeList();
        JSAttributeList.AccessType accessType2 = accessType = attributeList != null ? attributeList.getAccessType() : defaultAccessType;
        if (!this.canChangeVisibility() && this.isClassMember() && accessType != JSAttributeList.AccessType.PUBLIC) {
            accessType = JSAttributeList.AccessType.PUBLIC;
        } else if (JSResolveUtil.isConstructorFunction(this.myMethod) && accessType != JSAttributeList.AccessType.PUBLIC && accessType != JSAttributeList.AccessType.PACKAGE_LOCAL) {
            accessType = JSAttributeList.AccessType.PUBLIC;
        }
        return accessType.name();
    }

    public List<JSAttributeList.AccessType> getPossibleVisibility() {
        if (this.myMethod.isConstructor()) {
            return List.of(JSAttributeList.AccessType.PUBLIC, JSAttributeList.AccessType.PACKAGE_LOCAL);
        }
        return List.of(JSAttributeList.AccessType.PRIVATE, JSAttributeList.AccessType.PACKAGE_LOCAL, JSAttributeList.AccessType.PROTECTED, JSAttributeList.AccessType.PUBLIC);
    }

    public boolean isConstructor() {
        return this.myForceConstructor || this.myMethod.isConstructor();
    }

    @NotNull
    public JSFunction getMethod() {
        JSFunction jSFunction = this.myMethod;
        if (jSFunction == null) {
            JSMethodDescriptor.$$$reportNull$$$0(3);
        }
        return jSFunction;
    }

    public boolean canChangeVisibility() {
        if (!this.isActionScript()) {
            return false;
        }
        return this.canChangeVisibilityImpl();
    }

    public boolean resolveTypes() {
        return this.isActionScript();
    }

    protected final boolean canChangeVisibilityImpl() {
        JSClass clazz = JSUtils.getMemberContainingClass((PsiElement)this.myMember);
        return clazz != null && !clazz.isInterface();
    }

    public boolean canChangeParameters() {
        return !this.myMethod.isGetProperty();
    }

    @NotNull
    public MethodDescriptor.ReadWriteOption canChangeReturnType() {
        if (this.isConstructor() || !this.isActionScript()) {
            MethodDescriptor.ReadWriteOption readWriteOption = MethodDescriptor.ReadWriteOption.None;
            if (readWriteOption == null) {
                JSMethodDescriptor.$$$reportNull$$$0(4);
            }
            return readWriteOption;
        }
        if (this.myMethod.isSetProperty()) {
            MethodDescriptor.ReadWriteOption readWriteOption = MethodDescriptor.ReadWriteOption.Read;
            if (readWriteOption == null) {
                JSMethodDescriptor.$$$reportNull$$$0(5);
            }
            return readWriteOption;
        }
        MethodDescriptor.ReadWriteOption readWriteOption = MethodDescriptor.ReadWriteOption.ReadWrite;
        if (readWriteOption == null) {
            JSMethodDescriptor.$$$reportNull$$$0(6);
        }
        return readWriteOption;
    }

    boolean isActionScript() {
        return DialectDetector.isActionScript(this.myMethod);
    }

    boolean isTypeScript() {
        return DialectDetector.isTypeScript(this.myMethod);
    }

    boolean isEcmaScript6() {
        DialectOptionHolder holder = DialectDetector.dialectOfElement(this.myMethod);
        return holder != null && holder.isECMA6;
    }

    @Nullable
    DialectOptionHolder dialect() {
        return DialectDetector.dialectOfElement(this.myMethod);
    }

    boolean canHaveOptional() {
        return !this.isActionScript() && !this.isEcmaScript6();
    }

    boolean canHaveType() {
        DialectOptionHolder holder = DialectDetector.dialectOfElement(this.myMethod);
        return holder != null && holder.hasFeature(JSLanguageFeature.TYPES);
    }

    boolean canHaveInitializers() {
        return this.isActionScript() || this.isEcmaScript6();
    }

    String getFunctionNameWithKeyword(String methodName) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getFunctionPrefix());
        if (this.getMethod().isGetProperty()) {
            buffer.append(" get");
        } else if (this.getMethod().isSetProperty()) {
            buffer.append(" set");
        }
        if (!buffer.isEmpty()) {
            buffer.append(" ");
        }
        if (StringUtil.isNotEmpty((String)methodName)) {
            buffer.append(methodName);
        }
        return buffer.toString();
    }

    protected String getFunctionPrefix() {
        return JSClassUtils.isES6ClassImplementation(this.myMethod) && this.isClassMember() ? "" : "function";
    }

    @Nullable
    JSLanguageDialect getFileLanguage() {
        return DialectDetector.languageDialectOfElement(this.myMethod);
    }

    public boolean canChangeName() {
        if (this.myMethod instanceof JSFunctionExpression) {
            PsiElement parent = this.myMethod.getParent();
            return parent instanceof JSVariable || parent instanceof JSAssignmentExpression || parent instanceof JSProperty || parent instanceof ES6ExportDefaultAssignment && this.myMethod.getName() != null;
        }
        return !this.isConstructor();
    }

    protected boolean isClassMember() {
        return JSUtils.getMemberContainingClass((PsiElement)this.myMember) != null;
    }

    @Nullable
    public JSAttributeList getAttributeList() {
        JSAttributeListOwner element = this.myMember instanceof JSAttributeListOwner ? (JSAttributeListOwner)((Object)this.myMember) : this.myMethod;
        return element.getAttributeList();
    }

    @NotNull
    public static List<JSParameterInfo> getParameters(JSFunction method) {
        return JSMethodDescriptor.getParameters(method, Collections.emptyMap());
    }

    @NotNull
    public static List<JSParameterInfo> getParameters(@NotNull JSFunction method, @NotNull Map<String, String> typeOverrides) {
        if (method == null) {
            JSMethodDescriptor.$$$reportNull$$$0(7);
        }
        if (typeOverrides == null) {
            JSMethodDescriptor.$$$reportNull$$$0(8);
        }
        return JSMethodDescriptor.getParameters(method.getParameters(), typeOverrides);
    }

    @NotNull
    public static List<JSParameterInfo> getParameters(JSParameterListElement @NotNull [] parameters2, @NotNull Map<String, String> typeOverrides) {
        if (typeOverrides == null) {
            JSMethodDescriptor.$$$reportNull$$$0(9);
        }
        if (parameters2 == null) {
            JSMethodDescriptor.$$$reportNull$$$0(10);
        }
        ArrayList<JSParameterInfo> result2 = new ArrayList<JSParameterInfo>();
        for (int i = 0; i < parameters2.length; ++i) {
            String overridden;
            JSParameterListElement parameter = parameters2[i];
            JSParameterInfo info = JSParameterInfo.build(parameter, i);
            if (parameter instanceof JSParameter) {
                JSMethodDescriptor.setOldModifiersText(info, ((JSParameter)parameter).getAttributeList());
            }
            if ((overridden = typeOverrides.get(parameter.getName())) != null) {
                info.setTypeText(overridden);
            }
            result2.add(info);
        }
        ArrayList<JSParameterInfo> arrayList = result2;
        if (arrayList == null) {
            JSMethodDescriptor.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static void setOldModifiersText(JSParameterInfo info, JSAttributeList list) {
        String readonlyPostfix;
        if (list == null) {
            return;
        }
        boolean isReadonly = list.hasModifier(JSAttributeList.ModifierType.READONLY);
        JSAttributeList.AccessType accessType = list.getExplicitAccessType();
        String string = readonlyPostfix = isReadonly ? " readonly" : "";
        if (accessType == JSAttributeList.AccessType.PRIVATE) {
            info.setOldModifiers("private" + readonlyPostfix);
        } else if (accessType == JSAttributeList.AccessType.PROTECTED) {
            info.setOldModifiers("protected" + readonlyPostfix);
        } else if (accessType == JSAttributeList.AccessType.PUBLIC || isReadonly) {
            info.setOldModifiers("public" + readonlyPostfix);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/changeSignature/JSMethodDescriptor";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeOverrides";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSMethodDescriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibility";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethod";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "canChangeReturnType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 11 -> new IllegalStateException(string);
        };
    }
}

