/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.pattern;

import com.intellij.codeInsight.intention.AddAnnotationFixWithoutArgFix;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.siyeh.ig.fixes.IntroduceVariableFix;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.IntelliLangBundle;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.intellij.plugins.intelliLang.util.SubstitutedExpressionEvaluationHelper;
import org.jetbrains.annotations.NotNull;

public class PatternValidator
extends LocalInspectionTool {
    private static final Key<CachedValue<Pattern>> COMPLIED_PATTERN = Key.create((String)"COMPILED_PATTERN");
    public boolean CHECK_NON_CONSTANT_VALUES = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"CHECK_NON_CONSTANT_VALUES", (String)IntelliLangBundle.message("flag.non.compile.time.constant.expressions", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PatternValidator.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PatternValidator.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.visitExpression((PsiExpression)expression);
            }

            public void visitExpression(@NotNull PsiExpression expression) {
                PsiElement element;
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((element = expression.getParent()) instanceof PsiExpressionList) {
                    this.check(expression, holder, false);
                } else if (element instanceof PsiNameValuePair) {
                    PsiNameValuePair valuePair = (PsiNameValuePair)element;
                    String name = valuePair.getName();
                    if (name == null || name.equals("value")) {
                        this.check(expression, holder, true);
                    }
                    this.check(expression, holder, false);
                }
            }

            public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
                PsiExpression returnValue;
                if (statement == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((returnValue = statement.getReturnValue()) != null) {
                    this.check(returnValue, holder, false);
                }
            }

            public void visitVariable(@NotNull PsiVariable var) {
                PsiExpression initializer;
                if (var == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((initializer = var.getInitializer()) != null) {
                    this.check(initializer, holder, false);
                }
            }

            public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
                PsiExpression e;
                if (expression == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((e = expression.getRExpression()) != null) {
                    this.check(e, holder, false);
                }
                this.visitExpression((PsiExpression)expression);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void check(@NotNull PsiExpression expression, ProblemsHolder holder2, boolean isAnnotationValue) {
                if (expression == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (expression instanceof PsiConditionalExpression) {
                    PsiConditionalExpression expr = (PsiConditionalExpression)expression;
                    PsiExpression e = expr.getThenExpression();
                    if (e != null) {
                        this.check(e, holder2, isAnnotationValue);
                    }
                    if ((e = expr.getElseExpression()) == null) return;
                    this.check(e, holder2, isAnnotationValue);
                    return;
                } else {
                    PsiModifierListOwner element;
                    PsiType type = expression.getType();
                    if (type == null || !PsiUtilEx.isString(type)) return;
                    if (isAnnotationValue) {
                        PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiAnnotation.class);
                        if (psiAnnotation == null || !Configuration.getInstance().getAdvancedConfiguration().getSubstAnnotationClass().equals(psiAnnotation.getQualifiedName())) return;
                        element = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiModifierListOwner.class);
                    } else {
                        element = AnnotationUtilEx.getAnnotatedElementFor((PsiElement)expression, AnnotationUtilEx.LookupType.PREFER_CONTEXT);
                    }
                    if (element == null || !PsiUtilEx.isLanguageAnnotationTarget(element)) return;
                    PsiAnnotation[] annotations = AnnotationUtilEx.getAnnotationFrom(element, Configuration.getInstance().getAdvancedConfiguration().getPatternAnnotationPair(), true);
                    PatternValidator.this.checkExpression(expression, annotations, holder2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "var";
                        break;
                    }
                }
                objectArray2[1] = "org/intellij/plugins/intelliLang/pattern/PatternValidator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReturnStatement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitVariable";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAssignmentExpression";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "check";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void checkExpression(PsiExpression expression, PsiAnnotation[] annotations, ProblemsHolder holder) {
        String o;
        Pattern pattern;
        if (annotations.length == 0) {
            return;
        }
        PsiAnnotation psiAnnotation = annotations[0];
        CachedValue p = (CachedValue)psiAnnotation.getUserData(COMPLIED_PATTERN);
        if (p == null) {
            CachedValueProvider provider = () -> {
                String pattern = AnnotationUtilEx.calcAnnotationValue(psiAnnotation, "value");
                Pattern p1 = null;
                if (pattern != null) {
                    try {
                        p1 = Pattern.compile(pattern);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        // empty catch block
                    }
                }
                return CachedValueProvider.Result.create((Object)p1, (Object[])annotations);
            };
            p = CachedValuesManager.getManager((Project)expression.getProject()).createCachedValue(provider, false);
            psiAnnotation.putUserData(COMPLIED_PATTERN, (Object)p);
        }
        if ((pattern = (Pattern)p.getValue()) == null) {
            return;
        }
        SmartList nonConstantElements = new SmartList();
        Configuration configuration = Configuration.getInstance();
        Object result = new SubstitutedExpressionEvaluationHelper(expression.getProject()).computeExpression(expression, configuration.getAdvancedConfiguration().getDfaOption(), false, (List<? super PsiExpression>)nonConstantElements);
        String string = o = result == null ? null : String.valueOf(result);
        if (o != null) {
            if (!pattern.matcher(o).matches()) {
                if (annotations.length > 1) {
                    String fqn = annotations[annotations.length - 1].getQualifiedName();
                    assert (fqn != null);
                    String name = StringUtil.getShortName((String)fqn);
                    holder.registerProblem((PsiElement)expression, IntelliLangBundle.message("inspection.message.expression.does.not.match.pattern", o, name, pattern.pattern()), new LocalQuickFix[0]);
                } else {
                    holder.registerProblem((PsiElement)expression, IntelliLangBundle.message("inspection.message.expression.does.not.match.pattern2", o, pattern.pattern()), new LocalQuickFix[0]);
                }
            }
        } else if (this.CHECK_NON_CONSTANT_VALUES) {
            for (PsiExpression expr : nonConstantElements) {
                PsiAnnotation[] resolvedAnnos;
                Object e = expr instanceof PsiReferenceExpression ? ((PsiReferenceExpression)expr).resolve() : (expr instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)expr).getMethodExpression().resolve() : expr);
                PsiModifierListOwner owner = (PsiModifierListOwner)ObjectUtils.tryCast((Object)e, PsiModifierListOwner.class);
                SmartList fixes = new SmartList();
                if (owner != null && PsiUtilEx.isLanguageAnnotationTarget(owner) && (resolvedAnnos = AnnotationUtilEx.getAnnotationFrom(owner, configuration.getAdvancedConfiguration().getPatternAnnotationPair(), true)).length == 2 && annotations.length == 2 && Comparing.strEqual((String)resolvedAnnos[1].getQualifiedName(), (String)annotations[1].getQualifiedName())) {
                    return;
                }
                if (holder.isOnTheFly()) {
                    String classname = (String)configuration.getAdvancedConfiguration().getSubstAnnotationPair().first;
                    if (owner != null && AddAnnotationFixWithoutArgFix.isApplicable((PsiModifierListOwner)owner, (String)classname)) {
                        fixes.add(new AddAnnotationFixWithoutArgFix(classname, owner, new String[0]));
                    } else {
                        fixes.add(new IntroduceVariableFix(false));
                    }
                } else {
                    fixes.add(new IntroduceVariableFix(false));
                }
                holder.registerProblem((PsiElement)expr, IntelliLangBundle.message("inspection.pattern.validator.description", new Object[0]), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/pattern/PatternValidator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/pattern/PatternValidator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

