/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.plugincomponents;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.EditorConfigRegistry;
import org.editorconfig.plugincomponents.EditorConfigPropertiesService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/editorconfig/plugincomponents/EditorConfigModificationListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "<init>", "()V", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "intellij.editorconfig"})
public final class EditorConfigModificationListener
implements BulkFileListener {
    public void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        boolean isCodeStylePossiblyAffected = false;
        for (VFileEvent vFileEvent : events) {
            VirtualFile file = vFileEvent.getFile();
            if (file == null || !Intrinsics.areEqual((Object)file.getName(), (Object)".editorconfig")) continue;
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                Intrinsics.checkNotNull((Object)project);
                Project project2 = project;
                if (!ProjectRootManager.getInstance((Project)project2).getFileIndex().isInContent(file) && EditorConfigRegistry.shouldStopAtProjectRoot()) continue;
                project = vFileEvent;
                if (!(project instanceof VFileCopyEvent) && !(project instanceof VFileCreateEvent)) {
                    EditorConfigPropertiesService.Companion.getInstance(project2).clearCache$intellij_editorconfig();
                }
                isCodeStylePossiblyAffected = true;
            }
        }
        if (isCodeStylePossiblyAffected) {
            ApplicationManager.getApplication().invokeLater(EditorConfigModificationListener::after$lambda$0);
        }
    }

    private static final void after$lambda$0() {
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            if (editor.isDisposed()) continue;
            Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            ((EditorEx)editor).reinitSettings();
        }
    }
}

