/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter.add.wizard;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.python.remoteInterpreter.add.SshSdkCreationUtilKt;
import com.intellij.python.remoteInterpreter.add.wizard.AbstractFinishState;
import com.intellij.python.remoteInterpreter.add.wizard.CreateSshInterpreterWizardState;
import com.intellij.python.remoteInterpreter.add.wizard.DeploymentConfigurationUtil;
import com.intellij.python.remoteInterpreter.add.wizard.InternalStateListener;
import com.intellij.python.remoteInterpreter.add.wizard.ui.SshAdditionalConfigurationForm;
import com.intellij.python.remoteInterpreter.add.wizard.ui.ValidationStatusListener;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\b\u0010\u001c\u001a\u00020\u0015H\u0016J\b\u0010!\u001a\u00020\u0011H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lcom/intellij/python/remoteInterpreter/add/wizard/FinishExistingSshConfigState;", "Lcom/intellij/python/remoteInterpreter/add/wizard/AbstractFinishState;", "username", "", "host", "port", "", "listener", "Lcom/intellij/python/remoteInterpreter/add/wizard/InternalStateListener;", "sshSession", "Lcom/intellij/ssh/SshSession;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "existingSshConfig", "Lcom/intellij/ssh/config/unified/SshConfig;", "previousState", "Lcom/intellij/python/remoteInterpreter/add/wizard/CreateSshInterpreterWizardState;", "<init>", "(Ljava/lang/String;Ljava/lang/String;ILcom/intellij/python/remoteInterpreter/add/wizard/InternalStateListener;Lcom/intellij/ssh/SshSession;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Ljava/util/List;Lcom/intellij/ssh/config/unified/SshConfig;Lcom/intellij/python/remoteInterpreter/add/wizard/CreateSshInterpreterWizardState;)V", "getListener", "()Lcom/intellij/python/remoteInterpreter/add/wizard/InternalStateListener;", "getProject", "()Lcom/intellij/openapi/project/Project;", "previous", "form", "Lcom/intellij/python/remoteInterpreter/add/wizard/ui/SshAdditionalConfigurationForm;", "getForm", "()Lcom/intellij/python/remoteInterpreter/add/wizard/ui/SshAdditionalConfigurationForm;", "finish", "Companion", "intellij.python.remoteInterpreter"})
public final class FinishExistingSshConfigState
extends AbstractFinishState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalStateListener listener;
    @Nullable
    private final Project project;
    @Nullable
    private final Module module;
    @NotNull
    private final List<Sdk> existingSdks;
    @NotNull
    private final SshConfig existingSshConfig;
    @NotNull
    private final CreateSshInterpreterWizardState previousState;
    @NotNull
    private final SshAdditionalConfigurationForm form;
    @NotNull
    private static final Logger LOG;

    public FinishExistingSshConfigState(@NotNull String username, @NotNull String host, int port, @NotNull InternalStateListener listener, @NotNull SshSession sshSession, @Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @NotNull SshConfig existingSshConfig, @NotNull CreateSshInterpreterWizardState previousState) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)sshSession, (String)"sshSession");
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        Intrinsics.checkNotNullParameter((Object)existingSshConfig, (String)"existingSshConfig");
        Intrinsics.checkNotNullParameter((Object)previousState, (String)"previousState");
        this.listener = listener;
        this.project = project;
        this.module = module;
        this.existingSdks = existingSdks;
        this.existingSshConfig = existingSshConfig;
        this.previousState = previousState;
        this.form = new SshAdditionalConfigurationForm(this.getProject(), this.existingSshConfig.copyToCredentials(), username, host, port);
        this.getForm().setListener(new ValidationStatusListener(){

            @Override
            public void onValidationStatusChanged() {
                this.getListener().onControlsChanged();
            }
        });
    }

    @Override
    @NotNull
    public InternalStateListener getListener() {
        return this.listener;
    }

    @Override
    @Nullable
    protected Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public CreateSshInterpreterWizardState previous() {
        return this.previousState;
    }

    @Override
    @NotNull
    protected SshAdditionalConfigurationForm getForm() {
        return this.form;
    }

    @Override
    @NotNull
    public Sdk finish() {
        try {
            WebServerConfig server = new WebServerConfig(WebServerConfig.getNextId());
            server.setName(this.existingSshConfig.getName());
            server.getFileTransferConfig().setSshConfig(this.existingSshConfig);
            GroupedServersConfigManager.getInstance((Project)this.getProject()).addServer(server);
            DeploymentConfigurationUtil.notifyLaterThatDeploymentConfigurationCreated(this.getProject(), server);
            Project project = this.getProject();
            String string = this.getForm().getInterpreterPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInterpreterPath(...)");
            Sdk sdk = SshSdkCreationUtilKt.createSdkFromExistingServerConfiguration(project, this.module, this.existingSshConfig, server, this.existingSdks, string, this.getForm().isRunAsRootViaSudo());
            this.savePathMappingSettingsOnFinish(server);
            return sdk;
        }
        catch (RemoteSdkException e) {
            if (!ExceptionUtil.causedBy((Throwable)e, InterruptedException.class)) {
                LOG.debug((Throwable)e);
            }
            throw e;
        }
    }

    static {
        Logger logger = Logger.getInstance(FinishExistingSshConfigState.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/python/remoteInterpreter/add/wizard/FinishExistingSshConfigState$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.python.remoteInterpreter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

