/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.ref;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jinja.template.psi.Jinja2TemplateElementTypes;
import com.intellij.jinja.template.tags.Jinja2LoadTag;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.lang.template.DjangoTemplateElementGenerator;
import com.jetbrains.django.model.applications.DjangoAppConfig;
import com.jetbrains.python.BaseReference;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DjangoLoadTagsReference
extends BaseReference {
    private static final TokenSet MEMBER_NAMES = TokenSet.create((IElementType[])new IElementType[]{Jinja2TemplateElementTypes.MEMBER_NAME});
    private static final String TEMPLATE_TAGS = "templatetags";
    private final Jinja2LoadTag myLoadTag;
    private final ASTNode myMemberNode;

    public DjangoLoadTagsReference(Jinja2LoadTag element, ASTNode memberNode) {
        super((PsiElement)element);
        this.myLoadTag = element;
        this.myMemberNode = memberNode;
    }

    public ASTNode getMemberNode() {
        return this.myMemberNode;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        PsiElement psi;
        if (newElementName == null) {
            DjangoLoadTagsReference.$$$reportNull$$$0(0);
        }
        if ((psi = this.myMemberNode.getPsi()) != null) {
            return psi.replace((PsiElement)DjangoTemplateElementGenerator.getInstance(psi.getProject()).createLoadTagReference(newElementName));
        }
        return null;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myMemberNode.getTextRange().shiftLeft(this.myLoadTag.getTextOffset());
        if (textRange == null) {
            DjangoLoadTagsReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    public PsiElement resolve() {
        ASTNode[] memberNameTags = this.myMemberNode.getChildren(MEMBER_NAMES);
        ResolveTagsProcessor processor = new ResolveTagsProcessor(memberNameTags);
        DjangoLoadTagsReference.processCustomTagsModules(processor, (PsiElement)this.myLoadTag);
        PsiElement result = processor.myResult;
        if (result instanceof PyiFile) {
            return PyiUtil.getOriginalElement((PyElement)((PyiFile)result));
        }
        return processor.myResult;
    }

    private static void processCustomTagsModules(Processor<List<String>> processor, PsiElement foothold) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)foothold);
        if (!processor.process(Arrays.asList("django", TEMPLATE_TAGS))) {
            return;
        }
        if (module != null) {
            List<DjangoAppConfig> installedApps = DjangoSettingsPy.getInstalledApps(module);
            for (DjangoAppConfig installedAppInfo : installedApps) {
                ArrayList installedAppComponents = Lists.newArrayList((Iterable)StringUtil.split((String)installedAppInfo.getName(), (String)"."));
                installedAppComponents.add(TEMPLATE_TAGS);
                if (processor.process((Object)installedAppComponents)) continue;
                return;
            }
        }
    }

    public Object @NotNull [] getVariants() {
        List<LookupElement> results = DjangoLoadTagsReference.getTagsCompletionVariants((PsiElement)this.myLoadTag);
        Object[] objectArray = results.toArray();
        if (objectArray == null) {
            DjangoLoadTagsReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    public static List<LookupElement> getTagsCompletionVariants(PsiElement foothold) {
        CollectTagsProcessor processor = new CollectTagsProcessor(foothold);
        DjangoLoadTagsReference.processCustomTagsModules(processor, foothold);
        return processor.myResults;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/lang/template/ref/DjangoLoadTagsReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/lang/template/ref/DjangoLoadTagsReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private class ResolveTagsProcessor
    implements Processor<List<String>> {
        private PsiElement myResult;
        private final ASTNode[] myMemberNameTags;

        ResolveTagsProcessor(ASTNode[] memberNameTags) {
            this.myMemberNameTags = memberNameTags;
        }

        public boolean process(List<String> strings) {
            ArrayList components = Lists.newArrayList(strings);
            for (ASTNode tag : this.myMemberNameTags) {
                components.add(tag.getText());
            }
            QualifiedName qName = QualifiedName.fromComponents((String[])ArrayUtilRt.toStringArray((Collection)components));
            this.myResult = ResolveImportUtil.resolveModuleInRoots((QualifiedName)qName, (PsiElement)DjangoLoadTagsReference.this.myLoadTag);
            return this.myResult == null;
        }
    }

    private static class CollectTagsProcessor
    implements Processor<List<String>> {
        private final List<LookupElement> myResults = new ArrayList<LookupElement>();
        private final PsiElement myFoothold;

        CollectTagsProcessor(PsiElement foothold) {
            this.myFoothold = foothold;
        }

        public boolean process(List<String> strings) {
            QualifiedName qName = QualifiedName.fromComponents((String[])ArrayUtilRt.toStringArray(strings));
            PsiElement dir = ResolveImportUtil.resolveModuleInRoots((QualifiedName)qName, (PsiElement)this.myFoothold);
            if (dir instanceof PsiDirectory) {
                this.collectTagFiles((PsiDirectory)dir, "");
            }
            return true;
        }

        private void collectTagFiles(PsiDirectory dir, String prefix) {
            PsiDirectory[] directories;
            PsiFile[] files;
            for (PsiFile file : files = dir.getFiles()) {
                if (!(file instanceof PyFile) || file.getName().equals("__init__.py") || file.getName().equals("__init__.pyi")) continue;
                LookupElementBuilder element = LookupElementBuilder.create((Object)file, (String)(prefix + FileUtilRt.getNameWithoutExtension((String)file.getName())));
                this.myResults.add((LookupElement)element);
            }
            for (PsiDirectory childDir : directories = dir.getSubdirectories()) {
                this.collectTagFiles(childDir, prefix + dir.getName() + ".");
            }
        }
    }
}

