package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutConfigItemForFlat invokes the cloudcallcenter.PutConfigItemForFlat API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/putconfigitemforflat.html
func (client *Client) PutConfigItemForFlat(request *PutConfigItemForFlatRequest) (response *PutConfigItemForFlatResponse, err error) {
	response = CreatePutConfigItemForFlatResponse()
	err = client.DoAction(request, response)
	return
}

// PutConfigItemForFlatWithChan invokes the cloudcallcenter.PutConfigItemForFlat API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/putconfigitemforflat.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PutConfigItemForFlatWithChan(request *PutConfigItemForFlatRequest) (<-chan *PutConfigItemForFlatResponse, <-chan error) {
	responseChan := make(chan *PutConfigItemForFlatResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutConfigItemForFlat(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutConfigItemForFlatWithCallback invokes the cloudcallcenter.PutConfigItemForFlat API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/putconfigitemforflat.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PutConfigItemForFlatWithCallback(request *PutConfigItemForFlatRequest, callback func(response *PutConfigItemForFlatResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutConfigItemForFlatResponse
		var err error
		defer close(result)
		response, err = client.PutConfigItemForFlat(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutConfigItemForFlatRequest is the request struct for api PutConfigItemForFlat
type PutConfigItemForFlatRequest struct {
	*requests.RpcRequest
	InstanceId    string `position:"Query" name:"InstanceId"`
	Name          string `position:"Query" name:"Name"`
	DimensionName string `position:"Query" name:"DimensionName"`
	Value         string `position:"Query" name:"Value"`
	Dimension     string `position:"Query" name:"Dimension"`
}

// PutConfigItemForFlatResponse is the response struct for api PutConfigItemForFlat
type PutConfigItemForFlatResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreatePutConfigItemForFlatRequest creates a request to invoke PutConfigItemForFlat API
func CreatePutConfigItemForFlatRequest() (request *PutConfigItemForFlatRequest) {
	request = &PutConfigItemForFlatRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "PutConfigItemForFlat", "", "")
	request.Method = requests.POST
	return
}

// CreatePutConfigItemForFlatResponse creates a response to parse from PutConfigItemForFlat response
func CreatePutConfigItemForFlatResponse() (response *PutConfigItemForFlatResponse) {
	response = &PutConfigItemForFlatResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
