package dm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySignByParam invokes the dm.QuerySignByParam API synchronously
// api document: https://help.aliyun.com/api/dm/querysignbyparam.html
func (client *Client) QuerySignByParam(request *QuerySignByParamRequest) (response *QuerySignByParamResponse, err error) {
	response = CreateQuerySignByParamResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySignByParamWithChan invokes the dm.QuerySignByParam API asynchronously
// api document: https://help.aliyun.com/api/dm/querysignbyparam.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QuerySignByParamWithChan(request *QuerySignByParamRequest) (<-chan *QuerySignByParamResponse, <-chan error) {
	responseChan := make(chan *QuerySignByParamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySignByParam(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySignByParamWithCallback invokes the dm.QuerySignByParam API asynchronously
// api document: https://help.aliyun.com/api/dm/querysignbyparam.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QuerySignByParamWithCallback(request *QuerySignByParamRequest, callback func(response *QuerySignByParamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySignByParamResponse
		var err error
		defer close(result)
		response, err = client.QuerySignByParam(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySignByParamRequest is the request struct for api QuerySignByParam
type QuerySignByParamRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNo               requests.Integer `position:"Query" name:"PageNo"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	KeyWord              string           `position:"Query" name:"KeyWord"`
	FromType             requests.Integer `position:"Query" name:"FromType"`
}

// QuerySignByParamResponse is the response struct for api QuerySignByParam
type QuerySignByParamResponse struct {
	*responses.BaseResponse
	RequestId  string                 `json:"RequestId" xml:"RequestId"`
	PageNumber int                    `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                    `json:"PageSize" xml:"PageSize"`
	Data       DataInQuerySignByParam `json:"data" xml:"data"`
}

// CreateQuerySignByParamRequest creates a request to invoke QuerySignByParam API
func CreateQuerySignByParamRequest() (request *QuerySignByParamRequest) {
	request = &QuerySignByParamRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dm", "2015-11-23", "QuerySignByParam", "", "")
	return
}

// CreateQuerySignByParamResponse creates a response to parse from QuerySignByParam response
func CreateQuerySignByParamResponse() (response *QuerySignByParamResponse) {
	response = &QuerySignByParamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
