package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectImageSync invokes the mts.DetectImageSync API synchronously
func (client *Client) DetectImageSync(request *DetectImageSyncRequest) (response *DetectImageSyncResponse, err error) {
	response = CreateDetectImageSyncResponse()
	err = client.DoAction(request, response)
	return
}

// DetectImageSyncWithChan invokes the mts.DetectImageSync API asynchronously
func (client *Client) DetectImageSyncWithChan(request *DetectImageSyncRequest) (<-chan *DetectImageSyncResponse, <-chan error) {
	responseChan := make(chan *DetectImageSyncResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectImageSync(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectImageSyncWithCallback invokes the mts.DetectImageSync API asynchronously
func (client *Client) DetectImageSyncWithCallback(request *DetectImageSyncRequest, callback func(response *DetectImageSyncResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectImageSyncResponse
		var err error
		defer close(result)
		response, err = client.DetectImageSync(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectImageSyncRequest is the request struct for api DetectImageSync
type DetectImageSyncRequest struct {
	*requests.RpcRequest
	Image string `position:"Query" name:"Image"`
}

// DetectImageSyncResponse is the response struct for api DetectImageSync
type DetectImageSyncResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
	Status    string `json:"Status" xml:"Status"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDetectImageSyncRequest creates a request to invoke DetectImageSync API
func CreateDetectImageSyncRequest() (request *DetectImageSyncRequest) {
	request = &DetectImageSyncRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "DetectImageSync", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectImageSyncResponse creates a response to parse from DetectImageSync response
func CreateDetectImageSyncResponse() (response *DetectImageSyncResponse) {
	response = &DetectImageSyncResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
