package multimediaai

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RegisterFaceImage invokes the multimediaai.RegisterFaceImage API synchronously
// api document: https://help.aliyun.com/api/multimediaai/registerfaceimage.html
func (client *Client) RegisterFaceImage(request *RegisterFaceImageRequest) (response *RegisterFaceImageResponse, err error) {
	response = CreateRegisterFaceImageResponse()
	err = client.DoAction(request, response)
	return
}

// RegisterFaceImageWithChan invokes the multimediaai.RegisterFaceImage API asynchronously
// api document: https://help.aliyun.com/api/multimediaai/registerfaceimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RegisterFaceImageWithChan(request *RegisterFaceImageRequest) (<-chan *RegisterFaceImageResponse, <-chan error) {
	responseChan := make(chan *RegisterFaceImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RegisterFaceImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RegisterFaceImageWithCallback invokes the multimediaai.RegisterFaceImage API asynchronously
// api document: https://help.aliyun.com/api/multimediaai/registerfaceimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RegisterFaceImageWithCallback(request *RegisterFaceImageRequest, callback func(response *RegisterFaceImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RegisterFaceImageResponse
		var err error
		defer close(result)
		response, err = client.RegisterFaceImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RegisterFaceImageRequest is the request struct for api RegisterFaceImage
type RegisterFaceImageRequest struct {
	*requests.RpcRequest
	FaceGroupId  requests.Integer `position:"Query" name:"FaceGroupId"`
	FacePersonId requests.Integer `position:"Query" name:"FacePersonId"`
	ImageUrl     string           `position:"Query" name:"ImageUrl"`
}

// RegisterFaceImageResponse is the response struct for api RegisterFaceImage
type RegisterFaceImageResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	FaceImages []FaceImage `json:"FaceImages" xml:"FaceImages"`
}

// CreateRegisterFaceImageRequest creates a request to invoke RegisterFaceImage API
func CreateRegisterFaceImageRequest() (request *RegisterFaceImageRequest) {
	request = &RegisterFaceImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("multimediaai", "2019-08-10", "RegisterFaceImage", "", "")
	request.Method = requests.POST
	return
}

// CreateRegisterFaceImageResponse creates a response to parse from RegisterFaceImage response
func CreateRegisterFaceImageResponse() (response *RegisterFaceImageResponse) {
	response = &RegisterFaceImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
