Contributing
============

The project is mostly dormant, but not dead. If you wish to contribute or
maintain the project, please send me an email at fmang+oshu at mg0.fr, or open
an issue on [GitHub][].

[GitHub]: https://github.com/fmang/oshu/


Documentation
-------------

The HTML documentation is generated by Doxygen. Run `make html` and open
`html/index.html` relative to your build directory to browse it.

Doxygen is detected by CMake when you configure the project. You may need to
re-run CMake if it didn't detect Doxygen after you installed it.


Pull Requests
-------------

Pull requests are always welcome, but you should follow a few rules:

1. Make your code look like the rest of the project.

   Follow the Linux kernel coding style, but feel free to improvise something
   if that makes the code look better.

2. Document what you're doing.

   Explain the context, and don't repeat the code.

3. Focus your work, and don't be greedy.

   If you have an ambitious goal, like making a game mode, don't come and dump
   a thousand-line wall of code. Make small focused pull requests that add up.

4. Be reactive.

   Expect your pull request to be reviewed in the next few days after you open
   the pull request. If your pull request begins to rot and becomes conflicting
   with the master branch, things may get complicated.

5. Communicate your intentions.

   If you have an idea, please do open an issue on GitHub to get feedback.
   That's the best way to ensure your work won't cause conflicts, or stray off
   topic.


Technical choices
-----------------

C is love, but the cost of purity is high and sacrifices type safety. The code
is being ported to modern C++ but its paradigm will remain mostly procedural

Since this project is meant to have fun, let's also have fun while making it!

First of all, the graphical part. Tons of libraries exist, some OpenGL-focused
like glfw, some that are hybrid and able to make do with the CPU only. Of
course, we're going to choose the latter.

So we've got SDL2 and overkill toolkits like Qt and GTK. SDL2 sounds good.

For the audio part, it's more complicated. All the graphical toolkits above
have an audio module, but if we're going for the SDL, might as well use the SDL
audio facility because it will be well integrated.

The SDL2 audio subsystem is quite basic and can only play raw audio. A
higher-level library called SDL2_mixer provides a cool way to load fancy files
like MP3 but does not provide fine control over the stream. Specifically, it
won't tell us the time information in the audio stream's frame, which is
crucial for a rhythm game. Most high-level audio libraries don't provide that
kind of thing anyway. Another required feature is the mixing of sound effects,
which don't make much sense in frameworks like gstreamer.

The easy way is relying on the process time and hoping it doesn't deviate too
much from the song. The hard way is using the low-level interfaces to keep in
sync with the music.

Relying on libavcodec (ffmpeg) is the killer option, even though it's quite
manual and relies on a good understanding of the audio decoding process. But
hey, it's an opportunity to learn! Beside, using libavcodec provides an
incredible set of supported audio formats.
