
/*
 * Copyright (C) 2007 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: utils_config.h 2345 2007-06-27 12:11:08Z mschwerin $
 *
 */

#ifndef HAVE_UTILS_CONFIG_H
#define HAVE_UTILS_CONFIG_H


#include "oxine.h"


inline int config_lookup_entry (const char *key, xine_cfg_entry_t * entry);


inline void config_update_entry (xine_cfg_entry_t * entry);


inline void config_get_entry (const char *key, xine_cfg_entry_t * entry);


inline int config_get_number (const char *key);


inline int config_set_number (const char *key, int value);


inline const char *config_get_string (const char *key);


inline bool config_get_bool (const char *key);


inline bool config_set_bool (const char *key, bool value);


inline const char *config_get_enum (const char *key);


inline const char *config_register_string (const char *key,
                                           const char *init_value,
                                           const char *label);


inline int config_register_number (const char *key, int init_value,
                                   const char *label);


inline int config_register_range (const char *key, int init_value, int min,
                                  int max, const char *label);


inline int config_register_enum (const char *key, int init_value,
                                 char **values, const char *label);


inline bool config_register_bool (const char *key, bool init_value,
                                  const char *label);


inline void config_save (void);


#endif /* HAVE_UTILS_CONFIG_H */
