/*
 * Decompiled with CFR 0.152.
 */
package com.stampysoft.ant.j2me;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class JARToPRCTask
extends Task {
    private boolean m_beam = false;
    private boolean m_verbose = false;
    private boolean m_networking = false;
    private File m_jar;
    private String m_prc;
    private String m_mainClass;
    private String m_version;
    private String m_name;
    private String m_longName;
    private String m_creator;
    private String m_type;
    private String m_classpath;
    private String m_bootclasspath;
    private File m_jad;
    private File m_icon;
    private File m_listIcon;
    private File m_smallIcon;
    private String m_toolkitVersion;
    private static final String VERSION_1_0 = "1.0";
    private static final String VERSION_1_0_EARLY_ACCESS = "1.0EA";

    public void setBeam(boolean beam) {
        this.m_beam = beam;
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public void setNetworking(boolean networking) {
        this.m_networking = networking;
    }

    public void setJar(File jar) {
        this.m_jar = jar;
    }

    public void setPRC(String prc) {
        this.m_prc = prc;
    }

    public void setMainClass(String mainClass) {
        this.m_mainClass = mainClass;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setLongname(String longname) {
        this.m_longName = longname;
    }

    public void setCreator(String creator) {
        this.m_creator = creator;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public void setClasspath(String classpath) {
        this.m_classpath = classpath;
    }

    public void setBootclasspath(String bootclasspath) {
        this.m_bootclasspath = bootclasspath;
    }

    public void setJad(File jad) {
        this.m_jad = jad;
    }

    public void setIcon(File icon) {
        this.m_icon = icon;
    }

    public void setListicon(File listIcon) {
        this.m_listIcon = listIcon;
    }

    public void setSmallicon(File smallIcon) {
        this.m_smallIcon = smallIcon;
    }

    private String getCommandLineArgs() {
        StringBuffer args = new StringBuffer();
        if (this.m_version != null) {
            args.append("-version ");
            args.append(this.m_version);
            args.append(" ");
        }
        if (this.m_icon != null) {
            this.checkIconFile(this.m_icon, "icon");
            args.append("-icon \"");
            args.append(this.m_icon);
            args.append("\" ");
        }
        if (this.m_smallIcon != null) {
            this.checkIconFile(this.m_smallIcon, "smallicon");
            args.append("-smallicon \"");
            args.append(this.m_smallIcon);
            args.append("\" ");
        }
        if (this.m_name != null) {
            args.append("-name \"");
            args.append(this.m_name);
            args.append("\" ");
            if (this.m_longName == null) {
                this.m_longName = this.m_name;
            }
        }
        if (this.m_longName != null) {
            args.append("-longname \"");
            args.append(this.m_longName);
            args.append("\" ");
        }
        if (this.m_creator != null) {
            args.append("-creator ");
            args.append(this.m_creator);
            args.append(" ");
        }
        if (this.m_type != null) {
            args.append("-type ");
            args.append(this.m_type);
            args.append(" ");
        }
        if (this.m_classpath != null) {
            args.append("-classpath \"");
            args.append(this.m_classpath);
            args.append("\" ");
        }
        if (this.m_bootclasspath != null) {
            args.append("-bootclasspath \"");
            args.append(this.m_bootclasspath);
            args.append("\" ");
        }
        if (this.m_verbose) {
            args.append("-v ");
        }
        if (!this.m_beam) {
            args.append("-nobeam ");
        }
        if (this.m_networking) {
            args.append("-networking ");
        }
        if (this.m_listIcon != null) {
            this.checkIconFile(this.m_listIcon, "listicon");
            args.append("-listicon \"");
            args.append(this.m_listIcon);
            args.append("\" ");
        }
        args.append("-o \"");
        if (this.m_prc == null) {
            this.m_prc = this.m_jar.getName().substring(0, this.m_jar.getName().length() - ".jar".length()) + ".prc";
        }
        args.append(this.m_prc);
        args.append("\" ");
        if (this.m_jad != null) {
            args.append("-jad \"");
            args.append(this.m_jad);
            args.append("\" ");
        }
        if (this.m_toolkitVersion.equals(VERSION_1_0_EARLY_ACCESS)) {
            args.append("-JARtoPRC \"");
            args.append(this.m_jar);
            args.append("\" ");
            args.append(this.m_mainClass);
        } else {
            args.append("\"");
            args.append(this.m_jar);
            args.append("\" ");
        }
        return args.toString();
    }

    private void checkIconFile(File f, String description) throws BuildException {
        if (!f.isFile()) {
            throw new BuildException(description + " file does not exist or is not a file", this.location);
        }
    }

    private void determineConverterVersion(File file) throws BuildException {
        try {
            JarFile jar = new JarFile(file);
            this.m_toolkitVersion = jar.getJarEntry("palm/database/MakeMIDPApp.class") != null ? VERSION_1_0_EARLY_ACCESS : VERSION_1_0;
        }
        catch (IOException e) {
            throw new BuildException("Unable to determine MIDP for Palm toolkit version");
        }
    }

    public void execute() throws BuildException {
        String home = this.project.getProperty("midp4palm.home");
        File makeMIDPAppJar = new File(home + File.separator + "MakeMIDPApp.jar");
        if (!makeMIDPAppJar.isFile() && !(makeMIDPAppJar = new File(home + File.separator + "Converter" + File.separator + "Converter.jar")).isFile()) {
            throw new BuildException("Unable to find MakeMIDPApp.jar, be sure that \"midp4palm.home\" property is set correctly", this.location);
        }
        this.determineConverterVersion(makeMIDPAppJar);
        if (this.m_jar == null) {
            throw new BuildException("You must specify a JAR file containing classes for your application with the \"jar\" attribute", this.location);
        }
        if (!this.m_jar.getName().endsWith(".jar") && !this.m_jar.getName().endsWith(".zip")) {
            throw new BuildException("The specified jar file must have a .jar or .zip extension", this.location);
        }
        if (!this.m_jar.isFile()) {
            throw new BuildException("The specified jar, " + this.m_jar + ", either does not exist or is not a file", this.location);
        }
        if (this.m_jad != null) {
            if (!this.m_jad.isFile()) {
                throw new BuildException("The specified jad, " + this.m_jad + ", either does not exist or is not a file", this.location);
            }
        } else if (this.m_mainClass == null) {
            throw new BuildException("If you are not using a JAD you must specify a \"mainclass\" attribute as the entry point to your MIDlet");
        }
        Java helperTask = (Java)this.project.createTask("java");
        helperTask.setTaskName(this.getTaskName());
        helperTask.setFork(true);
        if (this.m_toolkitVersion.equals(VERSION_1_0_EARLY_ACCESS)) {
            helperTask.setClassname("palm.database.MakeMIDPApp");
        } else {
            helperTask.setClassname("com.sun.midp.palm.database.MakeMIDPApp");
        }
        String args = this.getCommandLineArgs();
        this.log("Creating " + this.m_prc + " with toolkit version " + this.m_toolkitVersion);
        this.log("Arguments to MakeMIDPApp: " + args, 3);
        Commandline.Argument arguments = helperTask.createArg();
        arguments.setLine(args);
        Path path = new Path(this.project);
        path.setLocation(makeMIDPAppJar);
        helperTask.setClasspath(path);
        if (helperTask.executeJava() != 0) {
            throw new BuildException("Execution of MakeMIDPApp helper failed");
        }
    }
}

