/*
 * Decompiled with CFR 0.152.
 */
package com.stampysoft.ant.j2me;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class PreverifyTask
extends Task {
    private File m_unverified;
    private File m_verified;
    private String m_classpath;

    public void setUnverified(File unverified) {
        this.m_unverified = unverified;
    }

    public void setVerified(File verified) {
        this.m_verified = verified;
    }

    public void setClasspath(String classpath) {
        this.m_classpath = classpath;
    }

    public void execute() throws BuildException {
        String os = this.project.getProperty("os.name").toLowerCase();
        String preverifyExecutable = null;
        if (os.indexOf("windows") != -1) {
            preverifyExecutable = "preverify.exe";
        } else if (os.indexOf("linux") != -1) {
            preverifyExecutable = "preverify";
        } else {
            throw new BuildException("Preverify is only supported on Windows and Linux at this time", this.location);
        }
        String toolkitHome = this.project.getProperty("j2mewtk.home");
        File executable = new File(toolkitHome + File.separator + "bin" + File.separator + preverifyExecutable);
        if (!executable.isFile()) {
            throw new BuildException("Preverify executable not found, be sure that j2mewtk.home property is set correctly", this.location);
        }
        File midpapi = new File(toolkitHome + File.separator + "lib" + File.separator + "midpapi.zip");
        if (!midpapi.isFile()) {
            throw new BuildException("midpapi.zip not found, be sure that j2mewtk.home property is set correctly", this.location);
        }
        if (this.m_unverified == null) {
            throw new BuildException("unverified attribute must be set", this.location);
        }
        if (!this.m_unverified.isDirectory()) {
            throw new BuildException("unverified " + this.m_unverified + " does not exist or is not a directory", this.location);
        }
        if (this.m_verified == null) {
            throw new BuildException("verified attribute must be set", this.location);
        }
        if (!this.m_verified.isDirectory()) {
            throw new BuildException("verified " + this.m_verified + " does not exist or is not a directory", this.location);
        }
        try {
            Path midpPath = new Path(this.project);
            midpPath.setLocation(midpapi);
            Commandline commandLine = new Commandline();
            commandLine.setExecutable(executable.getPath());
            String classpath = midpPath.toString();
            if (this.m_classpath != null) {
                classpath = classpath + File.pathSeparator + this.m_classpath;
            }
            commandLine.createArgument().setValue("-classpath");
            commandLine.createArgument().setValue(classpath);
            commandLine.createArgument().setValue("-d");
            commandLine.createArgument().setFile(this.m_verified);
            commandLine.createArgument().setFile(this.m_unverified);
            this.log("Preverifying classes to " + this.m_verified);
            this.log("Executing: " + commandLine, 3);
            Execute command = new Execute();
            command.setCommandline(commandLine.getCommandline());
            command.execute();
            if (command.getExitValue() != 0) {
                throw new BuildException("Call to preverify failed");
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.location);
        }
    }
}

