/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kssl;

import com.sun.ksecurity.Certificate;
import com.sun.ksecurity.KeyBuilder;
import com.sun.ksecurity.MessageDigest;
import com.sun.ksecurity.PublicKey;
import com.sun.ksecurity.RSAPublicKey;
import com.sun.kssl.Cipher;
import com.sun.kssl.Utils;
import java.util.Calendar;
import java.util.Date;

public class X509Certificate
extends Certificate {
    public static final byte NO_ERROR = 0;
    public static final byte EXPIRED = 1;
    public static final byte NOT_YET_VALID = 2;
    public static final byte VERIFICATION_FAILED = 3;
    public static final byte UNSUPPORTED_SIGALG = 4;
    public static final byte UNRECOGNIZED_ISSUER = 5;
    public static final byte SITENAME_MISMATCH = 6;
    public static final byte CERTIFICATE_CHAIN_TOO_LONG = 7;
    public static final byte MISSING_SIGNATURE = 8;
    public static final byte BAD_EXTENSIONS = 9;
    public static final byte INAPPROPRIATE_KEY_USAGE = 10;
    public static final byte BROKEN_CHAIN = 11;
    public static final byte CA_EXPIRED = 12;
    public static final int MISSING_PATH_LENGTH_CONSTRAINT = -1;
    public static final int UNLIMITED_CERT_CHAIN_LENGTH = 65535;
    private static final int MAX_NAME_LENGTH = 300;
    private static final byte ANY_STRING_TYPE = 0;
    private static final byte INTEGER_TYPE = 2;
    private static final byte BITSTRING_TYPE = 3;
    private static final byte OCTETSTR_TYPE = 4;
    private static final byte OID_TYPE = 6;
    private static final byte UTF8STR_TYPE = 12;
    private static final byte UNIVSTR_TYPE = 18;
    private static final byte PRINTSTR_TYPE = 19;
    private static final byte TELETEXSTR_TYPE = 20;
    private static final byte IA5STR_TYPE = 22;
    private static final byte SEQUENCE_TYPE = 48;
    private static final byte SET_TYPE = 49;
    public static final byte TYPE_EMAIL_ADDRESS = 1;
    public static final byte TYPE_DNS_NAME = 2;
    public static final byte TYPE_URI = 6;
    private static final int UTC_LENGTH = 13;
    private static final byte[][] nameAttr = new byte[][]{{3, 67, 78}, {6, 67}, {7, 76}, {8, 83, 84}, {10, 79}, {11, 79, 85}};
    private static final byte[] EMAIL_ATTR_OID = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 1};
    private static final byte[] PKCS1Seq = new byte[]{48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1};
    private static final byte NONE = -1;
    private static final byte RSA_ENCRYPTION = 1;
    private static final byte MD2_RSA = 2;
    private static final byte MD4_RSA = 3;
    private static final byte MD5_RSA = 4;
    private static final byte SHA1_RSA = 5;
    private static final byte[] PREFIX_MD5 = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16};
    private static final byte[] PREFIX_SHA1 = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    private static final byte[] NullSeq = new byte[]{5, 0};
    private static final byte[] ValiditySeq = new byte[]{48, 30};
    private static final byte[] UTCSeq = new byte[]{23, 13};
    private static final byte[] ID_KP = new byte[]{43, 6, 1, 5, 5, 7, 3};
    private boolean selfSigned = false;
    private byte version = 0;
    private byte[] fp = null;
    private String subject = null;
    private String issuer = null;
    private long from = 0L;
    private long until = 0L;
    private RSAPublicKey pubKey = null;
    private int idx = 0;
    private byte[] enc = null;
    private int TBSStart = 0;
    private int TBSLen = 0;
    private byte sigAlg = (byte)-1;
    private byte[] signature = null;
    private byte[] TBSCertHash = null;
    private boolean badExt = false;
    private byte subAltNameType;
    private Object subAltName;
    private boolean hasBC = false;
    private boolean isCA = false;
    private int pLenConstr = -1;
    private long keyUsage = -1L;
    private static final String[] KEY_USAGE = new String[]{"digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "cRLSign", "encipherOnly", "decipherOnly", "9", "10", "11", "12", "13", "14", "15", "16", "serverAuth", "clientAuth", "codeSigning", "emailProtection", "ipsecEndSystem", "ipsecTunnel", "ipsecUser", "timeStamping"};

    private X509Certificate() {
        super("X.509");
    }

    public X509Certificate(byte ver, String sub, String iss, long notBefore, long notAfter, byte[] mod, byte[] exp, byte[] chash, int pLen) throws Exception {
        super("X.509");
        this.version = ver;
        if (chash != null) {
            this.fp = new byte[chash.length];
            System.arraycopy(chash, 0, this.fp, 0, chash.length);
        }
        this.subject = new String(sub);
        this.issuer = new String(iss);
        this.from = notBefore;
        this.until = notAfter;
        this.sigAlg = (byte)-1;
        if (this.subject.compareTo(this.issuer) == 0) {
            this.selfSigned = true;
        }
        this.pubKey = (RSAPublicKey)KeyBuilder.buildKey((byte)1, (short)(mod.length << 3), false);
        this.pubKey.setModulus(mod, (short)0, (short)mod.length);
        this.pubKey.setExponent(exp, (short)0, (short)exp.length);
        if (ver == 3 && pLen != -1) {
            this.isCA = true;
            this.hasBC = true;
            this.pLenConstr = pLen;
        }
    }

    private void match(byte[] buf) throws Exception {
        if (this.idx + buf.length < this.enc.length) {
            int i = 0;
            while (i < buf.length) {
                if (this.enc[this.idx++] != buf[i]) {
                    throw new Exception("match() error 1");
                }
                ++i;
            }
        } else {
            throw new Exception("match() error 2");
        }
    }

    private int getLen(byte type) throws Exception {
        if (this.enc[this.idx] == type || type == 0 && (this.enc[this.idx] == 19 || this.enc[this.idx] == 20 || this.enc[this.idx] == 12 || this.enc[this.idx] == 22 || this.enc[this.idx] == 18)) {
            int size;
            ++this.idx;
            if ((size = this.enc[this.idx++] & 0xFF) >= 128) {
                int tmp = size - 128;
                if (tmp > 2 || this.idx + tmp > this.enc.length) {
                    throw new Exception("getLen() err 1");
                }
                size = 0;
                while (tmp > 0) {
                    size = (size << 8) + (this.enc[this.idx++] & 0xFF);
                    --tmp;
                }
            }
            return size;
        }
        throw new Exception("getLen() err 2");
    }

    private byte getAlg() throws Exception {
        try {
            this.match(PKCS1Seq);
            byte val = this.enc[this.idx++];
            this.match(NullSeq);
            return val;
        }
        catch (Exception e) {
            throw new Exception("Algorithm Id parsing failed");
        }
    }

    private String getName(int end) throws Exception {
        byte[] name = new byte[300];
        int off = 300;
        int len = 0;
        while (this.idx < end) {
            this.getLen((byte)49);
            this.getLen((byte)48);
            len = this.getLen((byte)6);
            int cidx = this.idx;
            int clen = len;
            this.idx += len;
            len = this.getLen((byte)0);
            if (len <= 0) continue;
            if (off < 300) {
                name[--off] = 59;
            }
            System.arraycopy(this.enc, this.idx, name, off -= len, len);
            this.idx += len;
            if (this.enc[cidx] == 85 && this.enc[cidx + 1] == 4) {
                int i = 0;
                while (i < nameAttr.length) {
                    if (this.enc[cidx + 2] == nameAttr[i][0]) {
                        name[--off] = 61;
                        int j = nameAttr[i].length - 1;
                        while (j > 0) {
                            name[--off] = nameAttr[i][j];
                            --j;
                        }
                    }
                    ++i;
                }
                continue;
            }
            if (!Utils.byteMatch(this.enc, cidx, EMAIL_ATTR_OID, 0, EMAIL_ATTR_OID.length)) continue;
            byte[] tmp = "EmailAddress=".getBytes();
            System.arraycopy(tmp, 0, name, off -= tmp.length, tmp.length);
        }
        return new String(name, off, 300 - off);
    }

    private static long getUTCTime(byte[] buf, int off) throws Exception {
        int[] period = new int[6];
        if (buf[off + 13 - 1] != 90) {
            throw new Exception("getUTCTime() err 1");
        }
        int i = 0;
        while (i < 6) {
            period[i] = 0;
            if (buf[2 * i + off] < 48 || buf[2 * i + off] > 57) {
                throw new Exception("getUTCTime() err 2");
            }
            period[i] = buf[2 * i + off] - 48;
            if (buf[2 * i + off + 1] < 48 || buf[2 * i + off + 1] > 57) {
                throw new Exception("getUTCTime() err 3");
            }
            period[i] = period[i] * 10 + (buf[2 * i + off + 1] - 48);
            ++i;
        }
        period[0] = period[0] < 50 ? period[0] + 2000 : period[0] + 1900;
        Calendar cal = Calendar.getInstance();
        cal.set(1, period[0]);
        cal.set(2, period[1] - 1);
        cal.set(5, period[2]);
        cal.set(11, period[3]);
        cal.set(12, period[4]);
        cal.set(13, period[5]);
        long res = cal.getTime().getTime();
        return res;
    }

    private void parseExtensions(int end) throws Exception {
        String extId = null;
        int extIdIdx = 0;
        int extIdLen = 0;
        int extValIdx = 0;
        int extValLen = 0;
        this.getLen((byte)-93);
        this.getLen((byte)48);
        while (this.idx < end) {
            extId = null;
            this.getLen((byte)48);
            extIdLen = this.getLen((byte)6);
            extIdIdx = this.idx;
            this.idx += extIdLen;
            boolean crit = false;
            if (this.enc[this.idx] == 1 && this.enc[this.idx + 1] == 1) {
                this.idx += 2;
                crit = this.enc[this.idx++] == -1;
            }
            extValLen = this.getLen((byte)4);
            extValIdx = this.idx;
            if (this.enc[extIdIdx] == 85 && this.enc[extIdIdx + 1] == 29) {
                block0 : switch (this.enc[extIdIdx + 2] & 0xFF) {
                    case 15: {
                        extId = "KU";
                        if (this.keyUsage == -1L) {
                            this.keyUsage = 0L;
                        }
                        int tmp = this.getLen((byte)3) - 1;
                        byte unused = this.enc[this.idx++];
                        int b = 0;
                        int i = 0;
                        while (i < (tmp << 3) - unused) {
                            if (i % 8 == 0) {
                                b = this.enc[this.idx++];
                            }
                            if (b < 0) {
                                this.keyUsage |= (long)(1 << i);
                            }
                            b = (byte)(b << 1);
                            ++i;
                        }
                        break;
                    }
                    case 17: {
                        StringBuffer temp = new StringBuffer();
                        int start = this.idx + 4;
                        int length = extValLen - 4;
                        extId = "SAN";
                        this.subAltNameType = (byte)(this.enc[this.idx + 2] - 128);
                        switch (this.subAltNameType) {
                            case 1: 
                            case 2: 
                            case 6: {
                                int i = 0;
                                while (i < length) {
                                    temp.append((char)this.enc[start + i]);
                                    ++i;
                                }
                                this.subAltName = temp.toString();
                                break block0;
                            }
                        }
                        this.subAltName = new byte[length];
                        int i = 0;
                        while (i < length) {
                            ((byte[])this.subAltName)[i] = this.enc[start + i];
                            ++i;
                        }
                        break;
                    }
                    case 19: {
                        this.hasBC = true;
                        extId = "BC";
                        int tmp = this.getLen((byte)48);
                        if (tmp == 0) break;
                        if (this.enc[this.idx] == 1 && this.enc[this.idx + 1] == 1 && this.enc[this.idx + 2] == -1) {
                            this.isCA = true;
                            this.idx += 3;
                        }
                        if (this.enc[this.idx] == 2 && this.enc[this.idx + 1] != 0) {
                            tmp = this.getLen((byte)2);
                            this.pLenConstr = 0;
                            int i = 0;
                            while (i < tmp) {
                                this.pLenConstr = (this.pLenConstr << 16) + this.enc[this.idx + i];
                                ++i;
                            }
                            this.idx += tmp;
                            break;
                        }
                        if (!this.isCA) break;
                        this.pLenConstr = 65535;
                        break;
                    }
                    case 37: {
                        extId = "EKU";
                        if (this.keyUsage == -1L) {
                            this.keyUsage = 0L;
                        }
                        this.getLen((byte)48);
                        while (this.idx < extValIdx + extValLen) {
                            int kuOidLen = this.getLen((byte)6);
                            if (kuOidLen == ID_KP.length + 1 && Utils.byteMatch(this.enc, this.idx, ID_KP, 0, ID_KP.length) && this.enc[this.idx + ID_KP.length] > 0 && this.enc[this.idx + ID_KP.length] < 9) {
                                this.keyUsage |= (long)(1 << 16 + this.enc[this.idx + ID_KP.length]);
                            } else if (crit) {
                                this.badExt = true;
                            }
                            this.idx += kuOidLen;
                        }
                        break;
                    }
                }
            }
            if (extId == null && crit) {
                this.badExt = true;
            }
            this.idx = extValIdx + extValLen;
        }
        if (this.idx != end) {
            throw new Exception("Extension parsing problem");
        }
    }

    public static X509Certificate generateCertificate(byte[] buf, int off, int len) throws Exception {
        if (off + len > buf.length) {
            return null;
        }
        int start = 0;
        int size = 0;
        byte[] hash = new byte[16];
        X509Certificate res = null;
        MessageDigest md = MessageDigest.getInstance((byte)1, false);
        md.doFinal(buf, off, len, hash, 0);
        res = new X509Certificate();
        res.idx = 0;
        res.enc = new byte[len];
        System.arraycopy(buf, off, res.enc, 0, len);
        res.fp = new byte[hash.length];
        System.arraycopy(hash, 0, res.fp, 0, hash.length);
        res.getLen((byte)48);
        res.TBSStart = res.idx;
        size = res.getLen((byte)48);
        int sigAlgIdx = res.idx + size;
        res.TBSLen = sigAlgIdx - res.TBSStart;
        if ((res.enc[res.idx] & 0xF0) == 160) {
            ++res.idx;
            if (res.idx + (size = res.enc[res.idx++] & 0xFF) > res.enc.length) {
                throw new Exception("Version info too long");
            }
            res.version = (byte)(1 + res.enc[res.idx + (size - 1)]);
            res.idx += size;
        } else {
            res.version = 1;
        }
        size = res.getLen((byte)2);
        res.idx += size;
        byte id = res.getAlg();
        start = res.idx;
        size = res.getLen((byte)48);
        int end = res.idx + size;
        try {
            res.issuer = res.getName(end);
        }
        catch (Exception e) {
            throw new Exception("Could not parse issuer name");
        }
        try {
            res.match(ValiditySeq);
            res.match(UTCSeq);
            res.from = X509Certificate.getUTCTime(res.enc, res.idx);
            res.idx += 13;
            res.match(UTCSeq);
            res.until = X509Certificate.getUTCTime(res.enc, res.idx);
            res.idx += 13;
        }
        catch (Exception e) {
            throw new Exception("Could not parse validity information, caught " + e);
        }
        start = res.idx;
        size = res.getLen((byte)48);
        end = res.idx + size;
        if (size != 0) {
            try {
                res.subject = res.getName(end);
            }
            catch (Exception e) {
                throw new Exception("Could not parse subject name");
            }
        }
        res.getLen((byte)48);
        id = res.getAlg();
        if (id != 1) {
            throw new Exception("Not an RSA certificate");
        }
        res.getLen((byte)3);
        if (res.enc[res.idx++] != 0) {
            throw new Exception("Bitstring error while parsing public key information");
        }
        res.getLen((byte)48);
        size = res.getLen((byte)2);
        if (res.enc[res.idx] == 0) {
            --size;
            ++res.idx;
        }
        res.pubKey = (RSAPublicKey)KeyBuilder.buildKey((byte)1, (short)(size << 3), false);
        res.pubKey.setModulus(res.enc, (short)res.idx, (short)size);
        res.idx += size;
        size = res.getLen((byte)2);
        if (res.enc[res.idx] == 0) {
            --size;
            ++res.idx;
        }
        res.pubKey.setExponent(res.enc, (short)res.idx, (short)size);
        res.idx += size;
        if (res.idx != sigAlgIdx) {
            if (res.version < 3) {
                throw new Exception("Unexpected extensions in cert");
            }
            res.parseExtensions(sigAlgIdx);
        }
        res.sigAlg = res.getAlg();
        if (res.sigAlg == 4) {
            res.TBSCertHash = new byte[md.getLength()];
            md.doFinal(buf, off + res.TBSStart, res.TBSLen, res.TBSCertHash, 0);
        } else if (res.sigAlg == 5) {
            MessageDigest mdSha = MessageDigest.getInstance((byte)2, false);
            res.TBSCertHash = new byte[mdSha.getLength()];
            mdSha.doFinal(buf, off + res.TBSStart, res.TBSLen, res.TBSCertHash, 0);
        }
        size = res.getLen((byte)3);
        if (res.enc[res.idx++] != 0) {
            throw new Exception("Bitstring error in signature parsing");
        }
        int sigLen = size - 1 + 7 >>> 3 << 3;
        res.signature = new byte[sigLen];
        System.arraycopy(res.enc, res.idx, res.signature, sigLen - (size - 1), size - 1);
        return res;
    }

    void destroy() {
        this.issuer = null;
        this.subject = null;
        this.TBSCertHash = null;
        this.enc = null;
        this.signature = null;
        this.fp = null;
        this.pubKey = null;
    }

    public byte[] getFingerprint() {
        byte[] res = new byte[16];
        if (this.fp != null) {
            System.arraycopy(this.fp, 0, res, 0, res.length);
        }
        return res;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public Date getNotBefore() {
        return new Date(this.from);
    }

    public Date getNotAfter() {
        return new Date(this.until);
    }

    public byte checkExtensions() {
        return this.badExt ? (byte)9 : 0;
    }

    public byte checkValidity() {
        long t = System.currentTimeMillis();
        if (t < this.from) {
            return 2;
        }
        if (t > this.until) {
            return 1;
        }
        return 0;
    }

    public byte checkValidity(Date date) {
        long t = date.getTime();
        if (t < this.from) {
            return 2;
        }
        if (t > this.until) {
            return 1;
        }
        return 0;
    }

    public PublicKey getPublicKey() {
        return this.pubKey;
    }

    public int getVersion() {
        return this.version;
    }

    public int getBasicConstraints() {
        if (this.isCA) {
            return this.pLenConstr;
        }
        return -1;
    }

    public int getKeyUsage() {
        return (int)this.keyUsage;
    }

    public int getSubjectAltNameType() {
        return this.subAltNameType;
    }

    public Object getSubjectAltName() {
        return this.subAltName;
    }

    public byte verify(PublicKey pk) {
        int val;
        if (pk.getType() != 1) {
            return 3;
        }
        if (this.selfSigned) {
            return this.pubKey.equals((RSAPublicKey)pk) ? (byte)0 : 3;
        }
        if (this.signature == null) {
            return 8;
        }
        if (this.TBSCertHash == null) {
            return 4;
        }
        int modLen = pk.getSize() >>> 3;
        byte[] result = new byte[modLen];
        try {
            Cipher rsa = Cipher.getInstance((byte)2, false);
            rsa.init(pk, (byte)2);
            val = rsa.doFinal(this.signature, 0, this.signature.length, result, 0);
        }
        catch (Exception e) {
            return 3;
        }
        if (this.sigAlg == 4 && val == PREFIX_MD5.length + this.TBSCertHash.length && Utils.byteMatch(result, 0, PREFIX_MD5, 0, PREFIX_MD5.length) && Utils.byteMatch(result, PREFIX_MD5.length, this.TBSCertHash, 0, this.TBSCertHash.length)) {
            return 0;
        }
        if (this.sigAlg == 5 && val == PREFIX_SHA1.length + this.TBSCertHash.length && Utils.byteMatch(result, 0, PREFIX_SHA1, 0, PREFIX_SHA1.length) && Utils.byteMatch(result, PREFIX_SHA1.length, this.TBSCertHash, 0, this.TBSCertHash.length)) {
            return 0;
        }
        return 3;
    }

    public String getSigAlgName() {
        if (this.sigAlg == 4) {
            return "MD5withRSA";
        }
        if (this.sigAlg == 2) {
            return "MD2withRSA";
        }
        if (this.sigAlg == 5) {
            return "SHA1withRSA";
        }
        if (this.sigAlg == -1) {
            return "None";
        }
        if (this.sigAlg == 3) {
            return "MD4withRSA";
        }
        return "Unknown (" + this.sigAlg + ")";
    }

    private String date2str(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        String d = c.get(2) + 1 + "/" + c.get(5) + "/" + c.get(1) + " " + c.get(11) + ":" + c.get(12) + ":" + c.get(13);
        return d;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("[Type: ");
        tmp.append(this.getType());
        tmp.append("v");
        tmp.append(this.version);
        tmp.append("\n");
        tmp.append("Subject: ");
        tmp.append(this.subject);
        tmp.append("\n");
        tmp.append("Issuer: ");
        tmp.append(this.issuer);
        tmp.append("\n");
        tmp.append("Valid from ");
        tmp.append(this.date2str(this.getNotBefore()));
        tmp.append(" GMT until ");
        tmp.append(this.date2str(this.getNotAfter()));
        tmp.append(" GMT");
        tmp.append("\n");
        tmp.append("Signature Algorithm: ");
        tmp.append(this.getSigAlgName());
        if (this.subAltName != null) {
            tmp.append("\n");
            tmp.append("SubjectAltName: ");
            tmp.append(this.subAltName);
            tmp.append("(type ");
            tmp.append(this.subAltNameType);
            tmp.append(")");
        }
        if (this.keyUsage != -1L) {
            tmp.append("\n");
            tmp.append("KeyUsage:");
            int t = (int)this.keyUsage;
            int i = 0;
            while (i < KEY_USAGE.length) {
                if ((t & 1) == 1) {
                    tmp.append(" ");
                    tmp.append(KEY_USAGE[i]);
                }
                t >>>= 1;
                ++i;
            }
        }
        if (this.hasBC) {
            tmp.append("\n");
            tmp.append("BasicConstraints: ");
            tmp.append(this.isCA ? "is a CA" : "not a CA");
            tmp.append(" (pathLengthConstraint ");
            if (this.pLenConstr == -1 || this.pLenConstr == 65535) {
                tmp.append("absent");
            } else {
                tmp.append(this.pLenConstr);
            }
            tmp.append(")");
        }
        tmp.append("]");
        return tmp.toString();
    }
}

