/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.lcdui;

import com.sun.midp.lcdui.DisplayAccess;
import com.sun.midp.lcdui.EventHandler;
import com.sun.midp.lcdui.Events;
import com.sun.midp.midlet.Scheduler;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;

public class EmulEventHandler
implements EventHandler {
    private static boolean debug = false;
    private static DisplayAccess noRecipient = new DisplayAccess(){

        public Display getDisplay() {
            return null;
        }

        public void commandAction(int n) {
        }

        public void pointerEvent(int type, int x, int y) {
        }

        public void keyEvent(int type, int keyCode) {
        }

        public void timerEvent(int type) {
        }

        public void suspendPainting() {
        }

        public void resumePainting() {
        }

        public void setForeground(boolean hasForeground) {
        }

        public void inputMethodEvent(String str) {
        }

        public boolean hasCurrent() {
            return false;
        }
    };
    private DisplayAccess current = noRecipient;
    private Thread eventThread;
    private boolean canUseScreen = true;
    private Displayable currentWidget = null;

    public native void scheduleTimer(int var1, int var2);

    public native int getKeyCode(int var1);

    public native String getKeyName(int var1);

    public int getSystemKey(int keyCode) {
        return EmulEventHandler.getSystemKeyImpl(keyCode);
    }

    public int getGameAction(int keyCode) {
        return EmulEventHandler.getGameActionImpl(keyCode);
    }

    static native int getSystemKeyImpl(int var0);

    static native int getGameActionImpl(int var0);

    public native void addToCommandSet(Command var1);

    public native void closeCommandSet();

    public void updateCommandSet(Command[] commands, int numCommands) {
        int i = 0;
        while (i < numCommands) {
            this.addToCommandSet(commands[i]);
            ++i;
        }
        this.closeCommandSet();
        this.updateWidget();
    }

    public void setEventRecipient(DisplayAccess da, boolean shouldReceiveEvents) {
        if (shouldReceiveEvents) {
            this.current = da;
        } else if (this.current == da) {
            this.current = noRecipient;
        }
        this.updateWidget();
    }

    public EmulEventHandler() {
        try {
            Events queue = new Events();
            queue.open();
            this.eventThread = new Thread(new EventLoop(queue));
            this.eventThread.start();
        }
        catch (IOException x) {
            throw new Error();
        }
    }

    public boolean isDispatchThread() {
        return Thread.currentThread() == this.eventThread;
    }

    public void clearSystemScreen() {
    }

    private native boolean canUseScreen();

    private native void setCurrentWidget(String var1);

    private synchronized void updateWidget() {
        Display display = this.current.getDisplay();
        if (display == null) {
            if (this.currentWidget != null) {
                this.currentWidget = null;
                this.setCurrentWidget("None");
            }
        } else {
            Displayable widget = display.getCurrent();
            if (this.currentWidget != widget) {
                this.currentWidget = widget;
                if (widget instanceof TextBox) {
                    this.setCurrentWidget("TextBox");
                } else if (widget instanceof Canvas) {
                    this.setCurrentWidget("Canvas");
                } else {
                    this.setCurrentWidget(widget.getClass().toString());
                }
            }
        }
    }

    private class EventLoop
    implements Runnable {
        private Events in;

        public EventLoop(Events in) {
            this.in = in;
        }

        public synchronized void run() {
            String state = "Initializing";
            block8: while (true) {
                try {
                    if (debug) {
                        state = "event loop";
                    }
                    int evt = this.in.readInt();
                    if (debug) {
                        System.out.println("EmulEventHandler: Event type " + evt);
                    }
                    boolean couldUseScreen = EmulEventHandler.this.canUseScreen;
                    EmulEventHandler.this.canUseScreen = EmulEventHandler.this.canUseScreen();
                    if (EmulEventHandler.this.canUseScreen != couldUseScreen) {
                        if (EmulEventHandler.this.canUseScreen) {
                            EmulEventHandler.this.current.resumePainting();
                        } else {
                            EmulEventHandler.this.current.suspendPainting();
                        }
                    }
                    switch (evt) {
                        case 1: {
                            int type = this.in.readInt();
                            int code = this.in.readInt();
                            if (EmulEventHandler.this.getSystemKey(code) == 3 && type == 2) {
                                if (debug) {
                                    state = "Scheduler.getScheduler().notifyEnd()";
                                }
                                Scheduler.getScheduler().notifyEnd(EmulEventHandler.this.current);
                                break;
                            }
                            if (!EmulEventHandler.this.canUseScreen) continue block8;
                            if (debug) {
                                System.out.println("EmulEventHandler: Key Event, type = " + type + ", code = " + code);
                            }
                            if (debug) {
                                state = "current.keyEvent()";
                            }
                            EmulEventHandler.this.current.keyEvent(type, code);
                            break;
                        }
                        case 2: {
                            int type = this.in.readInt();
                            int x = this.in.readInt();
                            int y = this.in.readInt();
                            if (!EmulEventHandler.this.canUseScreen) continue block8;
                            if (debug) {
                                state = "current.pointerEvent()";
                            }
                            EmulEventHandler.this.current.pointerEvent(type, x, y);
                            break;
                        }
                        case 3: {
                            int type = this.in.readInt();
                            if (debug) {
                                System.out.println("EmulEventHandler: command index " + type);
                                System.out.println("Current: " + EmulEventHandler.this.current);
                            }
                            if (type < 0) continue block8;
                            if (debug) {
                                state = "current.commandAction()";
                            }
                            EmulEventHandler.this.current.commandAction(type);
                            break;
                        }
                        case 4: {
                            int type = this.in.readInt();
                            if (debug) {
                                System.out.println("EmulEventHandler: timer type " + type);
                            }
                            if (debug) {
                                state = "current.timerEvent(type=" + type + ")";
                            }
                            EmulEventHandler.this.current.timerEvent(type);
                            break;
                        }
                        default: {
                            System.out.println("Unknown event type " + evt);
                            break;
                        }
                    }
                    continue;
                }
                catch (Throwable t) {
                    System.err.println(t);
                    if (!debug) continue;
                    System.err.println("  in " + state);
                    System.err.println("  called from EmulEventHandler");
                    continue;
                }
                break;
            }
        }
    }
}

