/* gkrellm-bluez - A BlueZ monitor plug-in for GKrellM2
 *
 * Copyright (C) 2006 Ludovic Cintrat <lcintrat@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gkrellm-bluez.h"
#include "gkrellm-bluez-monitor.h"

#define HCI_STRING "hci%d"

GkrellmBlueZMonitor *
gkrellm_bluez_monitor_create (gint16 devid)
{
  GkrellmBlueZMonitor *bluezmon;

  bluezmon = g_new0 (GkrellmBlueZMonitor, 1);

  bluezmon->devid     = devid;
  bluezmon->interface = g_strdup_printf (HCI_STRING, devid);

  bluezmon->rx_bytes = 0;
  bluezmon->tx_bytes = 0;
  bluezmon->rx_bytes_old = 0;
  bluezmon->tx_bytes_old = 0;
  bluezmon->updated = FALSE;
  bluezmon->chart = NULL;

  gkrellm_bluez_monitor_list = g_list_insert_sorted (gkrellm_bluez_monitor_list,
						     bluezmon,
						     gkrellm_bluez_monitor_compare);
  return bluezmon;
}

void
gkrellm_bluez_monitor_delete (GkrellmBlueZMonitor *bluezmon)
{
  gkrellm_bluez_monitor_list = g_list_remove( gkrellm_bluez_monitor_list,
					      bluezmon );
  g_free( bluezmon );
}


GkrellmBlueZMonitor *
gkrellm_bluez_monitor_find (gint16 devid)
{
  GkrellmBlueZMonitor *bluezmon;
  GList              *list;

  bluezmon = g_new0 (GkrellmBlueZMonitor, 1);
  bluezmon->devid = devid;

  list = g_list_find_custom (gkrellm_bluez_monitor_list,
                             bluezmon,
                             gkrellm_bluez_monitor_compare);

  if (list)
    {
      g_free (bluezmon);

      bluezmon = list->data;
    }
  else
    {
      g_free (bluezmon);

      bluezmon = NULL;
    }

  return bluezmon;
}

gint
gkrellm_bluez_monitor_compare (gconstpointer a,
                               gconstpointer b)
{
  const GkrellmBlueZMonitor *alpha;
  const GkrellmBlueZMonitor *bravo;

  g_assert (a != NULL);
  g_assert (b != NULL);

  alpha = a;
  bravo = b;

  return alpha->devid - bravo->devid;
}
