/* $Id: builtins.c,v 1.1 2005/09/14 09:29:51 cegger Exp $
   ******************************************************************************

   libggigcp builtin target bindings.

   Copyright (C) 2005 Christoph Egger

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

   ******************************************************************************
 */

#include <stdio.h>
#include <string.h>

#include "config.h"
#include <ggi/gg.h> /* We use LibGG to manage config files */
#include <ggi/internal/gcp_debug.h>


typedef int (ggigcpfunc_dlinit)(int, void **);

#ifdef BUILTIN_DEFAULT
ggigcpfunc_dlinit GCPdl_color_gcp;
#endif


struct target {
	const char *target;
	ggigcpfunc_dlinit *func;
};

static struct target _targets[] = {

#ifdef BUILTIN_DEFAULT
	{ "GCPdl_color_gcp", &GCPdl_color_gcp },
#endif
	{ NULL, NULL }
};



static void * _builtins_get(void * _, const char *symbol)
{
	struct target *t;

	for (t = _targets; t->target != NULL; t++) {
		if (!strcmp(t->target, symbol)) {
			DPRINT_LIBS("builtin symbol found: '%s'\n", symbol);
			return t->func;
		}
	}
	DPRINT_LIBS("builtin symbol '%s' not found\n", symbol);
	return NULL;
}

static gg_scope _builtins;

void _ggigcpInitBuiltins(void);
void _ggigcpExitBuiltins(void);

void _ggigcpInitBuiltins(void)
{
	_builtins = ggNewScope("@libggigcp", NULL, &_builtins_get, NULL);
}

void _ggigcpExitBuiltins(void)
{
	ggDelScope(_builtins);
}
