/*
 * SPDX-License-Identifier: GPL-3.0-only
 * MuseScore-Studio-CLA-applies
 *
 * MuseScore Studio
 * Music Composition & Notation
 *
 * Copyright (C) 2021 MuseScore Limited
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
#pragma once

#include <array>
#include <vector>

#include "global/types/string.h"

#include "../types/propertyvalue.h"
#include "../dom/property.h"

namespace mu::engraving {
// Needs to be duplicated here and in symid.h since moc doesn't handle macros from #include'd files
#ifdef SCRIPT_INTERFACE
#define BEGIN_QT_REGISTERED_ENUM(Name) \
    class MSQE_##Name { \
        Q_GADGET \
    public:
#define END_QT_REGISTERED_ENUM(Name) \
    Q_ENUM(Name); \
}; \
    using Name = MSQE_##Name::Name;
#else
#define BEGIN_QT_REGISTERED_ENUM(Name)
#define END_QT_REGISTERED_ENUM(Name)
#endif

//---------------------------------------------------------
//   Sid
///   Enumerates the list of score style settings
//
//    Keep in sync with styleTypes[] in styledef.cpp
//---------------------------------------------------------

BEGIN_QT_REGISTERED_ENUM(Sid)
enum class Sid {
    ///.\{
    NOSTYLE = -1,

    pageWidth,
    pageHeight,
    pagePrintableWidth,
    pageEvenLeftMargin,
    pageOddLeftMargin,
    pageEvenTopMargin,
    pageEvenBottomMargin,
    pageOddTopMargin,
    pageOddBottomMargin,
    pageTwosided,

    staffUpperBorder,
    staffLowerBorder,
    staffHeaderFooterPadding,
    staffDistance,
    instrumentNameOffset,
    akkoladeDistance,
    minSystemDistance,
    maxSystemDistance,
    alignSystemToMargin,

    enableVerticalSpread,
    spreadSystem,
    spreadSquareBracket,
    spreadCurlyBracket,
    minSystemSpread,
    maxSystemSpread,
    minStaffSpread,
    maxStaffSpread,
    maxAkkoladeDistance,
    maxPageFillSpread,

    lyricsPlacement,
    lyricsPosAbove,
    lyricsPosBelow,
    lyricsMinTopDistance, // actual meaning: distance to elements on same staff
    lyricsMinBottomDistance, // actual meaning: distance to elements on other staff
    lyricsMinDistance, // actual meaning: min horizontal spacing of lyrics-to-lyrics
    lyricsLineHeight,
    lyricsDashMinLength,
    lyricsDashMaxLength,
    lyricsDashMaxDistance,
    lyricsDashForce,
    lyricsDashFirstAndLastGapAreHalf,
    lyricsAlignVerseNumber,
    lyricsLineThickness,
    lyricsMelismaAlign,
    lyricsMelismaPad,
    lyricsDashPad,
    lyricsDashLineThickness,
    lyricsDashYposRatio,

    lyricsShowDashIfSyllableOnFirstNote,
    lyricsMelismaForce,
    lyricsMelismaMinLength,
    lyricsDashPosAtStartOfSystem,
    lyricsAvoidBarlines,
    lyricsLimitDashCount,
    lyricsMaxDashCount,
    lyricsCenterDashedSyllables,

    lyricsOddFontFace,
    lyricsOddFontSize,
    lyricsOddLineSpacing,
    lyricsOddFontSpatiumDependent,
    lyricsOddFontStyle,
    lyricsOddColor,
    lyricsOddAlign,
    lyricsOddFrameType,
    lyricsOddFramePadding,
    lyricsOddFrameWidth,
    lyricsOddFrameRound,
    lyricsOddFrameFgColor,
    lyricsOddFrameBgColor,
    lyricsOddPosition,

    lyricsEvenFontFace,
    lyricsEvenFontSize,
    lyricsEvenLineSpacing,
    lyricsEvenFontSpatiumDependent,
    lyricsEvenFontStyle,
    lyricsEvenColor,
    lyricsEvenAlign,
    lyricsEvenFrameType,
    lyricsEvenFramePadding,
    lyricsEvenFrameWidth,
    lyricsEvenFrameRound,
    lyricsEvenFrameFgColor,
    lyricsEvenFrameBgColor,
    lyricsEvenPosition,

    figuredBassFontFamily,
    //      figuredBassFontSize,
    figuredBassYOffset,
    figuredBassLineHeight,
    figuredBassAlignment,
    figuredBassStyle,
    systemFrameDistance,
    frameSystemDistance,
    paddingToNotationAbove,
    paddingToNotationBelow,
    minMeasureWidth,

    barWidth,
    doubleBarWidth,
    endBarWidth,
    doubleBarDistance,
    endBarDistance,
    repeatBarlineDotSeparation,
    repeatBarTips,
    startBarlineSingle,
    startBarlineMultiple,
    maskBarlinesForText,

    bracketWidth,
    bracketDistance,
    akkoladeWidth,
    akkoladeBarDistance,
    dividerLeft,
    dividerLeftSym,
    dividerLeftX,
    dividerLeftY,
    dividerRight,
    dividerRightSym,
    dividerRightX,
    dividerRightY,

    clefLeftMargin,
    keysigLeftMargin,
    ambitusMargin,
    timesigLeftMargin,

    midClefKeyRightMargin,
    clefKeyRightMargin,
    clefKeyDistance,
    clefTimesigDistance,
    keyTimesigDistance,
    keyBarlineDistance,
    systemHeaderDistance,
    systemHeaderTimeSigDistance,
    systemHeaderMinStartOfSystemDistance,
    systemTrailerRightMargin,

    clefBarlineDistance,
    timesigBarlineDistance,

    timeSigPlacement,

    timeSigCenterOnBarline,
    timeSigVSMarginCentered,
    timeSigVSMarginNonCentered,
    timeSigCenterAcrossStaveGroup,

    timeSigNormalStyle,
    timeSigNormalScale,
    timeSigNormalScaleLock,
    timeSigNormalNumDist,
    timeSigNormalY,
    timeSigAboveStyle,
    timeSigAboveScale,
    timeSigAboveScaleLock,
    timeSigAboveNumDist,
    timeSigAboveY,
    timeSigAcrossStyle,
    timeSigAcrossScale,
    timeSigAcrossScaleLock,
    timeSigAcrossNumDist,
    timeSigAcrossY,

    useStraightNoteFlags,
    stemWidth,
    shortenStem,
    stemLength,
    stemLengthSmall,
    shortStemStartLocation,
    shortestStem,
    combineVoice,
    beginRepeatLeftMargin,
    minNoteDistance,
    barNoteDistance,
    barAccidentalDistance,
    noteBarDistance,

    spacingDensity,
    measureSpacing, // At some point we should rename this. This name is a legacy relic. This is now the spacing ratio.
    measureRepeatNumberPos,
    mrNumberSeries,
    mrNumberEveryXMeasures,
    mrNumberSeriesWithParentheses,
    oneMeasureRepeatShow1,
    fourMeasureRepeatShowExtenders,
    staffLineWidth,
    ledgerLineWidth,
    ledgerLineLength,
    stemSlashPosition,
    stemSlashAngle,
    stemSlashThickness,
    accidentalDistance,
    accidentalNoteDistance,
    bracketedAccidentalPadding,
    alignAccidentalsLeft,
    accidentalOrderFollowsNoteDisplacement,
    alignAccidentalOctavesAcrossSubChords,
    keepAccidentalSecondsTogether,
    alignOffsetOctaveAccidentals,
    keysigAccidentalDistance,
    keysigNaturalDistance,
    beamWidth,
    useWideBeams,
    beamMinLen,
    beamNoSlope,
    snapCustomBeamsToGrid,
    frenchStyleBeams,

    dotMag,
    dotNoteDistance,
    dotRestDistance,
    dotDotDistance,
    propertyDistanceHead,
    propertyDistanceStem,
    propertyDistance,
    articulationMag,
    articulationPosAbove,
    articulationAnchorDefault,
    articulationAnchorLuteFingering,
    articulationAnchorOther,
    articulationStemHAlign,
    articulationKeepTogether,
    trillAlwaysShowCueNote,
    lastSystemFillLimit,

    hairpinPlacement,
    hairpinPosAbove,
    hairpinPosBelow,
    hairpinLinePosAbove,
    hairpinLinePosBelow,
    hairpinHeight,
    hairpinContHeight,
    hairpinLineWidth,
    hairpinFontFace,
    hairpinFontSize,
    hairpinLineSpacing,
    hairpinFontSpatiumDependent,
    hairpinFontStyle,
    hairpinColor,
    hairpinTextAlign,
    hairpinFrameType,
    hairpinFramePadding,
    hairpinFrameWidth,
    hairpinFrameRound,
    hairpinFrameFgColor,
    hairpinFrameBgColor,
    hairpinPosition,
    hairpinText,
    hairpinCrescText,
    hairpinDecrescText,
    hairpinCrescContText,
    hairpinDecrescContText,
    hairpinLineStyle,
    hairpinDashLineLen,
    hairpinDashGapLen,
    hairpinLineLineStyle,
    hairpinLineDashLineLen,
    hairpinLineDashGapLen,

    pedalPlacement,
    pedalPosAbove,
    pedalPosBelow,
    pedalLineWidth,
    pedalLineStyle,
    pedalDashLineLen,
    pedalDashGapLen,
    pedalHookHeight,
    pedalFontFace,
    pedalFontSize,
    pedalLineSpacing,
    pedalFontSpatiumDependent,
    pedalMusicalSymbolsScale,
    pedalFontStyle,
    pedalColor,
    pedalTextAlign,
    pedalFrameType,
    pedalFramePadding,
    pedalFrameWidth,
    pedalFrameRound,
    pedalFrameFgColor,
    pedalFrameBgColor,
    pedalPosition,
    pedalText,
    pedalHookText,
    pedalContinueText,
    pedalContinueHookText,
    pedalEndText,
    pedalRosetteEndText,

    trillPlacement,
    trillPosAbove,
    trillPosBelow,

    vibratoPlacement,
    vibratoPosAbove,
    vibratoPosBelow,

    harmonyFretDist,
    minHarmonyDistance,
    harmonyHarmonyDistance,
    maxHarmonyBarDistance,
    maxChordShiftAbove,
    maxChordShiftBelow,

    harmonyPlacement,
    romanNumeralPlacement,
    nashvilleNumberPlacement,
    harmonyVoiceLiteral,
    harmonyVoicing,
    harmonyDuration,

    chordSymbolAPosAbove,
    chordSymbolAPosBelow,

    chordSymbolBPosAbove,
    chordSymbolBPosBelow,

    romanNumeralPosAbove,
    romanNumeralPosBelow,

    nashvilleNumberPosAbove,
    nashvilleNumberPosBelow,

    chordSymbolAFontFace,
    chordSymbolAFontSize,
    chordSymbolALineSpacing,
    chordSymbolAFontSpatiumDependent,
    chordSymbolAFontStyle,
    chordSymbolAColor,
    chordSymbolAAlign,
    chordSymbolAFrameType,
    chordSymbolAFramePadding,
    chordSymbolAFrameWidth,
    chordSymbolAFrameRound,
    chordSymbolAFrameFgColor,
    chordSymbolAFrameBgColor,
    // chordSymbolAPosition,

    chordSymbolBFontFace,
    chordSymbolBFontSize,
    chordSymbolBLineSpacing,
    chordSymbolBFontSpatiumDependent,
    chordSymbolBFontStyle,
    chordSymbolBColor,
    chordSymbolBAlign,
    chordSymbolBFrameType,
    chordSymbolBFramePadding,
    chordSymbolBFrameWidth,
    chordSymbolBFrameRound,
    chordSymbolBFrameFgColor,
    chordSymbolBFrameBgColor,
    // chordSymbolBPosition,

    romanNumeralFontFace,
    romanNumeralFontSize,
    romanNumeralLineSpacing,
    romanNumeralFontSpatiumDependent,
    romanNumeralFontStyle,
    romanNumeralColor,
    romanNumeralAlign,
    romanNumeralFrameType,
    romanNumeralFramePadding,
    romanNumeralFrameWidth,
    romanNumeralFrameRound,
    romanNumeralFrameFgColor,
    romanNumeralFrameBgColor,

    nashvilleNumberFontFace,
    nashvilleNumberFontSize,
    nashvilleNumberLineSpacing,
    nashvilleNumberFontSpatiumDependent,
    nashvilleNumberFontStyle,
    nashvilleNumberColor,
    nashvilleNumberAlign,
    nashvilleNumberFrameType,
    nashvilleNumberFramePadding,
    nashvilleNumberFrameWidth,
    nashvilleNumberFrameRound,
    nashvilleNumberFrameFgColor,
    nashvilleNumberFrameBgColor,

    capoPosition,
    fretNumMag,
    fretNumPos,
    fretY,
    fretMinDistance,
    fretMag,
    fretPlacement,
    fretStrings,
    fretFrets,
    fretNut,
    fretDotSize,
    fretDotSpatiumSize,
    fretStringSpacing,
    fretFretSpacing,
    fretOrientation,
    maxFretShiftAbove,
    maxFretShiftBelow,
    fretNutThickness,
    fretUseCustomSuffix,
    fretCustomSuffix,
    barreAppearanceSlur,
    barreLineWidth,
    fretShowFingerings,
    fretStyleExtended,

    showPageNumber,
    showPageNumberOne,
    pageNumberOddEven,
    showMeasureNumber,
    showMeasureNumberOne,
    measureNumberInterval,
    measureNumberSystem,
    measureNumberPlacementMode,

    smallNoteMag,
    scaleRythmicSpacingForSmallNotes,
    graceNoteMag,
    graceToMainNoteDist,
    graceToGraceNoteDist,
    smallStaffMag,
    smallClefMag,
    genClef,
    hideTabClefAfterFirst,
    genKeysig,
    genCourtesyTimesig,
    genCourtesyKeysig,
    genCourtesyClef,

    keySigCourtesyBarlineMode,
    timeSigCourtesyBarlineMode,

    barlineBeforeSigChange,
    doubleBarlineBeforeKeySig,
    doubleBarlineBeforeTimeSig,

    swingRatio,
    swingUnit,

    chordSymbolSpelling,
    automaticCapitalization,
    lowerCaseMinorChords,
    lowerCaseBassNotes,
    allCapsNoteNames,
    chordStyle,
    chordsXmlFile,
    chordDescriptionFile,
    chordExtensionMag,
    chordExtensionAdjust,
    chordModifierMag,
    chordModifierAdjust,
    verticallyStackModifiers,
    chordStackedModifierMag,
    chordBassNoteStagger,
    chordBassNoteScale,
    polychordDividerThickness,
    polychordDividerSpacing,
    verticallyAlignChordSymbols,
    chordSymPosition,
    chordAlignmentToFretboard,
    chordAlignmentExcludeModifiers,

    concertPitch,
    multiVoiceRestTwoSpaceOffset,
    mergeMatchingRests,
    createMultiMeasureRests,
    minEmptyMeasures,
    singleMeasureMMRestUseNormalRest,
    singleMeasureMMRestShowNumber,
    minMMRestWidth,
    mmRestConstantWidth,
    mmRestReferenceWidth,
    mmRestMaxWidthIncrease,
    mmRestNumberPos,
    mmRestBetweenStaves,
    mmRestNumberMaskHBar,
    multiMeasureRestMargin,
    mmRestHBarThickness,
    mmRestHBarVStrokeThickness,
    mmRestHBarVStrokeHeight,
    oldStyleMultiMeasureRests,
    mmRestOldStyleMaxMeasures,
    mmRestOldStyleSpacing,
    hideEmptyStaves,
    dontHideStavesInFirstSystem,
    enableIndentationOnFirstSystem,
    firstSystemIndentationValue,
    alwaysShowBracketsWhenEmptyStavesAreHidden,
    alwaysShowSquareBracketsWhenEmptyStavesAreHidden,
    hideInstrumentNameIfOneInstrument,
    firstSystemInstNameVisibility,
    subsSystemInstNameVisibility,
    gateTime,
    tenutoGateTime,
    staccatoGateTime,
    slurGateTime,

    arpeggioNoteDistance,
    arpeggioAccidentalDistance,
    arpeggioAccidentalDistanceMin,
    arpeggioLineWidth,
    arpeggioHookLen,
    arpeggioHiddenInStdIfTab,

    slurEndWidth,
    slurMidWidth,
    slurDottedWidth,
    angleHangingSlursAwayFromStaff,
    tieEndWidth,
    tieMidWidth,
    tieDottedWidth,
    minTieLength,
    minHangingTieLength,
    minStraightGlissandoLength,
    minWigglyGlissandoLength,
    slurMinDistance,
    tieMinDistance,
    laissezVibMinDistance,
    headerToLineStartDistance,   // determines start point of "dangling" lines (ties, gliss, lyrics...) when preceded by header clefs/timesigs/keysigs
    lineEndToBarlineDistance,  // determines end point of "dangling" lines (ties, gliss, lyrics...) in relation to barlines
    barlineToLineStartDistance, // determines start point of incoming partial ties and slurs in relation to the preceding barline

    tiePlacementSingleNote,
    tiePlacementChord,
    tieDotsPlacement,
    tieMinShoulderHeight,
    tieMaxShoulderHeight,

    minLaissezVibLength,
    laissezVibUseSmuflSym,

    sectionPause,
    musicalSymbolFont,
    musicalTextFont,

    showHeader,
    headerFirstPage,
    headerOddEven,
    evenHeaderL,
    evenHeaderC,
    evenHeaderR,
    oddHeaderL,
    oddHeaderC,
    oddHeaderR,

    showFooter,
    footerFirstPage,
    footerOddEven,
    evenFooterL,
    evenFooterC,
    evenFooterR,
    oddFooterL,
    oddFooterC,
    oddFooterR,

    voltaPosAbove,
    voltaHook,
    voltaLineWidth,
    voltaLineStyle,
    voltaDashLineLen,
    voltaDashGapLen,
    voltaFontFace,
    voltaFontSize,
    voltaLineSpacing,
    voltaFontSpatiumDependent,
    voltaFontStyle,
    voltaColor,
    voltaAlign,
    voltaOffset,
    voltaFrameType,
    voltaFramePadding,
    voltaFrameWidth,
    voltaFrameRound,
    voltaFrameFgColor,
    voltaFrameBgColor,
    voltaPosition,

    voltaAlignStartBeforeKeySig,
    voltaAlignEndLeftOfBarline,

    ottava8VAPlacement,
    ottava8VBPlacement,
    ottava15MAPlacement,
    ottava15MBPlacement,
    ottava22MAPlacement,
    ottava22MBPlacement,

    ottava8VAText,
    ottava8VAContinueText,
    ottava8VBText,
    ottava8VBContinueText,
    ottava15MAText,
    ottava15MAContinueText,
    ottava15MBText,
    ottava15MBContinueText,
    ottava22MAText,
    ottava22MAContinueText,
    ottava22MBText,
    ottava22MBContinueText,

    ottava8VAnoText,
    ottava8VAnoContinueText,
    ottava8VBnoText,
    ottava8VBnoContinueText,
    ottava15MAnoText,
    ottava15MAnoContinueText,
    ottava15MBnoText,
    ottava15MBnoContinueText,
    ottava22MAnoText,
    ottava22MAnoContinueText,
    ottava22MBnoText,
    ottava22MBnoContinueText,

    ottavaPosAbove,
    ottavaPosBelow,
    ottavaHookAbove,
    ottavaHookBelow,
    ottavaLineWidth,
    ottavaLineStyle,
    ottavaDashLineLen,
    ottavaDashGapLen,
    ottavaNumbersOnly,
    ottavaFontFace,
    ottavaFontSize,
    ottavaLineSpacing,
    ottavaFontSpatiumDependent,
    ottavaMusicalSymbolsScale,
    ottavaFontStyle,
    ottavaColor,
    ottavaTextAlignAbove,
    ottavaTextAlignBelow,
    ottavaFrameType,
    ottavaFramePadding,
    ottavaFrameWidth,
    ottavaFrameRound,
    ottavaFrameFgColor,
    ottavaFrameBgColor,
    ottavaPosition,

    tabClef,

    tremoloWidth,
    tremoloBoxHeight,
    tremoloLineWidth,
    tremoloDistance,
    tremoloStyle,
    tremoloStrokeLengthMultiplier,
    tremoloNoteSidePadding,
    tremoloOutSidePadding,
    // TODO tremoloMaxBeamLength,

    linearStretch,
    crossMeasureValues,
    keySigNaturals,

    tupletMaxSlope,
    tupletOutOfStaff,
    tupletVHeadDistance,
    tupletVStemDistance,
    tupletStemLeftDistance,
    tupletStemRightDistance,
    tupletNoteLeftDistance,
    tupletNoteRightDistance,
    tupletBracketWidth,
    tupletDirection,
    tupletNumberType,
    tupletBracketType,
    tupletFontFace,
    tupletFontSize,
    tupletLineSpacing,
    tupletFontSpatiumDependent,
    tupletMusicalSymbolsScale,
    tupletFontStyle,
    tupletColor,
    tupletAlign,
    tupletUseSymbols,
    tupletBracketHookHeight,
    tupletOffset,
    tupletFrameType,
    tupletFramePadding,
    tupletFrameWidth,
    tupletFrameRound,
    tupletFrameFgColor,
    tupletFrameBgColor,
    tupletPosition,
    tupletExtendToEndOfDuration,
    tupletNumberRythmicCenter,

    scaleBarlines,
    barGraceDistance,

    minVerticalDistance,
    skylineMinHorizontalClearance,
    ornamentStyle,
    spatium,

    autoplaceHairpinDynamicsDistance,

    dynamicsHairpinVoiceBasedPlacement,
    dynamicsHairpinsAutoCenterOnGrandStaff,
    dynamicsHairpinsAboveForVocalStaves,

    dynamicsOverrideFont,
    dynamicsFont,
    dynamicsSize,
    dynamicsPlacement,
    dynamicsPosAbove,
    dynamicsPosBelow,
    avoidBarLines,
    snapToDynamics,
    centerOnNotehead,
    dynamicsMinDistance,
    autoplaceVerticalAlignRange,

    textLinePlacement,
    textLinePosAbove,
    textLinePosBelow,
    textLineLineWidth,
    textLineLineStyle,
    textLineDashLineLen,
    textLineDashGapLen,
    textLineHookHeight,
    textLineFrameType,
    textLineFramePadding,
    textLineFrameWidth,
    textLineFrameRound,
    textLineFrameFgColor,
    textLineFrameBgColor,
    textLinePosition,

    systemTextLinePlacement,
    systemTextLinePosAbove,
    systemTextLinePosBelow,
    systemTextLineLineWidth,
    systemTextLineLineStyle,
    systemTextLineDashLineLen,
    systemTextLineDashGapLen,
    systemTextLineHookHeight,
    systemTextLineFrameType,
    systemTextLineFramePadding,
    systemTextLineFrameWidth,
    systemTextLineFrameRound,
    systemTextLineFrameFgColor,
    systemTextLineFrameBgColor,
    systemTextLinePosition,

    tremoloBarLineWidth,
    jumpPosAbove,
    markerPosAbove,

    defaultFontFace,
    defaultFontSize,
    defaultLineSpacing,
    defaultFontSpatiumDependent,
    defaultFontStyle,
    defaultColor,
    defaultAlign,
    defaultFrameType,
    defaultFramePadding,
    defaultFrameWidth,
    defaultFrameRound,
    defaultFrameFgColor,
    defaultFrameBgColor,
    defaultOffset,
    defaultOffsetType,
    defaultSystemFlag,
    defaultText,
    defaultPosition,

    titleFontFace,
    titleFontSize,
    titleLineSpacing,
    titleFontSpatiumDependent,
    titleFontStyle,
    titleColor,
    titleAlign,
    titleOffset,
    titleOffsetType,
    titleFrameType,
    titleFramePadding,
    titleFrameWidth,
    titleFrameRound,
    titleFrameFgColor,
    titleFrameBgColor,
    titlePosition,

    subTitleFontFace,
    subTitleFontSize,
    subTitleLineSpacing,
    subTitleFontSpatiumDependent,
    subTitleFontStyle,
    subTitleColor,
    subTitleAlign,
    subTitleOffset,
    subTitleOffsetType,
    subTitleFrameType,
    subTitleFramePadding,
    subTitleFrameWidth,
    subTitleFrameRound,
    subTitleFrameFgColor,
    subTitleFrameBgColor,
    subTitlePosition,

    composerFontFace,
    composerFontSize,
    composerLineSpacing,
    composerFontSpatiumDependent,
    composerFontStyle,
    composerColor,
    composerAlign,
    composerOffset,
    composerOffsetType,
    composerFrameType,
    composerFramePadding,
    composerFrameWidth,
    composerFrameRound,
    composerFrameFgColor,
    composerFrameBgColor,
    composerPosition,

    lyricistFontFace,
    lyricistFontSize,
    lyricistLineSpacing,
    lyricistFontSpatiumDependent,
    lyricistFontStyle,
    lyricistColor,
    lyricistAlign,
    lyricistOffset,
    lyricistOffsetType,
    lyricistFrameType,
    lyricistFramePadding,
    lyricistFrameWidth,
    lyricistFrameRound,
    lyricistFrameFgColor,
    lyricistFrameBgColor,
    lyricistPosition,

    fingeringFontFace,
    fingeringFontSize,
    fingeringLineSpacing,
    fingeringFontSpatiumDependent,
    fingeringFontStyle,
    fingeringColor,
    fingeringAlign,
    fingeringFrameType,
    fingeringFramePadding,
    fingeringFrameWidth,
    fingeringFrameRound,
    fingeringFrameFgColor,
    fingeringFrameBgColor,
    fingeringOffset,
    fingeringPosition,

    tabFretNumberFontFace,
    tabFretNumberFontSize,
    tabFretNumberLineSpacing,
    tabFretNumberFontSpatiumDependent,
    tabFretNumberFontStyle,
    tabFretNumberColor,
    tabFretNumberAlign,
    tabFretNumberOffset,
    tabFretNumberFrameType,
    tabFretNumberFramePadding,
    tabFretNumberFrameWidth,
    tabFretNumberFrameRound,
    tabFretNumberFrameFgColor,
    tabFretNumberFrameBgColor,

    lhGuitarFingeringFontFace,
    lhGuitarFingeringFontSize,
    lhGuitarFingeringLineSpacing,
    lhGuitarFingeringFontSpatiumDependent,
    lhGuitarFingeringFontStyle,
    lhGuitarFingeringColor,
    lhGuitarFingeringAlign,
    lhGuitarFingeringFrameType,
    lhGuitarFingeringFramePadding,
    lhGuitarFingeringFrameWidth,
    lhGuitarFingeringFrameRound,
    lhGuitarFingeringFrameFgColor,
    lhGuitarFingeringFrameBgColor,
    lhGuitarFingeringOffset,
    lhGuitarFingeringPosition,

    rhGuitarFingeringFontFace,
    rhGuitarFingeringFontSize,
    rhGuitarFingeringLineSpacing,
    rhGuitarFingeringFontSpatiumDependent,
    rhGuitarFingeringFontStyle,
    rhGuitarFingeringColor,
    rhGuitarFingeringAlign,
    rhGuitarFingeringFrameType,
    rhGuitarFingeringFramePadding,
    rhGuitarFingeringFrameWidth,
    rhGuitarFingeringFrameRound,
    rhGuitarFingeringFrameFgColor,
    rhGuitarFingeringFrameBgColor,
    rhGuitarFingeringOffset,
    rhGuitarFingeringPosition,

    hammerOnPullOffTappingFontFace,
    hammerOnPullOffTappingFontSize,
    hammerOnPullOffTappingLineSpacing,
    hammerOnPullOffTappingFontSpatiumDependent,
    hammerOnPullOffTappingFontStyle,
    hammerOnPullOffTappingColor,
    hammerOnPullOffTappingAlign,
    hammerOnPullOffTappingFrameType,
    hammerOnPullOffTappingFramePadding,
    hammerOnPullOffTappingFrameWidth,
    hammerOnPullOffTappingFrameRound,
    hammerOnPullOffTappingFrameFgColor,
    hammerOnPullOffTappingFrameBgColor,
    hammerOnPullOffTappingOffset,
    hammerOnPullOffTappingPosition,

    hopoShowOnStandardStaves,
    hopoShowOnTabStaves,
    hopoUpperCase,
    hopoShowAll,
    hopoAlignLettersStandardStaves,
    hopoAlignLettersTabStaves,

    lhTappingSymbolNormalStave,
    lhTappingSymbolTab,
    lhTappingShowItemsNormalStave,
    lhTappingShowItemsTab,
    lhTappingSlurTopAndBottomNoteOnTab,

    rhTappingSymbolNormalStave,
    rhTappingSymbolTab,

    stringNumberFontFace,
    stringNumberFontSize,
    stringNumberLineSpacing,
    stringNumberFontSpatiumDependent,
    stringNumberFontStyle,
    stringNumberColor,
    stringNumberAlign,
    stringNumberFrameType,
    stringNumberFramePadding,
    stringNumberFrameWidth,
    stringNumberFrameRound,
    stringNumberFrameFgColor,
    stringNumberFrameBgColor,
    stringNumberOffset,
    stringNumberPosition,
    preferSameStringForTranspose,

    stringTuningsFontSize,

    harpPedalDiagramFontFace,
    harpPedalDiagramFontSize,
    harpPedalDiagramLineSpacing,
    harpPedalDiagramFontSpatiumDependent,
    harpPedalDiagramMusicalSymbolsScale,
    harpPedalDiagramFontStyle,
    harpPedalDiagramColor,
    harpPedalDiagramAlign,
    harpPedalDiagramFrameType,
    harpPedalDiagramFramePadding,
    harpPedalDiagramFrameWidth,
    harpPedalDiagramFrameRound,
    harpPedalDiagramFrameFgColor,
    harpPedalDiagramFrameBgColor,
    harpPedalDiagramOffset,
    harpPedalDiagramPlacement,
    harpPedalDiagramPosAbove,
    harpPedalDiagramPosBelow,
    harpPedalDiagramMinDistance,
    harpPedalDiagramPosition,

    harpPedalTextDiagramFontFace,
    harpPedalTextDiagramFontSize,
    harpPedalTextDiagramLineSpacing,
    harpPedalTextDiagramFontSpatiumDependent,
    harpPedalTextDiagramFontStyle,
    harpPedalTextDiagramColor,
    harpPedalTextDiagramAlign,
    harpPedalTextDiagramFrameType,
    harpPedalTextDiagramFramePadding,
    harpPedalTextDiagramFrameWidth,
    harpPedalTextDiagramFrameRound,
    harpPedalTextDiagramFrameFgColor,
    harpPedalTextDiagramFrameBgColor,
    harpPedalTextDiagramOffset,
    harpPedalTextDiagramPlacement,
    harpPedalTextDiagramPosAbove,
    harpPedalTextDiagramPosBelow,
    harpPedalTextDiagramMinDistance,
    harpPedalTextDiagramPosition,

    articulationFontFace,
    articulationFontSize,
    articulationLineSpacing,
    articulationFontSpatiumDependent,
    articulationFontStyle,
    articulationColor,
    articulationAlign,
    articulationFrameType,
    articulationFramePadding,
    articulationFrameWidth,
    articulationFrameRound,
    articulationFrameFgColor,
    articulationFrameBgColor,
    articulationOffset,
    articulationPosition,

    longInstrumentFontFace,
    longInstrumentFontSize,
    longInstrumentLineSpacing,
    longInstrumentFontSpatiumDependent,
    longInstrumentFontStyle,
    longInstrumentColor,
    longInstrumentAlign,
    longInstrumentOffset,
    longInstrumentFrameType,
    longInstrumentFramePadding,
    longInstrumentFrameWidth,
    longInstrumentFrameRound,
    longInstrumentFrameFgColor,
    longInstrumentFrameBgColor,
    longInstrumentPosition,

    shortInstrumentFontFace,
    shortInstrumentFontSize,
    shortInstrumentLineSpacing,
    shortInstrumentFontSpatiumDependent,
    shortInstrumentFontStyle,
    shortInstrumentColor,
    shortInstrumentAlign,
    shortInstrumentOffset,
    shortInstrumentFrameType,
    shortInstrumentFramePadding,
    shortInstrumentFrameWidth,
    shortInstrumentFrameRound,
    shortInstrumentFrameFgColor,
    shortInstrumentFrameBgColor,
    shortInstrumentPosition,

    partInstrumentFontFace,
    partInstrumentFontSize,
    partInstrumentLineSpacing,
    partInstrumentFontSpatiumDependent,
    partInstrumentFontStyle,
    partInstrumentColor,
    partInstrumentAlign,
    partInstrumentOffset,
    partInstrumentFrameType,
    partInstrumentFramePadding,
    partInstrumentFrameWidth,
    partInstrumentFrameRound,
    partInstrumentFrameFgColor,
    partInstrumentFrameBgColor,
    partInstrumentPosition,

    dynamicsFontFace,
    dynamicsFontSize,
    dynamicsLineSpacing,
    dynamicsFontSpatiumDependent,
    dynamicsFontStyle,
    dynamicsColor,
    dynamicsAlign,
    dynamicsFrameType,
    dynamicsFramePadding,
    dynamicsFrameWidth,
    dynamicsFrameRound,
    dynamicsFrameFgColor,
    dynamicsFrameBgColor,
    dynamicsPosition,

    expressionFontFace,
    expressionFontSize,
    expressionLineSpacing,
    expressionFontSpatiumDependent,
    expressionFontStyle,
    expressionColor,
    expressionAlign,
    expressionPlacement,
    expressionOffset,
    expressionPosAbove,
    expressionPosBelow,
    expressionFrameType,
    expressionFramePadding,
    expressionFrameWidth,
    expressionFrameRound,
    expressionFrameFgColor,
    expressionFrameBgColor,
    expressionMinDistance,
    expressionPosition,

    tempoFontFace,
    tempoFontSize,
    tempoLineSpacing,
    tempoFontSpatiumDependent,
    tempoFontStyle,
    tempoColor,
    tempoAlign,
    tempoSystemFlag,
    tempoPlacement,
    tempoPosAbove,
    tempoPosBelow,
    tempoMinDistance,
    tempoFrameType,
    tempoFramePadding,
    tempoFrameWidth,
    tempoFrameRound,
    tempoFrameFgColor,
    tempoFrameBgColor,
    tempoPosition,

    tempoChangeFontFace,
    tempoChangeFontSize,
    tempoChangeLineSpacing,
    tempoChangeFontSpatiumDependent,
    tempoChangeFontStyle,
    tempoChangeColor,
    tempoChangeAlign,
    tempoChangeSystemFlag,
    tempoChangePlacement,
    tempoChangePosAbove,
    tempoChangePosBelow,
    tempoChangeMinDistance,
    tempoChangeFrameType,
    tempoChangeFramePadding,
    tempoChangeFrameWidth,
    tempoChangeFrameRound,
    tempoChangeFrameFgColor,
    tempoChangeFrameBgColor,
    tempoChangePosition,
    tempoChangeLineWidth,
    tempoChangeLineStyle,
    tempoChangeDashLineLen,
    tempoChangeDashGapLen,

    metronomeFontFace,
    metronomeFontSize,
    metronomeLineSpacing,
    metronomeFontSpatiumDependent,
    metronomeFontStyle,
    metronomeColor,
    metronomePlacement,
    metronomeAlign,
    metronomeOffset,
    metronomeFrameType,
    metronomeFramePadding,
    metronomeFrameWidth,
    metronomeFrameRound,
    metronomeFrameFgColor,
    metronomeFrameBgColor,
    metronomePosition,

    measureNumberFontFace,
    measureNumberFontSize,
    measureNumberLineSpacing,
    measureNumberFontSpatiumDependent,
    measureNumberFontStyle,
    measureNumberColor,
    measureNumberPosAbove,
    measureNumberPosBelow,
    measureNumberOffsetType,
    measureNumberVPlacement,
    measureNumberHPlacement,
    measureNumberMinDistance,
    measureNumberAlign,
    measureNumberFrameType,
    measureNumberFramePadding,
    measureNumberFrameWidth,
    measureNumberFrameRound,
    measureNumberFrameFgColor,
    measureNumberFrameBgColor,
    measureNumberPosition,
    measureNumberTextStyle,
    measureNumberAlignToBarline,

    measureNumberAlternateFontFace,
    measureNumberAlternateFontSize,
    measureNumberAlternateLineSpacing,
    measureNumberAlternateFontSpatiumDependent,
    measureNumberAlternateFontStyle,
    measureNumberAlternateColor,
    measureNumberAlternateAlign,
    measureNumberAlternatePosAbove,
    measureNumberAlternatePosBelow,
    measureNumberAlternateFrameType,
    measureNumberAlternateFramePadding,
    measureNumberAlternateFrameWidth,
    measureNumberAlternateFrameRound,
    measureNumberAlternateFrameFgColor,
    measureNumberAlternateFrameBgColor,
    measureNumberAlternatePosition,

    mmRestShowMeasureNumberRange,
    mmRestRangeBracketType,

    mmRestRangeFontFace,
    mmRestRangeFontSize,
    mmRestRangeFontSpatiumDependent,
    mmRestRangeFontStyle,
    mmRestRangeColor,
    mmRestRangePosAbove,
    mmRestRangePosBelow,
    mmRestRangeOffsetType,
    mmRestRangeVPlacement,
    mmRestRangeHPlacement,
    mmRestRangeAlign,
    mmRestRangeFrameType,
    mmRestRangeFramePadding,
    mmRestRangeFrameWidth,
    mmRestRangeFrameRound,
    mmRestRangeFrameFgColor,
    mmRestRangeFrameBgColor,
    mmRestRangePosition,
    mmRestRangeMinDistance,
    mmRestRangeTextStyle,

    translatorFontFace,
    translatorFontSize,
    translatorLineSpacing,
    translatorFontSpatiumDependent,
    translatorFontStyle,
    translatorColor,
    translatorAlign,
    translatorOffset,
    translatorFrameType,
    translatorFramePadding,
    translatorFrameWidth,
    translatorFrameRound,
    translatorFrameFgColor,
    translatorFrameBgColor,
    translatorPosition,

    systemTextFontFace,
    systemTextFontSize,
    systemTextLineSpacing,
    systemTextFontSpatiumDependent,
    systemTextFontStyle,
    systemTextColor,
    systemTextAlign,
    systemTextOffsetType,
    systemTextPlacement,
    systemTextPosAbove,
    systemTextPosBelow,
    systemTextMinDistance,
    systemTextFrameType,
    systemTextFramePadding,
    systemTextFrameWidth,
    systemTextFrameRound,
    systemTextFrameFgColor,
    systemTextFrameBgColor,
    systemTextPosition,

    staffTextFontFace,
    staffTextFontSize,
    staffTextLineSpacing,
    staffTextFontSpatiumDependent,
    staffTextFontStyle,
    staffTextColor,
    staffTextAlign,
    staffTextOffsetType,
    staffTextPlacement,
    staffTextPosAbove,
    staffTextPosBelow,
    staffTextMinDistance,
    staffTextFrameType,
    staffTextFramePadding,
    staffTextFrameWidth,
    staffTextFrameRound,
    staffTextFrameFgColor,
    staffTextFrameBgColor,
    staffTextPosition,

    fretDiagramFingeringFontFace,
    fretDiagramFingeringFontSize,
    fretDiagramFingeringLineSpacing,
    fretDiagramFingeringFontSpatiumDependent,
    fretDiagramFingeringFontStyle,
    fretDiagramFingeringColor,
    fretDiagramFingeringAlign,
    fretDiagramFingeringPosAbove,
    fretDiagramFingeringFrameType,
    fretDiagramFingeringFramePadding,
    fretDiagramFingeringFrameWidth,
    fretDiagramFingeringFrameRound,
    fretDiagramFingeringFrameFgColor,
    fretDiagramFingeringFrameBgColor,
    fretDiagramFingeringPosition,

    fretDiagramFretNumberFontFace,
    fretDiagramFretNumberFontSize,
    fretDiagramFretNumberLineSpacing,
    fretDiagramFretNumberFontSpatiumDependent,
    fretDiagramFretNumberFontStyle,
    fretDiagramFretNumberColor,
    fretDiagramFretNumberAlign,
    fretDiagramFretNumberPosAbove,
    fretDiagramFretNumberFrameType,
    fretDiagramFretNumberFramePadding,
    fretDiagramFretNumberFrameWidth,
    fretDiagramFretNumberFrameRound,
    fretDiagramFretNumberFrameFgColor,
    fretDiagramFretNumberFrameBgColor,
    fretDiagramFretNumberPosition,

    rehearsalMarkFontFace,
    rehearsalMarkFontSize,
    rehearsalMarkLineSpacing,
    rehearsalMarkFontSpatiumDependent,
    rehearsalMarkFontStyle,
    rehearsalMarkColor,
    rehearsalMarkAlign,
    rehearsalMarkFrameType,
    rehearsalMarkFramePadding,
    rehearsalMarkFrameWidth,
    rehearsalMarkFrameRound,
    rehearsalMarkFrameFgColor,
    rehearsalMarkFrameBgColor,
    rehearsalMarkPosition,
    rehearsalMarkPlacement,
    rehearsalMarkPosAbove,
    rehearsalMarkPosBelow,
    rehearsalMarkMinDistance,

    repeatPlayCountFontFace,
    repeatPlayCountFontSize,
    repeatPlayCountLineSpacing,
    repeatPlayCountFontSpatiumDependent,
    repeatPlayCountFontStyle,
    repeatPlayCountColor,
    repeatPlayCountAlign,
    repeatPlayCountPlacement,
    repeatPlayCountFrameType,
    repeatPlayCountFramePadding,
    repeatPlayCountFrameWidth,
    repeatPlayCountFrameRound,
    repeatPlayCountFrameFgColor,
    repeatPlayCountFrameBgColor,
    repeatPlayCountPosition,
    repeatPlayCountPosAbove,
    repeatPlayCountPosBelow,
    repeatPlayCountMinDistance,

    repeatLeftFontFace,
    repeatLeftFontSize,
    repeatLeftLineSpacing,
    repeatLeftFontSpatiumDependent,
    repeatLeftFontStyle,
    repeatLeftColor,
    repeatLeftAlign,
    repeatLeftPlacement,
    repeatLeftFrameType,
    repeatLeftFramePadding,
    repeatLeftFrameWidth,
    repeatLeftFrameRound,
    repeatLeftFrameFgColor,
    repeatLeftFrameBgColor,
    repeatLeftPosition,

    repeatRightFontFace,
    repeatRightFontSize,
    repeatRightLineSpacing,
    repeatRightFontSpatiumDependent,
    repeatRightFontStyle,
    repeatRightColor,
    repeatRightAlign,
    repeatRightPlacement,
    repeatRightFrameType,
    repeatRightFramePadding,
    repeatRightFrameWidth,
    repeatRightFrameRound,
    repeatRightFrameFgColor,
    repeatRightFrameBgColor,
    repeatRightPosition,

    frameFontFace,
    frameFontSize,
    frameLineSpacing,
    frameFontSpatiumDependent,
    frameFontStyle,
    frameColor,
    frameAlign,
    frameOffset,
    frameFrameType,
    frameFramePadding,
    frameFrameWidth,
    frameFrameRound,
    frameFrameFgColor,
    frameFrameBgColor,
    framePosition,

    textLineFontFace,
    textLineFontSize,
    textLineLineSpacing,
    textLineFontSpatiumDependent,
    textLineFontStyle,
    textLineColor,
    textLineTextAlign,
    textLineSystemFlag,

    systemTextLineFontFace,
    systemTextLineFontSize,
    systemTextLineFontSpatiumDependent,
    systemTextLineFontStyle,
    systemTextLineColor,
    systemTextLineTextAlign,
    systemTextLineSystemFlag,

    noteLinePlacement,
    noteLineFontFace,
    noteLineFontSize,
    noteLineLineSpacing,
    noteLineFontSpatiumDependent,
    noteLineFontStyle,
    noteLineColor,
    noteLineAlign,
    noteLineOffset,
    noteLineFrameType,
    noteLineFramePadding,
    noteLineFrameWidth,
    noteLineFrameRound,
    noteLineFrameFgColor,
    noteLineFrameBgColor,
    noteLinePosition,

    noteLineWidth,
    noteLineStyle,
    noteLineDashLineLen,
    noteLineDashGapLen,

    glissandoFontFace,
    glissandoFontSize,
    glissandoLineSpacing,
    glissandoFontSpatiumDependent,
    glissandoFontStyle,
    glissandoColor,
    glissandoAlign,
    glissandoOffset,
    glissandoFrameType,
    glissandoFramePadding,
    glissandoFrameWidth,
    glissandoFrameRound,
    glissandoFrameFgColor,
    glissandoFrameBgColor,
    glissandoPosition,
    glissandoLineWidth,
    glissandoText,
    glissandoStyle,
    glissandoStyleHarp,

    glissandoType,
    glissandoLineStyle,
    glissandoDashLineLen,
    glissandoDashGapLen,
    glissandoShowText,

    bendFontFace,
    bendFontSize,
    bendLineSpacing,
    bendFontSpatiumDependent,
    bendFontStyle,
    bendColor,
    bendAlign,
    bendOffset,
    bendFrameType,
    bendFramePadding,
    bendFrameWidth,
    bendFrameRound,
    bendFrameFgColor,
    bendFrameBgColor,
    bendPosition,
    bendLineWidth,
    bendArrowWidth,

    guitarBendLineWidth,
    guitarBendLineWidthTab,
    guitarBendHeightAboveTABStaff,
    guitarBendPartialBendHeight,
    guitarBendUseFull,
    guitarBendArrowWidth,
    guitarBendArrowHeight,
    useCueSizeFretForGraceBends,

    headerFontFace,
    headerFontSize,
    headerLineSpacing,
    headerFontSpatiumDependent,
    headerFontStyle,
    headerColor,
    headerAlign,
    headerOffset,
    headerFrameType,
    headerFramePadding,
    headerFrameWidth,
    headerFrameRound,
    headerFrameFgColor,
    headerFrameBgColor,
    headerPosition,

    footerFontFace,
    footerFontSize,
    footerLineSpacing,
    footerFontSpatiumDependent,
    footerFontStyle,
    footerColor,
    footerAlign,
    footerOffset,
    footerFrameType,
    footerFramePadding,
    footerFrameWidth,
    footerFrameRound,
    footerFrameFgColor,
    footerFrameBgColor,
    footerPosition,

    copyrightFontFace,
    copyrightFontSize,
    copyrightLineSpacing,
    copyrightFontSpatiumDependent,
    copyrightFontStyle,
    copyrightColor,
    copyrightAlign,
    copyrightOffset,
    copyrightFrameType,
    copyrightFramePadding,
    copyrightFrameWidth,
    copyrightFrameRound,
    copyrightFrameFgColor,
    copyrightFrameBgColor,
    copyrightPosition,

    pageNumberFontFace,
    pageNumberFontSize,
    pageNumberLineSpacing,
    pageNumberFontSpatiumDependent,
    pageNumberFontStyle,
    pageNumberColor,
    pageNumberAlign,
    pageNumberOffset,
    pageNumberFrameType,
    pageNumberFramePadding,
    pageNumberFrameWidth,
    pageNumberFrameRound,
    pageNumberFrameFgColor,
    pageNumberFrameBgColor,
    pageNumberPosition,

    instrumentChangeFontFace,
    instrumentChangeFontSize,
    instrumentChangeLineSpacing,
    instrumentChangeFontSpatiumDependent,
    instrumentChangeFontStyle,
    instrumentChangeColor,
    instrumentChangeAlign,
    instrumentChangeOffset,
    instrumentChangePlacement,
    instrumentChangePosAbove,
    instrumentChangePosBelow,
    instrumentChangeMinDistance,
    instrumentChangeFrameType,
    instrumentChangeFramePadding,
    instrumentChangeFrameWidth,
    instrumentChangeFrameRound,
    instrumentChangeFrameFgColor,
    instrumentChangeFrameBgColor,
    instrumentChangePosition,

    stickingFontFace,
    stickingFontSize,
    stickingLineSpacing,
    stickingFontSpatiumDependent,
    stickingFontStyle,
    stickingColor,
    stickingAlign,
    stickingOffset,
    stickingPlacement,
    stickingPosAbove,
    stickingPosBelow,
    stickingMinDistance,
    stickingFrameType,
    stickingFramePadding,
    stickingFrameWidth,
    stickingFrameRound,
    stickingFrameFgColor,
    stickingFrameBgColor,
    stickingPosition,

    figuredBassFontFace,
    figuredBassFontSize,
    figuredBassLineSpacing,
    figuredBassFontSpatiumDependent,
    figuredBassFontStyle,
    figuredBassColor,

    user1Name,
    user1FontFace,
    user1FontSize,
    user1LineSpacing,
    user1FontSpatiumDependent,
    user1FontStyle,
    user1Color,
    user1Align,
    user1Offset,
    user1OffsetType,
    user1FrameType,
    user1FramePadding,
    user1FrameWidth,
    user1FrameRound,
    user1FrameFgColor,
    user1FrameBgColor,
    user1Position,

    user2Name,
    user2FontFace,
    user2FontSize,
    user2LineSpacing,
    user2FontSpatiumDependent,
    user2FontStyle,
    user2Color,
    user2Align,
    user2Offset,
    user2OffsetType,
    user2FrameType,
    user2FramePadding,
    user2FrameWidth,
    user2FrameRound,
    user2FrameFgColor,
    user2FrameBgColor,
    user2Position,

    user3Name,
    user3FontFace,
    user3FontSize,
    user3LineSpacing,
    user3FontSpatiumDependent,
    user3FontStyle,
    user3Color,
    user3Align,
    user3Offset,
    user3OffsetType,
    user3FrameType,
    user3FramePadding,
    user3FrameWidth,
    user3FrameRound,
    user3FrameFgColor,
    user3FrameBgColor,
    user3Position,

    user4Name,
    user4FontFace,
    user4FontSize,
    user4LineSpacing,
    user4FontSpatiumDependent,
    user4FontStyle,
    user4Color,
    user4Align,
    user4Offset,
    user4OffsetType,
    user4FrameType,
    user4FramePadding,
    user4FrameWidth,
    user4FrameRound,
    user4FrameFgColor,
    user4FrameBgColor,
    user4Position,

    user5Name,
    user5FontFace,
    user5FontSize,
    user5LineSpacing,
    user5FontSpatiumDependent,
    user5FontStyle,
    user5Color,
    user5Align,
    user5Offset,
    user5OffsetType,
    user5FrameType,
    user5FramePadding,
    user5FrameWidth,
    user5FrameRound,
    user5FrameFgColor,
    user5FrameBgColor,
    user5Position,

    user6Name,
    user6FontFace,
    user6FontSize,
    user6LineSpacing,
    user6FontSpatiumDependent,
    user6FontStyle,
    user6Color,
    user6Align,
    user6Offset,
    user6OffsetType,
    user6FrameType,
    user6FramePadding,
    user6FrameWidth,
    user6FrameRound,
    user6FrameFgColor,
    user6FrameBgColor,
    user6Position,

    user7Name,
    user7FontFace,
    user7FontSize,
    user7LineSpacing,
    user7FontSpatiumDependent,
    user7FontStyle,
    user7Color,
    user7Align,
    user7Offset,
    user7OffsetType,
    user7FrameType,
    user7FramePadding,
    user7FrameWidth,
    user7FrameRound,
    user7FrameFgColor,
    user7FrameBgColor,
    user7Position,

    user8Name,
    user8FontFace,
    user8FontSize,
    user8LineSpacing,
    user8FontSpatiumDependent,
    user8FontStyle,
    user8Color,
    user8Align,
    user8Offset,
    user8OffsetType,
    user8FrameType,
    user8FramePadding,
    user8FrameWidth,
    user8FrameRound,
    user8FrameFgColor,
    user8FrameBgColor,
    user8Position,

    user9Name,
    user9FontFace,
    user9FontSize,
    user9LineSpacing,
    user9FontSpatiumDependent,
    user9FontStyle,
    user9Color,
    user9Align,
    user9Offset,
    user9OffsetType,
    user9FrameType,
    user9FramePadding,
    user9FrameWidth,
    user9FrameRound,
    user9FrameFgColor,
    user9FrameBgColor,
    user9Position,

    user10Name,
    user10FontFace,
    user10FontSize,
    user10LineSpacing,
    user10FontSpatiumDependent,
    user10FontStyle,
    user10Color,
    user10Align,
    user10Offset,
    user10OffsetType,
    user10FrameType,
    user10FramePadding,
    user10FrameWidth,
    user10FrameRound,
    user10FrameFgColor,
    user10FrameBgColor,
    user10Position,

    user11Name,
    user11FontFace,
    user11FontSize,
    user11LineSpacing,
    user11FontSpatiumDependent,
    user11FontStyle,
    user11Color,
    user11Align,
    user11Offset,
    user11OffsetType,
    user11FrameType,
    user11FramePadding,
    user11FrameWidth,
    user11FrameRound,
    user11FrameFgColor,
    user11FrameBgColor,
    user11Position,

    user12Name,
    user12FontFace,
    user12FontSize,
    user12LineSpacing,
    user12FontSpatiumDependent,
    user12FontStyle,
    user12Color,
    user12Align,
    user12Offset,
    user12OffsetType,
    user12FrameType,
    user12FramePadding,
    user12FrameWidth,
    user12FrameRound,
    user12FrameFgColor,
    user12FrameBgColor,
    user12Position,

    letRingFontFace,
    letRingFontSize,
    letRingLineSpacing,
    letRingFontSpatiumDependent,
    letRingFontStyle,
    letRingColor,
    letRingTextAlign,
    letRingHookHeight,
    letRingPlacement,
    letRingPosAbove,
    letRingPosBelow,
    letRingLineWidth,
    letRingLineStyle,
    letRingDashLineLen,
    letRingDashGapLen,
    letRingText,
    letRingFrameType,
    letRingFramePadding,
    letRingFrameWidth,
    letRingFrameRound,
    letRingFrameFgColor,
    letRingFrameBgColor,
    letRingPosition,
    letRingEndHookType,

    palmMuteFontFace,
    palmMuteFontSize,
    palmMuteLineSpacing,
    palmMuteFontSpatiumDependent,
    palmMuteFontStyle,
    palmMuteColor,
    palmMuteTextAlign,
    palmMuteHookHeight,
    palmMutePlacement,
    palmMutePosAbove,
    palmMutePosBelow,
    palmMuteLineWidth,
    palmMuteLineStyle,
    palmMuteDashLineLen,
    palmMuteDashGapLen,
    palmMuteText,
    palmMuteFrameType,
    palmMuteFramePadding,
    palmMuteFrameWidth,
    palmMuteFrameRound,
    palmMuteFrameFgColor,
    palmMuteFrameBgColor,
    palmMutePosition,
    palmMuteEndHookType,

    fermataPosAbove,
    fermataPosBelow,
    fermataMinDistance,

    fingeringPlacement,

    articulationMinDistance,
    fingeringMinDistance,
    hairpinMinDistance,
    letRingMinDistance,
    ottavaMinDistance,
    palmMuteMinDistance,
    pedalMinDistance,
    repeatMinDistance,
    textLineMinDistance,
    systemTextLineMinDistance,
    trillMinDistance,
    vibratoMinDistance,
    voltaMinDistance,
    figuredBassMinDistance,
    tupletMinDistance,

    /// Display options for tab elements (simple and common styles)

    slurShowTabSimple,
    slurShowTabCommon,
    fermataShowTabSimple,
    fermataShowTabCommon,
    dynamicsShowTabSimple,
    dynamicsShowTabCommon,
    hairpinShowTabSimple,
    hairpinShowTabCommon,
    accentShowTabSimple,
    accentShowTabCommon,
    staccatoShowTabSimple,
    staccatoShowTabCommon,
    harmonicMarkShowTabSimple,
    harmonicMarkShowTabCommon,
    letRingShowTabSimple,
    letRingShowTabCommon,
    palmMuteShowTabSimple,
    palmMuteShowTabCommon,
    rasgueadoShowTabSimple,
    rasgueadoShowTabCommon,
    mordentShowTabSimple,
    mordentShowTabCommon,
    turnShowTabSimple,
    turnShowTabCommon,
    wahShowTabSimple,
    wahShowTabCommon,
    golpeShowTabSimple,
    golpeShowTabCommon,

    tabShowTiedFret,
    tabParenthesizeTiedFret,
    parenthesizeTiedFretIfArticulation,

    tabFretPadding,

    chordlineThickness,

    dummyMusicalSymbolsScale,

    autoplaceEnabled,
    defaultsVersion,

    changesBeforeBarlineRepeats,
    changesBeforeBarlineOtherJumps,

    placeClefsBeforeRepeats,
    changesBetweenEndStartRepeat,

    showCourtesiesRepeats,
    useParensRepeatCourtesies,

    showCourtesiesOtherJumps,
    useParensOtherJumpCourtesies,

    showCourtesiesAfterCancellingRepeats,
    useParensRepeatCourtesiesAfterCancelling,

    showCourtesiesAfterCancellingOtherJumps,
    useParensOtherJumpCourtesiesAfterCancelling,

    smallParens,

    repeatPlayCountPreset,
    repeatPlayCountShow,
    repeatPlayCountShowSingleRepeats,

    systemObjectsBelowBottomStaff,

    STYLES
    ///\}
};
END_QT_REGISTERED_ENUM(Sid)

using StyleIdSet = std::unordered_set<Sid>;

//---------------------------------------------------------
//   VerticalAlignRange
//---------------------------------------------------------

enum class VerticalAlignRange : unsigned char {
    SEGMENT, MEASURE, SYSTEM
};

//---------------------------------------------------------
//   StyledProperty
///   \cond PLUGIN_API \private \endcond
//---------------------------------------------------------
struct StyledProperty {
    Sid sid;
    Pid pid;
};

typedef std::vector<StyledProperty> ElementStyle;

//---------------------------------------------------------
//   StyleDef
///   \cond PLUGIN_API \private \endcond
//---------------------------------------------------------
struct StyleDef
{
private:

    friend class MStyle;

    struct StyleValue {
        Sid _idx;
        muse::AsciiStringView _name;         // xml name for read()/write()
        PropertyValue _defaultValue;

    public:
        Sid  styleIdx() const { return _idx; }
        int idx() const { return int(_idx); }
        const muse::AsciiStringView& name() const { return _name; }
        P_TYPE valueType() const { return _defaultValue.type(); }
        const PropertyValue& defaultValue() const { return _defaultValue; }
    };

    static const std::array<StyleValue, size_t(Sid::STYLES)> styleValues;
};
}
