/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.pdata.EpInfo;
import java.awt.Color;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JCheckBox;

public class EpCheckBox
extends JCheckBox {
    public EpInfo ep;
    public int status;

    EpCheckBox(EpInfo e) {
        super(e.toString());
        this.ep = e;
        this.status = 0;
        e.setCheckBox(this);
        this.setOpaque(false);
    }

    int click() {
        switch (this.status) {
            case 0: {
                this.status = 1;
                this.setForeground(Color.GRAY);
                this.setSelected(true);
                this.setText("B: " + this.getText());
                return 1;
            }
            case 1: {
                this.status = 3;
                this.setForeground(Color.BLACK);
                this.setSelected(true);
                this.setText(this.getText().substring(3));
                return 2;
            }
            case 3: {
                this.status = 2;
                this.setForeground(Color.GRAY);
                this.setSelected(true);
                this.setText("A: " + this.getText());
                return -1;
            }
            case 2: {
                this.status = 0;
                this.setForeground(Color.BLACK);
                this.setSelected(false);
                this.setText(this.getText().substring(3));
                return -2;
            }
        }
        return 0;
    }

    void setCoverageColor(SortedSet activePes) {
        if (this.ep.getBPSet().isEmpty()) {
            this.setForeground(Color.BLACK);
            this.setSelected(false);
        } else if (this.ep.getBPSet().containsAll(activePes)) {
            this.setForeground(Color.BLACK);
            this.setSelected(true);
        } else {
            TreeSet tmp = new TreeSet();
            tmp.addAll(this.ep.getBPSet());
            tmp.retainAll(activePes);
            if (tmp.isEmpty()) {
                this.setForeground(Color.BLACK);
                this.setSelected(false);
            } else {
                this.setForeground(Color.GRAY);
                this.setSelected(true);
            }
        }
    }
}

