/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.pdata;

import charm.debug.EpCheckBox;
import charm.debug.inspect.InspectPanel;
import charm.debug.pdata.ChareTypeInfo;
import charm.debug.pdata.GenericInfo;
import java.util.SortedSet;
import java.util.TreeSet;

public class EpInfo
extends GenericInfo
implements Cloneable {
    String name;
    int epIdx;
    int msgIdx;
    ChareTypeInfo chare;
    EpCheckBox checkBox;
    SortedSet breakpoints;

    EpInfo(String n, int e, int m, ChareTypeInfo c) {
        this.name = n;
        this.epIdx = e;
        this.msgIdx = m;
        this.chare = c;
        this.checkBox = null;
        this.breakpoints = new TreeSet();
    }

    public String toString() {
        return this.name;
    }

    public int getChareType() {
        return this.chare.getIndex();
    }

    public String getChareName() {
        return this.chare.name;
    }

    public int getEpIndex() {
        return this.epIdx;
    }

    public SortedSet getBPSet() {
        return this.breakpoints;
    }

    public void setCheckBox(EpCheckBox cb) {
        this.checkBox = cb;
    }

    public EpCheckBox getCheckBox() {
        return this.checkBox;
    }

    public void addBP(SortedSet bp) {
        this.breakpoints.addAll(bp);
    }

    public void removeBP(SortedSet bp) {
        this.breakpoints.removeAll(bp);
    }

    @Override
    public void getDetails(InspectPanel panel) {
        panel.load("<html>chare type " + this.chare.getIndex() + ": " + this.chare.getType() + "<br>" + "entry point " + this.epIdx + ": " + this.name + "</html>");
    }

    public Object clone() {
        return new EpInfo(this.name, this.epIdx, this.msgIdx, this.chare);
    }

    public boolean equals(String chareName, String epName) {
        return this.chare.getType().equals(chareName) && this.name.startsWith(epName);
    }
}

